

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_DoesTaskHaveOscSchedule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_DoesTaskHaveOscSchedule.sp,v $ $Id: TM_DoesTaskHaveOscSchedule.sp,v 1.1.4.2 2018/12/27 15:07:19 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 02/14/2012
-- Description:	Get the list of OSC schedules.
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_DoesTaskHaveOscSchedule')
BEGIN
	print '>>> Drop Stored Procedure: TM_DoesTaskHaveOscSchedule <<<'
	drop procedure TM_DoesTaskHaveOscSchedule
END
IF EXISTS (select * from GxQscripts where name='TM_DoesTaskHaveOscSchedule')
	delete from GxQscripts where name = 'TM_DoesTaskHaveOscSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_DoesTaskHaveOscSchedule')
	delete from GXDBVersions where aliasname = 'TM_DoesTaskHaveOscSchedule'
GO
print '... Creating Procedure: TM_DoesTaskHaveOscSchedule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_DoesTaskHaveOscSchedule
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @taskId integer
AS
  DECLARE @hasOscSchedule integer
BEGIN
SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @hasOscSchedule = 0
	SELECT @hasOscSchedule = 1
	FROM    TM_Task TA WITH (NOLOCK)
			INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = TA.taskId AND TA.taskId = @taskId
			INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = SA.subTaskId
INNER JOIN TM_Pattern P WITH (NOLOCK) ON P.patternId = PA.patternId AND P.freq_type=1024
LEFT JOIN TM_SubTaskOptions SO ON SO.subTaskId = SA.subTaskId AND SO.optionId = 458405394 AND SO.value = '4' -- BACKUP_LEVEL_SYNTHETIC_FULL = 4
			WHERE SO.subTaskId IS NULL -- We want to filter automatic synthetic full schedules.
			AND TA.[deleted] = 0
			AND TA.[invalid] = 0
			AND TA.[uninstalled] = 0
			AND TA.[savedReport] = 0
			AND TA.[disabled] = 0
AND TA.[taskType] IN ( 2, 4 )
	SELECT @hasOscSchedule
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_DoesTaskHaveOscSchedule')
	delete from GxQscripts where name = 'TM_DoesTaskHaveOscSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_DoesTaskHaveOscSchedule')
	delete from GXDBVersions where aliasname = 'TM_DoesTaskHaveOscSchedule'
GO

insert into GXDBVersions values(2, 'TM_DoesTaskHaveOscSchedule',  '00010001000400020000', 'TM_DoesTaskHaveOscSchedule', '00010001000400020000')
GO

