

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_CreateDefaultSchedulesForFailover.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_CreateDefaultSchedulesForFailover.sp,v $ $Id: TM_CreateDefaultSchedulesForFailover.sp,v 1.1.2.3 2018/06/29 02:58:36 xsui Exp $";
-- =============================================
-- Author:		Madhusudhananan N
-- Create date: 07/10/2009
-- Description:	Create Default System created backup Schedules for failover configuration.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_CreateDefaultSchedulesForFailover <<<'

IF EXISTS (select * from sysobjects where name='TM_CreateDefaultSchedulesForFailover')
	drop procedure TM_CreateDefaultSchedulesForFailover
IF EXISTS (select * from GxQscripts where name='TM_CreateDefaultSchedulesForFailover')
	delete from GxQscripts where name = 'TM_CreateDefaultSchedulesForFailover'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_CreateDefaultSchedulesForFailover')
	delete from GXDBVersions where aliasname = 'TM_CreateDefaultSchedulesForFailover'
GO
print '... Creating Procedure: TM_CreateDefaultSchedulesForFailover'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_CreateDefaultSchedulesForFailover
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @errCode INTEGER
  DECLARE @errStr NVARCHAR(1024)
--BEGIN TRANSACTION CREATESYSTASK
BEGIN
-------------------------------------------------------------------------------------
	----------------------------------------------------------------------------
	--									Variables							  --
	----------------------------------------------------------------------------
	DECLARE @l_taskId1		INTEGER
	DECLARE @l_subTaskId1	INTEGER
	DECLARE @l_subTaskId2	INTEGER
	DECLARE @l_subTaskId3	INTEGER
	DECLARE @l_patternId1	INTEGER
	DECLARE @l_patternId2	INTEGER
	DECLARE @l_patternId3	INTEGER
	DECLARE @currentDate	DATETIME
	DECLARE @currentTime	INTEGER
DECLARE @userId			INT = (SELECT TOP 1 id FROM UMUsers WITH (NOLOCK) WHERE flags & 0x040 <> 0)
	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())
	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))
	DECLARE @xmlText		XML
	DECLARE @IsTranStarted INT = 0
	SET @errCode  = 0
	SET @errStr = ''
IF EXISTS (SELECT 1 FROM TM_Task WHERE taskName = 'System Created for Failover' )
	BEGIN
		GOTO ERROR_EXIT
	END
	BEGIN TRY
		IF @@TRANCOUNT=0
		BEGIN
			SET @IsTranStarted = 1
			BEGIN TRAN
		END
		if object_id('tempdb.dbo.#TM_IDTable') IS NOT NULL
		BEGIN
			DROP TABLE #TM_IDTable
		END
		CREATE TABLE #TM_IDTable
		(
			id		INTEGER,
			type	INTEGER,
			PRIMARY KEY(id,type)
		)
	-----------------------------------------------------------------------------
	-- System Created Schedule Policy
		-- Schedule Policy
		INSERT INTO TM_Task(taskName,
							taskType,
							flags,
							status,
							created,
							modified,
							alertId,
							ownerId,
							runUserId,
							initiatedFrom,
							sequenceNumber,
							localeId,
							description,
							deleted,
							disabled,
							uninstalled,
							invalid,
							defaultTask,
							savedReport,
							serial,
							policyType,
							origCCId,
							GUID,
							isEZOperation,
							isAgentlessSRM,
							hidden)
		OUTPUT	INSERTED.taskId , 1 INTO #TM_IDTable
VALUES			   ( 'System Created for Failover',				-- Task Name
4,		-- Task Type
CAST(0x8000 AS INT)|CAST(0x4 AS INT),					-- Task Flags
							0,								-- Status
							0,								-- Created
							0,								-- Modified
							0,								-- Alert ID
							@userId,							-- Owner ID
							@userId,							-- Run User ID
3,			-- Initiated From
							0,								-- Seq No
							0,								-- Locale ID
'System created schedule policy for Failover',		-- Description
							0,								-- Deleted
							0,								-- Disabled
							0,								-- Uninstalled
							0,								-- Invalid
							0,								-- Default Task ???
							0,								-- Saved Report
							0,								-- Serial
							0,								-- Policy Type
							DEFAULT,						-- Original CC ID
							newid(),						-- GUID
							0,								-- isEZOperation
							0,								-- isAgentlessSRM
							0)								-- hidden
		SET @l_taskId1 = (SELECT id FROM #TM_IDTable WHERE type = 1)
		-- Schedule 1 :
		-- TL Schedule
		INSERT INTO TM_SubTask (subTaskName,
	 				 			taskId,
								subTaskType	,
								operationType,
								flags		,
								subTaskOrder,
								deleted,
 		 						uninstalled,
								defaultTask)
		OUTPUT	INSERTED.subTaskId , 2 INTO #TM_IDTable
VALUES				   ('Failover Transaction Log schedule',							-- SubTask Name
								@l_taskId1,					-- Task ID
2,		-- SubTask Type
2,	-- Operation Type
0x80000,							-- Flags
								0,							-- SubTask Order
								0,							-- Deleted
								0,							-- Uninstalled
								0)							-- Default Task ???
		-- Schedule 2 :
		-- Full Schedule
		INSERT INTO TM_SubTask (subTaskName,
	 				 			taskId,
								subTaskType	,
								operationType,
								flags		,
								subTaskOrder,
								deleted,
 		 						uninstalled,
								defaultTask)
		OUTPUT	INSERTED.subTaskId , 3 INTO #TM_IDTable
VALUES				   ('Failover Full backup schedule',							-- SubTask Name
								@l_taskId1,					-- Task ID
2,		-- SubTask Type
2,	-- Operation Type
0x40000,							-- Flags
								0,							-- SubTask Order
								0,							-- Deleted
								0,							-- Uninstalled
								0)							-- Default Task ???
		SET @l_subTaskId1 = (SELECT id FROM #TM_IDTable WHERE type = 2)
		SET @l_subTaskId2 = (SELECT id FROM #TM_IDTable WHERE type = 3)
		---- Get CS Time Zone ID
		-- Pattern 1:
		-- Every 15 mins
		INSERT INTO TM_Pattern(name,
							   ownerId,
							   status,
							   flags,
							   freq_type,
							   freq_interval,
							   freq_relative_interval,
							   freq_recurrence_factor,
							   freq_subday_interval,
							   skipOccurence,
							   skipDayNumber,
							   active_start_date,
							   active_start_time,
							   active_end_date,
							   active_end_time,
							   active_end_occurence,
							   created,
							   modified,
							   tzId,
							   calendarId,
							   description,
							   local_start_date,
							   local_end_date,
							   disabled,
							   deleted,
							   scheduling,
							   freq_restart_interval)
		OUTPUT	INSERTED.patternId , 4 INTO #TM_IDTable
		VALUES				  ('',							-- Name
							   @userId,						-- Owner ID
							   0,							-- Status
							   0,							-- Flags
0x4,			-- Freq Type
							   1,							-- Freq Interval
							   0,							-- Freq Relative Interval
							   1,							-- Freq Recurrence Factor
							   900,							-- Freq Subday Interval -- every 15 mins
							   0,							-- Skip Occurrence
							   0,							-- Skip Day Number
							   @currentDate,				-- Active Start Date
							   0,							-- Active Start Time
							   '1970-01-01 00:00:00',		-- Active End Date
							   86340,						-- Active End Time
							   0,							-- Active End Occurrence
							   0,							-- Created
							   0,							-- Modified
							   1000,					-- Time Zone Id
							   1,							-- Calendar Id
							   'Every day at 12:00 AM and repeats every 0 hr(s) 15 min(s) until 11:59 PM',							-- Description
							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date
							   0,							-- Local End Date
							   0,							-- Disabled
							   0,							-- Deleted
							   0,							-- Scheduling
							   0)							-- Freq Restart Interval
		-- Pattern 2:
		-- Weekly Sunday 12 AM
		INSERT INTO TM_Pattern(name,
							   ownerId,
							   status,
							   flags,
							   freq_type,
							   freq_interval,
							   freq_relative_interval,
							   freq_recurrence_factor,
							   freq_subday_interval,
							   skipOccurence,
							   skipDayNumber,
							   active_start_date,
							   active_start_time,
							   active_end_date,
							   active_end_time,
							   active_end_occurence,
							   created,
							   modified,
							   tzId,
							   calendarId,
							   description,
							   local_start_date,
							   local_end_date,
							   disabled,
							   deleted,
							   scheduling,
							   freq_restart_interval)
		OUTPUT	INSERTED.patternId , 5 INTO #TM_IDTable
		VALUES				  ('',							-- Name
							   @userId,						-- Owner ID
							   0,							-- Status
							   0,							-- Flags
0x8,			-- Freq Type
							   1,							-- Freq Interval
							   0,							-- Freq Relative Interval
							   1,							-- Freq Recurrence Factor
							   0,							-- Freq Subday Interval
							   0,							-- Skip Occurrence
							   0,							-- Skip Day Number
							   @currentDate,				-- Active Start Date
							   0,							-- Active Start Time
							   '1970-01-01 00:00:00',		-- Active End Date
							   0,							-- Active End Time
							   0,							-- Active End Occurrence
							   0,							-- Created
							   0,							-- Modified
							   1000,						-- Time Zone Id
							   1,							-- Calendar Id
							   'Every week on Sunday at 12:00 AM',							-- Description
							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date
							   0,							-- Local End Date
							   0,							-- Disabled
							   0,							-- Deleted
							   0,							-- Scheduling
							   0)							-- Freq Restart Interval
		SET @l_patternId1 = (SELECT id FROM #TM_IDTable WHERE type = 4)
		SET @l_patternId2 = (SELECT id FROM #TM_IDTable WHERE type = 5)
		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,
									subTaskId,
									flags,
						   			disabled,
									deleted,
									scheduling)
		Values					    (@l_patternId1,				-- Pattern ID
									@l_subTaskId1,				-- SubTask ID
									0,							-- Flags
									0,							-- Disabled
									0,							-- Deleted
									0),							-- Scheduling
									(@l_patternId2,				-- Pattern ID
									@l_subTaskId2,				-- SubTask ID
									0,							-- Flags
									0,							-- Disabled
									0,							-- Deleted
									0)							-- Scheduling
		-- SubTask XML Options
		SET @xmlText = '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" sybaseSkipFullafterLogBkp="0" notSynthesizeFullFromPrevBackup="0" backupLevel="2" incLevel="1" adHocBackup="0" runIncrementalBackup="1" isSpHasInLineCopy="0" runSILOBackup="0" doNotTruncateLog="0"><dataOpt skipCatalogPhaseForSnapBackup="1" useCatalogServer="0" enforceTransactionLogUsage="0" skipConsistencyCheck="0" createNewIndex="0" autoCopy="0" /><mediaOpt /></backupOpts><adminOpts><contentIndexingOption subClientBasedAnalytics="0" /></adminOpts><restoreOptions><virtualServerRstOption isBlockLevelReplication="0" /><commonOptions syncRestore="0" /></restoreOptions><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>'
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,xmlValue)
		VALUES							(@l_subTaskId1,@xmlText)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0
		SET @xmlText = '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" sybaseSkipFullafterLogBkp="0" notSynthesizeFullFromPrevBackup="0" backupLevel="1" incLevel="1" adHocBackup="0" runIncrementalBackup="1" isSpHasInLineCopy="0" runSILOBackup="0" doNotTruncateLog="0"><dataOpt skipCatalogPhaseForSnapBackup="1" useCatalogServer="0" enforceTransactionLogUsage="0" skipConsistencyCheck="0" autoCopy="0" /><mediaOpt /></backupOpts><adminOpts><contentIndexingOption subClientBasedAnalytics="0" /></adminOpts><restoreOptions><virtualServerRstOption isBlockLevelReplication="0" /><commonOptions syncRestore="0" /></restoreOptions><commonOpts><perfJobOpts /></commonOpts></TMMsg_JobOption>'
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,xmlValue)
		VALUES							(@l_subTaskId2,@xmlText)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId2, 0, @currentTime, 0
		-- SubTask Options
		-- Incremental Schedule
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		Values						  (@l_subTaskId1,
100003,
									   15,
									   '6296576'),
									  (@l_subTaskId1,
100004,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId1,
100005,
									   15,
									   '4'),
									  (@l_subTaskId1,
120013,
									   7,
									   '-1'),
									  (@l_subTaskId1,
140015,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId1,
177623377,
									   0,
									   '0'),
									  (@l_subTaskId1,
252695813,
									   0,
									   '0'),
									(@l_subTaskId1,
300510029,
									   0,
									   '0'),
									  (@l_subTaskId1,
312510015,
									   0,
									   '1'),
									  (@l_subTaskId1,
405755728,
									   0,
									   '0'),
									  (@l_subTaskId1,
428058421,
									   0,
									   '1'),
		-- TL Backup
									  (@l_subTaskId1,
458405394,
									   7,
									   '2'), -- Incremental/Transaction log schedule.
									  (@l_subTaskId1,
589118090,
									   0,
									   '0'),
									  (@l_subTaskId1,
641463701,
									   0,
									   '0'),
									  (@l_subTaskId1,
649116404,
									   0,
									   '0'),
									  (@l_subTaskId1,
697451464,
									   0,
									   '0'),
									  (@l_subTaskId1,
756999446,
									   7,
									   '1'),
									  (@l_subTaskId1,
974354278,
									   0,
									   '0'),
									  (@l_subTaskId1,
1013376701,
									   0,
									   '0'),
									  (@l_subTaskId1,
1197257326,
									   0,
									   '0'),
									  (@l_subTaskId1,
1510939499,
									   0,
									   '0'),
									  (@l_subTaskId1,
1735011734,
									   0,
									   '0'),
									  (@l_subTaskId1,
2045937773,
									   0,
									   '0'),
									  (@l_subTaskId1,
2055741185,
									   0,
									   '0')
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId1, 0, @currentTime, 0
		FROM TM_SubTaskOptions AS OPT
		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value
WHERE subTaskId = @l_subTaskId1 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		Values						  (@l_subTaskId2,
100003,
									   15,
									   '6296592'),
									  (@l_subTaskId2,
100004,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId2,
100005,
									   15,
									   '4'),
									  (@l_subTaskId2,
120013,
									   7,
									   '-1'),
									  (@l_subTaskId2,
140015,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId2,
177623377,
									   0,
									   '0'),
									  (@l_subTaskId2,
252695813,
									   0,
									   '0'),
									  (@l_subTaskId2,
300510029,
									   0,
									   '0'),
									  (@l_subTaskId2,
312510015,
									   0,
									   '1'),
									  (@l_subTaskId2,
405755728,
									   0,
									   '0'),
									  (@l_subTaskId2,
428058421,
									   0,
									   '1'),
		-- Diff Backup
									  (@l_subTaskId2,
458405394,
									   7,
									   '1'),
									  (@l_subTaskId2,
589118090,
									   0,
									   '0'),
									  (@l_subTaskId2,
641463701,
									   0,
									   '0'),
									  (@l_subTaskId2,
649116404,
									   0,
									   '0'),
									  (@l_subTaskId2,
697451464,
									   0,
									   '0'),
									  (@l_subTaskId2,
756999446,
									   7,
									   '1'),
									  (@l_subTaskId2,
974354278,
									   0,
									   '0'),
									  (@l_subTaskId2,
1013376701,
									   0,
									   '0'),
									  (@l_subTaskId2,
1197257326,
									   0,
									   '0'),
									  (@l_subTaskId2,
1510939499,
									   0,
									   '0'),
									  (@l_subTaskId2,
1735011734,
									   0,
									   '0'),
									  (@l_subTaskId2,
2055741185,
									   0,
									   '0')
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId2, 0, @currentTime, 0
		FROM TM_SubTaskOptions AS OPT
		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value
WHERE subTaskId = @l_subTaskId2 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)
		-- Check whether we need to create Differential schedule.
IF NOT EXISTS (SELECT 1 FROM TM_SubTask WHERE taskId = @l_taskId1 AND ( flags & 0x100000 )>0 )
		BEGIN
			DELETE FROM #TM_IDTable
			INSERT INTO TM_SubTask (subTaskName,
	 				 			taskId,
								subTaskType	,
								operationType,
								flags		,
								subTaskOrder,
								deleted,
 		 						uninstalled,
								defaultTask)
			OUTPUT	INSERTED.subTaskId , 6 INTO #TM_IDTable
VALUES				   ('Failover Differential schedule',							-- SubTask Name
									@l_taskId1,					-- Task ID
2,		-- SubTask Type
2,	-- Operation Type
0x100000,							-- Flags
									0,							-- SubTask Order
									0,							-- Deleted
									0,							-- Uninstalled
									0)							-- Default Task ???
			SET @l_subTaskId3 = (SELECT id FROM #TM_IDTable WHERE type = 6)
			INSERT INTO TM_Pattern(name,
							   ownerId,
							   status,
							   flags,
							   freq_type,
							   freq_interval,
							   freq_relative_interval,
							   freq_recurrence_factor,
							   freq_subday_interval,
							   skipOccurence,
							   skipDayNumber,
							   active_start_date,
							   active_start_time,
							   active_end_date,
							   active_end_time,
							   active_end_occurence,
							   created,
							   modified,
							   tzId,
							   calendarId,
							   description,
							   local_start_date,
							   local_end_date,
							   disabled,
							   deleted,
							   scheduling,
							   freq_restart_interval)
			OUTPUT	INSERTED.patternId , 7 INTO #TM_IDTable
			VALUES			   ('',							-- Name
							   @userId,						-- Owner ID
							   0,							-- Status
							   0,							-- Flags
0x8,			-- Freq Type
							   126,							-- Freq Interval -- Run it on all days except sunday since full runs on sunday
							   0,							-- Freq Relative Interval
							   1,							-- Freq Recurrence Factor
							   0,							-- Freq Subday Interval -- every 1 day
							   0,							-- Skip Occurrence
							   0,							-- Skip Day Number
							   @currentDate,				-- Active Start Date
							   0,							-- Active Start Time
							   '1970-01-01 00:00:00',		-- Active End Date
							   0,							-- Active End Time
							   0,							-- Active End Occurrence
							   0,							-- Created
							   0,							-- Modified
							   1000,						-- Time Zone Id
							   1,							-- Calendar Id
							   'Every week on Monday, Tuesday, Wednesday, Thursday, Friday, Saturday at 12:00 AM',							-- Description
							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date
							   0,							-- Local End Date
							   0,							-- Disabled
							   0,							-- Deleted
							   0,							-- Scheduling
							   0)							-- Freq Restart Interval
			SET @l_patternId3 = (SELECT id FROM #TM_IDTable WHERE type = 7)
			INSERT INTO TM_PatternAssoc(patternId,
									subTaskId,
									flags,
						   			disabled,
									deleted,
									scheduling)
			SELECT					@l_patternId3,				-- Pattern ID
									@l_subTaskId3,				-- SubTask ID
									0,							-- Flags
									0,							-- Disabled
									0,							-- Deleted
									0							-- Scheduling
			SET @xmlText = '<TMMsg_JobOption><backupOpts truncateLogsOnSource="0" sybaseSkipFullafterLogBkp="0" notSynthesizeFullFromPrevBackup="0" backupLevel="3" incLevel="1" adHocBackup="0" runIncrementalBackup="0" isSpHasInLineCopy="0" runSILOBackup="0" doNotTruncateLog="0"><dataOpt skipCatalogPhaseForSnapBackup="1" useCatalogServer="0" enforceTransactionLogUsage="0" skipConsistencyCheck="0" createNewIndex="0" autoCopy="0"/><mediaOpt/></backupOpts><adminOpts><contentIndexingOption subClientBasedAnalytics="0"/></adminOpts><restoreOptions><virtualServerRstOption isBlockLevelReplication="0"/><commonOptions syncRestore="0"/></restoreOptions><commonOpts><perfJobOpts/></commonOpts></TMMsg_JobOption>'
			INSERT INTO TM_SubTaskXMLOptions(subTaskID,xmlValue)
			VALUES							(@l_subTaskId3,@xmlText)
			INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId1, @l_subTaskId3, 0, @currentTime, 0
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		Values						  (@l_subTaskId3,
100003,
									   15,
									   '6296576'),
									  (@l_subTaskId3,
100004,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId3,
100005,
									   15,
									   '4'),
									  (@l_subTaskId3,
120013,
									   7,
									   '-1'),
									  (@l_subTaskId3,
140015,
									   1,
									   '1000000000100100000000000000000100000000000000000010010000000000000'),
									  (@l_subTaskId3,
177623377,
									   0,
									   '0'),
									  (@l_subTaskId3,
252695813,
									   0,
									   '0'),
									  (@l_subTaskId3,
300510029,
									   0,
									   '0'),
									  (@l_subTaskId3,
312510015,
									   0,
									   '0'),
									  (@l_subTaskId3,
405755728,
									   0,
									   '0'),
									  (@l_subTaskId3,
428058421,
									   0,
									   '1'),
		-- Differential Backup
									  (@l_subTaskId3,
458405394,
									   7,
									   '3'), -- Differential schedule.
									  (@l_subTaskId3,
589118090,
									   0,
									   '0'),
									  (@l_subTaskId3,
641463701,
									   0,
									   '0'),
									  (@l_subTaskId3,
649116404,
									   0,
									   '0'),
									  (@l_subTaskId3,
697451464,
									   0,
									   '0'),
									  (@l_subTaskId3,
756999446,
									   7,
									   '1'),
									  (@l_subTaskId3,
974354278,
									   0,
									   '0'),
									  (@l_subTaskId3,
1013376701,
									   0,
									   '0'),
									  (@l_subTaskId3,
1197257326,
									   0,
									   '0'),
									  (@l_subTaskId3,
1510939499,
									   0,
									   '0'),
									  (@l_subTaskId3,
1735011734,
									   0,
									   '0'),
									  (@l_subTaskId3,
2045937773,
									   0,
									   '0'),
									  (@l_subTaskId3,
2055741185,
									   0,
									   '0')
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId1, @l_subTaskId3, 0, @currentTime, 0
		FROM TM_SubTaskOptions AS OPT
		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value
WHERE subTaskId = @l_subTaskId3 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)
		END
		IF (@IsTranStarted=1)
		BEGIN
			COMMIT TRAN
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF (@IsTranStarted=1)
		BEGIN
			ROLLBACK TRAN
		END
	END CATCH;
ERROR_EXIT:
if object_id('tempdb.dbo.#TM_IDTable') is not null
BEGIN
	DROP TABLE #TM_IDTable
END
SELECT @errCode, @errStr
RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_CreateDefaultSchedulesForFailover')
	delete from GxQscripts where name = 'TM_CreateDefaultSchedulesForFailover'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_CreateDefaultSchedulesForFailover')
	delete from GXDBVersions where aliasname = 'TM_CreateDefaultSchedulesForFailover'
GO

insert into GXDBVersions values(2, 'TM_CreateDefaultSchedulesForFailover',  '00010001000200030000', 'TM_CreateDefaultSchedulesForFailover', '00010001000200030000')
GO

