

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ComputeStarttimeForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_ComputeStarttimeForClient.sp,v $ $Id: TM_ComputeStarttimeForClient.sp,v 1.1.2.3.20.1 2021/05/05 17:47:06 mnatarajan Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 04/15/2008
-- Description:	get the task time zone
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_ComputeStarttimeForClient')
BEGIN
	print '>>> Drop Stored Procedure: TM_ComputeStarttimeForClient <<<'
	drop procedure TM_ComputeStarttimeForClient
END
IF EXISTS (select * from GxQscripts where name='TM_ComputeStarttimeForClient')
	delete from GxQscripts where name = 'TM_ComputeStarttimeForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ComputeStarttimeForClient')
	delete from GXDBVersions where aliasname = 'TM_ComputeStarttimeForClient'
GO
print '... Creating Procedure: TM_ComputeStarttimeForClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_ComputeStarttimeForClient
AS
BEGIN
	SET NOCOUNT ON
	-- IF the DB is missing then return. Dont do anything.
	IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NULL
	BEGIN
		PRINT 'Temp table #Clients_Timezone_StartTime not created. So not processing further....'
		RETURN
	END
	DECLARE @isSubclientTblPassed INT = 0
	IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
	BEGIN
		SET @isSubclientTblPassed = 1
	END
	-- If temp table is emtpy then return
	IF NOT EXISTS(SELECT 1 FROM #Clients_Timezone_StartTime)
	BEGIN
		RETURN
	END
DECLARE @pseudoClient_status BIGINT = 0x200000
SET @pseudoClient_status = @pseudoClient_status | 0x0400 | 0x0200 | 0x0040 | 0x4000000
	DECLARE @csTimezone nvarchar(max) = dbo.GetClientTimezone(2) -- CS timezone.
	-- Avoid using function to compute client timezone.
    UPDATE allClientsTable
	SET timezoneName = CASE
              WHEN tz.TimeZoneId IS NOT NULL THEN tz.TimeZoneStdName
              WHEN P.componentNameId IS NOT NULL THEN RIGHT(P.attrVal, CHARINDEX(':', REVERSE(P.attrVal)) - 1)
              WHEN ( (A.status & @pseudoClient_status) > 0) OR S.ClientId IS NULL THEN @csTimezone
			  ELSE @csTimezone
       END
    FROM #Clients_Timezone_StartTime allClientsTable INNER JOIN
	APP_Client A ON allClientsTable.clientID = A.id
	LEFT OUTER JOIN APP_ClientProp P ON
              P.componentNameId = A.Id
              AND P.attrName = N'timezone'
              AND P.modified = 0
       LEFT OUTER JOIN APP_ClientProp P2 ON
              P2.componentNameId = A.Id
              AND P2.attrName = N'timezone id'
              AND P2.modified = 0
	   LEFT OUTER JOIN SchedTimeZone tz ON
              P2.attrVal IS NOT NULL
              AND P2.attrVal = CAST(tz.TimeZoneID AS VARCHAR(12))
		LEFT OUTER JOIN simInstalledPackages S ON S.ClientId = A.id
	--If there is any schedule associated to plan then update job start time here
	-- Process job start time for plan associated backup schedule policy
	IF NOT EXISTS(SELECT 1 FROM APP_PlanProp (NOLOCK) INNER JOIN #Clients_Timezone_StartTime allClientsTable ON
APP_PlanProp.attrName = 'Schedule policy' AND APP_PlanProp.attrVal = CAST(allClientsTable.taskId AS NVARCHAR(10) ) )
	BEGIN
		-- No schedules associated to plan. So no need to compute job start time for these clients.
		RETURN
	END
	-- Update job start time for all entries in allClientsTable
	-- Do this only for schedule policies associated to plan.
	UPDATE allClientsTable
	SET jobStartTime = CONVERT(INT,App_ClientProp.attrVal)
	FROM #Clients_Timezone_StartTime allClientsTable
	INNER JOIN App_ClientProp (NOLOCK) ON App_ClientProp.ComponentnameID = allClientsTable.clientId
	AND App_ClientProp.attrName = 'JobStartTime' -- CV_PROP_JOB_START_TIME
	AND App_ClientProp.modified = 0
	AND CONVERT(INT,App_ClientProp.attrVal)>=0
	INNER JOIN APP_PlanProp (NOLOCK) ON
APP_PlanProp.attrName = 'Schedule policy' AND APP_PlanProp.attrVal = CAST(allClientsTable.taskId AS NVARCHAR(10) )
	-- Compute the job start time set at organization level.
	UPDATE allClientsTable
	SET jobStartTime = APP_ComponentProp.longVal
	FROM #Clients_Timezone_StartTime allClientsTable
	INNER JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientId = allClientsTable.clientId
	INNER JOIN APP_ComponentProp (NOLOCK)
ON APP_ComponentProp.componentType = 8 AND APP_ComponentProp.componentId =  App_ClientGroupAssoc.clientGroupId AND APP_ComponentProp.propertyTypeId = 1303
	AND APP_ComponentProp.modified = 0
	AND jobStartTime < 0
	AND APP_ComponentProp.longVal>=0
	INNER JOIN APP_PlanProp (NOLOCK) ON
APP_PlanProp.attrName = 'Schedule policy' AND APP_PlanProp.attrVal = CAST(allClientsTable.taskId AS NVARCHAR(10) )
	IF @isSubclientTblPassed = 1
	BEGIN
		IF EXISTS(SELECT 1 FROM #SubClients_Timezone_StartTime)
		BEGIN
			;WITH CTE_Timezone
			AS
			(
				SELECT DISTINCT
					CASE
						WHEN tz.TimeZoneId IS NOT NULL THEN tz.TimeZoneStdName
						WHEN P.componentNameId IS NOT NULL THEN RIGHT(P.attrVal, CHARINDEX(':', REVERSE(P.attrVal)) - 1)
						ELSE NULL
					END tzName,
				appId subclientId
				FROM #SubClients_Timezone_StartTime E
JOIN APP_Application A ON A.apptypeId = 106 AND A.id = E.appId
				LEFT OUTER JOIN APP_SubClientProp P ON P.componentNameId = A.id AND P.attrName = N'timezone'AND P.modified = 0 AND P.cs_attrName = CHECKSUM(N'timezone')
				LEFT OUTER JOIN APP_SubClientProp P2 ON P2.componentNameId = A.id AND P2.attrName = N'timezone id'AND P2.modified = 0 AND P2.cs_attrName = CHECKSUM(N'timezone id')
				LEFT OUTER JOIN SchedTimeZone tz ON P2.attrVal IS NOT NULL AND P2.attrVal = CAST(tz.TimeZoneID AS NVARCHAR(12))
			)
			UPDATE #SubClients_Timezone_StartTime
			SET timezoneName = CTE_Timezone.tzName
			FROM CTE_Timezone
			WHERE CTE_Timezone.subclientId = appId
			AND CTE_Timezone.tzName IS NOT NULL
			-- for subclients where timezone isnt set, set timezone from client/CS
			UPDATE #SubClients_Timezone_StartTime
			SET timezonename = allClientsTable.timezoneName
			FROM #SubClients_Timezone_StartTime
			INNER JOIN APP_Application(NOLOCK) ON #SubClients_Timezone_StartTime.appid = APP_Application.id
			INNER JOIN #Clients_Timezone_StartTime allClientsTable ON allClientsTable.clientID = APP_Application.clientId
			WHERE #SubClients_Timezone_StartTime.timezoneName IS NULL
			-- Update job start time if specified on subclient property. Do this for VSA only.
			UPDATE #SubClients_Timezone_StartTime
			SET jobStartTime = CAST(App_SubclientProp.attrVal AS INT)
			FROM #SubClients_Timezone_StartTime
JOIN APP_Application A ON A.apptypeId = 106 AND A.id = #SubClients_Timezone_StartTime.appId
			INNER JOIN App_SubclientProp (NOLOCK) ON  #SubClients_Timezone_StartTime.appID = App_SubclientProp.componentNameID
			AND App_SubclientProp.attrName = N'JobStartTime' AND App_SubclientProp.modified = 0
			AND App_SubclientProp.cs_attrName = checksum(N'JobStartTime')
			WHERE CAST(App_SubclientProp.attrVal AS INT)>= 0
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ComputeStarttimeForClient')
	delete from GxQscripts where name = 'TM_ComputeStarttimeForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ComputeStarttimeForClient')
	delete from GXDBVersions where aliasname = 'TM_ComputeStarttimeForClient'
GO

insert into GXDBVersions values(2, 'TM_ComputeStarttimeForClient',  'v1.1.2.3.20.1', 'TM_ComputeStarttimeForClient', 'v1.1.2.3.20.1')
GO

