

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_ComputeNextStartTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Rohith Engu
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TM_ComputeNextStartTime')
BEGIN
	print '>>> Drop Stored Procedure: TM_ComputeNextStartTime <<<'
	drop procedure TM_ComputeNextStartTime
END
IF EXISTS (select * from GxQscripts where name='TM_ComputeNextStartTime')
	delete from GxQscripts where name = 'TM_ComputeNextStartTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ComputeNextStartTime')
	delete from GXDBVersions where aliasname = 'TM_ComputeNextStartTime'
GO
print '... Creating Procedure: TM_ComputeNextStartTime'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TM_ComputeNextStartTime
  @processOnlySchedules INT,
  @subTaskID INT
AS
BEGIN
	DECLARE @nowTime   integer
	SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
	-- Picked up from JMcalculateNextBackuplevel SP. Any change there needs to be reflected here.
	DECLARE @numOfDefaultDaysForAutoconvertBackupLevel INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysBetweenAutoConvertBackupLevel'), 7)
	DECLARE @failedRPOScheduleJobDelayInterval INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name='DelayForRPOScheduleFailedJobInMins'), 15)
	-- First get all the subclients for which we need to process.
	-- If processOnlySchedules is set to true, then call is done from TM_GetcontinuousPatterns.
	-- We have to identify continuous schedules and their associations/subclient with use job start time set.
	-- This checks whether any subclient needs to have next run time computed.
	-- If temp table isnt created then we create it here.
	IF object_id('tempdb.dbo.#continousPattern_Association') is NOT NULL
	BEGIN
		DROP TABLE #continousPattern_Association
	END
	CREATE TABLE #continousPattern_Association (stId INT, taskId INT, patId INT, clId INT, appTypeId INT, instId INT, bsId INT, scId INT, lastSuccessBkupTime INT DEFAULT 0,
			opType INT DEFAULT 0,taskType INT DEFAULT 0 , jobStartTime INT DEFAULT 0, lastBackupAttrName NVARCHAR(1024), nextBackupAttrName NVARCHAR(1024), freq_interval INT,
			isJobStartTimeSet INT DEFAULT 0, bkpLevel INT DEFAULT 0, patternStartTime INT , isPlanDataSchedulePolicy INT DEFAULT 0, lastJobFailedTimeForRPO INT DEFAULT 0,lastFailureAttrName NVARCHAR(1024), timezoneName NVARCHAR(2048) )
	IF @processOnlySchedules = 1
	BEGIN
		-- Consider only backup schedules.
		INSERT INTO #continousPattern_Association
		(stId, taskId, patId, clId, appTypeId, instId, bsId, scId, lastSuccessBkupTime, opType, taskType,freq_interval,patternStartTime,isPlanDataSchedulePolicy )
		SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId, 0, ST.operationType, T.taskType, PT.freq_interval,PT.active_start_time ,
CASE WHEN (ST.flags& 0x10000 ) > 0 THEN 1 ELSE 0 END
		FROM TM_SubTask ST WITH (NOLOCK)
		JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
		JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
		LEFT OUTER JOIN TM_AssocEntity AE WITH (NOLOCK) ON AE.taskId = ST.taskId
		JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = ST.subTaskId AND O.optionId = 414240771	--_COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE
		AND O.Value = '1' -- Consider only schedules which have usejobStarttime set.
		WHERE T.deleted = 0
		AND T.disabled = 0
AND PT.freq_type = 4096
		AND PT.freq_interval != 0
AND ST.operationType != 1007
AND T.TaskType = 2
AND ST.operationType = 2
		-- Delete all schedules not picked up by JM/scheduler.
		DELETE #continousPattern_Association
		FROM
		(
			--REMOVE ANY SCHEDULES WHICH RUN TIME HAS BEEN CALCULATED BUT NOT PICKED UP BY SCHEDULER
			SELECT stId subTaskId
			FROM #continousPattern_Association RT
			JOIN TM_RunTime R (NOLOCK) ON R.patternId = RT.patId AND R.processed = 0
			JOIN TM_Pattern P (NOLOCK) ON P.patternId = R.patternId
			UNION
			SELECT stId subTaskId
			FROM #continousPattern_Association RT
			JOIN TM_JobRequest (NOLOCK) ON TM_JobRequest.subTaskId = RT.stId
			JOIN TM_Jobs (NOLOCK) ON TM_Jobs.jobRequestId = TM_JobRequest.jobRequestId
			AND ( TM_Jobs.status = 0 OR ( (TM_Jobs.status & 1) = 1 ) ) -- Not picked by JM
		) T
		WHERE T.subTaskId = stId
		UPDATE #continousPattern_Association
		SET bkpLevel =
			CASE
WHEN T.value = 15 --_BACKUP_LEVEL_STUBBING
					THEN 2097152 /*CVBkpLevel.STUB*/
				ELSE T.value
			END
		FROM
		(
			SELECT O.value, O.subTaskId
			FROM #continousPattern_Association RI
JOIN TM_SubTask S (NOLOCK) ON S.subTaskId = RI.stId AND S.operationType = RI.opType AND S.operationType = 2 --_TASK_OPERATION_TYPE_BACKUP
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = S.subTaskId AND O.optionId = 458405394	--_BACKUPOPTION_BACKUP_LEVEL
		) T
		WHERE stId = T.subTaskId
	END
	ELSE IF object_id('tempdb.dbo.#appIdTbl') is NOT NULL -- This shld be called from TM_getbackupentity. That has appIds after all filters/exclusion applied
	-- We can compute for that list alone.
	BEGIN
		INSERT INTO #continousPattern_Association
		(stId, taskId, patId, clId, appTypeId, instId, bsId, scId, lastSuccessBkupTime, opType, taskType,freq_interval,bkpLevel,patternStartTime,isPlanDataSchedulePolicy )
		SELECT ST.subTaskId, ST.taskId, PT.patternId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.appId, 0, ST.operationType, T.taskType, PT.freq_interval,AE.bkpLevel,PT.active_start_time,
CASE WHEN (ST.flags& 0x10000 ) > 0 THEN 1 ELSE 0 END
		FROM TM_SubTask ST WITH (NOLOCK)
		JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId AND ST.subTaskId = @subTaskID
		JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
		JOIN TM_Task T WITH (NOLOCK) ON T.taskId = ST.taskId
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = ST.subTaskId AND O.optionId = 414240771	--_COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE
		AND O.Value = '1' -- Consider only schedules which have usejobStarttime set.
		CROSS JOIN #appIdTbl AE
		WHERE T.deleted = 0
		AND T.disabled = 0
AND PT.freq_type = 4096
		AND PT.freq_interval != 0
AND ST.operationType != 1007
AND ST.operationType = 2
	END
	-- Delete all entries which have backup level as Synthetic full.
	DELETE #continousPattern_Association
		FROM
		(
			SELECT O.value, O.subTaskId
			FROM #continousPattern_Association RI
JOIN TM_SubTask S (NOLOCK) ON S.subTaskId = RI.stId AND S.operationType = RI.opType AND S.operationType = 2 --_TASK_OPERATION_TYPE_BACKUP
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = S.subTaskId AND O.optionId = 458405394	--_BACKUPOPTION_BACKUP_LEVEL
AND O.value = '4' -- 4 --_BACKUP_LEVEL_SYNTHETIC_FULL
		) T
		WHERE stId = T.subTaskId
	UPDATE #continousPattern_Association
SET lastBackupAttrName = CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN 'Last backup start time Continuous '+CONVERT(NVARCHAR(10),stId )
		ELSE 'Last backup start time Continuous' END, -- CV_SC_PROP_LAST_BACKUP_START_TIME
	nextBackupAttrName = 'Next backup start time Continuous '+CONVERT(NVARCHAR(10),stId ) -- CV_SC_PROP_NEXT_BACKUP_START_TIME
	UPDATE #continousPattern_Association
SET lastFailureAttrName = CASE WHEN appTypeId = 137 OR appTypeId = 81 THEN 'Last Backup Failed Time '+CONVERT(NVARCHAR(10),stId )
		ELSE 'Last Backup Failed Time' END -- CV_SC_PROP_LAST_BACKUP_FAILED_TIME
	-- Delete the subclients for which next run time for schedule is already computed.
	DELETE continousPatternAssoc
	FROM  #continousPattern_Association continousPatternAssoc
	INNER JOIN App_SubclientProp ON
	continousPatternAssoc.scId = App_SubclientProp.componentNameId
	AND App_SubclientProp.cs_attrName = CHECKSUM(nextBackupAttrName)
	AND App_SubclientProp.attrName = nextBackupAttrName
	AND App_SubclientProp.modified = 0
	-- UPDATE freq_interval for NON log RPO schedule for SQL IDA to 1 day
	-- Update backup level to differential.
	UPDATE #continousPattern_Association
	SET freq_interval = 60*24,  -- Update it once a day
bkpLevel = 3
	FROM #continousPattern_Association
INNER JOIN APP_PlanProp ON APP_PlanProp.attrName = 'Schedule policy'
AND #continousPattern_Association.appTypeId = 81
	AND #continousPattern_Association.isPlanDataSchedulePolicy = 1
	AND APP_PlanProp.attrVal = CAST(#continousPattern_Association.taskId AS NVARCHAR(10) )
	-- Update backup level to full and update frequency interval for cases where differential isnt supported
	UPDATE #continousPattern_Association
	SET freq_interval = @numOfDefaultDaysForAutoconvertBackupLevel*24*60,  -- Update it once in 7 days by default.freq_interval is in minutes
bkpLevel = 1
	WHERE isPlanDataSchedulePolicy = 1 AND
appTypeId = 81 AND
	(
		EXISTS (SELECT 1 FROM APP_SubClientProp (NOLOCK) WHERE componentNameId=scId AND attrName='Enable Snap Backups' AND attrVal = '1' AND modified=0 AND cs_attrName = CHECKSUM(N'Enable Snap Backups') )	--INTELLISNAP IS ENABLED. it doesnt support differential.
		OR
		(
			EXISTS (SELECT 1 FROM APP_instanceprop WHERE componentNameId=instId AND attrName='MSSQL Server Type' AND modified=0 AND (attrVal in ('Analysis Services', 'Azure DataBase Engine', 'Aws DataBase Engine', 'Azure Managed DataBase Engine'  ) ) ) -- Differential is not supported for blocklevel subclients
		)
	)
	--Update if there is a failed RPO job set for a subclient the failed time
	UPDATE #continousPattern_Association
	SET lastJobFailedTimeForRPO = CAST(attrVal AS INT)
	FROM #continousPattern_Association
	INNER JOIN App_SubclientProp ON App_SubclientProp.componentnameId = #continousPattern_Association.scId
	AND App_SubclientProp.attrName = #continousPattern_Association.lastFailureAttrName
	AND #continousPattern_Association.isPlanDataSchedulePolicy = 1
	AND App_SubclientProp.cs_attrName = CHECKSUM(#continousPattern_Association.lastFailureAttrName)
	AND App_SubclientProp.modified = 0
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
	INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
	SELECT DISTINCT clId, NULL, -1, taskID,patId
	FROM #continousPattern_Association
	WHERE clId>0
	-- If there is schedule with plan associated entity flag set then insert its subclients.
IF EXISTS(SELECT 1 FROM #continousPattern_Association INNER JOIN TM_Task(NOLOCK) ON #continousPattern_Association.taskId = TM_Task.taskId AND (flags & 536870912 ) <> 0)
	BEGIN
		INSERT INTO #SubClients_Timezone_StartTime(appId , timezoneName, taskId)
		SELECT scId, NULL, taskId
		FROM #continousPattern_Association
		WHERE scId>0
AND appTypeId = 106
	END
	-- Compute the job start time if set at client properties.
	EXEC TM_ComputeStarttimeForClient
	-- If vsa has start time set then set it here
	UPDATE continousPattern_Association
	SET jobStartTime = allsubClientsTable.jobStartTime ,
	isJobStartTimeSet = 1,
	timezoneName = allsubClientsTable.timezoneName
	FROM #continousPattern_Association continousPattern_Association
	INNER JOIN #SubClients_Timezone_StartTime  allsubClientsTable ON allsubClientsTable.appId = continousPattern_Association.scId
	AND allsubClientsTable.taskId = continousPattern_Association.taskId
INNER JOIN TM_Task(NOLOCK) ON continousPattern_Association.taskId = TM_Task.taskId AND (flags & 536870912 ) <> 0
	WHERE allsubClientsTable.jobStartTime>=0
	-- Compute the job start time set at organization level.
	UPDATE continousPattern_Association
	SET jobStartTime = allClientsTable.jobStartTime ,
	isJobStartTimeSet = 1
	FROM #continousPattern_Association continousPattern_Association
	INNER JOIN #Clients_Timezone_StartTime  allClientsTable ON allClientsTable.clientId = continousPattern_Association.clId
	AND allClientsTable.taskID = continousPattern_Association.taskID
	AND allClientsTable.patternId = continousPattern_Association.patId
	WHERE allClientsTable.jobStartTime>=0
	AND isJobStartTimeSet = 0
	-- Update timezoneName from clients timezone temp table.
	UPDATE continousPattern_Association
	SET timezoneName = Clients_Timezone.timezoneName
	FROM #continousPattern_Association continousPattern_Association
	INNER JOIN #Clients_Timezone_StartTime Clients_Timezone ON
	continousPattern_Association.clId = Clients_Timezone.clientId
	AND (  continousPattern_Association.timezoneName IS NULL OR LEN(continousPattern_Association.timezoneName) = 0 )
	-- For subclients that have job fail time set, compute the next run time based on global param.
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT continousPattern_Association.scID, nextBackupAttrName, 7,
		(continousPattern_Association.lastJobFailedTimeForRPO + @failedRPOScheduleJobDelayInterval*60),
			@nowTime,0,0
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON continousPattern_Association.scID = App_SubclientProp.componentNameId
		AND	App_SubclientProp.attrname = nextBackupAttrName
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(nextBackupAttrName)
		WHERE App_SubclientProp.attrVal IS NULL AND continousPattern_Association.lastJobFailedTimeForRPO > 0
		AND (continousPattern_Association.lastJobFailedTimeForRPO + @failedRPOScheduleJobDelayInterval*60)>@nowTime
	--Delete from Subclient prop table and temp table with last failure as it is calculated above and saved
	DELETE App_SubclientProp FROM App_SubclientProp
	INNER JOIN #continousPattern_Association CPA
	ON CPA.scId = App_SubclientProp.componentNameId AND CPA.lastJobFailedTimeForRPO > 0
	WHERE App_SubclientProp.attrName = lastFailureAttrName
	AND App_SubclientProp.cs_attrName = CHECKSUM(lastFailureAttrName)
	DELETE #continousPattern_Association
	WHERE lastJobFailedTimeForRPO > 0
	-- For subclients that have job Start time set, compute the next run time.
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT continousPattern_Association.scID, nextBackupAttrName, 7, dbo.TM_GetNextRunTimeScForContSchedule(continousPattern_Association.jobStartTime,freq_interval,timezoneName)  , -- PROPERTY_INTEGER
			@nowTime,0,0
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON continousPattern_Association.scID = App_SubclientProp.componentNameId
		AND	App_SubclientProp.attrname = nextBackupAttrName
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(nextBackupAttrName)
		WHERE App_SubclientProp.attrVal IS NULL AND isJobStartTimeSet = 1
	-- Delete subclients where job start time is set since they are processed above.
	DELETE #continousPattern_Association
	WHERE isJobStartTimeSet = 1
	IF EXISTS(SELECT 1 FROM #continousPattern_Association continousPattern_Association
	LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
	AND App_SubclientProp.attrname = lastBackupAttrName
	AND App_SubclientProp.modified = 0
	AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
	WHERE App_SubclientProp.attrVal IS NULL -- We need last backup time only when jobstartTime isnt set. Else we can always use that
	)
	BEGIN
		-- Update the lastSuccessBkupTime if not computed already from running jobs table.
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7, MAX(JMJobInfo.jobstartTime),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName -- CV_SC_PROP_LAST_BACKUP_START_TIME
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		AND App_SubclientProp.modified = 0
		INNER JOIN JMBkpJobInfo ON JMBkpJobInfo.applicationID = continousPattern_Association.scID
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		INNER JOIN JMJobInfo ON JMJobInfo.jobID = JMBkpJobInfo.jobId AND JMJobInfo.commcellId = 2 -- DEFAULT_COMMCELL_ID
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId != 137
AND continousPattern_Association.appTypeId != 81
		GROUP BY continousPattern_Association.scID
		UNION
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7, MAX(JMJobInfo.jobstartTime),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName -- CV_SC_PROP_LAST_BACKUP_START_TIME
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		INNER JOIN JMBkpJobInfo ON JMBkpJobInfo.applicationID = continousPattern_Association.scId
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		AND JMBkpJobInfo.backupTaskId = continousPattern_Association.stId
		INNER JOIN JMJobInfo ON JMJobInfo.jobID = JMBkpJobInfo.jobId AND JMJobInfo.commcellId = 2 -- DEFAULT_COMMCELL_ID
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId = 137
		GROUP BY continousPattern_Association.scID,continousPattern_Association.stId
		UNION
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7, MAX(JMJobInfo.jobstartTime),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName -- CV_SC_PROP_LAST_BACKUP_START_TIME
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		AND App_SubclientProp.modified = 0
		INNER JOIN JMBkpJobInfo ON JMBkpJobInfo.applicationID = continousPattern_Association.scId
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		AND (
			(dbo.GetBackupLevel(continousPattern_Association.bkpLevel) = JMBkpJobInfo.bkpLevel AND isPlanDataSchedulePolicy = 0)  --_CV_APPTYPE_MSSQL
			-- for data schedule policy of plan associated to SQL subclients, last backup time should be last backup time of full or differential job. And not just the full job.
			OR (isPlanDataSchedulePolicy = 1 AND (JMBkpJobInfo.bkpLevel = 1 OR JMBkpJobInfo.bkpLevel = 4)  ) -- Full backup level OR DIFFERENTIAL backup level
		)
		INNER JOIN JMJobInfo ON JMJobInfo.jobID = JMBkpJobInfo.jobId AND JMJobInfo.commcellId = 2 -- DEFAULT_COMMCELL_ID
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId = 81
		GROUP BY continousPattern_Association.scID,continousPattern_Association.stId
	END
	IF EXISTS(SELECT 1 FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		AND App_SubclientProp.modified = 0
		WHERE App_SubclientProp.attrVal IS NULL -- We need last backup time only when jobstartTime isnt set. Else we can always use that
	)
	BEGIN
		-- Update the lastSuccessBkupTime if not computed already from stats table.
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7 , MAX(JMBkpStats.servStartDate),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		INNER JOIN JMBkpStats ON JMBkpStats.appID = continousPattern_Association.scId
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId != 137
AND continousPattern_Association.appTypeId != 81
		GROUP BY continousPattern_Association.scID
		UNION
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7 , MAX(JMBkpStats.servStartDate),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName -- CV_SC_PROP_LAST_BACKUP_START_TIME
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		INNER JOIN JMBkpStats ON JMBkpStats.appID = continousPattern_Association.scId
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		AND JMBkpStats.subTaskId = continousPattern_Association.stId
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId = 137
		GROUP BY continousPattern_Association.scID,continousPattern_Association.stId
		UNION
		SELECT continousPattern_Association.scID, MAX(lastBackupAttrName), 7 , MAX(JMBkpStats.servStartDate),@nowTime,0,0 -- PROPERTY_INTEGER
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp ON App_SubclientProp.componentNameId = continousPattern_Association.scID
		AND App_SubclientProp.attrname = lastBackupAttrName -- CV_SC_PROP_LAST_BACKUP_START_TIME
		AND App_SubclientProp.modified = 0
		AND App_SubclientProp.cs_attrName = CHECKSUM(lastBackupAttrName)
		INNER JOIN JMBkpStats ON JMBkpStats.appID = continousPattern_Association.scId
		AND commcellId = 2 -- DEFAULT_COMMCELL_ID
		AND (
			(dbo.GetBackupLevel(continousPattern_Association.bkpLevel) = JMBkpStats.bkpLevel AND isPlanDataSchedulePolicy = 0)  --_CV_APPTYPE_MSSQL
			-- for data schedule policy of plan associated to SQL subclients, last backup time should be last backup time of full or differential job. And not just the full job.
			OR (isPlanDataSchedulePolicy = 1 AND (JMBkpStats.bkpLevel = 1 OR JMBkpStats.bkpLevel = 4)  ) -- Full backup level OR DIFFERENTIAL backup level
		)
		WHERE App_SubclientProp.attrVal IS NULL
AND continousPattern_Association.appTypeId = 81
		GROUP BY continousPattern_Association.scID,continousPattern_Association.stId
	END
	-- Compute next run time from last run time.
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT DISTINCT continousPattern_Association.scID, nextBackupAttrName, 7 , ISNULL(LastBkpJob.attrVal,0)+freq_interval*60, --PROPERTY_INTEGER
			@nowTime,0,0
		FROM #continousPattern_Association continousPattern_Association
		LEFT JOIN App_SubclientProp NextBkpJob ON NextBkpJob.componentNameId = continousPattern_Association.scID
		AND NextBkpJob.attrname = nextBackupAttrName
		AND NextBkpJob.modified = 0
		AND NextBkpJob.cs_attrName = CHECKSUM(nextBackupAttrName)
		LEFT JOIN App_SubclientProp LastBkpJob ON LastBkpJob.componentNameId = continousPattern_Association.scID
		AND LastBkpJob.attrname = lastBackupAttrName
		AND LastBkpJob.modified = 0
		AND LastBkpJob.cs_attrName = CHECKSUM(lastBackupAttrName)
		WHERE NextBkpJob.attrVal IS NULL
	IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
	BEGIN
		DROP TABLE #Clients_Timezone_StartTime
	END
	IF object_id('tempdb.dbo.#continousPattern_Association') is NOT NULL
	BEGIN
		DROP TABLE #continousPattern_Association
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_ComputeNextStartTime')
	delete from GxQscripts where name = 'TM_ComputeNextStartTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_ComputeNextStartTime')
	delete from GXDBVersions where aliasname = 'TM_ComputeNextStartTime'
GO

insert into GXDBVersions values(2, 'TM_ComputeNextStartTime',  '00000000000000000000', 'TM_ComputeNextStartTime', '00000000000000000000')
GO

