

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_AddMissingEnities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_AddMissingEnities.sp,v $ $Id: TM_AddMissingEnities.sp,v 1.4.60.6 2020/03/12 01:34:46 mnatarajan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 07/01/2009
-- Description:	Fill missing entities
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_AddMissingEnities')
BEGIN
	print '>>> Drop Stored Procedure: TM_AddMissingEnities <<<'
	drop procedure TM_AddMissingEnities
END
IF EXISTS (select * from GxQscripts where name='TM_AddMissingEnities')
	delete from GxQscripts where name = 'TM_AddMissingEnities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddMissingEnities')
	delete from GXDBVersions where aliasname = 'TM_AddMissingEnities'
GO
print '... Creating Procedure: TM_AddMissingEnities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_AddMissingEnities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,	
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
BEGIN TRY
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
			DROP TABLE #AssocEntity
		CREATE TABLE #AssocEntity
		(
			assocId                 integer,
			clientId                integer,
			apptypeId               integer,
			instanceId              integer,
			backupsetId             integer
		)
		CREATE CLUSTERED INDEX AssocEntity_assocId_Idx ON #AssocEntity(assocId)
		INSERT INTO #AssocEntity (assocId,clientId,apptypeId,instanceId, backupsetId)
		SELECT TM_AssocEntity.assocId,App_application.clientId,App_application.appTypeId, App_application.instance, App_application.backupSet FROM TM_AssocEntity (NOLOCK)
			INNER JOIN App_Application (NOLOCK) ON TM_AssocEntity.subclientId > 0
			AND TM_AssocEntity.subclientId = App_application.id
			AND (App_application.clientId=TM_AssocEntity.clientId OR TM_AssocEntity.clientId=0)
			AND (App_application.appTypeId = TM_AssocEntity.appTypeId OR TM_AssocEntity.appTypeId=0) AND (App_application.instance=TM_AssocEntity.instanceId OR TM_AssocEntity.instanceId=0)
			AND (App_application.backupSet=TM_AssocEntity.backupSetId OR TM_AssocEntity.backupSetId=0)
			WHERE TM_AssocEntity.taskId = @i_taskId
			-- Update only if any of the parents are missing.
			AND (TM_AssocEntity.clientId = 0 OR TM_AssocEntity.appTypeId=0 OR TM_AssocEntity.instanceId=0 OR TM_AssocEntity.backupSetId=0 )
		UNION
			SELECT TM_AssocEntity.assocId,App_application.clientId,App_application.appTypeId, App_application.instance, App_application.backupSet FROM TM_AssocEntity (NOLOCK)
			INNER JOIN App_Application (NOLOCK) ON TM_AssocEntity.taskId = @i_taskId AND TM_AssocEntity.subclientId <= 0 AND TM_AssocEntity.backupsetId>0
			AND TM_AssocEntity.backupsetId = App_application.backupset
			AND (App_application.clientId=TM_AssocEntity.clientId OR TM_AssocEntity.clientId=0)
			AND (App_application.appTypeId = TM_AssocEntity.appTypeId OR TM_AssocEntity.appTypeId=0)
			AND (App_application.instance=TM_AssocEntity.instanceId OR TM_AssocEntity.instanceId=0)
			WHERE  -- Update only if any of the parents are missing.
			(TM_AssocEntity.clientId = 0 OR TM_AssocEntity.appTypeId=0 OR TM_AssocEntity.instanceId=0 )
		UNION
			SELECT TM_assocentity.assocId,App_application.clientId, App_application.appTypeId, App_application.instance, App_application.backupSet
			FROM TM_AssocEntity (NOLOCK) INNER JOIN App_Application (NOLOCK) ON TM_AssocEntity.taskId = @i_taskId  AND TM_AssocEntity.subclientId <= 0 AND TM_AssocEntity.backupsetId<=0 AND TM_AssocEntity.instanceId>0
			AND TM_AssocEntity.instanceId = App_application.instance
			AND (App_application.clientId=TM_AssocEntity.clientId OR TM_AssocEntity.clientId=0)
			AND (App_application.appTypeId = TM_AssocEntity.appTypeId OR TM_AssocEntity.appTypeId=0)
			WHERE
			-- Update only if any of the parents are missing.
			 (TM_AssocEntity.clientId = 0 OR TM_AssocEntity.appTypeId=0 )
		IF EXISTS(SELECT 1 FROM #AssocEntity)
		BEGIN
			UPDATE TM_AssocEntity
			SET clientId=T.clientId, apptypeId=T.appTypeId, instanceId=T.instanceId, backupsetId=T.backupSetId
			FROM TM_AssocEntity  INNER JOIN #AssocEntity T
			ON T.assocId = TM_AssocEntity.assocId
		END
	END
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
END CATCH;
EXIT_ADD_MISSING_ENTITIES:
IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
    DROP TABLE #AssocEntity
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_AddMissingEnities')
	delete from GxQscripts where name = 'TM_AddMissingEnities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddMissingEnities')
	delete from GXDBVersions where aliasname = 'TM_AddMissingEnities'
GO

insert into GXDBVersions values(2, 'TM_AddMissingEnities',  '00010004006000060000', 'TM_AddMissingEnities', '00010004006000060000')
GO

