

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_AddEntityToTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_AddEntityToTask.sp,v $ $Id: TM_AddEntityToTask.sp,v 1.5.2.5 2020/08/27 20:29:33 rengu Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 05/28/2012
-- Description:	Add subclient to schedule policy
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TM_AddEntityToTask')
BEGIN
	print '>>> Drop Stored Procedure: TM_AddEntityToTask <<<'
	drop procedure TM_AddEntityToTask
END
IF EXISTS (select * from GxQscripts where name='TM_AddEntityToTask')
	delete from GxQscripts where name = 'TM_AddEntityToTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddEntityToTask')
	delete from GXDBVersions where aliasname = 'TM_AddEntityToTask'
GO
print '... Creating Procedure: TM_AddEntityToTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_AddEntityToTask
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_subclientId integer,
  @i_clientGroupId integer = 0,
  @i_clientId integer = 0,
  @i_InstanceId integer = 0,
  @i_appTypeId integer = 0,
  @i_backupSetId integer = 0,
  @i_archGroupId integer = 0,
  @i_archGroupCopyId integer = 0,
  @i_taskId integer = 0,
  @i_taskFlag integer = 0x20
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
	DECLARE @now		INT = dbo.GetUnixTime(GETDATE())
DECLARE @assocType	INT = 28
	DECLARE @policyId	INT = 0
	DECLARE @copyNotRequired INT = 0
	IF @i_taskId = 0
	BEGIN
SET @i_taskId = (SELECT MIN(taskId) FROM TM_Task WHERE taskType=4 AND flags&@i_taskFlag=@i_taskFlag)
	END
	IF @i_clientGroupId > 0
	BEGIN
		INSERT INTO TM_AssocEntity	(assocType,			taskId,			flags,		created,		exclude,
									 clientGroupId,		clientId,		apptypeId,	instanceId,		backupsetId,
									 subclientId,		policyId,		copyId,		srmReportSet,	srmReportType,
									 trackingPolicyId,	MediaAgentId,	agentlessPolicyId, workflowId, sidbStoreId,
									 libraryId, logMonitoringPolicyId
									 )
values						(28,	@i_taskId,		0,			@now,		0,
									 @i_clientGroupId,	0,				0,			0,				0,
									 0,					0,				0,			0,				0,
									 0,					0,				0,			0,				0,
									 0,					0
									 )
	END
	ELSE
	BEGIN
		IF @i_subclientId > 0
		BEGIN
SET @assocType = 7
			IF @i_backupSetId = 0 OR @i_InstanceId = 0 OR @i_appTypeId = 0 OR @i_clientId = 0
				SELECT @i_backupSetId=backupSet, @i_InstanceId=instance, @i_appTypeId=appTypeId, @i_clientId=clientId FROM APP_Application WHERE id = @i_subclientId
		END
		ELSE
		BEGIN
			IF @i_clientId > 0
SET @assocType = 3
			IF @i_appTypeId > 0
SET @assocType = 4
			IF @i_InstanceId > 0
SET @assocType = 5
			IF @i_backupSetId > 0
SET @assocType = 6
			IF @i_archGroupId > 0
			BEGIN
SET @assocType = 17
				SET @policyId = @i_archGroupId
			END
			IF @i_archGroupCopyId > 0
			BEGIN
SET @assocType = 18
				SELECT @policyId = archGroupId FROM archGroupCopy (READUNCOMMITTED) WHERE id = @i_archGroupCopyId
				--If there is a association to the policy level, do not include new copy as all copies already handles it
IF EXISTS(SELECT 1 FROM TM_AssocEntity(NOLOCK) WHERE policyId = @policyId AND taskId = @i_taskId AND assoctype = 17)
OR EXISTS(SELECT 1 FROM TM_AssocEntity(NOLOCK) WHERE taskId = @i_taskId AND assoctype = 16)
				BEGIN
					SET @copyNotRequired = 1
				END
			END
		END
		IF @copyNotRequired = 0
		BEGIN
			INSERT INTO TM_AssocEntity	(assocType,			taskId,			flags,		created,		exclude,
										 clientGroupId,		clientId,		apptypeId,	instanceId,		backupsetId,
										 subclientId,		policyId,		copyId,		srmReportSet,	srmReportType,
										 trackingPolicyId,	MediaAgentId,	agentlessPolicyId, workflowId, sidbStoreId,
										 libraryId, logMonitoringPolicyId
										 )
			values						(@assocType,		@i_taskId,		0,			@now,		0,
										 @i_clientGroupId,	@i_clientId,	@i_appTypeId,	@i_InstanceId,	@i_backupSetId,
										 @i_subclientId,	@policyId,		@i_archGroupCopyId,			0,				0,
										 0,					0,				0,			0,				0,
										 0,					0
										 )
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_AddEntityToTask')
	delete from GxQscripts where name = 'TM_AddEntityToTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddEntityToTask')
	delete from GXDBVersions where aliasname = 'TM_AddEntityToTask'
GO

insert into GXDBVersions values(2, 'TM_AddEntityToTask',  '00010005000200050000', 'TM_AddEntityToTask', '00010005000200050000')
GO

