

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TM_AddBitOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TM_AddBitOptions.sp,v $ $Id: TM_AddBitOptions.sp,v 1.3.60.2 2018/07/28 04:59:53 duncan Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 03/28/2010
-- Description:	Add extended and bit options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TM_AddBitOptions <<<'

IF EXISTS (select * from sysobjects where name='TM_AddBitOptions')
	drop procedure TM_AddBitOptions
IF EXISTS (select * from GxQscripts where name='TM_AddBitOptions')
	delete from GxQscripts where name = 'TM_AddBitOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddBitOptions')
	delete from GXDBVersions where aliasname = 'TM_AddBitOptions'
GO
print '... Creating Procedure: TM_AddBitOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TM_AddBitOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId integer,
  @i_subTaskId integer,	
  @i_subTaskType integer,	
  @errorCode integer OUTPUT,
  @errorString nvarchar(MAX) OUTPUT
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
--BEGIN TRAN	--START THE TRANSACTION
	DECLARE		@bitOption			BIGINT = 0
	DECLARE		@tmpOption			BIGINT = 0
	DECLARE		@enumOption			INT = 0
	DECLARE		@extendedOption		NVARCHAR(1024) = ''
IF @i_subTaskType = 2
	BEGIN
		--ADDING NAS OPTIONS
SET @enumOption = ISNULL((SELECT value FROM dbo.TM_SubTaskOptions WHERE subTaskId = @i_subTaskId AND optionId = 1621564344), 0)
		SET @bitOption = CASE @enumOption
WHEN 1 THEN
									@bitOption | 0x10
WHEN 2 THEN
									@bitOption | 0x20
WHEN 3 THEN
									@bitOption | 0x30
							ELSE
									@bitOption
						END
EXEC dbo.BuildSubTaskOptionProc @i_taskId, @i_subTaskId, 12, @tmpOption OUTPUT
		SET @bitOption = @bitOption | @tmpOption
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
100005,			-- optionId - bigint
15,	-- type - int
				  @bitOption				-- value - nvarchar(max)
				)
		SET @errorString = @errorString + 'BKP_NAS_OPTION = [' + CAST(@bitOption AS NVARCHAR(24)) + ']. ';
		--ADDING BACKUP OPTIONS
EXEC dbo.BuildSubTaskOptionProc @i_taskId, @i_subTaskId, 4, @bitOption OUTPUT
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
100003,				-- optionId - bigint
15,	-- type - int
				  @bitOption				-- value - nvarchar(max)
				)
		SET @errorString = @errorString + 'BKP_OPTION = [' + CAST(@bitOption AS NVARCHAR(24)) + ']. ';
		--ADDING BACKUP EXTENED OPTIONS
EXEC dbo.BuildSubTaskExtOptionProc @i_taskId, @i_subTaskId, 5, @extendedOption OUTPUT
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
100004,				-- optionId - bigint
1,	-- type - int
				  @extendedOption				-- value - nvarchar(max)
				)
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
140015,				-- optionId - bigint
1,	-- type - int
				  @extendedOption				-- value - nvarchar(max)
				)
		SET @errorString = @errorString + 'BKP_EXTENDED = [' + @extendedOption + ']. ';
	END
ELSE IF @i_subTaskType = 1
	BEGIN
		--ADDING ADMIN OPTIONS
EXEC dbo.BuildSubTaskOptionProc @i_taskId, @i_subTaskId, 3, @bitOption OUTPUT
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
130006,		-- optionId - bigint
15,	-- type - int
				  @bitOption				-- value - nvarchar(max)
				)
		SET @errorString = @errorString + 'ADM_REPORT_OPTION = [' + CAST(@bitOption AS NVARCHAR(24)) + ']. ';
		--ADDING ADMIN EXTENED OPTIONS
EXEC dbo.BuildSubTaskExtOptionProc @i_taskId, @i_subTaskId, 7, @extendedOption OUTPUT
		INSERT INTO dbo.TM_SubTaskOptions
				( subTaskId, optionId, type, value )
		VALUES  ( @i_subTaskId,				-- subTaskId - int
130005,				-- optionId - bigint
1,	-- type - int
				  @extendedOption			-- value - nvarchar(max)
				)
		SET @errorString = @errorString + 'ADM_EXTENDED = [' + @extendedOption + ']. ';
	END
--COMMIT TRAN
END TRY
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to get error information.
    EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    --IF XACT_STATE() <> 0
    --BEGIN
    --    ROLLBACK TRANSACTION;		--This is called for upgrade, rolling back transaction may not be correct
    --END
END CATCH;
END
GO

IF EXISTS (select * from GxQscripts where name = 'TM_AddBitOptions')
	delete from GxQscripts where name = 'TM_AddBitOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TM_AddBitOptions')
	delete from GXDBVersions where aliasname = 'TM_AddBitOptions'
GO

insert into GXDBVersions values(2, 'TM_AddBitOptions',  '00010003006000020000', 'TM_AddBitOptions', '00010003006000020000')
GO

