

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TMFilterSubclientsByOperationWindowWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Madhusudhanan Natarajan
--      Date:   28/11/2006
--
--      | Input:                pairID  - pair id
--                                                          status      - initial status
--
--      | Output:               jobId   - job id
--                                                              existed - job existing flag
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TMFilterSubclientsByOperationWindowWrapper.sp,v $ $Id: TMFilterSubclientsByOperationWindowWrapper.sp,v 1.1.2.2 2020/08/28 06:57:11 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TMFilterSubclientsByOperationWindowWrapper')
BEGIN
	print '>>> Drop Stored Procedure: TMFilterSubclientsByOperationWindowWrapper <<<'
	drop procedure TMFilterSubclientsByOperationWindowWrapper
END
IF EXISTS (select * from GxQscripts where name='TMFilterSubclientsByOperationWindowWrapper')
	delete from GxQscripts where name = 'TMFilterSubclientsByOperationWindowWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TMFilterSubclientsByOperationWindowWrapper')
	delete from GXDBVersions where aliasname = 'TMFilterSubclientsByOperationWindowWrapper'
GO
print '... Creating Procedure: TMFilterSubclientsByOperationWindowWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TMFilterSubclientsByOperationWindowWrapper
  @inputXml XML OUTPUT, 
  @includeDoNotSubmitJobFilter INTEGER
-- For daily/weekly schedules, we need to filter subclients if option doNotsubmitJob is set. For them, pass includeDoNotSubmitJobFilter is 1.
-- for continous schedules, we dont need to look at this flag and this flag will be passed as 0.
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @includeDoNotSubmitJobFilter<>0 AND NOT EXISTS(SELECT 1 FROM App_OpwindowRule WHERE doNotsubmitJob = 1)
BEGIN
	-- Check if there is any operation window with option to not start job selected. If not, there is nothing to process
	SELECT @inputXml
	RETURN
END
	DECLARE @csTimezone nvarchar(max) = dbo.GetClientTimezone(2) -- CS timezone.
	if object_id('tempdb.dbo.#inputScsScheduleInfo') is not null
    		DROP TABLE #inputScsScheduleInfo
		CREATE TABLE #inputScsScheduleInfo (
			appId INT,
			clientId INT,
			stID	INT,
			stXml   XML
		)
		CREATE CLUSTERED INDEX inputScsScheduleInfo_appId_clientID_stId_idx ON #inputScsScheduleInfo (appId,clientId, stId)
		INSERT INTO #inputScsScheduleInfo(appId ,clientId ,stID	, stXml )
		SELECT ISNULL(ref.value('(../subclient/@subclientId)[1]', 'int'),0),
			ISNULL(ref.value('(../subclient/@clientId)[1]', 'int'),0),
			ISNULL(ref.value('(scheduleEntity/@subtaskId )[1]','int'),0),
			ref.query('.')
		FROM @inputXml.nodes('TMMsg_BackupEntityInfoList/subclientInfo/schedules') R(ref)
	-- Generate temp table from input xml
--- CODE BELOW HERE IS FROM TM_AppIdTblCreate.spb  ----------
		-------------------------------
		--CREATE TEMP TABLE------------
		-------------------------------
		-- None of these temp tables should ever exist when this procedure is called!
		if object_id('tempdb.dbo.#appIdTbl') is not null
    		DROP TABLE #appIdTbl
		CREATE TABLE #appIdTbl (
			appId INT,
			appTypeId INT,
			clientId INT,
			instanceId INT,
			backupsetId INT,
			STATUS INT,
			bkpLevel INT,
			storagePolicy INT,
timezoneName nvarchar(255) DEFAULT '',
			ignoreHigherLevelOpWindowRules	INT DEFAULT 0,
			jmOperationType INT DEFAULT 0,
			taskID			INT DEFAULT 0,
			parentJobId int DEFAULT 0,
			parentAppID int DEFAULT 0,
			vmDiscovered INT DEFAULT 0,
			utcdateTime     DATETIME DEFAULT '1970-01-01 00:00:00.000', -- Needed for Predict SLA project where we need to identify if backup time is outside operation window.
			stID		INT DEFAULT 0
		)
		CREATE CLUSTERED INDEX appIdTbl_idx ON #appIdTbl (appId)
		CREATE NONCLUSTERED INDEX appIdTbl_clientId_idx ON #appIdTbl ([clientId])
		CREATE NONCLUSTERED INDEX appIdTbl_appTypeId_idx ON #appIdTbl ([appTypeId])
		CREATE NONCLUSTERED INDEX appIdTbl_timezoneName_idx ON #appIdTbl ([timezoneName])
--- CODE ABOVE HERE IS FROM TM_AppIdTblCreate.spb  ----------
	INSERT INTO #appIdTbl
	(appId, appTypeId, clientId, instanceId, backupsetId, STATUS, bkpLevel, storagePolicy, taskId, stID, utcdateTime)
	SELECT ISNULL(ref.value('(../subclient/@subclientId)[1]', 'int'),0),
		ISNULL(ref.value('(../subclient/@applicationId)[1]', 'int'),0),
		ISNULL(ref.value('(../subclient/@clientId)[1]', 'int'),0),
		ISNULL(ref.value('(../subclient/@instanceId)[1]', 'int'),0),
		ISNULL(ref.value('(../subclient/@backupsetId)[1]','int'),0),
		0,
		ISNULL(ref.value('@backupLevel','int'),0),
		0,
		ISNULL(ref.value('(scheduleEntity/@taskId )[1]','int'),0),
		ISNULL(ref.value('(scheduleEntity/@subtaskId )[1]','int'),0),
		-- this is in utc
		dbo.getdatetime(ISNULL(ref.value('@nextScheduleTime','int'),0))
	FROM @inputXml.nodes('TMMsg_BackupEntityInfoList/subclientInfo/schedules') R(ref)
	EXEC TMFilterSubclientsByOperationWindow @includeDoNotSubmitJobFilter
	DELETE inputScsScheduleInfo FROM #inputScsScheduleInfo inputScsScheduleInfo
	LEFT JOIN #appIdTbl ON inputScsScheduleInfo.appId = #appIdTbl.appID
	AND inputScsScheduleInfo.clientID = #appIdTbl.clientID
	AND inputScsScheduleInfo.stID = #appIdTbl.stID
	WHERE #appIdTbl.stID is NULL
	SET @inputXml = (SELECT
		(
			SELECT clientId '@clientId', appTypeId '@applicationId', instanceId '@instanceId', backupsetId '@backupsetId' , appId '@subclientId'
			FOR XML PATH('subclient'),TYPE
		),
		(
			SELECT stXml.query('.')
			FROM #inputScsScheduleInfo scInfo
			WHERE scInfo.clientID = appIdTbl.clientID AND scInfo.appId = appIdTbl.appID
			FOR XML PATH(''),TYPE
		)
	FROM
	(
		SELECT DISTINCT clientId , appTypeId , instanceId , backupsetId , appId
		FROM #appIdTbl
	) appIdTbl
	FOR XML PATH('subclientInfo'),root('TMMsg_BackupEntityInfoList'))
	IF @inputXml IS NULL
	BEGIN
		SET @inputXml = '<TMMsg_BackupEntityInfoList/>'
	END
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'TMFilterSubclientsByOperationWindowWrapper')
	delete from GxQscripts where name = 'TMFilterSubclientsByOperationWindowWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TMFilterSubclientsByOperationWindowWrapper')
	delete from GXDBVersions where aliasname = 'TMFilterSubclientsByOperationWindowWrapper'
GO

insert into GXDBVersions values(2, 'TMFilterSubclientsByOperationWindowWrapper',  '00010001000200020000', 'TMFilterSubclientsByOperationWindowWrapper', '00010001000200020000')
GO

