

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TMFilterSubclientsByOperationWindow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Madhusudhanan Natarajan
--      Date:   28/11/2006
--
--      | Input:                pairID  - pair id
--                                                          status      - initial status
--
--      | Output:               jobId   - job id
--                                                              existed - job existing flag
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/TMFilterSubclientsByOperationWindow.sp,v $ $Id: TMFilterSubclientsByOperationWindow.sp,v 1.1.2.6 2020/05/20 09:46:13 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='TMFilterSubclientsByOperationWindow')
BEGIN
	print '>>> Drop Stored Procedure: TMFilterSubclientsByOperationWindow <<<'
	drop procedure TMFilterSubclientsByOperationWindow
END
IF EXISTS (select * from GxQscripts where name='TMFilterSubclientsByOperationWindow')
	delete from GxQscripts where name = 'TMFilterSubclientsByOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TMFilterSubclientsByOperationWindow')
	delete from GXDBVersions where aliasname = 'TMFilterSubclientsByOperationWindow'
GO
print '... Creating Procedure: TMFilterSubclientsByOperationWindow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TMFilterSubclientsByOperationWindow
  @includeDoNotSubmitJobFilter INTEGER
-- For daily/weekly schedules, we need to filter subclients if option doNotsubmitJob is set. For them, pass includeDoNotSubmitJobFilter is 1.
-- for continous schedules, we dont need to look at this flag and this flag will be passed as 0.
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
IF @includeDoNotSubmitJobFilter<>0
BEGIN
	-- Check if there is any operation window with option to not start job selected. If not, there is nothing to process
	IF NOT EXISTS(SELECT 1 FROM App_OpwindowRule WHERE doNotsubmitJob = 1)
	BEGIN
		RETURN
	END
END
-- This should be called from TM_Getbackupentity to identify subclients which should be filtered because of operation window.
-- Check whether #appIdTbl is present and if not, return
IF object_id('tempdb.dbo.#appIdTbl') is NULL
BEGIN
	RETURN
END
DECLARE @differentRunTimesForScs INT = 0
DECLARE @UTCTime   DATETIME = GetUTCDate() --Get the current time in UTC here
DECLARE @now   INT      = dbo.getunixtime(@UTCTime)
IF EXISTS(SELECT 1 FROM #appIdTbl WHERE utcDateTime > @UTCTime)
BEGIN
	SET @differentRunTimesForScs = 1
END
-- For regular case update utcdatetime to current utcdatetime if it isnt specified.
UPDATE #appIdTbl
SET utcDateTime = @UTCTime
WHERE utcDateTime < @UTCTime
-- Identify all clients and their timezones and pass to function
IF object_id('tempdb.dbo.#Clients_Timezone') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone
END
CREATE TABLE #Clients_Timezone(clientId INT, timezoneName NVARCHAR(1025) )
DECLARE @pseudoClient_status BIGINT = 0x200000
SET @pseudoClient_status = @pseudoClient_status | 0x0400 | 0x0200 | 0x0040 | 0x4000000
DECLARE @csTimezone nvarchar(max) = dbo.GetClientTimezone(2) -- CS timezone.
-- Avoid using function to compute client timezone.
-- Compute timezone for all clients for whose subclients we are going to run schedule
Insert into #Clients_Timezone
select distinct A.Id,
	CASE
            WHEN tz.TimeZoneId IS NOT NULL THEN tz.TimeZoneStdName
            WHEN P.componentNameId IS NOT NULL THEN RIGHT(P.attrVal, CHARINDEX(':', REVERSE(P.attrVal)) - 1)
            WHEN ( (A.status & @pseudoClient_status) > 0) OR S.ClientId IS NULL THEN @csTimezone
			ELSE @csTimezone -- Client doesnt have property set. And is not pseudoclient. So setting it to CS timezone.
    END
FROM #appIdTbl appIdTbl INNER JOIN
APP_Client A ON appIdTbl.clientId = A.id
LEFT OUTER JOIN APP_ClientProp P ON
            P.componentNameId = A.Id
            AND P.attrName = N'timezone'
            AND P.modified = 0
    LEFT OUTER JOIN APP_ClientProp P2 ON
            P2.componentNameId = A.Id
            AND P2.attrName = N'timezone id'
            AND P2.modified = 0
	LEFT OUTER JOIN SchedTimeZone tz ON
            P2.attrVal IS NOT NULL
            AND P2.attrVal = CAST(tz.TimeZoneID AS VARCHAR(12))
	LEFT OUTER JOIN simInstalledPackages S ON S.ClientId = A.id
-- Identify distinct timezones among clients and compute current time on those timezones below.
if object_id('tempdb.dbo.#clientTimeTbl') is not null
    DROP TABLE #clientTimeTbl
CREATE TABLE #clientTimeTbl (
	timezoneName NVARCHAR(1025),
	monthCol    INT,
	weekdayCol  INT,
	hourCol     INT,
	minuteCol   INT,
	secondCol   INT,
	yearCol     INT,
	dayCol      INT,
	operationTime  INT DEFAULT 0,
	operationDate  INT DEFAULT 0,
	ClientTime	   DATETIME,
	localMidNightEpoch INTEGER,
	cliWeek		INT DEFAULT 0,
	iscliLastWeek  INT DEFAULT 0,
	cliMonth		INT DEFAULT 0,
	cliYear		INT	DEFAULT 0,
	utcDateTime	DATETIME
)
		DECLARE @WEEK_OF_THE_MONTH_FIRST	INT = 0x01
		DECLARE @WEEK_OF_THE_MONTH_SECOND	INT	= 0x02
		DECLARE @WEEK_OF_THE_MONTH_THIRD	INT = 0x04
		DECLARE @WEEK_OF_THE_MONTH_FOURTH	INT = 0x08
		DECLARE @WEEK_OF_THE_MONTH_LAST		INT = 0x10
		DECLARE @WEEK_OF_THE_MONTH_ALL		INT = 0x20
	--IF @appType = 1000 --When check is required at CS level alone. It isnt needed since appType wont be 1000.
		--	SET @clientID = 2
		INSERT INTO #clientTimeTbl(timezoneName, ClientTime, monthCol , weekdayCol, hourCol , minuteCol ,secondCol , yearCol ,dayCol, operationTime,utcdateTime )
		SELECT DISTINCT #Clients_Timezone.timezoneName, dbo.UTCToLocalTime(appIdTbl.utcdateTime, #Clients_Timezone.timeZoneName),0,0,0,0,0,0,0,0,appIdTbl.utcdateTime
		FROM #Clients_Timezone INNER JOIN #appIdTbl appIdTbl ON appIdTbl.ClientID = #Clients_Timezone.clientID
		DELETE FROM #clientTimeTbl
		WHERE  ClientTime IS NULL
		UPDATE #clientTimeTbl
		SET monthCol = ISNULL(DATEPART(month, ClientTime),0),
		weekdayCol = ISNULL(DATEPART(weekday, ClientTime),0),
		hourCol = ISNULL(DATEPART(hour, ClientTime),0),
		minuteCol = ISNULL(DATEPART(minute, ClientTime),0),
		secondCol = ISNULL(DATEPART(second, ClientTime),0),
		yearCol = ISNULL(DATEPART(year, ClientTime),0),
		dayCol = ISNULL(DATEPART(day, ClientTime),0),
		localMidNightEpoch = dbo.GetUnixTime(CONVERT(datetime,CONVERT(date,ClientTime))) - DATEDIFF(second,utcdateTime,ClientTime),
		cliMonth = DATEPART(MONTH, ClientTime),
		cliYear = DATEPART(YEAR,  ClientTime),
		cliWeek = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, ClientTime), 0), ClientTime) +1
		UPDATE #clientTimeTbl
		SET iscliLastWeek = (CASE WHEN numberOfWeeks = cliWeek THEN 1 ELSE 0 END)
		FROM #clientTimeTbl, APP_YearMonthNumberOfWeeks (NOLOCK)
		WHERE yearNo = cliYear
		AND monthNo =  cliMonth
		UPDATE #clientTimeTbl
		SET operationTime = 3600 * hourCol + 60 * minuteCol + secondCol, --Compute the time of day in seconds
		operationDate = localMidNightEpoch
		--Convert WeekDay into macros OP_SUNDAY (1<<0) ,  OP_MONDAY (1<<1), OP_TUESDAY (1<<2),  OP_WEDNESDAY (1<<3), OP_THURSDAY (1<<4),  OP_FRIDAY (1<<5), OP_SATURDAY (1<<6) defined in AppMgrDefines.h
		-- ie 1 << (WeekDay-1)
		UPDATE #clientTimeTbl
		SET weekdayCol = POWER(2,weekdayCol-1)
		--Checking if there is a commcell level all opType /*OPERATION_ALL*/ then filtering all operations for that window
		IF EXISTS(
			SELECT 1 FROM APP_OpWindowRule WHERE (opType & 1048576 ) = 1048576 AND appTypeId = 1000 AND schedulePolicyId = 0
		)
		BEGIN
			DELETE appIdTbl
			FROM #appIdTbl appIdTbl
			INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
			INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
			INNER JOIN APP_OpWindowRule WITH(NOLOCK)
			ON APP_OpWindowRule.clientId = 2 AND APP_OpWindowRule.appTypeId = 1000 AND schedulePolicyId = 0
			AND appIdTbl.clientId>0 AND (((opType & jmOperationType ) = jmOperationType ) OR ((opType & 1048576 ) = 1048576/*OPERATION_ALL*/ ))
			AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
			AND startTime <= clientTimeTbl.operationTime AND endTime >= clientTimeTbl.operationTime
			AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
			AND (( startDate = 0 OR startDate <= clientTimeTbl.operationDate) AND (endDate = 0 OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
			AND APP_OpWindowRule.instanceId = 0 AND APP_OpWindowRule.backupsetId = 0 AND APP_OpWindowRule.subclientId = 0
			AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
			AND ignoreHigherLevelOpWindowRules = 0
		END
		-- Do for appType 1000 first
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID AND appIdTbl.appTypeId = 1000
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON APP_OpWindowRule.clientId = appIdTbl.clientId
		AND APP_OpWindowRule.appTypeId = appIdTbl.appTypeId
		AND appIdTbl.clientId>0 AND (((opType & jmOperationType ) = jmOperationType ) OR ((opType & 1048576 ) = 1048576/*OPERATION_ALL*/ ))
		AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
		AND startTime <= clientTimeTbl.operationTime AND endTime >= clientTimeTbl.operationTime
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (( startDate = 0 OR startDate <= clientTimeTbl.operationDate) AND (endDate = 0 OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
		AND APP_OpWindowRule.instanceId = 0 AND APP_OpWindowRule.backupsetId = 0 AND APP_OpWindowRule.subclientId = 0
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		AND ignoreHigherLevelOpWindowRules = 0
		-- For below, do for appType != 1000
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON APP_OpWindowRule.subclientId = appIdTbl.appId
		AND appIdTbl.appId>0 AND ((opType & jmOperationType ) = jmOperationType ) AND
		((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
		AND startTime <= clientTimeTbl.operationTime AND endTime >= clientTimeTbl.operationTime
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (( startDate = 0 OR startDate <= clientTimeTbl.operationDate) AND (endDate = 0 OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		AND ignoreHigherLevelOpWindowRules = 0
		--Check if Higher Op window rules has to be ignored
		UPDATE appIdTbl
		SET ignoreHigherLevelOpWindowRules = 1
		FROM #appIdTbl appIdTbl
		INNER JOIN APP_SubClientProp WITH(NOLOCK)
		ON APP_SubClientProp.componentNameID = appIdTbl.appId and APP_SubClientProp.attrName = 'Ignore commcell operation rule'
		and APP_SubClientProp.cs_attrName = CHECKSUM(N'Ignore commcell operation rule')
		AND modified = 0 and attrVal = '1'
		-- Delete subclients whose backupset have operation window set for current time.
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.backupsetId>0 AND APP_OpWindowRule.backupSetId = appIdTbl.backupsetId  AND appIdTbl.backupsetId >0
		AND ((opType & jmOperationType ) = jmOperationType ) AND ((daysOfWeek & weekdayCol ) = clientTimeTbl.weekdayCol )
		AND startTime <= clientTimeTbl.operationTime AND (endTime >= clientTimeTbl.operationTime)
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate))
		AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1 AND APP_OpWindowRule.subclientId = 0
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		UPDATE appIdTbl
		SET ignoreHigherLevelOpWindowRules = 1
		FROM #appIdTbl appIdTbl
		INNER JOIN APP_BackupSetProp WITH(NOLOCK)
		ON APP_BackupSetProp.componentNameID = appIdTbl.backupsetId and APP_BackupSetProp.attrName like 'Ignore commcell operation rule'
		AND modified = 0 and attrVal = '1'
		AND ignoreHigherLevelOpWindowRules = 0
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.instanceId <> 0 --instance level
		AND appIdTbl.clientId = APP_OpWindowRule.clientID AND APP_OpWindowRule.appTypeId = appIdTbl.appTypeId AND APP_OpWindowRule.instanceId = appIdTbl.instanceId AND ((opType & jmOperationType ) = jmOperationType ) AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
		AND (startTime <= clientTimeTbl.operationTime) AND (endTime >= clientTimeTbl.operationTime)
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate))
		AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1 AND APP_OpWindowRule.backupsetId = 0 AND APP_OpWindowRule.subclientId = 0
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		UPDATE appIdTbl
		SET ignoreHigherLevelOpWindowRules = 1
		FROM #appIdTbl appIdTbl
		INNER JOIN  APP_InstanceProp WITH(NOLOCK) ON componentNameID = appIdTbl.instanceId and APP_InstanceProp.attrName like 'Ignore commcell operation rule'
		AND modified = 0 and attrVal = '1'
		AND ignoreHigherLevelOpWindowRules = 0
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.appTypeId <> 0 -- ida level
		AND APP_OpWindowRule.clientId = appIdTbl.clientID AND APP_OpWindowRule.appTypeId = appIdTbl.appTypeId AND ((APP_OpWindowRule.opType & jmOperationType ) = jmOperationType )
		AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol ) AND (startTime <= clientTimeTbl.operationTime) AND (endTime >= clientTimeTbl.operationTime)
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate)) AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
		AND APP_OpWindowRule.instanceId = 0 AND APP_OpWindowRule.backupsetId = 0 AND APP_OpWindowRule.subclientId = 0
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		UPDATE appIdTbl
		SET ignoreHigherLevelOpWindowRules = 1
		FROM #appIdTbl appIdTbl
		INNER JOIN APP_IDAProp WITH(NOLOCK)
		ON ignoreHigherLevelOpWindowRules = 0 AND componentNameID = (SELECT TOP 1 id FROM APP_IDAName WITH(NOLOCK) WHERE APP_IDAName.clientId = appIdTbl.clientID
			AND APP_IDAName.appTypeId = appIdTbl.appTypeId) and APP_IDAProp.attrName like 'Ignore commcell operation rule'
		AND modified = 0 and attrVal = '1'
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN APP_OpWindowRule WITH(NOLOCK)
		ON ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.clientID <> 0 -- client level
		AND APP_OpWindowRule.clientId = appIdTbl.clientID AND APP_OpWindowRule.appTypeId = 0 AND ((opType & jmoperationType ) = jmoperationType ) AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
		AND (startTime <= clientTimeTbl.operationTime) AND (endTime >= clientTimeTbl.operationTime)
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate)) AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl. operationDate))) AND enable = 1
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		UPDATE appIdTbl
		SET ignoreHigherLevelOpWindowRules = 1
		FROM #appIdTbl appIdTbl
		INNER JOIN APP_ClientProp
		ON componentNameID = appIdTbl.clientID and APP_ClientProp.attrName like 'Ignore commcell operation rule'
		AND modified = 0 and attrVal = '1'
		DELETE appIdTbl
		FROM #appIdTbl appIdTbl
		INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
		INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
		INNER JOIN App_ClientGroupAssoc ON appIdTbl.clientID = App_ClientGroupAssoc.clientID
		INNER JOIN APP_OpWindowRule WITH(NOLOCK) ON
		ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.clientID <> 0
		AND App_ClientGroupAssoc.clientGroupId = APP_OpWindowRule.clientGroupId AND APP_OpWindowRule.appTypeId = 0
		AND ((opType & appIdTbl.jmoperationType ) = appIdTbl.jmoperationType ) AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
		AND (startTime <= clientTimeTbl.operationTime) AND (endTime >= clientTimeTbl.operationTime)
		AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
		AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate)) AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
		AND appIdTbl.appTypeId != 1000
		AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		IF EXISTS(SELECT 1 FROM APP_OpWindowRule WITH(NOLOCK)
				INNER JOIN #appIdTbl ON #appIdTbl.taskId = APP_OpWindowRule.schedulePolicyId AND #appIdTbl.taskId>0
		)
		BEGIN
			-- Remove all subclients based on operation window at schedule policy level.
			DELETE appIdTbl
			FROM #appIdTbl appIdTbl
			INNER JOIN #Clients_Timezone Clients_Timezone ON appIdTbl.clientID = Clients_Timezone.clientID
			INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.timezoneName = Clients_Timezone.timezoneName AND appIdTbl.utcDateTime = clientTimeTbl.utcDateTime
			INNER JOIN APP_OpWindowRule WITH(NOLOCK) ON ignoreHigherLevelOpWindowRules = 0 AND appIdTbl.clientID <> 0
			AND APP_OpWindowRule.schedulePolicyId = appIdTbl.taskId
			AND ((opType & appIdTbl.jmoperationType ) = appIdTbl.jmoperationType )
			AND ((daysOfWeek & clientTimeTbl.weekdayCol ) = clientTimeTbl.weekdayCol )
			AND (startTime <= clientTimeTbl.operationTime) AND (endTime >= clientTimeTbl.operationTime) AND (((startDate = 0) OR (startDate <= clientTimeTbl.operationDate))
			AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
			AND ((endDate = 0) OR (endDate + 86400 > clientTimeTbl.operationDate))) AND enable = 1
			AND appIdTbl.appTypeId != 1000
			AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		END
		IF @differentRunTimesForScs=0
		-- Remove all subclients based on operation window at CS level.
		BEGIN
				DECLARE @month       integer
				DECLARE @weekday     integer
				DECLARE @hour     integer
				DECLARE @minute     integer
				DECLARE @second     integer
				DECLARE @year     integer
				DECLARE @day     integer
				DECLARE @operationTime     integer = 0
				DECLARE @operationDate     integer = 0
				DECLARE @ClientTime DATETIME
				DECLARE @localMidNightEpoch INTEGER
				DECLARE @cliWeek INT, @iscliLastWeek INT, @cliMonth INT, @cliYear INT
				DECLARE @clientID INT = 2
				SELECT @ClientTime = clientTime,@year = year,@month = month,@weekday = weekday,@day = day, @hour = hour, @minute = minute,@second = seconds,@localMidNightEpoch = localMidNightEpoch
					FROM dbo.GetUTCToClientLocalTimeInParts(@now,@clientID)
				SET @operationTime = 3600 * @hour + 60 * @minute + @second --Compute the time of day in seconds
				SET @operationDate = @localMidNightEpoch --Compute the mid night time Bug Fix: Should be taken form GetUTCToClientLocalTimeInParts function just like earlier in this function
				--Convert WeekDay into macros OP_SUNDAY (1<<0) ,  OP_MONDAY (1<<1), OP_TUESDAY (1<<2),  OP_WEDNESDAY (1<<3), OP_THURSDAY (1<<4),  OP_FRIDAY (1<<5), OP_SATURDAY (1<<6) defined in AppMgrDefines.h
				-- ie 1 << (WeekDay-1)
				SET @weekday = POWER(2,@weekday-1)
				SELECT @cliWeek = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, @ClientTime), 0), @ClientTime) +1
				SELECT @cliMonth = DATEPART(MONTH, @ClientTime)
				SELECT @cliYear = DATEPART(YEAR, @ClientTime)
				SELECT @iscliLastWeek = (CASE WHEN numberOfWeeks = @cliWeek THEN 1 ELSE 0 END)
					FROM APP_YearMonthNumberOfWeeks (NOLOCK)
					WHERE yearNo = @cliYear
					AND monthNo = @cliMonth
				DELETE appIdTbl FROM #appIdTbl appIdTbl
				INNER JOIN APP_OpWindowRule WITH(NOLOCK)
				ON APP_OpWindowRule.clientId = 2 AND APP_OpWindowRule.appTypeId = 1000 AND ((opType & jmoperationType ) = jmoperationType ) AND ((daysOfWeek & @weekday ) = @weekday )
				AND (startTime <= @operationTime) AND (endTime >= @operationTime)
				AND (((weekOfTheMonth & @cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND @iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
				AND (((startDate = 0) OR (startDate <= @operationDate))
				AND ((endDate = 0) OR (endDate + 86400 > @operationDate))) AND enable = 1 AND APP_OpWindowRule.instanceId = 0 AND APP_OpWindowRule.backupsetId = 0
				AND APP_OpWindowRule.subclientId = 0
				AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		END
		ELSE
		BEGIN
			-- Delete existing rows and get data for utc next runtime with respect to CS timezone.
			TRUNCATE TABLE #clientTimeTbl
			INSERT INTO #clientTimeTbl(timezoneName, ClientTime, monthCol , weekdayCol, hourCol , minuteCol ,secondCol , yearCol ,dayCol, operationTime,utcdateTime  )
			SELECT DISTINCT @csTimezone, dbo.UTCToLocalTime(utcDateTime , @csTimezone),0,0,0,0,0,0,0,0, utcDateTime
			FROM #appIdTbl
			DELETE FROM #clientTimeTbl
			WHERE  ClientTime IS NULL
			UPDATE #clientTimeTbl
			SET monthCol = ISNULL(DATEPART(month, ClientTime),0),
			weekdayCol = ISNULL(DATEPART(weekday, ClientTime),0),
			hourCol = ISNULL(DATEPART(hour, ClientTime),0),
			minuteCol = ISNULL(DATEPART(minute, ClientTime),0),
			secondCol = ISNULL(DATEPART(second, ClientTime),0),
			yearCol = ISNULL(DATEPART(year, ClientTime),0),
			dayCol = ISNULL(DATEPART(day, ClientTime),0),
			localMidNightEpoch = dbo.GetUnixTime(CONVERT(datetime,CONVERT(date,ClientTime))) - DATEDIFF(second,@UTCTime,ClientTime),
			cliMonth = DATEPART(MONTH, ClientTime),
			cliYear = DATEPART(YEAR,  ClientTime),
			cliWeek = DATEDIFF(WEEK, DATEADD(MONTH, DATEDIFF(MONTH, 0, ClientTime), 0), ClientTime) +1
			UPDATE #clientTimeTbl
			SET iscliLastWeek = (CASE WHEN numberOfWeeks = cliWeek THEN 1 ELSE 0 END)
			FROM #clientTimeTbl, APP_YearMonthNumberOfWeeks (NOLOCK)
			WHERE yearNo = cliYear
			AND monthNo =  cliMonth
			UPDATE #clientTimeTbl
			SET operationTime = 3600 * hourCol + 60 * minuteCol + secondCol, --Compute the time of day in seconds
			operationDate = localMidNightEpoch
			--Convert WeekDay into macros OP_SUNDAY (1<<0) ,  OP_MONDAY (1<<1), OP_TUESDAY (1<<2),  OP_WEDNESDAY (1<<3), OP_THURSDAY (1<<4),  OP_FRIDAY (1<<5), OP_SATURDAY (1<<6) defined in AppMgrDefines.h
			-- ie 1 << (WeekDay-1)
			UPDATE #clientTimeTbl
			SET weekdayCol = POWER(2,weekdayCol-1)
			DELETE appIdTbl FROM #appIdTbl appIdTbl
			INNER JOIN #clientTimeTbl clientTimeTbl ON clientTimeTbl.UtcDateTime = appIdTbl.UtcDateTime
			INNER JOIN APP_OpWindowRule WITH(NOLOCK)
			ON APP_OpWindowRule.clientId = 2 AND APP_OpWindowRule.appTypeId = 1000 AND ((opType & jmoperationType ) = jmoperationType ) AND ((daysOfWeek & weekdayCol ) = weekdayCol )
			AND (startTime <= operationTime) AND (endTime >= operationTime)
			AND (((weekOfTheMonth & cliWeek) <> 0) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_LAST AND iscliLastWeek = 1) OR (weekOfTheMonth = @WEEK_OF_THE_MONTH_ALL ))
			AND (((startDate = 0) OR (startDate <= operationDate))
			AND ((endDate = 0) OR (endDate + 86400 > operationDate))) AND enable = 1 AND APP_OpWindowRule.instanceId = 0 AND APP_OpWindowRule.backupsetId = 0
			AND APP_OpWindowRule.subclientId = 0
			AND (@includeDoNotSubmitJobFilter = 0 OR APP_OpWindowRule.doNotsubmitJob = 1)
		END
		RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'TMFilterSubclientsByOperationWindow')
	delete from GxQscripts where name = 'TMFilterSubclientsByOperationWindow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TMFilterSubclientsByOperationWindow')
	delete from GXDBVersions where aliasname = 'TMFilterSubclientsByOperationWindow'
GO

insert into GXDBVersions values(2, 'TMFilterSubclientsByOperationWindow',  '00010001000200060000', 'TMFilterSubclientsByOperationWindow', '00010001000200060000')
GO

