

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TFA_UpdateUMUsersProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   06/01/2013
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TFA_UpdateUMUsersProp <<<'

IF EXISTS (select * from sysobjects where name='TFA_UpdateUMUsersProp')
	drop procedure TFA_UpdateUMUsersProp
IF EXISTS (select * from GxQscripts where name='TFA_UpdateUMUsersProp')
	delete from GxQscripts where name = 'TFA_UpdateUMUsersProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_UpdateUMUsersProp')
	delete from GXDBVersions where aliasname = 'TFA_UpdateUMUsersProp'
GO
print '... Creating Procedure: TFA_UpdateUMUsersProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TFA_UpdateUMUsersProp
  @id int = 0,
  @attr NVARCHAR(1024) = '',
  @val NVARCHAR(MAX) = '',
  @encode int = 0,
  @attrType int = 1
AS
    DECLARE	@o_retVal		integer=0
    DECLARE @errorString	nvarchar(max) = 'NO ERROR'
	IF (@val = '')	-- The user wants to delete the existing property, if any.
	BEGIN
		IF EXISTS (SELECT * FROM UMUsersProp WHERE componentNameId=@id AND attrName = @attr)
		BEGIN
			DELETE FROM UMUsersProp WHERE componentNameId=@id AND attrName = @attr
			IF @@ERROR > 0
			BEGIN
				SET @o_retVal = @@ERROR
				SET @errorString = 'ERROR: DELETE FROM UMUsersProp'
				GOTO proc_exit
			END
		END
	END
	ELSE
	BEGIN
		IF (@encode = 1)
			SET @val = dbo.EncodeSecretCLR(@val)
		IF EXISTS (SELECT * FROM UMUsersProp WHERE componentNameId=@id AND attrName = @attr)
		BEGIN
			UPDATE UMUsersProp SET attrVal = @val, created = dbo.GetUnixTime(GETUTCDATE()) WHERE componentNameId=@id AND attrName = @attr
			IF @@ERROR > 0
			BEGIN
				SET @o_retVal = @@ERROR
				SET @errorString = 'ERROR: UPDATE UMUsersProp SET attrVal'
				GOTO proc_exit
			END
		END
		ELSE
		BEGIN
	        INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
		    VALUES (@id, @attr, @attrType, @val, dbo.GetUnixTime(GETUTCDATE()), 0)
			IF @@ERROR > 0
			BEGIN
				SET @o_retVal = @@ERROR
				SET @errorString = 'ERROR: INSERT INTO UMUsersProp'
				GOTO proc_exit
			END
		END
	END
proc_exit:
    SELECT @o_retVal as [retVal], @errorString as [errorString]
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TFA_UpdateUMUsersProp')
	delete from GxQscripts where name = 'TFA_UpdateUMUsersProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_UpdateUMUsersProp')
	delete from GXDBVersions where aliasname = 'TFA_UpdateUMUsersProp'
GO

insert into GXDBVersions values(2, 'TFA_UpdateUMUsersProp',  '00000000000000000000', 'TFA_UpdateUMUsersProp', '00000000000000000000')
GO

