

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TFA_IsValidGalaxyUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   06/01/2013
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TFA_IsValidGalaxyUser <<<'

IF EXISTS (select * from sysobjects where name='TFA_IsValidGalaxyUser')
	drop procedure TFA_IsValidGalaxyUser
IF EXISTS (select * from GxQscripts where name='TFA_IsValidGalaxyUser')
	delete from GxQscripts where name = 'TFA_IsValidGalaxyUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_IsValidGalaxyUser')
	delete from GXDBVersions where aliasname = 'TFA_IsValidGalaxyUser'
GO
print '... Creating Procedure: TFA_IsValidGalaxyUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure TFA_IsValidGalaxyUser
  @loginName nvarchar(255),
  @userPswd varchar(255),
  @localeId int = 0
AS
    DECLARE	@o_retVal		integer=0
    DECLARE	@o_userId		integer=0
    DECLARE	@o_userGUID		nvarchar(255)=''
DECLARE @tblPassword	nvarchar(255)
DECLARE @userSalt	nvarchar(255)
	DECLARE @login			nvarchar(max) = ''
	DECLARE @mailTo			nvarchar(max) = ''
    DECLARE @errorString	nvarchar(max)=''
    DECLARE @errorCode		int = 0
    DECLARE @nowDay			int = dbo.GetUnixTime(GETUTCDATE())/(60*60*24)
    DECLARE @nowTime		int = dbo.GetUnixTime(GETUTCDATE())
    DECLARE @thenDay		int = 0
    DECLARE @policy			int = 0
    DECLARE @userEnabled	int = 0
    DECLARE @secret			nvarchar(max) = ''
    DECLARE @newSecret		nvarchar(max) = ''
    DECLARE @pins			nvarchar(max) = ''
    DECLARE @OTP			nvarchar(max) = ''
	DECLARE @isPasswordExpired int = 0
    SELECT @tblPassword = password,@userSalt=Salt, @mailTo=ISNULL(email, ''), @login=ISNULL(login, ''), @o_userId=id, @o_userGUID=userGuid, @userEnabled=enabled, @policy=policy, @thenDay=(datePasswordSet/(60*60*24)) FROM UMUsers WHERE login=@loginName
    IF(@o_userId = 0)
    BEGIN
        SET @o_retVal = 0
        SET @errorString = 'Username/Password are incorrect'
        SET @errorCode = 1116 --INVALID_COMMCELL_LOGIN
        goto proc_exit
    END
    IF(@userEnabled=0)
    BEGIN
        SET @o_retVal = 0
        SET @errorString = 'Account Disabled'
        SET @errorCode =  1131 --LOGIN_ERROR_CODES(ERROR_ACCOUNT_DISABLED)
        goto proc_exit
    END
    EXEC sec_isPasswordExpired @o_userId, @o_isExpired = @isPasswordExpired OUTPUT
    IF(@isPasswordExpired = 1)
    BEGIN
        SET @o_retVal = 0
        SET @errorString = 'Account Expired'
        SET @errorCode =  1132 --LOGIN_ERROR_CODES(ERROR_ACCOUNT_EXPIRED)
        goto proc_exit
    END
    SELECT @secret = ISNULL(attrVal, '') FROM UMUsersProp WHERE componentNameId=@o_userId AND attrName = 'secret'
    IF (@secret <> '')
    BEGIN -- Secret found.
		EXEC GetPinsForEncodedSecretManaged @secret, @pins OUTPUT
        IF (@pins <> '')
        BEGIN -- Secret found. PINs obtained.
            SELECT @OTP = ISNULL(attrVal, '') FROM UMUsersProp WHERE componentNameId=@o_userId AND attrName = 'OTP' AND created >= (@nowTime - 30*60)
            IF (@OTP <> '')
            BEGIN
                SET @pins = @pins + ',' + @OTP
            END
            EXEC ValidatePasswordWithPinAndSaltManaged @tblPassword, @userPswd, @userSalt,@pins, @o_retVal OUTPUT, @errorString OUTPUT
            IF (@o_retVal = 0) -- fail
            BEGIN -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed.
                -- user could be using no PIN to login.
                EXEC validateUserNew @tblPassword, @userPswd,@userSalt, @o_retVal OUTPUT, @errorString OUTPUT
                IF (@o_retVal = 0) -- fail
                BEGIN -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed. isValidUserManaged failed.
                    SET @errorString = 'Username/Password are incorrect'
                    SET @errorCode =  1116 --LOGIN_ERROR_CODES(INVALID_COMMCELL_LOGIN)
                    goto proc_exit
                END -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed. isValidUserManaged failed.
                -- Secret was sent to this user earlier. Just send the OTP. Still fail the login though.
                ELSE
                BEGIN -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed. isValidUserManaged succeeded.
					-- Still return failure.
                    SET @o_retVal = 0
                    SET @OTP = dbo.GetOTPForEncodedSecretCLR(@secret)
                    IF(@OTP = '')
                    BEGIN
                        SET @errorString = 'Error while generating OTP for the encoded secret'
                        SET @errorCode = 1127 --LOGIN_ERROR_CODES(ERROR_UNKNOWN)
                        goto proc_exit
                    END
                END -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed. isValidUserManaged succeeded.
            END -- Secret found. PINs obtained. ValidatePasswordWithPINManaged failed.
            ELSE
            BEGIN -- Secret found. PINs obtained. ValidatePasswordWithPINManaged succeeded. Login succeeded.
                SET @o_retVal = 1	-- This is the only place when @o_retVal will be 1!
                SET @errorString = 'NO ERROR'
                SET @errorCode = 0
                -- Delete the OTP, if any.
                -- IF EXISTS (SELECT * FROM UMUsersProp WHERE componentNameId=@o_userId AND attrName = 'OTP')
                -- BEGIN
                    -- DELETE FROM UMUsersProp WHERE componentNameId=@o_userId AND attrName = 'OTP'
                -- END
                goto proc_exit
            END -- Secret found. PINs obtained. ValidatePasswordWithPINManaged succeeded. Login succeeded.
        END -- Secret found. PINs obtained.
        ELSE
        BEGIN -- Secret found. Failed to get PINs for secret.
            SET @o_retVal = 0
            SET @errorString = 'Secret found but failed to generate PINs.'
            SET @errorCode = 1127 --LOGIN_ERROR_CODES(ERROR_UNKNOWN)
            goto proc_exit
        END -- Secret found. Failed to get PINs for secret.
    END -- Secret found.
    -- No secret found for this user. Validate without PIN. If success, generate a secret & OTP, email them and store in DB. Still fail the login though.
    ELSE
    BEGIN -- No Secret Found
       EXEC ValidateUserNew @tblPassword,@userPswd,@userSalt,@o_retVal OUTPUT,@errorString OUTPUT
        IF (@o_retVal = 0) -- fail
        BEGIN -- No Secret Found. isValidUserManaged failed.
            SET @errorString = 'Username/Password are incorrect'
            SET @errorCode =  1116 --LOGIN_ERROR_CODES(INVALID_COMMCELL_LOGIN)
            goto proc_exit
        END -- No Secret Found. isValidUserManaged failed.
        ELSE
        BEGIN -- No Secret Found. isValidUserManaged succeeded.
			-- Still return failure!
			SET @o_retVal = 0
			SET @newSecret = dbo.GetOneSecretCLR()
			IF(@newSecret = '')
			BEGIN
				SET @errorString = 'Error while generating a secret'
				SET @errorCode = 1127 --LOGIN_ERROR_CODES(ERROR_UNKNOWN)
				goto proc_exit
			END
			SET @OTP = dbo.GetOTPForSecretCLR(@newSecret)
			IF(@OTP = '')
			BEGIN
				SET @errorString = 'Error while generating OTP for the secret'
				SET @errorCode = 1127 --LOGIN_ERROR_CODES(ERROR_UNKNOWN)
				goto proc_exit
			END
        END -- No Secret Found. isValidUserManaged succeeded.
    END -- No Secret Found
proc_exit:
    SELECT @o_retVal as [retVal], @o_userId as [userId], @o_userGUID as [userGuid], @login as [login], @newSecret as [secret], @OTP as [OTP], @mailTo as [mailTo], @errorString as [errorString], @errorCode as [errorCode]
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TFA_IsValidGalaxyUser')
	delete from GxQscripts where name = 'TFA_IsValidGalaxyUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_IsValidGalaxyUser')
	delete from GXDBVersions where aliasname = 'TFA_IsValidGalaxyUser'
GO

insert into GXDBVersions values(2, 'TFA_IsValidGalaxyUser',  '00000000000000000000', 'TFA_IsValidGalaxyUser', '00000000000000000000')
GO

