

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TFA_IsDisabledForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   06/01/2013
--  Previously the property was applicable only at commcell level - ON(1),OFF(2),GROUP INC(2)
--  Qscripts allowed - user group exclusions and inclusions based on additional properties
--	Retaining the behavior for backward compatibility.
--	Now, Extending TFA to companies and user groups
--	When you enable/disable at company we set it enabled/disabled for all user groups under that company.
--  the default value at user groups and company is disabled.
--	Exclusions are applicable at group level only when enabled at company.
-- ----------------------------------------------------------------------------
-- |Company			 User group										Ret Value
-- |----------------------------------------------------------------------------
-- |OFF																RET_TFA_USER_DISABLED
-- |ON				User belongs to atleast one group disabled		RET_TFA_USER_DISABLED
-- |				Otherwise										RET_TFA_USER_ENABLED
-- |GROUP_INC		Can be enabled via qscript and user				RET_TFA_USER_ENABLED
-- -----------------------------------------------------------------------------------*/
-- Right now it works at exclusions at group level. Use qscript to create inclusions thats on demand.
-- UI will be simple for now.
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='TFA_IsDisabledForUser')
BEGIN
	print '>>> Drop Stored Procedure: TFA_IsDisabledForUser <<<'
	drop procedure TFA_IsDisabledForUser
END
IF EXISTS (select * from GxQscripts where name='TFA_IsDisabledForUser')
	delete from GxQscripts where name = 'TFA_IsDisabledForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_IsDisabledForUser')
	delete from GXDBVersions where aliasname = 'TFA_IsDisabledForUser'
GO
print '... Creating Procedure: TFA_IsDisabledForUser'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure TFA_IsDisabledForUser
  @i_usrId int=0,
  @i_groupList nvarchar(MAX) = '',
  @i_providerId INT=0,
  @i_domainName varchar(255) = ''
AS
  DECLARE @o_retVal integer=0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
Declare @isTFAEnabledAtCompany integer=0
BEGIN
    IF (@i_usrId < 0)
SET @o_retVal = 1
	ELSE
	BEGIN
		-- FOR A CLIENT'S LOCAL ADMINISTRATOR USER WHO CAN LOGIN USING QCOMMAND WITHOUT PUTTING A PASSWORD, DO NOT APPLY TFA ON THIS USER
		DECLARE @userFlags INTEGER = (SELECT flags FROM UMUsers WHERE id = @i_usrId)
IF (@userFlags & 0x020) = 0x020
		BEGIN
SET @o_retVal = 1
			GOTO PROC_EXIT
		END
		-- Get the company id and property set for the company
		-- Do this so that we dont increase the login time for users that dont belong to companies where its not enabled.
		DECLARE @companyId INTEGER = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@i_usrId,1),0)
DECLARE @extGroupList   TABLE(  t_groupName nvarchar(255),hostName nvarchar(255), providerid INT)
		-- Tenant User
		IF (@companyId <> 0)
		BEGIN
			SET @isTFAEnabledAtCompany = ISNULL(
													(select attrValInt from App_CompanyProp where
attrname = 'EnableTwoFactorAuthentication'
														and componentNameId = @companyId),
0
												)
		END
		ELSE -- Commcell User
		BEGIN
			SET @isTFAEnabledAtCompany = ISNULL(
												(
													select Convert(int, value) from GxGlobalParam WITH (NOLOCK)
where Name = 'EnableTwoFactorAuthentication'
), 0)
		END
IF(@isTFAEnabledAtCompany = 0)
		BEGIN
SET @o_retVal = 1
		END
		ELSE
		BEGIN
			-- Get the user group property,if enabled at company then its default enabled at all groups
			Declare @tempGroupIds Table(groupId int primary key,
										enableTFA INT not null default 1)
			IF(@i_groupList is NULL or @i_groupList = '')
			BEGIN
				Insert into @tempGroupIds
				select umGroupId,1 from UMDSGroupMaps M Join UMDSUserGroup G ON M.umdsgroupId = G.groupId
						where G.userId = @i_usrId
				union
				SELECT groupId,1 from UMUserGroup where userId=@i_usrId
			END
			ELSE
			BEGIN
				DECLARE @UMDSProvider       integer
				DECLARE @delimPos       integer
				DECLARE @delim          char
				SET @delim          = ','
				if(@i_providerId=0)
				BEGIN
					SELECT  TOP 1 @UMDSProvider=ISNULL(id,0) FROM UMDSProviders where domainName = @i_domainName AND enabled = 1
				END
				ELSE
				BEGIN
					SET @UMDSProvider = @i_providerId
				END
				WHILE len(@i_groupList) > 0
				BEGIN
					SET @delimPos = CHARINDEX(@delim, @i_groupList)
					DECLARE @extGroupName nvarchar(512)
					IF @delimPos > 0
					BEGIN
						SET @extGroupName = substring(@i_groupList, 1, @delimPos-1)
						SET @i_groupList = substring(@i_groupList, @delimPos+1, len(@i_groupList)-@delimPos)
					END
					ELSE
					BEGIN
						SET @extGroupName = @i_groupList
						SET @i_groupList = ''
					END
					declare @hostName nvarchar(512)=NULL
					declare @groupName nvarchar(512)=NULL
					declare @groupProviderId INT = @UMDSProvider
					IF(charindex('\',@extGroupName) > 0)
					BEGIN
						SET @hostName = SUBSTRING(@extGroupName,0,charindex('\',@extGroupName))
						SET @groupName = SUBSTRING(@extGroupName,charindex('\',@extGroupName)+1,len(@extGroupName)-len(@hostName))
					END
					ELSE
						SET @groupName=@extGroupName
					INSERT INTO @extGroupList(t_groupname,hostname) VALUES (@groupName,@hostName)
				END
				--populate providerid from hostname
				UPDATE ExGrp SET providerid=id
				FROM @extGroupList ExGrp
				INNER JOIN UMDSProviders ON UMDSProviders.hostName=ExGrp.hostName WHERE ExGrp.hostName IS NOT NULL
				--if hostname is null, consider the provider id of the user
				UPDATE @extGroupList set providerId=@umdsprovider where hostName is NULL
				Insert into @tempGroupIds
				SELECT G.id,1 FROM @extGroupList GL JOIN UMGroups G WITH(NOLOCK) ON G.name = GL.t_groupName AND G.umdsProviderId = GL.providerId and G.groupFlags&1<>0
			END
IF(@isTFAEnabledAtCompany = 1)
			BEGIN
				-- update the property to disabled when its disabled at group level
				UPDATE @tempGroupIds
				SET enableTFA = 0
				WHERE groupId in (
									SELECT groupId FROM
									UMGroupsProp P join @tempGroupIds M ON P.ComponentNameId = M.groupId
where (P.attrName= 'DisableTwoFactorAuthentication'
									and P.attrVal='1')
								 )
				IF EXISTS(SELECT groupId from @tempGroupIds where enableTFA = 0)
				BEGIN
SET @o_retVal = 1
				END
				ELSE
				BEGIN
SET @o_retVal = 0
				END
			END
ELSE IF (@isTFAEnabledAtCompany = 2)
			BEGIN
				-- update the property to disabled when it is not enabled for TFA group inclusion
				UPDATE @tempGroupIds
				SET enableTFA = 0
				WHERE groupId NOT in (
									SELECT groupId FROM
									UMGroupsProp P join @tempGroupIds M ON P.ComponentNameId = M.groupId
where (P.attrName= 'DisableTwoFactorAuthentication'
									and P.attrVal='0')
								 )
				IF EXISTS(SELECT groupId from @tempGroupIds where enableTFA = 1)
				BEGIN
SET @o_retVal = 0
				END
				ELSE
				BEGIN
SET @o_retVal = 1
				END
			END
		END
	END
END
PROC_EXIT:
-- anything above 0 means TFA is disabled for this user
SELECT @o_retVal as [retVal]
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'TFA_IsDisabledForUser')
	delete from GxQscripts where name = 'TFA_IsDisabledForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_IsDisabledForUser')
	delete from GXDBVersions where aliasname = 'TFA_IsDisabledForUser'
GO

insert into GXDBVersions values(2, 'TFA_IsDisabledForUser',  '00000000000000000000', 'TFA_IsDisabledForUser', '00000000000000000000')
GO

