

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/TFA_GetPinsForSecret.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Imtiaz Mohammad
--	Date:   06/01/2013
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   TFA_GetPinsForSecret   - Given a secret, return pin for current interval and pins corresponding to N intervals in the past and future.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: TFA_GetPinsForSecret <<<'

IF EXISTS (select * from sysobjects where name='TFA_GetPinsForSecret')
	drop procedure TFA_GetPinsForSecret
IF EXISTS (select * from GxQscripts where name='TFA_GetPinsForSecret')
	delete from GxQscripts where name = 'TFA_GetPinsForSecret'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_GetPinsForSecret')
	delete from GXDBVersions where aliasname = 'TFA_GetPinsForSecret'
GO
print '... Creating Procedure: TFA_GetPinsForSecret'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure TFA_GetPinsForSecret
  @i_secret nvarchar(1024) = ''
AS
  DECLARE @o_pins nvarchar(1024);
BEGIN
	set @o_pins = ISNULL((select dbo.GetPinsForSecretCLR(@i_secret)), '')
END
SELECT @o_pins as [pins]
GO

IF EXISTS (select * from GxQscripts where name = 'TFA_GetPinsForSecret')
	delete from GxQscripts where name = 'TFA_GetPinsForSecret'
GO

IF EXISTS (select * from GXDBVersions where aliasname='TFA_GetPinsForSecret')
	delete from GXDBVersions where aliasname = 'TFA_GetPinsForSecret'
GO

insert into GXDBVersions values(2, 'TFA_GetPinsForSecret',  '00000000000000000000', 'TFA_GetPinsForSecret', '00000000000000000000')
GO

