

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SummPageGetCommCellInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SummPageGetCommCellInfo.sp,v $ $Id: SummPageGetCommCellInfo.sp,v 1.8.210.7 2020/05/06 16:15:23 xsui Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "SummPageGetCommCellInfo"    	                |
--	|									                                    |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SummPageGetCommCellInfo')
BEGIN
	print '>>> Drop Stored Procedure: SummPageGetCommCellInfo <<<'
	drop procedure SummPageGetCommCellInfo
END
IF EXISTS (select * from GxQscripts where name='SummPageGetCommCellInfo')
	delete from GxQscripts where name = 'SummPageGetCommCellInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetCommCellInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetCommCellInfo'
GO
print '... Creating Procedure: SummPageGetCommCellInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SummPageGetCommCellInfo
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Do not block for locks
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clntVer VARCHAR(64)
DECLARE @clntType varchar(32)
DECLARE @installDir VARCHAR(1024)
DECLARE	@clientId INTEGER
DECLARE @xmlText XML
DECLARE @updateStatus integer
DECLARE @clientCount INTEGER
DECLARE @maCount INTEGER
DECLARE @libraryCount INTEGER
DECLARE @spCount integer
DECLARE @usersCount integer
DECLARE @QnetServs varchar(max)
DECLARE @successfulJobsLast24Hours integer
DECLARE @failedJobsLast24Hours integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @clientId  = 2
-- Only get client row once
DECLARE @clientRelId	INT = NULL
DECLARE @clientName		NVARCHAR(255) = NULL
DECLARE @clientHostname	NVARCHAR(255) = NULL
SELECT
	@clientRelId = c.releaseId,
	@clientName = c.name,
	@clientHostname = c.net_hostname
FROM
	APP_Client c
WHERE
	c.id = @clientId
-- client Version
SELECT TOP 1 @clntVer = Build FROM LicUSage WHERE CId = @clientId
SET @clntVer = (SELECT [release] FROM simAllGalaxyRel Rel WHERE Rel.id = @clientRelId) + '.' + @clntVer
-- install directory
SELECT TOP 1 @installDir = install_dir FROM APP_Platform WHERE clientId = @clientId AND platformtype = 4
SET	@updateStatus	= ISNULL((select dbo.simGetBaseline(sum(distinct P.Baseline)) from simInstalledPackages P where P.clientId = @clientId ), 8)
SET	@updateStatus	= (case	when (@updateStatus & 8) > 0 then (369 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 16) > 0 then (1709 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 2) > 0 then (1639 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when EXISTS (select * from simInstalledPackages where clientId=@clientId and Baseline=0) then (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 4) > 0 then (1640 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 1) > 0 then (1638 | (CAST(POWER(2, 24) AS BIGINT) * 61))
				else 0 end	)
SELECT @clientCount = COUNT(*) FROM app_client WHERE id > 1
SELECT @maCount = COUNT(*) FROM	MMHost WHERE	clientId > 1 AND MmHostType >= 0
SELECT @libraryCount = COUNT(*) FROM MMLibrary WHERE LibraryId > 0
SELECT @spCount = COUNT(*) FROM archGroup WHERE	id > 1
SELECT @usersCount = COUNT(*) FROM UMUSERS WHERE id > 0
DECLARE @l_timeYesterday int
SET @l_timeYesterday = ( dbo.getunixtime(GETUTCDATE()) - (24*60*60) )
-- AEB NOTE: should create index for better scale performance:
-- CREATE NONCLUSTERED INDEX test_JMBkpStats_status_servStartDate_idx ON JMBkpStats (status ASC, servStartDate ASC)
SELECT @successfulJobsLast24Hours = COUNT(*) FROM JMBkpStats WHERE servStartDate > @l_timeYesterday AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS
SELECT @failedJobsLast24Hours = COUNT(*) FROM  JMBkpStats WHERE servStartDate > @l_timeYesterday AND status IN (2, 9) -- FAIL, DROPPED
set @QnetServs=''
SET @QnetServs = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0, 2)
SET @xmlText =
(
	SELECT
		@clientName as "@clientName",
		@clientHostname as "@hostName",
		@clntVer AS "@version",
		@installDir AS "@installDir",
		DBO.fn_EvFormatEventMsgText(0, @i_localeId, @updateStatus, 0,2) AS "@clientUpToDate",
		@clientCount AS "@clients",
		@maCount AS "@MediaAgent",
		@libraryCount AS "@libraries",
		@spCount AS "@storagePolicies",
		@usersCount AS "@Users",
		@successfulJobsLast24Hours AS "@successfulJobsLast24Hours",
		@failedJobsLast24Hours AS "@failedJobsLast24Hours",
		@QnetServs AS "@CommNetServer"
	FOR XML PATH('EVGui_SummPageGetCommCellInfo')
)
SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SummPageGetCommCellInfo')
	delete from GxQscripts where name = 'SummPageGetCommCellInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetCommCellInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetCommCellInfo'
GO

insert into GXDBVersions values(2, 'SummPageGetCommCellInfo',  '00010008021000070000', 'SummPageGetCommCellInfo', '00010008021000070000')
GO

