

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SummPageGetClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SummPageGetClientInfo.sp,v $ $Id: SummPageGetClientInfo.sp,v 1.49.2.13 2020/09/03 21:57:06 njudge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "SummPageGetClientInfo"    	                |
--	|									                                    |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SummPageGetClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: SummPageGetClientInfo <<<'
	drop procedure SummPageGetClientInfo
END
IF EXISTS (select * from GxQscripts where name='SummPageGetClientInfo')
	delete from GxQscripts where name = 'SummPageGetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetClientInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetClientInfo'
GO
print '... Creating Procedure: SummPageGetClientInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SummPageGetClientInfo
  @i_clientId INTEGER, 
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_clientReadinessInfo NVARCHAR(MAX)=N''
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clntVer VARCHAR(64)
DECLARE @updateStatus integer
DECLARE @clntType varchar(32)
DECLARE @timeZone  NVARCHAR(2048)
DECLARE @formattedTimeZone  NVARCHAR(2048)
DECLARE @FirstColon INTEGER
DECLARE @SecondColon INTEGER
DECLARE @MinusSign INTEGER
DECLARE @Minutes INTEGER
DECLARE @locClntType INTEGER
DECLARE @installDir VARCHAR(1024)
DECLARE @xmlText XML
DECLARE @subClientMask	as INTEGER		= 2+4+16+32   -- unistalled/deleted/dummy/hidden
DECLARE @ATTR_ENCRYPT	as varchar(80)	= 'Encryption Settings'  -- Default @ subclient level is ENC_NETWORK_AND_MEDIA;
DECLARE @SC_WO_ENCRYPT	as INTEGER		= 0
DECLARE @SC_W_ENCRYPT	as INTEGER		= 0
DECLARE @CL_ENCRYPT		as INTEGER		= 0
DECLARE @locEncrptType	as INTEGER		= (1496 | (CAST(POWER(2, 24) AS BIGINT) * 35))					--'GUIMSG_CL_SUMMPAGE_CRYPT_DISABLED'
DECLARE @refTime		as INTEGER		= 0
DECLARE @installDate	as varchar(30)
DECLARE @cvInstallDate	as INT = 0
DECLARE @locBackupDone	as INTEGER =0
DECLARE @veFlags	as INTEGER
DECLARE @CCRId			as INTEGER
DECLARE @readinessStatus	as INTEGER
DECLARE @offlineTime	as INTEGER
DECLARE @onlineTime		as INTEGER
DECLARE @CCRTime		as INTEGER
SET @CL_ENCRYPT		= ISNULL((SELECT attrVal from APP_ClientProp where componentNameId=@i_clientId and modified=0 AND attrName=@ATTR_ENCRYPT), 0)
SET @locEncrptType =	CASE
WHEN @CL_ENCRYPT = 1
THEN    (4630 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN @CL_ENCRYPT = 2
THEN	(1496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
ELSE		(4631 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						END
SET @veFlags=( SELECT attrVal FROM APP_ClientProp WHERE attrName ='Virtual Entity Flags' AND componentNameId = @i_clientId)
IF ( @veFlags IS NOT NULL)
BEGIN
SET @locBackupDone	= (395 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	IF ( @veFlags & 512 = 512 )
SET @locBackupDone = (394 | (CAST(POWER(2, 24) AS BIGINT) * 61))
END
select @formattedTimeZone=TimeZoneStdName from APP_ClientProp,SchedTimeZone where attrName = 'timezone Id' AND componentNameId = @i_clientId and CONVERT(int,attrVal) = TimeZoneID
SET @clntVer = (SELECT attrval from APP_ClientProp where componentNameId = @i_clientId and attrName = 'SP Version Info' and modified = 0)
SET	@updateStatus	= ISNULL((select dbo.simGetBaseline(sum(distinct P.Baseline)) from simInstalledPackages P where P.clientId = @i_clientId ), 8)
SET	@updateStatus	= (case	when (@updateStatus & 8) > 0 then (369 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 16) > 0 then (1709 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 2) > 0 then (1639 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when EXISTS (select * from simInstalledPackages where clientId=@i_clientId and Baseline=0) then (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 4) > 0 then (1640 | (CAST(POWER(2, 24) AS BIGINT) * 61))
when (@updateStatus & 1) > 0 then (1638 | (CAST(POWER(2, 24) AS BIGINT) * 61))
				else 0 end	)
SET @clntType = 'Physical'
SELECT @clntType = (CASE WHEN attrVal = 1 THEN 'Virtual'  ELSE 'Physical' end) FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName='Virtual client' AND modified = 0
IF @clntType = 'Physical'
SET @locClntType = (1354 | (CAST(POWER(2, 24) AS BIGINT) * 35))
ELSE
SET @locClntType = (1355 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SELECT TOP 1 @installDir = install_dir FROM APP_Platform WHERE clientId = @i_clientId AND platformtype = 4
SELECT @CCRId = ISNULL(MAX(S.CCRId), 0) FROM CCRToSubClient S INNER JOIN  CCRCommCellReadiness C ON  C.CCRId = S.CCRId   WHERE ClientId = @i_clientId AND C.CCREndTime>0
IF @CCRId = 0
BEGIN
SET @readinessStatus = (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	SET @offlineTime = 0
	SET @onlineTime = 0
	SET @CCRTime = 0
END
ELSE
BEGIN
	SELECT @readinessStatus = (CASE WHEN EXISTS (SELECT * FROM (SELECT SubClientId,min(CCRResultFlag) AS CCRResultFlag FROM CCRToSubClient WHERE ClientId = @i_clientId AND CCRId =@CCRId group by SubClientId)SUB
WHERE  CCRResultFlag <> 0) THEN (897 | (CAST(POWER(2, 24) AS BIGINT) * 61)) ELSE (896 | (CAST(POWER(2, 24) AS BIGINT) * 61)) END)
SET @offlineTime = (CASE WHEN @readinessStatus = (897 | (CAST(POWER(2, 24) AS BIGINT) * 61)) THEN (SELECT MAX(lastOfflineTime) FROM CCRClientToClient WHERE ToClientId = @i_clientId AND FromClientId=2 and serviceType=0) ELSE 0 END)
	SET @onlineTime = (SELECT MAX(lastOnlineTime) FROM CCRClientToClient WHERE ToClientId = @i_clientId AND FromClientId=2 and serviceType=0)
	SET @CCRTime = (SELECT CCREndTime FROM CCRCommCellReadiness WHERE CCRId = @CCRID)
END
IF(@offlineTime IS NULL)
	SET @offlineTime = 0
IF(@onlineTime IS NULL)
	SET @onlineTime = 0
IF(@CCRTime IS NULL)
	SET @CCRTime = 0
DECLARE @d DATETIME
SELECT TOP 1 @refTime = dbo.getUnixTime(OpTimeUTC) FROM LicUsage WHERE cid = @i_clientId AND AppType = 1001 AND OpType = 'Install' ORDER BY OpTimeUTC Desc
	IF(@refTime = 0)
	BEGIN
		SET @refTime = (select refTime from APP_Client where id = @i_clientId)
	END
	IF(@refTime <> 0)
	BEGIN
		SET @d = dbo.UTCToClientLocalTime(dbo.GetDateTime(@refTime),2)
		SET @installDate = DATENAME(weekday , @d) + ', ' + DATENAME(month , @d) + ' ' + right('0' + rtrim(day(@d)),2) + ', ' + rtrim(year(@d))
		SET @cvInstallDate = @refTime
	END
	ELSE
			SET @installDate = 'N/A'
	DECLARE @isNas	INTEGER=0
	DECLARE @OSId	INTEGER=0
	DECLARE @OSName	NVARCHAR(255)
	DECLARE @OSInfo NVARCHAR(1024)
	SELECT @OSId = (Select simOperatingSystemId FROM APP_Client where id = @i_clientId)
	SELECT  @OSName = dbo.GetClientOSName(@i_clientId, null)
	IF @OSName = ''
		SET @OSName = (SELECT name FROM simOperatingSystem S WHERE S.id = @OSId)
	SET @isNas =( select (case
						when type in ('Any','Windows')  then (case SubType
												when 'NAS' then 1
												else 0
												end)
						else 0
						end)
				from simOperatingSystem where id = @OSId)
	IF @isNas <> 0
    BEGIN
		SET @OSInfo =  ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo where ClientId = @i_clientId),'')
		IF @OSInfo <> '' AND CHARINDEX(@OSInfo, @OSName) = 0
			SET @OSName = @OSName + ' ' +@OSInfo
    END
-- Auxiliary Copy Job Time Calculation for the Client DR Status
BEGIN TRY
	DECLARE @drStatus NVARCHAR(MAX)
	DECLARE @BehindScheduleConfig INT = 48
	SELECT @BehindScheduleConfig = value
	FROM MMConfigs WHERE name = 'MMCONFIG_CLIENT_DR_BEHIND_SCHEDULE_CRITERIA_IN_HOURS'
	DECLARE @tblSP TABLE (archGroupId INTEGER, archGroupCopyId INTEGER, sourceCopyId INTEGER,
            TotalTobeCopiedJobApplicationSize FLOAT, EstTotalTobeCopiedJobMediaSize FLOAT,
            AvgAuxCopyJobThroughput FLOAT, EstiamtedHours INT )
	INSERT INTO @tblSP
	SELECT  AG.id, AGC.id, (CASE WHEN sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END),
          NULL, NULL, NULL, 0
 	FROM    archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK),(SELECT DISTINCT JDS.archGrpId , JDS.archGrpCopyId
 	FROM JMJobDataStats JDS WITH (NOLOCK), APP_Application AP WITH (NOLOCK), APP_Client AC WITH (NOLOCK)
 	WHERE AC.id = AP.clientId AND AP.id = JDS.appId AND AC.id = @i_clientId
 		 AND JDS.status IN( 101,102,103) AND JDS.disabled & 257 = 0 ) CAG
  	WHERE   AG.id = AGC.archGroupId
 		AND AG.id = CAG.archGrpId
        AND AGC.id = CAG.archGrpCopyId
        AND AGC.id <> AG.defaultCopy
        AND AGC.id <> AG.defaultSnapCopy
        AND AGC.isSnapCopy = 0  -- PICK ONLY NON SNAP COPIES
        AND AGC.type <> 5
  		  AND AGC.isActive = 1
	IF OBJECT_ID('tempdb.dbo.#jobsToBeCopiedNewData') IS NOT NULL DROP TABLE #jobsToBeCopiedNewData
	IF OBJECT_ID('tempdb.dbo.#jobsToBeCopiedNewDataWithSize') IS NOT NULL DROP TABLE #jobsToBeCopiedNewDataWithSize
	CREATE TABLE #jobsToBeCopiedNewData (archGroupId INTEGER, archGroupCopyId INTEGER,
            sourceCopyId INTEGER, CommCellId INTEGER, JobID INTEGER, CurrentOrNew INTEGER, currentBackupSize BIGINT)
	CREATE TABLE #jobsToBeCopiedNewDataWithSize (archGroupId INTEGER, archGroupCopyId INTEGER,
            sourceCopyId INTEGER, CommCellId INTEGER, JobID INTEGER, CurrentOrNew INTEGER, totalAppSize BIGINT, totalIndexSize BIGINT, totalBackupSize BIGINT, currentBackupSize BIGINT, tobeCopiedBackupSize BIGINT)
	INSERT INTO #jobsToBeCopiedNewData
	SELECT  T.archGroupId, T.archGroupCopyId, T.sourceCopyId, JDS.commCellId, JDS.jobId,
        (CASE WHEN MAX(AFC.archFileId) IS NULL THEN 2 ELSE 1 END), SUM(ISNULL(AFC.physicalSize, 0))
	FROM    @tblSP T
            INNER JOIN JMJobDataStats JDS  WITH (NOLOCK) ON archGrpId = T.archGroupId AND archGrpCopyId = T.archGroupCopyId
            INNER JOIN archFile AF  WITH (NOLOCK) ON JDS.archGrpId = AF.archGroupId AND JDS.commCellId = AF.commCellId AND JDS.jobId = AF.jobId AND JDS.dataType = AF.fileType
            LEFT OUTER JOIN archFileCopy AFC  WITH (NOLOCK) ON JDS.archGrpCopyId = AFC.archCopyId AND AF.commCellId = AFC.commCellId AND AF.id= AFC.archFileId
	WHERE   (JDS.disabled & 257) = 0
        AND JDS.status IN (101, 102, 103)
	GROUP BY T.archGroupId, T.archGroupCopyId, T.sourceCopyId, JDS.commCellId, JDS.jobId
	INSERT INTO #jobsToBeCopiedNewDataWithSize
	SELECT  J.archGroupId, J.archGroupCopyId, J.sourceCopyId, JBS.commCellId, JBS.jobId, CurrentOrNew, MAX(ISNULL(JBS.totalUncompBytes, 0)), SUM(CASE WHEN JMP.id IS NOT NULL THEN ISNULL(JBAS.unCompBytes, 0) ELSE 0 END), MAX(ISNULL(JBS.totalBackupSize, 0)), MAX(J.currentBackupSize), NULL
	FROM    #jobsToBeCopiedNewData J
            INNER JOIN JMBkpStats JBS WITH (NOLOCK) ON JBS.commCellId = J.commCellId AND JBS.jobId = J.jobId
            LEFT OUTER JOIN JMBkpAtmptStats JBAS WITH (NOLOCK) ON JBS.commCellId = JBAS.commCellId AND JBS.jobId = JBAS.jobId
            LEFT OUTER JOIN JMOpTable JOP WITH (NOLOCK) ON JBS.opType = JOP.operation AND JBS.appType = JOP.appTypeType
            LEFT OUTER JOIN JMPhase JMP WITH (NOLOCK) ON JOP.id = JMP.opTableId AND JBAS.phase = JMP.phase AND (JMP.name = 'Archive Index' OR JMP.startExec = 'archiveIndex.exe')
	GROUP BY J.archGroupId, J.archGroupCopyId, J.sourceCopyId, JBS.commCellId, JBS.jobId, CurrentOrNew
	UPDATE  #jobsToBeCopiedNewDataWithSize
	SET     tobeCopiedBackupSize = ISNULL(backupSize, J.totalBackupSize)
	FROM    #jobsToBeCopiedNewDataWithSize J,
        (SELECT  JD.archGroupId, JD.archGroupCopyId, JD.commCellId, JD.jobId, SUM(AFC.physicalSize) backupSize
        FROM    #jobsToBeCopiedNewData JD, archFile AF, archFileCopy AFC
        WHERE   JD.JobID = AF.jobId
                AND JD.CommCellId = AF.commCellId
                AND AF.id = AFC.archFileId
                AND AF.commCellId = AFC.commCellId
                AND AF.isValid = 1
                AND JD.sourceCopyId = AFC.archCopyId
        GROUP BY JD.archGroupId, JD.archGroupCopyId, JD.commCellId, JD.jobId) T
	WHERE   J.archGroupId = T.archGroupId
        AND J.archGroupCopyId = T.archGroupCopyId
        AND J.JobID = T.JobID
        AND J.CommCellId = T.CommCellId
	INSERT INTO #jobsToBeCopiedNewDataWithSize
	SELECT  J.archGroupId, J.archGroupCopyId, J.sourceCopyId, JBS.commCellId, JBS.jobId, J.CurrentOrNew,
            ISNULL((CASE WHEN (opType = 64 AND JBS.uncompBytes <> 0) THEN JBS.uncompBytes ELSE JBS.totalBackupSize END), 0), 0, ISNULL(JBS.totalBackupSize, 0), J.currentBackupSize, ISNULL(JBS.totalBackupSize, 0)
	FROM    #jobsToBeCopiedNewData J
            INNER JOIN JMAdminJobStatsTable JBS WITH (NOLOCK) ON JBS.commCellId = J.commCellId AND JBS.jobId = J.jobId
            LEFT OUTER JOIN #jobsToBeCopiedNewDataWithSize JN ON JN.commCellId = J.commCellId AND JN.jobId = J.jobId
	WHERE   JN.JobID IS NULL
        AND JBS.opType IN (11,46) --DR Backup, Legal Hold
	UPDATE  @tblSP
	SET     TotalTobeCopiedJobApplicationSize = J.ToBeCopiedDataSizeByCurrentJob,
        EstTotalTobeCopiedJobMediaSize = J.EstMediaSize
	FROM    @tblSP T,
        (
            SELECT  archGroupId, archGroupCopyId, SUM(ISNULL(totalAppSize+totalIndexSize, 0) * ((ISNULL(tobeCopiedBackupSize - currentBackupSize, 0)*1.0)/ISNULL(totalBackupSize, 0)))/(1024 * 1024 * 1024) AS ToBeCopiedDataSizeByCurrentJob, (ISNULL(SUM(tobeCopiedBackupSize - currentBackupSize), 0)*1.0)/(1024 * 1024 * 1024) AS EstMediaSize, COUNT(*) AS JobsCount
            FROM    #jobsToBeCopiedNewDataWithSize
            WHERE   CurrentOrNew = 1
                    AND totalBackupSize <> 0
            GROUP BY archGroupId, archGroupCopyId
        ) J
	WHERE   T.archGroupId = J.archGroupId
        AND T.archGroupCopyID = J.archGroupCopyId
	UPDATE  @tblSP
	SET     TotalTobeCopiedJobApplicationSize = ISNULL(TotalTobeCopiedJobApplicationSize,0) + J.NewDataSincetheCurrentAuxCopyJobStarted,
        EstTotalTobeCopiedJobMediaSize = ISNULL(EstTotalTobeCopiedJobMediaSize,0) + J.EstMediaSize
	FROM    @tblSP T,
        (
            SELECT  archGroupId, archGroupCopyId, ISNULL(SUM(totalAppSize+totalIndexSize)/(1024*1024*1024), 0) AS NewDataSincetheCurrentAuxCopyJobStarted, (ISNULL(SUM(totalBackupSize), 0)*1.0)/(1024 * 1024 * 1024) AS EstMediaSize, COUNT(*) AS JobsCount
            FROM    #jobsToBeCopiedNewDataWithSize
            WHERE   CurrentOrNew = 2
            GROUP BY archGroupId, archGroupCopyId
        ) J
	WHERE   T.archGroupId = J.archGroupId
        AND T.archGroupCopyID = J.archGroupCopyId
	UPDATE  @tblSP
	SET     TotalTobeCopiedJobApplicationSize = ISNULL(TotalTobeCopiedJobApplicationSize, 0),
        EstTotalTobeCopiedJobMediaSize = ISNULL(EstTotalTobeCopiedJobMediaSize, 0)
	DECLARE @lastAuxJobs TABLE( archCopyId INT, jobId INT, bytesCopied BIGINT, writeTime INT)
	INSERT @lastAuxJobs
	SELECT RN.archGrpCopyId, RN.jobId, RN.BytesXferred,  CAST((RN.totalWriteTime * (RN.BytesXferred * 1.0) / RN.EX_TotalSuccess) AS INT)
	FROM   @tblSP A
        CROSS APPLY
    (SELECT TOP(10) J.*, JA.totalWriteTime, JA.EX_TotalSuccess
    FROM JMDataCopiedStatsTable J WITH (NOLOCK), JMAdminJobStatsTable JA WITH (NOLOCK)
    WHERE J.archGrpCopyId = A.archGroupCopyId
    AND J.jobId = JA.jobId
    AND JA.commCellId = J.commCellId
    AND JA.EX_TotalSuccess > 0
    AND JA.opType IN ( 13, 104) ORDER BY J.jobId DESC) RN
	INSERT @lastAuxJobs
	SELECT J.archGrpCopyId, J.jobId, J.BytesXferred, (elapsedTime*(J.BytesXferred*1.0/RAJ.ObjectsDone))
	FROM JMDataCopiedStatsTable J WITH (NOLOCK), @tblSP A, RunningAdminJobs RAJ, @lastAuxJobs LA
	WHERE J.jobId = RAJ.jobId
		AND J.commCellId = RAJ.commCellId
		AND A.archGroupCopyId = J.archGrpCopyId
		AND RAJ.opType IN ( 13, 104)
		AND RAJ.ObjectsDone > 0
		AND J.archGrpCopyId NOT IN (SELECT DISTINCT archCopyId FROM @lastAuxJobs)
	UPDATE  @tblSP
	SET     AvgAuxCopyJobThroughput = (CASE WHEN TP.wTime > 0 THEN  TP.BytesTransfer / TP.wTime ELSE  0 END) * 3600.0/(1024*1024*1024)
	FROM    @tblSP T LEFT OUTER JOIN
            ( SELECT archCopyId, SUM(bytesCopied) BytesTransfer, SUM(writeTime) wTime
            FROM @lastAuxJobs
            GROUP BY archCopyId ) TP
            ON  T.archGroupCopyId = TP.archCopyId
	UPDATE    @tblSP
	SET       EstiamtedHours = CEILING( TotalTobeCopiedJobApplicationSize/AvgAuxCopyJobThroughput)
	WHERE AvgAuxCopyJobThroughput > 0
	IF NOT EXISTS( SELECT * FROM @tblSP WHERE    TotalTobeCopiedJobApplicationSize > 0)
SET @drStatus =  DBO.fn_EvFormatEventMsgText(0, @i_localeId, (1368 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+ '.'
	ELSE IF NOT EXISTS( SELECT * FROM @tblSP WHERE TotalTobeCopiedJobApplicationSize > 0 AND AvgAuxCopyJobThroughput > 0)
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3465 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
	ELSE
	BEGIN
		DECLARE @MaxEstimatedHours INT = 0
		SELECT  @MaxEstimatedHours = MAX(EstiamtedHours)   FROM @tblSP
		IF @MaxEstimatedHours  < @BehindScheduleConfig
		BEGIN
			IF @MaxEstimatedHours < 36
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3463 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CONVERT(NVARCHAR,@MaxEstimatedHours) + ' ' + DBO.fn_EvFormatEventMsgText(0, @i_localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
			ELSE
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3463 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CONVERT(NVARCHAR,CEILING(@MaxEstimatedHours/24)) + ' ' + DBO.fn_EvFormatEventMsgText(0, @i_localeId, (530 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
		END
		ELSE
			BEGIN
			IF @MaxEstimatedHours < 36
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3464 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CONVERT(NVARCHAR,@MaxEstimatedHours) + ' ' + DBO.fn_EvFormatEventMsgText(0, @i_localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
			ELSE
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3464 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CONVERT(NVARCHAR,CEILING(@MaxEstimatedHours/24)) + ' ' +  DBO.fn_EvFormatEventMsgText(0, @i_localeId, (530 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
		END
	END
IF OBJECT_ID('tempdb.dbo.#jobsToBeCopiedNewData') IS NOT NULL DROP TABLE #jobsToBeCopiedNewData
IF OBJECT_ID('tempdb.dbo.#jobsToBeCopiedNewDataWithSize') IS NOT NULL DROP TABLE #jobsToBeCopiedNewDataWithSize
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @drStatus = DBO.fn_EvFormatEventMsgText(0, @i_localeId, (3465 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)+'.'
END CATCH
	SET @xmlText =
	(
	SELECT Name as "@clientName", net_hostname as "@hostName",
		--(select [name] from simOS OS where OS.id = (select simOSId from simSystemOS where id = C.simSystemOSId)) as "@os" ,
		@OSName as "@os" ,
		dbo.getClientHardwareName(C.Id, null) as "@platform",
	    @clntVer AS "@version",
	   	DBO.fn_EvFormatEventMsgText(0, @i_localeId, @locClntType, 0,2) AS "@virtualFlag",
	    DBO.fn_EvFormatEventMsgText(0, @i_localeId, @updateStatus, 0,2) AS "@clientUpToDate",
	    @formattedTimeZone AS "@timeZone",
	    @installDir AS "@installDir",
	    @installDate AS "@installDate",
	    DBO.fn_EvFormatEventMsgText(0, @i_localeId, @locEncrptType, 0,2) as '@encryptionStatus',
	    CASE WHEN @locBackupDone <> 0
		THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, @locBackupDone, 0,2)
		END  as '@backupStatus',
		(SELECT @cvInstallDate AS '@time'
			FOR XML PATH('cvInstallDate'),TYPE),
		 (SELECT
				DBO.fn_EvFormatEventMsgText(0, @i_localeId, @readinessStatus, 0,2) as '@readinessStatus',
				CASE @offlineTime
					WHEN 0 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
					ELSE CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.GetDateTime(@offlineTime), 2))
					END as '@offlineTime',
				CASE @onlineTime
					WHEN 0 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
					ELSE CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.GetDateTime(@onlineTime), 2))
					END as '@onlineTime',
				CASE @CCRTime
					WHEN 0 THEN DBO.fn_EvFormatEventMsgText(0, @i_localeId, (369 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
					ELSE CONVERT(VARCHAR, dbo.UTCToClientLocalTime(dbo.GetDateTime(@CCRTime), 2))
					END as '@CCRTime',
				@drStatus as '@DRStatus',
				(CASE
					WHEN LEN(@i_clientReadinessInfo) = 0 THEN NULL
WHEN @readinessStatus = (896 | (CAST(POWER(2, 24) AS BIGINT) * 61)) THEN NULL
					ELSE @i_clientReadinessInfo
					END)
				as 'offlineReasons/@val',
				(SELECT @offlineTime AS '@time'
					FOR XML PATH('cvOfflineTime'),TYPE),
				(SELECT @onlineTime AS '@time'
					FOR XML PATH('cvOnlineTime'),TYPE),
				(SELECT @CCRTime AS '@time'
					FOR XML PATH('cvCCRTime'),TYPE)
		 FOR XML PATH('clientReadiness'),TYPE)
	FROM APP_Client C
	WHERE id = @i_clientId
	       FOR XML PATH('EVGui_SummPageGetClientInfo')
	)
SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SummPageGetClientInfo')
	delete from GxQscripts where name = 'SummPageGetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetClientInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetClientInfo'
GO

insert into GXDBVersions values(2, 'SummPageGetClientInfo',  '00010049000200130000', 'SummPageGetClientInfo', '00010049000200130000')
GO

