

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SummPageGetClientComupters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SummPageGetClientComupters.sp,v $ $Id: SummPageGetClientComupters.sp,v 1.31.34.4.20.1 2021/04/27 00:05:25 nnuthakki Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "SummPageGetClientComupters"	                |
--	|									                                    |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SummPageGetClientComupters')
BEGIN
	print '>>> Drop Stored Procedure: SummPageGetClientComupters <<<'
	drop procedure SummPageGetClientComupters
END
IF EXISTS (select * from GxQscripts where name='SummPageGetClientComupters')
	delete from GxQscripts where name = 'SummPageGetClientComupters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetClientComupters')
	delete from GXDBVersions where aliasname = 'SummPageGetClientComupters'
GO
print '... Creating Procedure: SummPageGetClientComupters'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SummPageGetClientComupters
  @i_clientGroupId INTEGER,
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
SET NOCOUNT ON
DECLARE @ClntTbl	TABLE (t_id int primary key, t_upToDate int, t_OS int, t_clientStatus int, t_releaseId int)
DECLARE @currentReleaseId INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--If we are provided with a definite client group Id, then we target only those clients which are a part of that client group.
--If not, then we eventually take all active clients for creating summary
IF ( @i_clientGroupId != 0 )
BEGIN
	INSERT INTO @ClntTbl
		SELECT DISTINCT C.Id, 1, C.simOperatingSystemId, C.status, C.releaseId
		FROM APP_Client C JOIN App_Platform P on P.clientId = C.Id and P.platformType = 4
						  JOIN APP_ClientGroupAssoc CGA ON  (CGA.clientId = C.Id AND CGA.clientGroupId = @i_clientGroupId)
		WHERE C.Id > 1
END
ELSE
BEGIN
INSERT INTO @ClntTbl
    SELECT DISTINCT C.Id, 1, C.simOperatingSystemId, C.status, C.releaseId
	FROM APP_Client C JOIN App_Platform P on P.clientId = C.Id and P.platformType = 4
    WHERE C.Id > 1
END
SELECT @currentReleaseId = MAX(id) FROM simAllGalaxyRel
UPDATE @ClntTbl SET t_clientStatus = 2
   FROM @ClntTbl C JOIN APP_ClientProp P ON C.t_id = P.componentNameId AND attrName = 'PlatformDeleted 4' AND P.modified = 0 AND P.attrVal = '1'
UPDATE @ClntTbl
SET	t_OS = (case
			when type in ('Any','windows') then (case subtype  when 'NAS' then 4 else 1 end )
			when type = 'netware' then 2
			when type = 'Unix' then 3 end	)
FROM	simOperatingSystem
WHERE	id = t_OS
--Only Client with BaseLine value(s) corresponding to 2->'BELOW BASELINE' shall be regarded as "requiring update".
--All other baseline values, including "HOTFIX" will be regarded as updated
UPDATE @ClntTbl	SET t_upToDate = 0 WHERE  EXISTS (SELECT 1 FROM simInstalledPackages WHERE clientId = t_id AND (Baseline & (2 + 4096)) > 0) --BELOW BASELINE
----------------------
-- VISIBILITY CHECK --
----------------------
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#SummPageGetClientComupters') IS NOT null DROP TABLE #SummPageGetClientComupters
create table  #SummPageGetClientComupters ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#SummPageGetClientComupters'
	DELETE #SummPageGetClientComupters
	WHERE clientGroupId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR mediaAgentId <>0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	DELETE @ClntTbl
	WHERE NOT EXISTS (select 1 from #SummPageGetClientComupters where clientId in (0, t_id))
	DROP TABLE #SummPageGetClientComupters
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
SELECT  TAG							= 1,
		Parent						= null,
	   [EVGui_SummPageGetClientComupters!1!numOfClients]			= (select count(*) from @ClntTbl),
[EVGui_SummPageGetClientComupters!1!numOfWindowsClients]		= (select count(*) from @ClntTbl where t_OS = 1),
[EVGui_SummPageGetClientComupters!1!numOfUnixClients]		= (select count(*) from @ClntTbl where t_OS = 3),
[EVGui_SummPageGetClientComupters!1!numOfNASClients]			= (select count(*) from @ClntTbl where t_OS = 4),
       [EVGui_SummPageGetClientComupters!1!numOfClientsNeedUpdate]	= (select count(*) from @ClntTbl where t_upToDate = 0 AND t_clientStatus = 0),
       [EVGui_SummPageGetClientComupters!1!numOfClientsUpToDate]   	= (select count(*) from @ClntTbl where t_upToDate = 1 AND t_clientStatus = 0) ,
       [EVGui_SummPageGetClientComupters!1!numOfClientsDeconfigured]= (select count(*) from @ClntTbl where t_clientStatus = 2 ),
       [EVGui_SummPageGetClientComupters!1!numOfClientsNeedUpgrade] = (select count(*) from @ClntTbl where (t_clientStatus & 2) <> 2 --uninstalled
       AND (t_clientStatus & 4) <> 4 --deleted
       AND (t_clientStatus & 0x200000) <> 0x200000 --exchange DAG client
       AND t_releaseId < @currentReleaseId  ),
       [EVGui_SummPageGetClientComupters!1!numOfVirtualSrvClients]		= (select count(*) from @ClntTbl C where t_id in (select componentNameId from APP_ClientProp where attrName LIKE 'Virtual Server Discovered Clients' AND attrVal = '1' and modified =0 )),
       [EVGui_SummPageGetClientComupters!1!numOfOutlookAddinClients]	= (select count(*) from @ClntTbl C where t_id in (select componentNameId from APP_ClientProp where attrName LIKE 'Outlook Addin Client' AND attrVal ='1' AND modified = 0)),
       [EVGui_SummPageGetClientComupters!1!numOfEDCDiscoveredClients]	= (select count(distinct t_id) from @ClntTbl C inner join app_clientGroupAssoc CGA on C.t_id = CGA.clientId inner join app_clientgroup CG on CG.id = CGA.clientGroupId WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))),
	   [EVGui_SummPageGetClientComupters!1!numOfReferenceCopyClients] 	= (select count(*) from @ClntTbl where (t_clientStatus & 0x4000000) = 0x4000000) --Reference copy client
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SummPageGetClientComupters')
	delete from GxQscripts where name = 'SummPageGetClientComupters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetClientComupters')
	delete from GXDBVersions where aliasname = 'SummPageGetClientComupters'
GO

insert into GXDBVersions values(2, 'SummPageGetClientComupters',  'v1.31.34.4.20.1', 'SummPageGetClientComupters', 'v1.31.34.4.20.1')
GO

