

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SummPageGetAgentInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SummPageGetAgentInfo.sp,v $ $Id: SummPageGetAgentInfo.sp,v 1.13.2.3 2018/05/03 10:27:20 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "SummPageGetAgentInfo"    	                |
--	|									                                    |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SummPageGetAgentInfo <<<'

IF EXISTS (select * from sysobjects where name='SummPageGetAgentInfo')
	drop procedure SummPageGetAgentInfo
IF EXISTS (select * from GxQscripts where name='SummPageGetAgentInfo')
	delete from GxQscripts where name = 'SummPageGetAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetAgentInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetAgentInfo'
GO
print '... Creating Procedure: SummPageGetAgentInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SummPageGetAgentInfo
  @i_clientId INTEGER,
  @i_appType INTEGER,
  @i_userId INTEGER,
  @i_localeId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clntVer VARCHAR(64)
DECLARE @installDate VARCHAR(64)
DECLARE @cvInstallDate INT = 0
DECLARE @clientName NVARCHAR(510)
DECLARE @xmlText XML
DECLARE @licType INT
DECLARE @instTime INT=0
SELECT TOP 1 @clntVer = Build FROM LicUSage WHERE CId = @i_clientId AND LicType NOT IN (71, 10, 26)
SET @clntVer = (SELECT [release] FROM simAllGalaxyRel Rel WHERE Rel.id = (SELECT ReleaseId FROM APP_Client WHERE id = @i_clientId)) + '.' + @clntVer
SELECT @clientName=[NAME] FROM APP_Client WHERE id = @i_clientId
SELECT TOP 1 @instTime = dbo.getUnixTime(OpTimeUTC), @licType = licType FROM LicUsage WHERE cid = @i_clientId AND AppType = @i_appType ORDER BY OpTimeUTC Desc
SET @instTime = ISNULL((select modified from APP_iDAName WHERE clientId = @i_clientId AND appTypeId = @i_appType AND status = 0 AND (modified > 0) AND modified < @instTime), @instTime)
IF @instTime = 0
BEGIN
	SET @instTime = (select refTime from APP_Client where id = @i_clientId)
END
IF(@instTime <> 0)
BEGIN
	SET @cvInstallDate = @instTime
	DECLARE @d DATETIME
	SET @d =  CAST(dbo.UTCToClientLocalTime(dbo.GetDateTime(@instTime),2) as varchar(11))
	SET @installDate = DATENAME(weekday , @d) + ', ' + DATENAME(month , @d) + ' ' +
		right('0' + rtrim(day(@d)),2) + ', ' + rtrim(year(@d))
END
ELSE
	SET @installDate = 'N/A'
SET @xmlText =
(
SELECT TOP 1 displayName AS "@agentType", @clientName AS "@clientName", @clntVer AS "@version", @installDate AS "@installDate",
			(SELECT @cvInstallDate AS '@timeValue'
					FOR XML PATH('cvInstallDate'),TYPE)
 FROM APP_IDAType WHERE  type = @i_appType
       FOR XML PATH('EVGui_SummPageGetAgentInfo')
)
SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SummPageGetAgentInfo')
	delete from GxQscripts where name = 'SummPageGetAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SummPageGetAgentInfo')
	delete from GXDBVersions where aliasname = 'SummPageGetAgentInfo'
GO

insert into GXDBVersions values(2, 'SummPageGetAgentInfo',  '00010013000200030000', 'SummPageGetAgentInfo', '00010013000200030000')
GO

