

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Stat_IsDataAnomalous.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: Stat_FindAnomalousData
--        Gets a history and
--		  based on it find if the current occurrence is anomalous
--		  input: 1. temp table #historyData(occ)
--				 2. current count
--        output: 0/1
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Stat_IsDataAnomalous <<<'

IF EXISTS (select * from sysobjects where name='Stat_IsDataAnomalous')
	drop procedure Stat_IsDataAnomalous
IF EXISTS (select * from GxQscripts where name='Stat_IsDataAnomalous')
	delete from GxQscripts where name = 'Stat_IsDataAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Stat_IsDataAnomalous')
	delete from GXDBVersions where aliasname = 'Stat_IsDataAnomalous'
GO
print '... Creating Procedure: Stat_IsDataAnomalous'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure Stat_IsDataAnomalous
  @currentCount INT,
  @multiple FLOAT, 
  @isAnomalous INT OUTPUT,
  @threshold INT OUTPUT
AS
BEGIN
	SET @isAnomalous = 0
	DECLARE @std FLOAT = ISNULL((SELECT STDEV(occ) FROM #historyData),0)
	DECLARE @average FLOAT = ISNULL((SELECT AVG(occ) FROM #historyData),0)
	DECLARE @hisoryDataCount INT = (SELECT COUNT(1) FROM #historyData)
	SET @threshold = 1.1 * @average+((@std+1)*@multiple*(1+ABS(@std+1))/(@std+1))
	IF(@currentCount > @threshold) AND @hisoryDataCount > 10 AND @currentCount > 10
		SET @isAnomalous = 1
END
GO

IF EXISTS (select * from GxQscripts where name = 'Stat_IsDataAnomalous')
	delete from GxQscripts where name = 'Stat_IsDataAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Stat_IsDataAnomalous')
	delete from GXDBVersions where aliasname = 'Stat_IsDataAnomalous'
GO

insert into GXDBVersions values(2, 'Stat_IsDataAnomalous',  '00000000000000000000', 'Stat_IsDataAnomalous', '00000000000000000000')
GO

