

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Stat_GetOutliers_GESD.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Stat_GetOutliers_GESD.sp,v $ $Id: Stat_GetOutliers_GESD.sp,v 1.1.2.1 2018/05/14 10:35:09 snandhini Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Stat_GetOutliers_GESD <<<'

IF EXISTS (select * from sysobjects where name='Stat_GetOutliers_GESD')
	drop procedure Stat_GetOutliers_GESD
IF EXISTS (select * from GxQscripts where name='Stat_GetOutliers_GESD')
	delete from GxQscripts where name = 'Stat_GetOutliers_GESD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Stat_GetOutliers_GESD')
	delete from GXDBVersions where aliasname = 'Stat_GetOutliers_GESD'
GO
print '... Creating Procedure: Stat_GetOutliers_GESD'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Stat_GetOutliers_GESD
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--   dataPointsString - comma separated string of data points
--   alpha            - significance level
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @dataPointsString VARCHAR(MAX),
  @numberOfOutliers INTEGER,
  @alphaS VARCHAR(10)
AS
  DECLARE @outlier FLOAT
SET NOCOUNT ON
DECLARE @dataPoints TABLE(data float)
DECLARE @alpha FLOAT = 0.05
IF ISNUMERIC(@alphaS)=1
	SET @alpha=CAST(@alphaS AS float)
INSERT INTO @dataPoints
SELECT data FROM SPLIT(@dataPointsString,',')
DECLARE @n INT =(SELECT COUNT(*) FROM @dataPoints)
IF @numberOfOutliers=0
	SET @numberOfOutliers = 10.0*@n/100.0
IF(@n<@numberOfOutliers+2)
 RETURN
DECLARE @gesdCriticalValues TABLE(i int , data float, R float,p float,lambda float, t float, isOutlier int)
DECLARE @i int=1
WHILE @i<=@numberOfOutliers
BEGIN
	DECLARE @datapt float
	DECLARE @diff float
	DECLARE @mean float
	DECLARE @sigma float
	DECLARE @R float
	SELECT top(1) @datapt=data ,@diff=ABS(AVG(data)OVER()-data) from @datapoints order by abs(avg(data)over()-data) desc
	INSERT INTO @gesdCriticalValues(i,data,R)
	SELECT @i,@datapt,@diff/NULLIF(stdev(data),0)
	FROM @datapoints
	DELETE top(1) from @datapoints where data=@datapt
	SET @i=@i+1
END
UPDATE @gesdCriticalValues SET p=1.0-(@alpha/(2.0*(@n-i+1)))
UPDATE @gesdCriticalValues SET t=dbo.Stat_GetTCriticalValue(@n-i+1,p)
UPDATE @gesdCriticalValues SET lambda=((@n-i)*t)/SQRT((@n-i+1+power(t,2))*(@n-i+1)),isOutlier=0
UPDATE @gesdCriticalValues SET isOutlier= 1 WHERE R>lambda
DECLARE  @lastOutlier INT=(SELECT MAX(i) FROM @gesdCriticalValues WHERE isOutlier=1)
SELECT data FROM @gesdCriticalValues WHERE i<= @lastOutlier
GO

IF EXISTS (select * from GxQscripts where name = 'Stat_GetOutliers_GESD')
	delete from GxQscripts where name = 'Stat_GetOutliers_GESD'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Stat_GetOutliers_GESD')
	delete from GXDBVersions where aliasname = 'Stat_GetOutliers_GESD'
GO

insert into GXDBVersions values(2, 'Stat_GetOutliers_GESD',  '00010001000200010000', 'Stat_GetOutliers_GESD', '00010001000200010000')
GO

