

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlUpgradeSchedRestoreFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlUpgradeSchedRestoreFiles.sp,v $ $Id: SqlUpgradeSchedRestoreFiles.sp,v 1.2.300.1 2018/03/27 08:59:30 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlUpgradeSchedRestoreFiles
--  |
--  | Description:
--  |  Upgrades the sql restore files list in the SchedRestoreFiles table
--  |  from using ':' as the delimiter to using 0x12.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        myang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlUpgradeSchedRestoreFiles <<<'

IF EXISTS (select * from sysobjects where name='SqlUpgradeSchedRestoreFiles')
	drop procedure SqlUpgradeSchedRestoreFiles
IF EXISTS (select * from GxQscripts where name='SqlUpgradeSchedRestoreFiles')
	delete from GxQscripts where name = 'SqlUpgradeSchedRestoreFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpgradeSchedRestoreFiles')
	delete from GXDBVersions where aliasname = 'SqlUpgradeSchedRestoreFiles'
GO
print '... Creating Procedure: SqlUpgradeSchedRestoreFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlUpgradeSchedRestoreFiles
  @i_clientId integer
AS
  DECLARE @retVal INTEGER;
SET NOCOUNT ON
UPDATE SchedRestoreFiles
SET name = REPLACE(name, '::', 0x12)
FROM SchedRestoreFiles f, SchedRestoreTask t
WHERE f.restoreTaskId = t.id
AND t.appTypeId = 81
AND t.destClientId = @i_clientId
SET @retVal = @@ERROR
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SqlUpgradeSchedRestoreFiles')
	delete from GxQscripts where name = 'SqlUpgradeSchedRestoreFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpgradeSchedRestoreFiles')
	delete from GXDBVersions where aliasname = 'SqlUpgradeSchedRestoreFiles'
GO

insert into GXDBVersions values(2, 'SqlUpgradeSchedRestoreFiles',  '00010002030000010000', 'SqlUpgradeSchedRestoreFiles', '00010002030000010000')
GO

