

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlUpdateDatabaseInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlUpdateDatabaseInfo')
BEGIN
	print '>>> Drop Stored Procedure: SqlUpdateDatabaseInfo <<<'
	drop procedure SqlUpdateDatabaseInfo
END
IF EXISTS (select * from GxQscripts where name='SqlUpdateDatabaseInfo')
	delete from GxQscripts where name = 'SqlUpdateDatabaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateDatabaseInfo')
	delete from GXDBVersions where aliasname = 'SqlUpdateDatabaseInfo'
GO
print '... Creating Procedure: SqlUpdateDatabaseInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlUpdateDatabaseInfo
  @XmlInputOutput XML
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
/* This indicates that no more data is available. */
BEGIN TRY
	-- INSERT or UPDATE
	-- Only one entry, so using table variable.
	DECLARE @sqlInfoTbl TABLE(instanceId INTEGER NOT NULL, appId INTEGER NOT NULL, DbName nvarchar(128),
		LastOkBackupTime INTEGER, LastAttemptBkpTime INTEGER,
		LastBackupJob INTEGER, LastBackupSetId INTEGER, RecoveryModel INTEGER, LastBkpStatus INTEGER,
		Reserved NVARCHAR(MAX), sqlNameId INT)
	-- Get input values.
	INSERT INTO @sqlInfoTbl
		SELECT ISNULL(Tbl.Col.value('@instanceId', 'int'), ''),
			ISNULL(Tbl.Col.value('@appId', 'int'), ''),
			ISNULL(Tbl.Col.value('@sqlDatabaseName', 'nvarchar(2048)'), ''),
			ISNULL(Tbl.Col.value('@LastOkBackupTime', 'int'), ''),
			ISNULL(Tbl.Col.value('@LastAttemptBkpTime', 'int'), ''),
			ISNULL(Tbl.Col.value('@LastBackupJob', 'int'), ''),
			ISNULL(Tbl.Col.value('@LastBackupSetId', 'int'), ''),
			ISNULL(Tbl.Col.value('@rm', 'int'), ''),
			ISNULL(Tbl.Col.value('@LastBkpStatus', 'int'), ''),
			ISNULL(Tbl.Col.value('@ReservedXml', 'NVARCHAR(MAX)'), ''), SN.id
		FROM @XmlInputOutput.nodes('/SQLiDA_SqlUpdateDatabaseInfoReq') as Tbl(Col)
			JOIN sqlNames2 (NOLOCK) SN2 ON SN2.type = 1
				AND SN2.name = ISNULL(Tbl.Col.value('@sqlDatabaseName', 'nvarchar(2048)'), '')
			JOIN sqlNames (NOLOCK) SN ON SN.type = 1  AND SN.sqlId = SN2.id
	-- INSERT OR UPDATE value based on given input and existing values.
	DECLARE @LastBackupSetId INT  = 0
	DECLARE @bAS BIT = 'false'
	SET @bAS = CASE WHEN EXISTS( select id from APP_InstanceProp as IP
								JOIN @sqlInfoTbl SI on IP.componentNameId = SI.instanceId
								Where IP.attrName= N'MSSQL Server Type' AND IP.attrVal =  N'Analysis Services') THEN 'true'
			ELSE 'false' END
	IF @bAS = 'false'
	BEGIN
		SELECT TOP 1 @LastBackupSetId = SBI.id
			FROM @sqlInfoTbl SI JOIN sqlDbBackupInfo (NOLOCK) SBI
				ON SBI.appId = SI.appId AND SBI.jobId = SI.LastBackupJob AND SBI.sqlNameId = SI.SqlNameId
			ORDER BY SBI.backup_finish_date DESC
	END
	ELSE
	BEGIN
		SELECT TOP 1 @LastBackupSetId = SABI.id
		FROM @sqlInfoTbl SI
		JOIN sqlAnalysisDbBackupInfo (NOLOCK) SABI
		ON SABI.appId = SI.appId AND SABI.jobId = SI.LastBackupJob AND SABI.dbId = SI.SqlNameId
		ORDER BY SABI.backup_finish_date DESC
	END
	-- Skip the update if there is no backup found for the database.
	IF @LastBackupSetId <> 0 OR @LastBackupSetId <> NULL
	BEGIN
		-- Update last backup set ID.
		UPDATE SI SET SI.LastBackupSetId = @LastBackupSetId FROM @sqlInfoTbl SI
		-- First try UPDATE.
		UPDATE SDB SET
				SDB.appId = CASE WHEN SI.appId <> 0
						THEN SI.appId ELSE SDB.appId END,
				SDB.LastOkBackupTime = CASE
										WHEN SI.LastOkBackupTime <> 0 AND SI.LastOkBackupTime > SDB.LastOkBackupTime
											THEN SI.LastOkBackupTime
										ELSE SDB.LastOkBackupTime END,
				SDB.LastAttemptBkpTime = CASE WHEN SI.LastAttemptBkpTime <> 0
						THEN SI.LastAttemptBkpTime ELSE SDB.LastAttemptBkpTime END,
				SDB.LastBackupJob = CASE WHEN SI.LastBackupJob <> 0 AND SI.LastAttemptBkpTime <> 0
						THEN SI.LastBackupJob ELSE SDB.LastBackupJob END,
				SDB.LastBackupSetId = CASE
								WHEN @bAS = 'false' AND SI.LastBackupJob <> 0 AND SI.LastOkBackupTime <> 0
									THEN (SELECT TOP 1 id FROM sqlDbBackupInfo (NOLOCK) SBI WHERE SBI.appId = SI.appId
									AND SBI.jobId = SI.LastBackupJob AND SBI.sqlNameId = SI.SqlNameId ORDER BY SBI.backup_finish_date DESC)
								WHEN  @bAS = 'true' AND SI.LastBackupJob <> 0 AND SI.LastOkBackupTime <> 0
									THEN (SELECT TOP 1 id FROM sqlAnalysisDbBackupInfo (NOLOCK) SABI WHERE SABI.appId = SI.appId
									AND SABI.jobId = SI.LastBackupJob AND SABI.dbId = SI.SqlNameId ORDER BY SABI.backup_finish_date DESC)
						ELSE SDB.LastBackupSetId END,
				SDB.RecoveryModel = CASE WHEN SI.RecoveryModel <> 0
						THEN SI.RecoveryModel ELSE SDB.RecoveryModel END,
				SDB.LastBkpStatus = CASE WHEN SI.LastBkpStatus <> 0
						THEN SI.LastBkpStatus ELSE SDB.LastBkpStatus END,
				SDB.Reserved = CASE WHEN LEN(SI.Reserved) <> 0
						THEN SI.Reserved ELSE SDB.Reserved END
			FROM sqlDatabaseInfo SDB JOIN @sqlInfoTbl SI
				ON SDB.databaseId = SI.SqlNameId AND SDB.instanceId = SI.instanceId
		-- Then INSERT.
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO SqlDatabaseInfo
				SELECT SI.instanceId,  SI.sqlNameId, SI.appId, SI.DbName, SI.LastOkBackupTime,
					SI.LastAttemptBkpTime, SI.LastBackupJob, SI.LastBackupSetId,
					SI.RecoveryModel, SI.LastBkpStatus, SI.Reserved
				FROM @sqlInfoTbl SI
		END
	END
	-- Output.
	SET  @XmlInputOutput = (SELECT 0 AS '@errorCode', N'' AS '@errorMessage'
			FOR XML PATH ('SQLiDA_SqlUpdateDatabaseInfoResp'), type)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
			FOR XML PATH ('SQLiDA_SqlUpdateDatabaseInfoResp'), type)
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'SqlUpdateDatabaseInfo')
	delete from GxQscripts where name = 'SqlUpdateDatabaseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateDatabaseInfo')
	delete from GXDBVersions where aliasname = 'SqlUpdateDatabaseInfo'
GO

insert into GXDBVersions values(2, 'SqlUpdateDatabaseInfo',  '00000000000000000000', 'SqlUpdateDatabaseInfo', '00000000000000000000')
GO

