

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlUpdateBackupInfoXML.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault  Systems, Inc.
--        The copyright notice above does not evidence any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlUpdateBackupInfoXML')
BEGIN
	print '>>> Drop Stored Procedure: SqlUpdateBackupInfoXML <<<'
	drop procedure SqlUpdateBackupInfoXML
END
IF EXISTS (select * from GxQscripts where name='SqlUpdateBackupInfoXML')
	delete from GxQscripts where name = 'SqlUpdateBackupInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateBackupInfoXML')
	delete from GXDBVersions where aliasname = 'SqlUpdateBackupInfoXML'
GO
print '... Creating Procedure: SqlUpdateBackupInfoXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlUpdateBackupInfoXML
  @iXmlInput XML
AS
  DECLARE @outputXML XML
  DECLARE @totalLogCount INTEGER
-- Logic to update or insert the backup information.
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @outputXML = ''
SET @totalLogCount = 0
DECLARE	@replicaUsed			NVARCHAR(1024) = N''
DECLARE	@dbName					NVARCHAR(1024) = N''
DECLARE	@appId					INTEGER = 0
DECLARE	@jobId					INTEGER = 0
DECLARE	@instanceId				INTEGER = 0
DECLARE @ErrNo					INT = 0
DECLARE @ErrMsg					NVARCHAR(MAX) = N''
DECLARE @Version				INT = 1
BEGIN TRY
	SET @Version = ISNULL((Select Tbl.Col.value('@version', 'bigint') From @iXmlInput.nodes('App_SqlBulkUpdateBackupInfo') Tbl(Col)), 1)
	/************ SQL db backup info ************/
	IF OBJECT_ID('tempdb.dbo.#sqlDbBackupInfo_mock') IS NOT NULL
		DROP TABLE #sqlDbBackupInfo_mock
	CREATE TABLE #sqlDbBackupInfo_mock([id] [int] IDENTITY(1,1) NOT NULL,
		[backup_set_id] [int] NOT NULL, [majorVersion] [int] NOT NULL, [minorVersion] [int] NOT NULL,
		[buildVersion] [int] NOT NULL, [database_creation_date] [int] NOT NULL, [backup_start_Date] [int] NOT NULL,
		[backup_finish_Date] [int] NOT NULL, [type] [char](1) NOT NULL, [instanceId] [int] NOT NULL,
		[appId] [int] NOT NULL, [backup_size] [bigint] NOT NULL, [dbId] [int] NOT NULL,
		[first_lsn] NUMERIC(32,0) NOT NULL, [last_lsn] NUMERIC(32,0) NOT NULL, [checkpoint_lsn] NUMERIC(32,0) NOT NULL,
		[full_bkup_lsn] NUMERIC(32,0) NOT NULL, [sqlNameId] [int] NOT NULL, [sqlLastLogBackup] [int] NOT NULL,
		[sqlVssFullbackupTime] [varchar](64) NULL, [is_copy] [int] NOT NULL, [backupmethod] [int] NOT NULL,
		[backupVendor] [int] NOT NULL, [jobId] [int] NOT NULL, [replica_id] [uniqueidentifier] NULL,
		[group_database_id] [uniqueidentifier] NULL, [first_recovery_fork_guid] [uniqueidentifier] NULL,
		[last_recovery_fork_guid] [uniqueidentifier] NULL, [differential_base_guid] [uniqueidentifier] NULL,
		[database_guid] [uniqueidentifier] NULL, [fork_point_lsn] [varchar](32) NULL, [differential_base_lsn] [varchar](32) NULL,
		[compressed_backup_size] [varchar](32) NULL, [begins_log_chain] [char](1) NULL, [has_backup_checksums] [char](1) NULL,
		[database_bkup_lsn] [varchar](32) NOT NULL, [group_id] INT, database_name nvarchar(1024), [no_files] [INT], PRIMARY KEY (id))
	IF OBJECT_ID('tempdb.dbo.#sqlDbBackupInfo_mock_copy') IS NOT NULL
		DROP TABLE #sqlDbBackupInfo_mock_copy
	CREATE TABLE #sqlDbBackupInfo_mock_copy([id] [int] NOT NULL,
		[backup_set_id] [int] NOT NULL, [majorVersion] [int] NOT NULL, [minorVersion] [int] NOT NULL,
		[buildVersion] [int] NOT NULL, [database_creation_date] [int] NOT NULL, [backup_start_Date] [int] NOT NULL,
		[backup_finish_Date] [int] NOT NULL, [type] [char](1) NOT NULL, [instanceId] [int] NOT NULL,
		[appId] [int] NOT NULL, [backup_size] [bigint] NOT NULL, [dbId] [int] NOT NULL,
		[first_lsn] [varchar](32) NOT NULL, [last_lsn] [varchar](32) NOT NULL, [checkpoint_lsn] [varchar](32) NOT NULL,
		[full_bkup_lsn] [varchar](32) NOT NULL, [sqlNameId] [int] NOT NULL, [sqlLastLogBackup] [int] NOT NULL,
		[sqlVssFullbackupTime] [varchar](64) NULL, [is_copy] [int] NOT NULL, [backupmethod] [int] NOT NULL,
		[backupVendor] [int] NOT NULL, [jobId] [int] NOT NULL, [replica_id] [uniqueidentifier] NULL,
		[group_database_id] [uniqueidentifier] NULL, [first_recovery_fork_guid] [uniqueidentifier] NULL,
		[last_recovery_fork_guid] [uniqueidentifier] NULL, [differential_base_guid] [uniqueidentifier] NULL,
		[database_guid] [uniqueidentifier] NULL, [fork_point_lsn] [varchar](32) NULL, [differential_base_lsn] [varchar](32) NULL,
		[compressed_backup_size] [varchar](32) NULL, [begins_log_chain] [char](1) NULL, [has_backup_checksums] [char](1) NULL,
		[database_bkup_lsn] [varchar](32) NOT NULL, [group_id] INT, database_name nvarchar(1024), [no_files] [INT], PRIMARY KEY (id))
	CREATE NONCLUSTERED INDEX [sqlDbBackupInfo_mock_copy_backupmethod_id_idx]
		ON #sqlDbBackupInfo_mock_copy ([backupmethod] ASC)
		INCLUDE ([id])
	CREATE NONCLUSTERED INDEX [sqlDbBackupInfo_mock_copy_instanceId_sqlNameid_type_lstlsn_frstlsn_idx]
		ON #sqlDbBackupInfo_mock_copy ( [instanceId] ASC, [sqlNameId] ASC, [type] ASC, [last_lsn] ASC, [first_lsn] ASC )
		INCLUDE ([backup_set_id], [backup_finish_Date], [id])
	CREATE NONCLUSTERED INDEX [sqlDbBackupInfo_mock_copy_sqlNameId]
		ON #sqlDbBackupInfo_mock_copy ( [sqlNameId] ASC )
	CREATE NONCLUSTERED INDEX [sqlDbBackupInfo_mock_copy_sqlNameId_instanceId_jobId_idx]
		ON #sqlDbBackupInfo_mock_copy ( [sqlNameId] ASC, [instanceId] ASC, [jobId] ASC )
	/************ SQL Archive Info ************/
	IF OBJECT_ID('tempdb.dbo.#sqlArchiveInfo_mock') IS NOT NULL
		DROP TABLE #sqlArchiveInfo_mock
	CREATE TABLE #sqlArchiveInfo_mock([commCellId] [int] NOT NULL, [aFileId] [int] NOT NULL, [aFileOffset] [bigint] NOT NULL,
			[aGroupId] [int] NOT NULL, [appId] [int] NOT NULL, [DbFile] [nvarchar](max) NULL, [backupJobId] [int] NOT NULL,
			[backup_start_Date] [int] NOT NULL, [backup_finish_date] [INT] NOT NULL,
			[first_lsn] [nvarchar](32) NOT NULL, [last_lsn] [nvarchar](32) NOT NULL,
			[ckpt_lsn] [nvarchar](32) NOT NULL,
			[type] [char](1) NOT NULL)
	CREATE CLUSTERED INDEX [sqlArchiveInfo_mock_sqlDbBackupFileId_aFileId_commCellId_aFileOffset_PK]
		ON #sqlArchiveInfo_mock([aFileId] ASC, [commCellId] ASC, [aFileOffset] ASC, [backup_finish_date] ASC)
	CREATE NONCLUSTERED INDEX [sqlArchiveInfo_mock_backupJobId_commCellId]
		ON #sqlArchiveInfo_mock([backupJobId] ASC, [commCellId] ASC)
	CREATE NONCLUSTERED INDEX [sqlArchiveInfo_mock_aFileId_commCellId_lsn]
		ON #sqlArchiveInfo_mock ([aFileId] ASC, [commCellId] ASC)
		INCLUDE ([first_lsn], [last_lsn], [ckpt_lsn])
	/************************* SQL File backup info table ****************************/
	IF OBJECT_ID('tempdb.dbo.#sqlFileBackupInfo_mock') IS NOT NULL
		DROP TABLE #sqlFileBackupInfo_mock
	CREATE TABLE #sqlFileBackupInfo_mock([id] [int] IDENTITY(1,1) NOT NULL PRIMARY KEY,
		[backup_start_Date] [int] NOT NULL, [backup_finish_date] [INT] NOT NULL,
		[first_lsn] NVARCHAR(32), [last_lsn] NVARCHAR(32),
		[checkpoint_lsn] NVARCHAR(32), [fileGroupName] NVARCHAR(255), [sqlFgId] INT,
		[logicalFileName] NVARCHAR(255), [sqlLogId] INT, [number] INT, [pageSize] BIGINT, [physicalFileName] NVARCHAR(255),
		[sqlPhyId] INT, [type] INT, [bkpType] [char](1) NOT NULL)
	CREATE NONCLUSTERED INDEX [sqlFileBackupInfo_mock_aFileId_commCellId_lsn]
		ON #sqlFileBackupInfo_mock ([id], [first_lsn], [last_lsn])
		INCLUDE ([checkpoint_lsn])
	-- Table to store combined log entries as output. This will be used for sending response xml compatible to update JMMisc table
	IF OBJECT_ID('tempdb.dbo.#combinedLogEntries') IS NOT NULL DROP TABLE #combinedLogEntries
	CREATE TABLE #combinedLogEntries([id] [int] NOT NULL, [backup_set_id] [int] NOT NULL, [majorVersion] [int] NOT NULL, [minorVersion] [int] NOT NULL,
		[buildVersion] [int] NOT NULL, [database_creation_date] [int] NOT NULL, [backup_start_Date] [int] NOT NULL, [backup_finish_Date] [int] NOT NULL,
		[type] [char](1) NOT NULL, [instanceId] [int] NOT NULL, [appId] [int] NOT NULL, [backup_size] [bigint] NOT NULL, [dbId] [int] NOT NULL,
		[first_lsn] [varchar](32) NOT NULL, [last_lsn] [varchar](32) NOT NULL, [checkpoint_lsn] [varchar](32) NOT NULL,[full_bkup_lsn] [varchar](32) NOT NULL,
		[sqlNameId] [int] NOT NULL, [sqlLastLogBackup] [int] NOT NULL, [sqlVssFullbackupTime] [varchar](64) NULL, [is_copy] [int] NOT NULL, [backupmethod] [int] NOT NULL,
		[backupVendor] [int] NOT NULL,[jobId] [int] NOT NULL,[replica_id] [uniqueidentifier] NULL,[group_database_id] [uniqueidentifier] NULL,
		[first_recovery_fork_guid] [uniqueidentifier] NULL,[last_recovery_fork_guid] [uniqueidentifier] NULL, [differential_base_guid] [uniqueidentifier] NULL,
		[database_guid] [uniqueidentifier] NULL,[fork_point_lsn] [varchar](32) NULL, [differential_base_lsn] [varchar](32) NULL,[compressed_backup_size] [varchar](32) NULL,
		[begins_log_chain] [char](1) NULL, [has_backup_checksums] [char](1) NULL, [database_bkup_lsn] [varchar](32) NOT NULL, [groupNo] [int] NOT NULL,
		[comppressedLogCount] [int] NOT NULL)
	-- Populate #sqlDbBackupInfo_mock from the xml
	INSERT INTO #sqlDbBackupInfo_mock ([backup_set_id], [majorVersion], [minorVersion], [buildVersion], [database_creation_date],
		[backup_start_Date], [backup_finish_Date], [type], [instanceId], [appId], [backup_size], [dbId], [first_lsn], [last_lsn],
		[checkpoint_lsn], [full_bkup_lsn], [sqlNameId], [sqlLastLogBackup], [sqlVssFullbackupTime], [is_copy], [backupmethod],
		[backupVendor], [jobId], [replica_id], [group_database_id], [first_recovery_fork_guid], [last_recovery_fork_guid],
		[differential_base_guid], [database_guid], [fork_point_lsn], [differential_base_lsn], [compressed_backup_size],
		[begins_log_chain], [has_backup_checksums], [database_bkup_lsn], [group_id], [database_name], [no_files])
		SELECT
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_set_id)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@majorVersion)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@minorVersion)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@buildVersion)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@database_creation_date)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_start_Date)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_finish_Date)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@type)[1]', 'CHAR'), 'L'),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@instanceId)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@appId)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_size)[1]', 'BIGINT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@databaseId)[1]', 'INT'), 0),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@first_lsn)[1]', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@last_lsn)[1]', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@checkpoint_lsn)[1]', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@full_bkup_lsn)[1]', 'NVARCHAR(32)'), N'') AS NUMERIC(32,0)),
			0/*sqlNameid*/, 0, ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@sqlVssBackupTime)[1]', 'NVARCHAR(32)'), N''),
			0, 0, 0, ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@jobId)[1]', 'INT'), 0),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@replica_id)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@group_database_id)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@first_recovery_fork_guid)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@last_recovery_fork_guid)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@differential_base_guid)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			CAST(ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@database_guid)[1]', 'NVARCHAR(36)'), N'00000000-0000-0000-0000-000000000000') AS UNIQUEIDENTIFIER),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@fork_point_lsn)[1]', 'NVARCHAR(32)'), N''),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@differential_base_lsn)[1]', 'NVARCHAR(32)'), N''),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@compressed_backup_size)[1]', 'NVARCHAR(32)'), N''),
			'N', '', N'0', 0,
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@databaseName)[1]', 'NVARCHAR(1024)'), N''), 0
		FROM @iXmlInput.nodes('App_SqlBulkUpdateBackupInfo/SqlBackups') Tbl(Col)
	-- This query has been written to make sure
	-- Ordering AND ROW ordering in sequence.
	INSERT INTO #sqlDbBackupInfo_mock_copy
	SELECT ROW_NUMBER() OVER (ORDER BY SM.[backup_finish_Date], SM.[last_lsn]),
		[backup_set_id], [majorVersion], [minorVersion], [buildVersion], [database_creation_date],
		[backup_start_Date], [backup_finish_Date], [type], [instanceId], [appId], [backup_size], [dbId], [first_lsn], [last_lsn],
		[checkpoint_lsn], [full_bkup_lsn], [sqlNameId], [sqlLastLogBackup], [sqlVssFullbackupTime], [is_copy], [backupmethod],
		[backupVendor], [jobId], [replica_id], [group_database_id], [first_recovery_fork_guid], [last_recovery_fork_guid],
		[differential_base_guid], [database_guid], [fork_point_lsn], [differential_base_lsn], [compressed_backup_size],
		[begins_log_chain], [has_backup_checksums], [database_bkup_lsn], [group_id], [database_name], [no_files]
	FROM #sqlDbBackupInfo_mock SM
	-- Free the memory.
	DROP TABLE #sqlDbBackupInfo_mock
	-- Fetch database name, instance id, jobid and appid from #sqlDbBackupInfo_mock_copy table
	DECLARE @databaseName NVARCHAR(1024) = N''
	SELECT TOP 1 @databaseName = SM.database_name, @instanceId  = SM.instanceId, @jobId = SM.jobId, @appId = appid
	FROM #sqlDbBackupInfo_mock_copy SM
	WHERE SM.database_name IS NOT NULL AND SM.database_name <> N'' AND SM.instanceId IS NOT NULL AND SM.instanceId > 0
	-- Populate @sqlArchiveInfo_mock table from the xml
	INSERT INTO #sqlArchiveInfo_mock([commCellId], [aFileId], [aFileOffset], [aGroupId], [appId], [backupJobId],
		[backup_start_date], [backup_finish_date], [first_lsn], [last_lsn], [ckpt_lsn], [type])
	SELECT
		ISNULL(Tbl.Col.value('(backupInfo/archFile/@commcellId)[1]', 'int'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/archFile/@aFileId)[1]', 'int'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/archFile/@aOffset)[1]', 'BIGINT'), N''),
		ISNULL(Tbl.Col.value('(backupInfo/archFile/@aGroupId)[1]', 'INT'), N''),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@appId)[1]', 'INT'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@jobId)[1]', 'INT'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_start_Date)[1]', 'INT'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_finish_Date)[1]', 'INT'), 0),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@first_lsn)[1]', 'NVARCHAR(32)'), N''),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@last_lsn)[1]', 'NVARCHAR(32)'), N''),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@checkpoint_lsn)[1]', 'NVARCHAR(32)'), N''),
		ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@type)[1]', 'CHAR'), 'L')
	FROM @iXmlInput.nodes('App_SqlBulkUpdateBackupInfo/SqlBackups') Tbl(Col)
	-- Populate #sqlFileBackupInfo_mock from input xml
	INSERT INTO #sqlFileBackupInfo_mock ([backup_start_Date], [backup_finish_Date], [first_lsn], [last_lsn],
		[checkpoint_lsn], [fileGroupName], [sqlFgId], [logicalFileName], [sqlLogId], [number], [pageSize],
		[physicalFileName], [sqlPhyId], [type]/*, [backupStartId]*/, [bkpType])
		SELECT
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_start_Date)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@backup_finish_Date)[1]', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@first_lsn)[1]', 'NVARCHAR(32)'), N''),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@last_lsn)[1]', 'NVARCHAR(32)'), N''),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@checkpoint_lsn)[1]', 'NVARCHAR(32)'), N''),
			ISNULL(Tbl2.Col2.value('@fileGroupName', 'NVARCHAR(255)'), N''), 0,
			ISNULL(Tbl2.Col2.value('@logicalFileName', 'NVARCHAR(255)'), N''), 0,
			ISNULL(Tbl2.Col2.value('@number', 'INT'), 0),
			ISNULL(Tbl2.Col2.value('@pageSize', 'BIGINT'), 0),
			ISNULL(Tbl2.Col2.value('@physicalFileName', 'NVARCHAR(255)'), N''), 0,
			ISNULL(Tbl2.Col2.value('@type', 'INT'), 0),
			ISNULL(Tbl.Col.value('(backupInfo/dbInfo/@type)[1]', 'CHAR'), 'L')
		FROM @iXmlInput.nodes('App_SqlBulkUpdateBackupInfo/SqlBackups') Tbl(Col)
			CROSS APPLY Tbl.Col.nodes('backupInfo/fileInfo') Tbl2(Col2)
		WHERE Tbl.Col.value('(backupInfo/dbInfo/@backup_start_Date)[1]', 'INT') IS NOT NULL AND
			Tbl.Col.value('(backupInfo/dbInfo/@backup_finish_Date)[1]', 'INT') IS NOT NULL AND
			Tbl2.Col2.value('@logicalFileName', 'NVARCHAR(255)') IS NOT NULL AND
			LEN(Tbl2.Col2.value('@logicalFileName', 'NVARCHAR(255)')) > 0
	IF OBJECT_ID('tempdb.dbo.#sqlNames') IS NOT NULL
		DROP TABLE #sqlNames
	CREATE TABLE #sqlNames([name] [NVARCHAR](255) NOT NULL,  type [int] NOT NULL, sqlId [int])
	BEGIN TRAN SqlUpdateBackupInfoXML_Tran
	-- Database name insert.
	-- TODO: Handle multiple ids due to race condition
	-- *BUG*: Race condition leads to a BUG with multiple IDs for same files.
	DECLARE @outSqlNameID INT = 0
	SELECT TOP 1 @outSqlNameID = SN.id
    FROM sqlNames SN JOIN sqlNames2 SN2
        ON SN.sqlId = SN2.id AND SN.type = 1
            AND SN2.type = 1 AND SN2.name = @databaseName
	-- Check if DB name found already. If not, go for insert.
	IF @outSqlNameID = 0
	BEGIN
		DECLARE @n2Id INT = 0
		INSERT INTO sqlNames2 VALUES(0, @databaseName, 1)
		SELECT @n2Id = SCOPE_IDENTITY()
		INSERT INTO sqlNames VALUES (@n2Id, @databaseName, 1)
		SELECT @outSqlNameID = SCOPE_IDENTITY()
	END
	-- File group ID insert
	INSERT INTO sqlNames2 (sqlId, name, type)
		OUTPUT INSERTED.name, INSERTED.type, INSERTED.id INTO #sqlNames
	SELECT  0, SM.fileGroupName, 2
		FROM #sqlFileBackupInfo_mock SM
			LEFT JOIN sqlNames2 SN2 ON SM.fileGroupName = SN2.name AND SN2.type = 2
			LEFT JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 2
		WHERE SN2.id IS  NULL
	INSERT INTO sqlNames (sqlId, name, type)
	SELECT  SN.sqlId, SM.fileGroupName, 2
		FROM #sqlFileBackupInfo_mock SM
			JOIN #sqlNames SN ON SN.name = SM.fileGroupName AND SN.type = 2
	-- Physical file ID insert.
	INSERT INTO sqlNames2 (sqlId, name, type)
		OUTPUT INSERTED.name, INSERTED.type, INSERTED.id INTO #sqlNames
	SELECT  0, SM.physicalFileName, 3
		FROM #sqlFileBackupInfo_mock SM
			LEFT JOIN sqlNames2 SN2 ON SM.physicalFileName = SN2.name AND SN2.type = 3
			LEFT JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 3
		WHERE SN2.id IS  NULL
	INSERT INTO sqlNames (sqlId, name, type)
	SELECT  SN.sqlId, SM.physicalFileName, 3
		FROM #sqlFileBackupInfo_mock SM
			JOIN #sqlNames SN ON SN.name = SM.physicalFileName AND SN.type = 3
	-- Logical file ID insert.
	INSERT INTO sqlNames2 (sqlId, name, type)
		OUTPUT INSERTED.name, INSERTED.type, INSERTED.id INTO #sqlNames
	SELECT  0, SM.logicalFileName, 4
		FROM #sqlFileBackupInfo_mock SM
			LEFT JOIN sqlNames2 SN2 ON SM.logicalFileName = SN2.name AND SN2.type = 4
			LEFT JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 4
		WHERE SN2.id IS  NULL
	INSERT INTO sqlNames (sqlId, name, type)
	SELECT  SN.sqlId, SM.logicalFileName, 4
		FROM #sqlFileBackupInfo_mock SM
			JOIN #sqlNames SN ON SN.name = SM.logicalFileName AND SN.type = 4
	-- Update name IDs.
	UPDATE SD SET
		SD.sqlNameId = SN.id
	FROM #sqlDbBackupInfo_mock_copy SD
		JOIN sqlNames2 SN2
			ON SN2.type = 1
				AND SN2.name = SD.database_name
		JOIN sqlNames SN
			ON SN.sqlId = SN2.id
				AND SN.type = 1
	-- File Group ID.
	UPDATE SF SET
		SF.sqlFgId = SN.id
	FROM #sqlFileBackupInfo_mock SF
		JOIN sqlNames2 SN2
			ON SN2.type = 2
				AND SN2.name = SF.fileGroupName
		JOIN sqlNames SN
			ON SN.sqlId = SN2.id
				AND SN.type = 2
	-- File Physical ID.
	UPDATE SF SET
		SF.sqlPhyId = SN.id
	FROM #sqlFileBackupInfo_mock SF
		JOIN sqlNames2 SN2
			ON SN2.type = 3
				AND SN2.name = SF.physicalFileName
		JOIN sqlNames SN
			ON SN.sqlId = SN2.id
				AND SN.type = 3
	-- File logical ID.
	UPDATE SF SET
		SF.sqlLogId = SN.id
	FROM #sqlFileBackupInfo_mock SF
		JOIN sqlNames2 SN2
			ON SN2.type = 4
				AND SN2.name = SF.logicalFileName
		JOIN sqlNames SN
			ON SN.sqlId = SN2.id
				AND SN.type = 4
	-- Check if hole is created, mark the group started.
	-- TODO: Need to create clustered index using id, backupStartTime, backupEndTime, first_lsn, last_lsn so that the insert will be in order of that.
	UPDATE PR SET PR.group_id = 1
		FROM #sqlDbBackupInfo_mock_copy PR
			LEFT JOIN #sqlDbBackupInfo_mock_copy NX
			ON PR.id = NX.id - 1 AND PR.last_lsn = NX.first_lsn
		WHERE NX.id IS NULL
	-- Mark group on FullBkpLSN change
	UPDATE A SET
		A.group_id = 1
	FROM #sqlDbBackupInfo_mock_copy A
		LEFT JOIN #sqlDbBackupInfo_mock_copy B
			ON A.id = B.id - 1
			AND A.full_bkup_lsn = B.full_bkup_lsn
	WHERE B.id IS NULL AND A.group_id <> 1
	IF @Version = 2
	BEGIN
		-- Check if files details are changed.
		-- This logic will be applied for new XML (combined file information).
		UPDATE SD SET
			SD.group_id = 1
		FROM #sqlDbBackupInfo_mock_copy SD
			JOIN (SELECT SI.id as sqlID, SF.id as fileId
					FROM #sqlDbBackupInfo_mock_copy SI
						LEFT JOIN #sqlFileBackupInfo_mock SF
							ON SI.first_lsn = SF.first_lsn
								AND SI.last_lsn = SF.last_lsn
					WHERE SF.id IS NOT NULL) SF
				ON SD.id = SF.sqlID - 1
		WHERE SD.group_id <> 1
	END
	ELSE
	BEGIN
		/* ******** Following Logic for version 1 metadata. ********* */
		-- Check if file numbers are same.
		UPDATE SBM SET
			SBM.no_files = FC.fnt
		FROM #sqlDbBackupInfo_mock_copy SBM
			JOIN  (SELECT
					SF.last_lsn,
					COUNT(SF.last_lsn) fnt
				FROM #sqlFileBackupInfo_mock SF
				GROUP BY SF.last_lsn) FC
			ON FC.last_lsn = SBM.last_lsn
		-- Check if number of files between the backups.
		UPDATE PR SET
			PR.group_id = 1
		FROM #sqlDbBackupInfo_mock_copy PR
			LEFT JOIN #sqlDbBackupInfo_mock_copy NX
				ON PR.id = NX.id - 1
					AND PR.no_files = NX.no_files
		WHERE NX.id IS NULL
	END
	-- Find start and end time to fetch all fulls/diffs in the time range of all the log in the request.
	DECLARE @StartBackupTime INT = 0
	DECLARE @EndBackupTime INT = 0
	SELECT
		@StartBackupTime = MIN(SM.backup_start_Date),
		@EndBackupTime = MAX(SM.backup_finish_Date)
	FROM #sqlDbBackupInfo_mock_copy SM
	-- Find last row id in #sqlDbBackupInfo_mock_copy table to generate rowid for fulls/diffs
	declare @lastRowId integer = 0
	select @lastRowId = max(id) from #sqlDbBackupInfo_mock_copy
	-- Insert required FULLs and DIFFs that are applicable for the logs backups.
	INSERT INTO #sqlDbBackupInfo_mock_copy
		SELECT
			ROW_NUMBER() OVER (ORDER BY SD.[backup_finish_Date], SD.[last_lsn]) + @lastRowId,
			[backup_set_id], [majorVersion], [minorVersion], [buildVersion], [database_creation_date],
			[backup_start_Date], [backup_finish_Date], SD.[type], [instanceId], [appId], [backup_size], [dbId], [first_lsn], [last_lsn],
			[checkpoint_lsn], [full_bkup_lsn], [sqlNameId], [sqlLastLogBackup], [sqlVssFullbackupTime], [is_copy], [backupmethod],
			[backupVendor], [jobId], [replica_id], [group_database_id], [first_recovery_fork_guid], [last_recovery_fork_guid],
			[differential_base_guid], [database_guid], [fork_point_lsn], [differential_base_lsn], [compressed_backup_size],
			[begins_log_chain], [has_backup_checksums], [database_bkup_lsn], 1, @databaseName, 0
		FROM sqlDbBackupInfo SD
		WHERE SD.backup_finish_Date >= @StartBackupTime
			AND SD.backup_finish_Date <= @EndBackupTime
			AND SD.type IN ('D', 'I')
			AND SD.sqlNameId = @outSqlNameID
			AND SD.instanceId = @instanceId
	-- TODO: couting groups might not be needed. But will optimize later.
	DECLARE @groupNo INT = 1
	DECLARE @CountGroups INT  = 0
	SELECT @CountGroups  = COUNT(SM.id)
	FROM #sqlDbBackupInfo_mock_copy SM
	WHERE SM.group_id = 1
	WHILE @CountGroups > 0
	BEGIN
		-- Note: id column in sqlDbBackupInfo_mock is an identity column and full/diff/log are not in order of id column value.
		DECLARE @lastBkpFirstLsn	NUMERIC (32,0) = 0
		DECLARE @lastBkpLastLsn		NUMERIC (32,0) = 0
		DECLARE @lastBkpStartTime	INTEGER = 0
		DECLARE @lastBkpEndTime		INTEGER = 0
		DECLARE @lastBkpType		CHAR = ''
		SELECT TOP 1
			@lastBkpFirstLsn = first_lsn,
			@lastBkpLastLsn = last_lsn,
			@lastBkpStartTime = backup_start_Date,
			@lastBkpEndTime = backup_finish_Date,
			@lastBkpType = type
		FROM #sqlDbBackupInfo_mock_copy SN
		WHERE group_id = 1
		ORDER BY SN.backup_finish_Date ASC
		DECLARE @firstBkpFirstLsn	NUMERIC (32,0) = 0
		DECLARE @firstBkpLastLsn	NUMERIC (32,0) = 0
		DECLARE @firstBkpStartTime	INTEGER = 0
		DECLARE @firstBkpEndTime	INTEGER = 0
		DECLARE @firstBkpType		CHAR = ''
		SELECT TOP 1
			@firstBkpFirstLsn = first_lsn,
			@firstBkpLastLsn = last_lsn,
			@firstBkpStartTime = backup_start_Date,
			@firstBkpEndTime = backup_finish_Date,
			@firstBkpType = type
		FROM #sqlDbBackupInfo_mock_copy SN
		WHERE first_lsn <= @lastBkpFirstLsn
			AND last_lsn <= @lastBkpLastLsn
			AND backup_start_Date <= @lastBkpStartTime
			AND backup_finish_Date <= @lastBkpEndTime
		ORDER BY SN.backup_finish_Date ASC
		-- Check if only full/diff in this group. If yes delete from the group and continue with next group
		IF @lastBkpType = @firstBkpType AND (@lastBkpType = 'D' OR @lastBkpType = 'I')
		BEGIN
			DELETE #sqlFileBackupInfo_mock
				WHERE first_lsn = @lastBkpFirstLsn
					AND last_lsn = @lastBkpLastLsn
					AND backup_start_Date = @lastBkpStartTime
					AND backup_finish_Date = @lastBkpEndTime
					AND bkpType = @lastBkpType
			DELETE #sqlArchiveInfo_mock
				WHERE first_lsn = @lastBkpFirstLsn
					AND last_lsn = @lastBkpLastLsn
					AND backup_start_Date = @lastBkpStartTime
					AND backup_finish_Date = @lastBkpEndTime
					AND type = @lastBkpType
			DELETE #sqlDbBackupInfo_mock_copy
				WHERE first_lsn = @lastBkpFirstLsn
					AND last_lsn <= @lastBkpLastLsn
					AND backup_start_Date <= @lastBkpStartTime
					AND backup_finish_Date <= @lastBkpEndTime
					AND type = @lastBkpType
		END
		ELSE
		BEGIN
			-- Fetch latest FULL corresponding to group's log entries from sqlDbBackupInfo table.
			DECLARE @fullBkpLsnForCurGrpLogs NUMERIC (32, 0) = 0
			SELECT TOP 1
				@fullBkpLsnForCurGrpLogs = SDBI.checkpoint_lsn
			FROM sqlDbBackupInfo SDBI
			WHERE SDBI.instanceId = @instanceId
				AND SDBI.sqlNameId = @outSqlNameID
				AND SDBI.type = 'D'
				AND SDBI.backup_finish_Date <= @firstBkpEndTime
			ORDER BY SDBI.backup_finish_Date DESC
			-- Fetch count of log records that will be compressed
			DECLARE @compressedLogCount INTEGER = 0
			SELECT @compressedLogCount = COUNT(SM.backup_set_id)
			FROM #sqlDbBackupInfo_mock_copy SM
			WHERE backup_finish_Date <= @lastBkpEndTime AND type = 'L'
			SET @totalLogCount = @totalLogCount + @compressedLogCount
			INSERT INTO sqlDbBackupInfo ([backup_set_id],[majorVersion],[minorVersion],[buildVersion], [database_creation_date],[backup_start_Date],
					[backup_finish_Date], [type], [instanceId], [appId], [backup_size], [dbId], [first_lsn], [last_lsn], [checkpoint_lsn], [full_bkup_lsn],
					[sqlNameId], [sqlLastLogBackup], [sqlVssFullbackupTime], [is_copy], [backupmethod], [backupVendor], [jobId], [replica_id],[group_database_id],
					[first_recovery_fork_guid], [last_recovery_fork_guid], [differential_base_guid], [database_guid], [fork_point_lsn],
					[differential_base_lsn], [compressed_backup_size], [begins_log_chain], [has_backup_checksums], [database_bkup_lsn])
					OUTPUT
					inserted.[id], inserted.[backup_set_id], inserted.[majorVersion], inserted.[minorVersion],
					inserted.[buildVersion], inserted.[database_creation_date], inserted.[backup_start_Date], inserted.[backup_finish_Date],
					inserted.[type], inserted.[instanceId], inserted.[appId], inserted.[backup_size], inserted.[dbId],
					inserted.[first_lsn], inserted.[last_lsn], inserted.[checkpoint_lsn], inserted.[full_bkup_lsn],
					inserted.[sqlNameId], inserted.[sqlLastLogBackup], inserted.[sqlVssFullbackupTime], inserted.[is_copy], inserted.[backupmethod],
					inserted.[backupVendor], inserted.[jobId], inserted.[replica_id],inserted.[group_database_id],
					inserted.[first_recovery_fork_guid], inserted.[last_recovery_fork_guid], inserted.[differential_base_guid],
					inserted.[database_guid], inserted.[fork_point_lsn], inserted.[differential_base_lsn], inserted.[compressed_backup_size],
					inserted.[begins_log_chain], inserted.[has_backup_checksums], inserted.[database_bkup_lsn], @groupNo, @compressedLogCount
					INTO #combinedLogEntries
					SELECT MIN([backup_set_id]), MAX([majorVersion]), MAX([minorVersion]), MAX([buildVersion]), MAX([database_creation_date]),
							MIN([backup_start_Date]), MAX([backup_finish_Date]), MAX(SM.[type]), [instanceId], MAX([appId]),
							SUM([backup_size]), MAX([dbId]), MIN([first_lsn]), MAX([last_lsn]), MAX([checkpoint_lsn]), @fullBkpLsnForCurGrpLogs,
							@outSqlNameID, MAX([sqlLastLogBackup]), MAX([sqlVssFullbackupTime]), MAX([is_copy]), MAX([backupmethod]),
							MAX([backupVendor]), MAX([jobId]), MAX([replica_id]), MAX([group_database_id]), MAX([first_recovery_fork_guid]), MAX([last_recovery_fork_guid]),
							MAX([differential_base_guid]), MAX([database_guid]), MAX([fork_point_lsn]), MAX([differential_base_lsn]), MAX([compressed_backup_size]),
							CASE WHEN COUNT(last_lsn) > 1 THEN N'Y' ELSE N'N' END,
							MAX([has_backup_checksums]), MAX([full_bkup_lsn])
						FROM #sqlDbBackupInfo_mock_copy SM
						WHERE backup_finish_Date <= @lastBkpEndTime
							AND type = 'L'
						GROUP BY [instanceId]
			INSERT INTO sqlArchiveInfo([sqlDbBackupFileId],[commCellId], [aFileId], [aFileOffset], [aGroupId], [appId], [DbFile], [backupJobId])
				SELECT
					(SELECT TOP 1 id FROM #combinedLogEntries where groupNo = @groupNo), /* DbFileId*/
					SAN.commCellId,
					SAN.aFileId,
					MIN(SAN.aFileOffset) AS aFileOffset,
					SAN.aGroupId,
					MAX(SAN.appId) AS appId,
					(SELECT
						SAM.backup_finish_date AS '@backupTime',
						SAM.last_lsn AS '@last_lsn',
						SAM.ckpt_lsn AS '@ckpt_lsn',
						SAM.aFileOffset AS '@value'
					FROM #sqlArchiveInfo_mock SAM
						WHERE SAM.backup_finish_Date <= @lastBkpEndTime
							AND SAM.type = 'L'
						FOR XML PATH('offset'), ROOT('App_SqlAfile')) DbFile,
					MAX(SAN.backupJobId) AS jobId
				FROM #sqlArchiveInfo_mock SAN
					WHERE SAN.backup_finish_Date <= @lastBkpEndTime AND
						SAN.type = 'L'
				GROUP BY SAN.commCellId, SAN.aFileId, SAN.aGroupId
			INSERT INTO sqlFileBackupInfo([sqlDbBackupInfoId], [number], [pageSize], [pageCount], [type],
					[sqlNameFgId], [sqlNamePhyId], [sqlNameLogId])
				SELECT
					(SELECT TOP 1 id FROM #combinedLogEntries where groupNo = @groupNo),
					SM.number,
					SM.pageSize, 0,
					SM.type,
					SM.sqlFgId,
					SM.sqlPhyId,
					SM.sqlLogId
				FROM #sqlFileBackupInfo_mock SM
					WHERE SM.backup_finish_Date <= @lastBkpEndTime
						AND SM.first_lsn = @firstBkpFirstLsn
						AND SM.last_lsn = @firstBkpLastLsn
			-- Delete the entries from the table (based on group).
			IF @Version = 2
			BEGIN
				-- Conditional delete for version 2.
				DECLARE @CntEntriesForDelete INT = 0
				SELECT @CntEntriesForDelete = COUNT(SF.backup_finish_date)
					FROM #sqlFileBackupInfo_mock SF
					WHERE SF.backup_finish_date <= @lastBkpEndTime
				IF(@CntEntriesForDelete > 1)
				BEGIN
					DELETE SAM FROM #sqlFileBackupInfo_mock SAM
						WHERE SAM.backup_finish_date < @lastBkpEndTime
				END
			END
			ELSE
			BEGIN
				DELETE #sqlFileBackupInfo_mock WHERE backup_finish_date <= @lastBkpEndTime
			END
			DELETE #sqlArchiveInfo_mock WHERE  backup_finish_date <= @lastBkpEndTime
			DELETE #sqlDbBackupInfo_mock_copy WHERE  backup_finish_date <= @lastBkpEndTime
			-- Increase group number by 1
			SET @groupNo = @groupNo + 1
		END
		-- Reduce the group count now.
		SET @CountGroups = @CountGroups - 1
	END
	-- In case of success, send response xml as JobManager_SQLJobInfo
	IF @ErrNo = 0
	BEGIN
		SET @ErrMsg = (SELECT
						(SELECT
							(SELECT
								(SELECT @databaseName AS '@databaseName',
                                    MIN(backup_start_Date) AS '@backup_start_Date', MAX(backup_finish_date) AS '@backup_finish_Date',
                                    SUM(backup_size) AS '@backup_size', SUM(CAST(compressed_backup_size AS bigint)) AS '@compressed_backup_size',
                                    MIN(first_lsn) AS '@firstLSN', MAX(last_lsn) AS '@lastLSN',
                                    @jobId AS '@jobId', @appId AS '@appId', @instanceId AS '@instanceId'
                                FOR XML PATH('dbInfo'), TYPE)
							FOR XML PATH('backupInfo'), TYPE)
						FROM #combinedLogEntries
						GROUP BY instanceId, sqlNameId
						FOR XML PATH('SqlBackups'), TYPE)
					FOR XML PATH('SqlBulkUpdateBackupInfo'))
	END
EXIT_SQLUPDATEBACKUPINFOXML:
	IF @ErrNo > 0
	BEGIN
		ROLLBACK TRAN SqlUpdateBackupInfoXML_Tran
	END
	ELSE
	BEGIN
		COMMIT TRAN SqlUpdateBackupInfoXML_Tran
	END
END TRY
BEGIN CATCH
	IF @@trancount <> 0
		ROLLBACK TRAN SqlUpdateBackupInfoXML_Tran
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @ErrNo = ERROR_NUMBER()
	SET @ErrMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
SET @outputXML = (SELECT 0 AS '@operation', 0 AS '@backupSetId', ASCII(0) AS '@backupType',
						(SELECT @ErrNo AS '@errorCode', @ErrMsg AS '@errorMessage'
						FOR XML PATH('response'), TYPE)
					FOR XML PATH('App_SQLUpdateBackupResp'))
SELECT @outputXML, @totalLogCount

IF EXISTS (select * from GxQscripts where name = 'SqlUpdateBackupInfoXML')
	delete from GxQscripts where name = 'SqlUpdateBackupInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateBackupInfoXML')
	delete from GXDBVersions where aliasname = 'SqlUpdateBackupInfoXML'
GO

insert into GXDBVersions values(2, 'SqlUpdateBackupInfoXML',  '00000000000000000000', 'SqlUpdateBackupInfoXML', '00000000000000000000')
GO

