

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlUpdateBackupDumpInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- --------------------------------------------------------------------------------
-- Stored procedure to update sqlDatabaseInfo table with latest backup dump time.
-- Example input: <SQLiDA_SqlUpdateBackupDumpInfoReq> <enitity subclientId="25"/> <database ../> <database ../> </SQLiDA_SqlUpdateBackupDumpInfoReq>
-- Will check if database information can be found. If found update else insert the backup info for each DB.
-- --------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlUpdateBackupDumpInfo')
BEGIN
	print '>>> Drop Stored Procedure: SqlUpdateBackupDumpInfo <<<'
	drop procedure SqlUpdateBackupDumpInfo
END
IF EXISTS (select * from GxQscripts where name='SqlUpdateBackupDumpInfo')
	delete from GxQscripts where name = 'SqlUpdateBackupDumpInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateBackupDumpInfo')
	delete from GXDBVersions where aliasname = 'SqlUpdateBackupDumpInfo'
GO
print '... Creating Procedure: SqlUpdateBackupDumpInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlUpdateBackupDumpInfo
  @XmlInputOutput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	-- INSERT or UPDATE
	IF OBJECT_ID('tempdb..#SqlDbDumpInfoPerAppId') IS NOT NULL DROP TABLE #SqlDbDumpInfoPerAppId
	CREATE TABLE #SqlDbDumpInfoPerAppId (appId INT, databaseName NVARCHAR(1024), backupTime INT, recoveryModel INT, lastLSN NUMERIC(32,0), PRIMARY KEY(appId, databaseName))
	INSERT INTO #SqlDbDumpInfoPerAppId
		SELECT (SELECT ISNULL(Ti.Ci.value('@subclientId', 'INT'), 0) FROM @XmlInputOutput.nodes('/SQLiDA_SqlUpdateBackupDumpInfoReq/entity') Ti(Ci)),
			T.C.value('@databaseName', 'nvarchar(1024)'), T.C.value('@backupTime', 'INT'), T.C.value('@recoveryModel', 'INT'), CAST(ISNULL(T.C.value('@lastLSN', 'NVARCHAR(32)'), N'0') AS NUMERIC(32,0))
		FROM @XmlInputOutput.nodes('/SQLiDA_SqlUpdateBackupDumpInfoReq/database') T(C)
	-- Number of rows to be updated
	DECLARE @RowCountIN INT = 0
	SELECT @RowCountIN = COUNT(*) FROM #SqlDbDumpInfoPerAppId SP
	-- Lets check if database backup information is already created or not
	UPDATE SD SET
		SD.LastOkBackupTime = CASE WHEN SD.LastOkBackupTime > DB.backupTime THEN SD.LastOkBackupTime ELSE DB.backupTime END
	FROM SqlDatabaseInfo SD JOIN #SqlDbDumpInfoPerAppId DB ON SD.DatabaseName = DB.databaseName
		JOIN APP_Application SC ON SC.id = SD.appId AND SD.instanceId = SC.instance
	-- Check if all rows got updated
	-- If number of rows updated is less than row count,
	--  then insert those entries which is not found in sqlDatabaseInfo.
	IF @@ROWCOUNT < @RowCountIN
	BEGIN
		-- This condition should not happen as FULL backup is mandate and will be present in this table.
		INSERT INTO SqlDatabaseInfo
			SELECT SC.instance, SN.id, DB.appId, DB.databaseName, DB.backupTime, 0, 0, 0, DB.recoveryModel, 1, N''
			FROM #SqlDbDumpInfoPerAppId DB
					JOIN APP_Application SC ON SC.id = DB.appId
					JOIN sqlNames2 SN2 ON SN2.name = DB.databaseName AND SN2.type = 1
					JOIN sqlNames SN ON SN.sqlId = SN2.id AND SN.type = 1
					LEFT JOIN SqlDatabaseInfo SD ON SD.DatabaseName = DB.databaseName
			WHERE SD.databaseId IS NULL
	END
	-- Output.
	SET  @XmlInputOutput = (SELECT 0 AS '@errorCode', N'' AS '@errorMessage'
			FOR XML PATH ('SQLiDA_GenericResp'), type)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
			FOR XML PATH ('SQLiDA_GenericResp'), type)
END CATCH
SET @o_xml = @XmlInputOutput
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'SqlUpdateBackupDumpInfo')
	delete from GxQscripts where name = 'SqlUpdateBackupDumpInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUpdateBackupDumpInfo')
	delete from GXDBVersions where aliasname = 'SqlUpdateBackupDumpInfo'
GO

insert into GXDBVersions values(2, 'SqlUpdateBackupDumpInfo',  '00000000000000000000', 'SqlUpdateBackupDumpInfo', '00000000000000000000')
GO

