

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlIsBackupRestorable_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlIsBackupRestorable_V1.sp,v $ $Id: SqlIsBackupRestorable_V1.sp,v 1.8.66.10 2020/10/13 16:26:58 vkhule Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlIsBackupRestorable_V1
--  |
--  | Description:
--  |   The stored procedure checks if a backup is restorable by traversing
--  |   the backup chain in commserve..sqlDbBackupInfo and look for at least
--  |   one Full backup that can be used to restore the chain.
--  |
--  | Return:
--  |   0 - if the new backup is restorable
--  |   1 - otherwise
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        myang & Anup		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlIsBackupRestorable_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlIsBackupRestorable_V1 <<<'
	drop procedure SqlIsBackupRestorable_V1
END
IF EXISTS (select * from GxQscripts where name='SqlIsBackupRestorable_V1')
	delete from GxQscripts where name = 'SqlIsBackupRestorable_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlIsBackupRestorable_V1')
	delete from GXDBVersions where aliasname = 'SqlIsBackupRestorable_V1'
GO
print '... Creating Procedure: SqlIsBackupRestorable_V1'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlIsBackupRestorable_V1
  @i_backup_type CHAR(1),
  @i_database_name NVARCHAR(1024),
  @i_instance_id INT,
  @i_is_copy INT,
  @i_first_lsn VARCHAR(32),
  @i_last_lsn VARCHAR(32),
  @i_full_bkup_lsn VARCHAR(32)
AS
  DECLARE @retVal INT
-- Do not lock table when reading.
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @retVal = 1
-- No check needed for FULL.
IF @i_backup_type = 'D'
BEGIN
	SELECT @retVal = 0
	SELECT @retVal
	RETURN 0
END
-- Converting to numeric (original type)
-- As keeping it to string, causes lexicological comparison instead numeric comparison.
-- To avoid multiple times conversion, it is converted only once.
DECLARE @in_first_lsn NUMERIC(32, 0) = CAST(@i_first_lsn AS NUMERIC(32,0))
DECLARE @in_last_lsn NUMERIC(32, 0) = CAST(@i_last_lsn AS NUMERIC(32,0))
DECLARE @in_full_bkup_lsn NUMERIC(32, 0) = CAST(@i_full_bkup_lsn AS NUMERIC(32,0))
-- Database ID for fast filter purpose.
DECLARE @SqlNameIdTable TABLE (ID INT)
INSERT INTO @SqlNameIdTable
	SELECT DISTINCT SN.id FROM sqlNames SN WITH (NOLOCK)
		JOIN sqlNames2 SN2 WITH (NOLOCK)
		ON SN.sqlId = SN2.id AND SN2.type = 1 AND SN.type = 1 AND SN2.name = @i_database_name
-- ============================================================================
-- = DIFFERENTIAL BACKUP
-- = If this is a differential backup, check if there is a corresponding Full.
-- ============================================================================
IF @i_backup_type = 'I'
BEGIN
	SELECT @retVal = 0
		FROM sqlDbBackupInfo SBI WITH (NOLOCK)
		JOIN @SqlNameIdTable DB ON SBI.sqlNameId = DB.ID
		WHERE instanceId = @i_instance_id AND type = 'D'
			AND is_copy = @i_is_copy AND CAST(checkpoint_lsn AS NUMERIC(32,0))  = @in_full_bkup_lsn
	SELECT @retVal
	RETURN @retVal
END
-- Get previous backups for given database.
IF OBJECT_ID('tempdb.dbo.#dbbackupList') IS NOT NULL DROP TABLE #dbbackupList
CREATE TABLE #dbbackupList(rn int identity, backupsetId INTEGER, backupType  CHAR, backupFinishTime INTEGER, majorVersion INTEGER,
	firstLsn numeric(32,0), lastLsn numeric(32,0), checkpointLsn numeric(32,0), fullbackupLsn numeric(32,0))
CREATE CLUSTERED INDEX dbbackupList_firstLsn_lastLsn_checkpointLsn_fullbackupLsn_backupType_IDX
	ON #dbbackupList(firstLsn, lastLsn, checkpointLsn, fullbackupLsn, backupType)
-- With below query, we will get only the latest and previous (from latest) FULL backup.
-- Ultimate and penultimate FULL is added to the temp table.
-- Due to support of COPY FULL backups as regular FULL, no we should not pay attention to
-- is_copy only flag.
DECLARE @RowsFull INT = 0
DECLARE @RowsLog INT = 0
DECLARE @MinTimeFull INT = 0
DECLARE @MaxTimeFull INT = 0
INSERT INTO #dbbackupList
	SELECT TOP 2
		SDB.id, SDB.type, SDB.backup_finish_Date, SDB.majorversion, CAST(SDB.first_lsn AS NUMERIC(32,0)), CAST(SDB.last_lsn AS NUMERIC(32,0)), CAST(SDB.checkpoint_lsn AS NUMERIC(32,0)), CAST(SDB.full_bkup_lsn AS NUMERIC(32,0))
		FROM  sqlDbBackupInfo SDB
		JOIN @SqlNameIdTable DB ON instanceid = @i_instance_id AND SDB.sqlNameId = DB.ID
			AND SDB.type = 'D'
		ORDER BY SDB.backup_finish_Date DESC
SELECT @RowsFull = @@ROWCOUNT
SELECT @MinTimeFull = MIN(BL.backupFinishTime) FROM #dbbackupList BL
SELECT @MaxTimeFull = MAX(BL.backupFinishTime) FROM #dbbackupList BL
-- Very unlikely situation to happen.
IF @MinTimeFull = 0
BEGIN
	SELECT @retVal
	RETURN 0
END
-- Very unlikely situation to happen.
IF @RowsFull = 0
BEGIN
	SELECT @retVal
	RETURN 0
END
-- Get the last log backup (Ordered DESC).
INSERT INTO #dbbackupList
	SELECT TOP 1
		SDB.id, SDB.type, SDB.backup_finish_Date, SDB.majorversion, CAST(SDB.first_lsn AS NUMERIC(32,0)), CAST(SDB.last_lsn AS NUMERIC(32,0)), CAST(SDB.checkpoint_lsn AS NUMERIC(32,0)), CAST(SDB.full_bkup_lsn AS NUMERIC(32,0))
		FROM  sqlDbBackupInfo SDB
		JOIN @SqlNameIdTable DB ON instanceid = @i_instance_id AND SDB.sqlNameId = DB.ID
			AND SDB.type = 'L' AND SDB.backup_finish_Date >= @MinTimeFull
		ORDER BY SDB.backup_finish_Date DESC
SELECT @RowsLog = @@ROWCOUNT
-- Get the last Differential backup after the most recent full backup.
INSERT INTO #dbbackupList
	SELECT TOP 1
		SDB.id, SDB.type, SDB.backup_finish_Date, SDB.majorversion, CAST(SDB.first_lsn AS NUMERIC(32,0)), CAST(SDB.last_lsn AS NUMERIC(32,0)), CAST(SDB.checkpoint_lsn AS NUMERIC(32,0)), CAST(SDB.full_bkup_lsn AS NUMERIC(32,0))
		FROM  sqlDbBackupInfo SDB
		JOIN @SqlNameIdTable DB ON instanceid = @i_instance_id AND SDB.sqlNameId = DB.ID
			AND SDB.type = 'I' AND SDB.backup_finish_Date >= @MaxTimeFull
		ORDER BY SDB.backup_finish_Date DESC
-- ============================================================================
-- = TRANSACTION LOG BACKUP
-- = If this is a log backup, follow the log chain and check if there is a full or differential
-- = backup that can be used to restore the chain.
-- ============================================================================
IF @i_backup_type = 'L'
BEGIN
    -- LOG backup is restorable on three conditions,
    -- Condition 1) There should be no chain break between current L and previous L.
    IF @RowsLog <> 0
    BEGIN
		-- If above condition is false, check if LOG backup is found in other chain (no FULL backup check added here).
		SELECT @retVal = 0
			FROM #dbbackupList BL WITH (NOLOCK)
			WHERE BL.backuptype = 'L'
				AND  ((@in_first_lsn = BL.lastLsn) OR (@in_first_lsn = BL.firstlsn))
				AND  @in_last_lsn >= BL.lastlsn
    END
	-- Condition 2) Check if FULL backup found for current backup.
	-- If found, then we can assume that current log backup will be the very first one in log chain after FULL.
	-- If previous LOG update attempt failed, condition will be detected early and convert to FULL (not here; so safe to make this assumption of first LOG).
	-- Case found where PIT restore done for the database and next LOG converted to FULL. Later logs should get linked to converted FULL.
	-- Such cases are handled by below check (including the very first log backup case).
	IF @retVal <> 0
	BEGIN
	   SELECT @retVal = 0
		FROM #dbbackupList BL WITH (NOLOCK)
		WHERE BL.backuptype = 'D' AND BL.rn = 1
			AND @in_first_lsn <= BL.lastLsn AND @in_last_lsn >= BL.lastLsn
	END
	-- Condition 3) Check if Differential backup found for current log backup. This can happen in following situation.
	--   1. A Database has a Simple Recovery Model to Begin with
    --   2. A few Full AND/OR Differential Backup are successfully performed on this database in Commvault
    --   3. Recovery Model of the Databse is now changed from Simple to Full
    --   4. A Differential Backup (I1) is successfully performed on this database in Commvault
    --   5. Now a Transaction Log Backup (L1) is attempted in Commvault.
	-- In this situation, the log chain is intact if Last LSN of the Most Recent Differential Backup (I1) falls in between the first
	-- and last LSNs of the Transaction Log Backup (I1) and we need to treat it acordingly instead of detecting it as a false broken chain
	IF @retVal <> 0
	BEGIN
	   SELECT @retVal = 0
		FROM #dbbackupList BL WITH (NOLOCK)
		WHERE BL.backuptype = 'I'
			AND @in_first_lsn <= BL.lastLsn AND @in_last_lsn >= BL.lastLsn
	END
END
-- ============================================================================
-- = OTHER BACKUP (a.k.a. Full, PARTIALS)
-- = If this is a full backup, it is always restorable. If it's a new type of
-- = backup, assume it is restorable until we fix this code.
-- ============================================================================
ELSE
	SELECT @retVal = 0
DROP TABLE #dbbackupList
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'SqlIsBackupRestorable_V1')
	delete from GxQscripts where name = 'SqlIsBackupRestorable_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlIsBackupRestorable_V1')
	delete from GXDBVersions where aliasname = 'SqlIsBackupRestorable_V1'
GO

insert into GXDBVersions values(2, 'SqlIsBackupRestorable_V1',  '00010008006600100000', 'SqlIsBackupRestorable_V1', '00010008006600100000')
GO

