

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlIsBackupRestorable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlIsBackupRestorable.sp,v $ $Id: SqlIsBackupRestorable.sp,v 1.4.290.1 2018/03/27 08:41:48 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlIsBackupRestorable
--  |
--  | Description:
--  |   The stored procedure checks if a backup is restorable by traversing
--  |   the backup chain in commserve..sqlDbBackupInfo and look for at least
--  |   one Full backup that can be used to restore the chain.
--  |
--  | Return:
--  |   0 - if the new backup is restorable
--  |   1 - otherwise
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        myang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlIsBackupRestorable <<<'

IF EXISTS (select * from sysobjects where name='SqlIsBackupRestorable')
	drop procedure SqlIsBackupRestorable
IF EXISTS (select * from GxQscripts where name='SqlIsBackupRestorable')
	delete from GxQscripts where name = 'SqlIsBackupRestorable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlIsBackupRestorable')
	delete from GXDBVersions where aliasname = 'SqlIsBackupRestorable'
GO
print '... Creating Procedure: SqlIsBackupRestorable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlIsBackupRestorable
  @i_backup_type CHAR(1),
  @i_database_name VARCHAR(1024),
  @i_instance_id INT,
  @i_first_lsn VARCHAR(32),
  @i_last_lsn VARCHAR(32),
  @i_full_bkup_lsn VARCHAR(32)
AS
  DECLARE @retVal INT
SET @retVal = 1
-- Compute the dbId one time so that it doesn't have to be recomputed
-- several times by joining sqlDbBackupInfo with APP_SubClientProp.
DECLARE @sqlNameId INT
SELECT @sqlNameId = ID
FROM sqlNames
WHERE name = @i_database_name
AND type = 1
DECLARE @dbId INT
SELECT @dbId = i.dbId
FROM sqlDbBackupInfo i, APP_SubClientProp p
WHERE p.attrType = 118 -- SQL DB backup
AND p.attrName = @i_database_name
AND i.appId = p.componentNameId
AND CONVERT(NVARCHAR, i.dbId) = p.attrVal
-- ============================================================================
-- = DIFFERENTIAL BACKUP
-- = If this is a differential backup, check if there is a corresponding Full.
-- ============================================================================
IF @i_backup_type = 'I'
BEGIN
	SELECT @retVal = 0
	FROM sqlDbBackupInfo
	WHERE instanceId = @i_instance_id
	AND sqlNameId = @sqlNameId
	AND type = 'D'
	AND checkpoint_lsn = @i_full_bkup_lsn
END
-- ============================================================================
-- = TRANSACTION LOG BACKUP
-- = If this is a log backup, follow the log chain and check if there is a full
-- = backup that can be used to restore the chain.
-- ============================================================================
ELSE IF @i_backup_type = 'L'
BEGIN
	-- Use recursive CTE (Common Table Expression) to traverse a log
	-- chain to find a compatible full backup without using a single
	-- cursor or auxiliary SP/UDF.
	WITH CTE_first_lsn (type, first_lsn)
	AS
	(
		-- Anchor member
		SELECT @i_backup_type, @i_first_lsn
		UNION ALL
		-- Recursive member
		SELECT i.type, i.first_lsn
		FROM CTE_first_lsn AS c, sqlDbBackupInfo AS i
		WHERE i.instanceId = @i_instance_id
		AND i.sqlNameId = @sqlNameId
		AND c.type = 'L'
		AND (
			 -- Follow the log chain
			 ((i.type = 'L' AND
			  i.last_lsn = c.first_lsn AND
			  i.first_lsn <> i.last_lsn) -- avoid infinite loop
			 OR
			 -- Find full backups whose first_lsn is within the range
			 -- of the currently connected log chain.
			 (i.type = 'D' AND
			  CONVERT(DECIMAL(32), i.first_lsn) >= CONVERT(DECIMAL(32), c.first_lsn) AND
			  CONVERT(DECIMAL(32), i.last_lsn) <= CONVERT(DECIMAL(32), @i_last_lsn)))
			)
	)
	SELECT @retVal = 0
	FROM CTE_first_lsn
	WHERE type = 'D'
	OPTION (MAXRECURSION 3000) -- Don't follow the log chain more than
							   -- 3000 levels deep. It's highly unlikely
							   -- that no full backup exists among 3000
							   -- log backups.
END
-- ============================================================================
-- = OTHER BACKUP (a.k.a. Full)
-- = If this is a full backup, it is always restorable. If it's a new type of
-- = backup, assume it is restorable until we fix this code.
-- ============================================================================
ELSE
	SELECT @retVal = 0
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'SqlIsBackupRestorable')
	delete from GxQscripts where name = 'SqlIsBackupRestorable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlIsBackupRestorable')
	delete from GXDBVersions where aliasname = 'SqlIsBackupRestorable'
GO

insert into GXDBVersions values(2, 'SqlIsBackupRestorable',  '00010004029000010000', 'SqlIsBackupRestorable', '00010004029000010000')
GO

