

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetSqlNames_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
---------------------------------------------------------------------------
--	Author		:	Anup
--	Date		:	20 Sept 2007
--	Description	:	In order to support wide char database backup and restore
--					sqlNames2 table has been added.
--					This cursor hence retrievs all information from sqlNames
--					except name and retrieves name from sqlNames2.
--
---------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetSqlNames_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetSqlNames_V1 <<<'
	drop procedure SqlGetSqlNames_V1
END
IF EXISTS (select * from GxQscripts where name='SqlGetSqlNames_V1')
	delete from GxQscripts where name = 'SqlGetSqlNames_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetSqlNames_V1')
	delete from GXDBVersions where aliasname = 'SqlGetSqlNames_V1'
GO
print '... Creating Procedure: SqlGetSqlNames_V1'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetSqlNames_V1
-- Input Arguments
  @i_Name nvarchar(1024),
  @i_Type INTEGER
AS
-- Output Arguments
  DECLARE @o_Id INTEGER
SET NOCOUNT ON
DECLARE		@name	NVARCHAR(1024)
DECLARE		@type	INTEGER
DECLARE 	@outID  INTEGER = 0
SET @name = @i_Name
SET @type = @i_Type
SELECT TOP 1 @outID = SN.id
	FROM sqlNames SN JOIN sqlNames2 SN2
		ON SN.sqlId = SN2.id AND SN.type = @type
			AND SN2.type = @type AND SN2.name = @name
-- Check if DB name found already. If not, go for insert.
IF @outID = 0
BEGIN
	DECLARE @n2Id INT = 0
	INSERT INTO sqlNames2 VALUES(0, @name, @type)
	SELECT @n2Id = SCOPE_IDENTITY()
	INSERT INTO sqlNames VALUES (@n2Id, @name, @type)
	SELECT @outID = SCOPE_IDENTITY()
END
-- Output found ID.
SELECT @outID
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetSqlNames_V1')
	delete from GxQscripts where name = 'SqlGetSqlNames_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetSqlNames_V1')
	delete from GXDBVersions where aliasname = 'SqlGetSqlNames_V1'
GO

insert into GXDBVersions values(2, 'SqlGetSqlNames_V1',  '00000000000000000000', 'SqlGetSqlNames_V1', '00000000000000000000')
GO

