

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetPointInTimeForRestore_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetPointInTimeForRestore_V1.sp,v $ $Id: SqlGetPointInTimeForRestore_V1.sp,v 1.5.274.7 2020/01/08 14:09:23 shussain Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetPointInTimeForRestore_V1
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Kiran & Anup		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetPointInTimeForRestore_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetPointInTimeForRestore_V1 <<<'
	drop procedure SqlGetPointInTimeForRestore_V1
END
IF EXISTS (select * from GxQscripts where name='SqlGetPointInTimeForRestore_V1')
	delete from GxQscripts where name = 'SqlGetPointInTimeForRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForRestore_V1'
GO
print '... Creating Procedure: SqlGetPointInTimeForRestore_V1'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlGetPointInTimeForRestore_V1
  @in_databaseName NVARCHAR(256),
  @in_time INTEGER,
  @in_instanceId INTEGER,
  @in_restoreType INTEGER
AS
  DECLARE @o_fullBackupFinishTime INTEGER; 
  DECLARE @o_logOrDiffBackupFinishTime INTEGER;
--This will turn off message: "xxx rows affected".
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Do not lock table when reading.
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--DECLARE @sqlNameId INTEGER
DECLARE @SQLNAMEIDTABLE				TABLE ( ID INT )
DECLARE @fullBackupFinishTime		INTEGER = 0
DECLARE @logOrDiffBackupFinishTime	INTEGER = 0
DECLARE @majorVersion				INTEGER = 0
DECLARE @first_lsn					NUMERIC(32, 0) = 0
DECLARE @last_lsn					NUMERIC(32, 0) = 0
DECLARE @checkpoint_lsn				NUMERIC(32, 0) = 0
DECLARE @fullBackup_lsn				NUMERIC(32, 0) = 0
DECLARE @full_backup_id				INTEGER = 0
-- Insert the database IDs into table.
-- We might end up with two different IDs during race conditions. This case has been rectified with latest code.
-- To support backward compatibility, follow the table solution.
INSERT INTO @SQLNAMEIDTABLE
	SELECT SN.id
		FROM sqlNames SN
			JOIN sqlNames2 SN2
				ON SN2.name = @in_databaseName
					AND SN2.type = 1
					AND SN2.id = SN.sqlId
					AND SN.type = 1
-- Lets get the FULL details within the given point-in-time.
SELECT TOP 1 @first_lsn = first_lsn,
			@last_lsn = last_lsn,
			@checkpoint_lsn = checkpoint_lsn,
			@fullBackup_lsn = full_bkup_lsn,
			@fullBackupFinishTime = backup_finish_Date,
			@majorVersion = majorVersion,
			@full_backup_id = SD.id
	FROM sqlDbBackupInfo SD
		JOIN @SQLNAMEIDTABLE SN ON SD.sqlNameId = SN.id
	WHERE instanceId = @in_instanceId
		AND SD.type = 'D'
		AND SD.backup_finish_Date <= @in_time
	ORDER BY SD.backup_finish_Date DESC
IF(@in_restoreType = 1) --Point-in-time restore
BEGIN
	-- Check if full backup covered the given point in time.
	-- On yes, use the time for restore.
	IF @fullBackupFinishTime = @in_time
	BEGIN
		SET @logOrDiffBackupFinishTime = @in_time
	END
	ELSE
	BEGIN
		-- Get DIFF/LOG backup job details where backup finish time = PIT.
		-- LOG backups which is compressed/uncompressed are handled here.
		DECLARE @backup_id_pit INTEGER = 0
		SELECT @backup_id_pit = SD.id
			FROM sqlDbBackupInfo SD
				JOIN @SQLNAMEIDTABLE SN ON SD.sqlNameId = SN.id
			WHERE SD.instanceId = @in_instanceId
				AND SD.backup_finish_Date = @in_time
		IF @backup_id_pit <> 0
		BEGIN
			SET @logOrDiffBackupFinishTime = @in_time
		END
		ELSE
		BEGIN
			IF OBJECT_ID('tempdb..#DatabaseChain') IS NOT NULL DROP TABLE #DatabaseChain
			CREATE TABLE #DatabaseChain(backup_set_id INT, instance int, sqlNameid INT, bkpType CHAR, bkpFinTime INT,
				bkpStartTime INT, first_lsn NUMERIC(32, 0), last_lsn NUMERIC(32, 0), cmprsd INT)
			CREATE INDEX IDX_DB_CHAIN ON #DatabaseChain (backup_set_id, bkpType, first_lsn, last_lsn, bkpFinTime)
			-- Copy of the table.
			IF OBJECT_ID('tempdb..#DatabaseChainCopy') IS NOT NULL DROP TABLE #DatabaseChainCopy
			CREATE TABLE #DatabaseChainCopy(backup_set_id INT, instance int, sqlNameid INT, bkpType CHAR, bkpFinTime INT,
				bkpStartTime INT, first_lsn NUMERIC(32, 0), last_lsn NUMERIC(32, 0), cmprsd INT)
			CREATE INDEX IDX_DB_CHAIN_COPY ON #DatabaseChainCopy (backup_set_id, bkpType, first_lsn, last_lsn, bkpFinTime)
			-- Get the last FULL before the given PIT.
			INSERT INTO #DatabaseChain
				SELECT T.*
				FROM (
					-- Get FULL backup job details within PIT.
					SELECT TOP 1 SD.id,
							SD.instanceId,
							SD.sqlNameId,
							SD.type,
							SD.backup_finish_Date,
							SD.backup_start_Date,
							SD.first_lsn,
							SD.last_lsn,
							0 as cmprsd
						FROM sqlDbBackupInfo SD
						WHERE SD.id = @full_backup_id
					UNION
					-- Get LOG backup either compressed or uncompressed >= the PIT time.
					SELECT TOP 1 SD.id,
							SD.instanceId,
							SD.sqlNameId,
							SD.type,
							SD.backup_finish_Date,
							SD.backup_start_Date,
							SD.first_lsn,
							SD.last_lsn,
							CASE
								WHEN SD.begins_log_chain IS NULL THEN 0
								WHEN SD.begins_log_chain = 'Y' THEN 1
								ELSE 0
							END AS cmprsd
						FROM sqlDbBackupInfo SD
							JOIN @SQLNAMEIDTABLE SN
								ON SD.sqlNameId = SN.id
						WHERE SD.instanceId = @in_instanceId
							AND SD.type = 'L'
							AND SD.backup_finish_Date >= @in_time
						ORDER BY SD.backup_finish_Date ASC
					UNION
					-- Get LOG backup either compressed or uncompressed < the PIT time.
					SELECT TOP 1 SD.id,
							SD.instanceId,
							SD.sqlNameId,
							SD.type,
							SD.backup_finish_Date,
							SD.backup_start_Date,
							SD.first_lsn,
							SD.last_lsn,
							CASE
								WHEN SD.begins_log_chain IS NULL THEN 0
								WHEN SD.begins_log_chain = 'Y' THEN 1
								ELSE 0
							END AS cmprsd
						FROM sqlDbBackupInfo SD
							JOIN @SQLNAMEIDTABLE SN
								ON SD.sqlNameId = SN.id
						WHERE SD.instanceId = @in_instanceId
							AND SD.type = 'L'
							AND SD.backup_finish_Date < @in_time
						ORDER BY SD.backup_finish_Date DESC
					) T
				ORDER BY T.backup_finish_Date DESC
			-- Get expanded list of backups.
			IF OBJECT_ID('tempdb..#GetLogChainExpanded') IS NOT NULL DROP TABLE #GetLogChainExpanded
			CREATE TABLE #GetLogChainExpanded(rn INT IDENTITY PRIMARY KEY, sqlInfoID INT, aFilId INT,
				first_lsn numeric(25,0), last_lsn numeric(25, 0), ckpt_lsn numeric(25, 0), backup_finish_time int)
			CREATE INDEX IDX_GET_CHAIN_LSN ON #GetLogChainExpanded (rn, sqlInfoID, last_lsn, ckpt_lsn, backup_finish_time)
			-- Get compressed xml entries.
			IF OBJECT_ID('tempdb..#compressedEntries') IS NOT NULL DROP TABLE #compressedEntries
			CREATE TABLE #compressedEntries(sqlInfoID INT, afileId INT, xmlOffsets XML)
			INSERT INTO #compressedEntries
				SELECT SA.sqlDbBackupFileId,
						SA.aFileId,
						CAST(SA.DbFile AS XML)
					FROM #DatabaseChain CP
						JOIN sqlArchiveInfo SA
							ON SA.sqlDbBackupFileId = CP.backup_set_id
								AND CP.cmprsd = 1
			-- Query takes more time if entries are high. Need to to verify the performance.
			INSERT INTO #GetLogChainExpanded
				SELECT SA.sqlInfoID,
						M.C.value('@id', 'INT') AFile,
						NULL,
						CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) LastLSN,
						CAST(M.C.value('@ckpt_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0))  CKPT_LSN,
						M.C.value('@backupTime', 'INT') bkp_fin_time
				FROM #compressedEntries AS SA
					OUTER APPLY SA.xmlOffsets.nodes('/App_SqlAfile/offset') AS M(C)
				ORDER BY CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) DESC
			-- Self join to populate the first LSN.
			UPDATE GC SET GC.first_lsn = PREV.last_lsn
				FROM #GetLogChainExpanded GC
					LEFT JOIN #GetLogChainExpanded PREV
						ON GC.rn = PREV.rn - 1
			INSERT INTO #DatabaseChainCopy
				SELECT DC.backup_set_id,
						DC.instance,
						DC.sqlNameid,
						DC.bkpType,
						DC.bkpFinTime,
						DC.bkpStartTime,
						DC.first_lsn,
						Dc.last_lsn,
						DC.cmprsd
					FROM #DatabaseChain DC
					WHERE DC.cmprsd = 0
				UNION
				SELECT DC.backup_set_id,
						DC.instance,
						DC.sqlNameid,
						DC.bkpType,
						EX.backup_finish_time,
						0,
						EX.first_lsn,
						EX.last_lsn,
						0
					FROM #DatabaseChain DC
						JOIN #GetLogChainExpanded EX
							ON DC.backup_set_id = EX.sqlInfoID
								AND DC.cmprsd = 1
			DROP TABLE #DatabaseChain
			DROP TABLE #GetLogChainExpanded
			DECLARE @LogBkpTimeAfterPIT INT = 0
			DECLARE @logFirstLsnAfterPIT NUMERIC(32, 0) = 0
			DECLARE @logLastLsnAfterPIT NUMERIC(32, 0) = 0
			SELECT @LogBkpTimeAfterPIT = DC.bkpFinTime,
					@logFirstLsnAfterPIT = DC.first_lsn,
					@logLastLsnAfterPIT = DC.last_lsn
				FROM #DatabaseChainCopy DC
				WHERE DC.bkpFinTime >= @in_time
				ORDER BY DC.bkpFinTime ASC
			-- Check if the LOG chained with the previous LOG.
			IF EXISTS(SELECT 1
						FROM #DatabaseChainCopy DC
						WHERE DC.last_lsn = @logFirstLsnAfterPIT
							AND DC.bkpFinTime < @LogBkpTimeAfterPIT)
			BEGIN
				SET @logOrDiffBackupFinishTime = @LogBkpTimeAfterPIT
			END
			-- Check if the first LOG chained to the found FULL.
			ELSE IF @logFirstLsnAfterPIT <= @last_lsn AND @logLastLsnAfterPIT > @last_lsn
			BEGIN
				SET @logOrDiffBackupFinishTime = @LogBkpTimeAfterPIT
			END
			ELSE
			BEGIN
				SET @logOrDiffBackupFinishTime = @in_time
			END -- Check if log backups chained.
		END -- No backup with (=) PIT time.
	END -- Full backup check (=) PIT time.
END -- Point in time calculation
ELSE IF(@in_restoreType = 3) --Transaction mark restore
BEGIN
	SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
	where
	sqlNameId in (select id from @SQLNAMEIDTABLE) and
	instanceId = @in_instanceId and
	type = 'L' and
	backup_finish_Date >= @in_time
	order by backup_finish_Date ASC
	IF(@logOrDiffBackupFinishTime = 0)
	BEGIN
		SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
		where
		sqlNameId in (select id from @SQLNAMEIDTABLE) and
		instanceId = @in_instanceId and
		type = 'L' and
		backup_finish_Date < @in_time
		order by backup_finish_Date DESC
	END
END
SELECT @fullBackupFinishTime, @logOrDiffBackupFinishTime
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetPointInTimeForRestore_V1')
	delete from GxQscripts where name = 'SqlGetPointInTimeForRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForRestore_V1'
GO

insert into GXDBVersions values(2, 'SqlGetPointInTimeForRestore_V1',  '00010005027400070000', 'SqlGetPointInTimeForRestore_V1', '00010005027400070000')
GO

