

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetPointInTimeForRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetPointInTimeForRestore.sp,v $ $Id: SqlGetPointInTimeForRestore.sp,v 1.6.290.1 2018/03/27 08:59:33 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetPointInTimeForRestore
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlGetPointInTimeForRestore <<<'

IF EXISTS (select * from sysobjects where name='SqlGetPointInTimeForRestore')
	drop procedure SqlGetPointInTimeForRestore
IF EXISTS (select * from GxQscripts where name='SqlGetPointInTimeForRestore')
	delete from GxQscripts where name = 'SqlGetPointInTimeForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForRestore')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForRestore'
GO
print '... Creating Procedure: SqlGetPointInTimeForRestore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetPointInTimeForRestore
  @in_databaseName VARCHAR(256),
  @in_time INTEGER,
  @in_instanceId INTEGER,
  @in_restoreType INTEGER
AS
  DECLARE @o_fullBackupFinishTime INTEGER; 
  DECLARE @o_logOrDiffBackupFinishTime INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE @sqlNameId INTEGER
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
DECLARE @fullBackupFinishTime INTEGER
DECLARE @logOrDiffBackupFinishTime INTEGER
DECLARE @majorVersion INTEGER
DECLARE @first_lsn VARCHAR(1024)
DECLARE @last_lsn VARCHAR(1024)
DECLARE @checkpoint_lsn VARCHAR(1024)
DECLARE @fullBackup_lsn VARCHAR(1024)
SET @fullBackupFinishTime = 0
SET @logOrDiffBackupFinishTime = 0
insert into @SQLNAMEIDTABLE select id from sqlNames where id in (select id from sqlNames where name = @in_databaseName  and type = 1) and type = 1
SELECT TOP 1 @first_lsn = first_lsn, @last_lsn = last_lsn,
			@checkpoint_lsn = checkpoint_lsn, @fullBackup_lsn = full_bkup_lsn,
			@fullBackupFinishTime = backup_finish_Date, @majorVersion = majorVersion
from sqlDbBackupInfo
where
sqlNameId in (select id from @SQLNAMEIDTABLE) and
instanceId = @in_instanceId and
type = 'D' and
backup_finish_Date <= @in_time
order by backup_finish_Date desc
IF(@in_restoreType = 1) --Point-in-time restore
BEGIN
	SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
	where
	sqlNameId in (select id from  @SQLNAMEIDTABLE) and
	instanceId = @in_instanceId and
	type = 'L' and
	full_bkup_lsn = (case when @majorVersion < 8 then @last_lsn else @checkpoint_lsn end) and
	backup_finish_Date >= @in_time
	order by backup_finish_Date ASC
	IF(@logOrDiffBackupFinishTime = 0)
	BEGIN
		--This may happen if full backup is done outside galaxy.
		SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
		where
		sqlNameId in (select id from @SQLNAMEIDTABLE) and
		instanceId = @in_instanceId and
		type = 'L' and
		backup_finish_Date >= @in_time
		order by backup_finish_Date ASC
	END
	IF(@logOrDiffBackupFinishTime = 0)
	BEGIN
		SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
		where
		sqlNameId in (select id from @SQLNAMEIDTABLE) and
		instanceId = @in_instanceId and
		type = 'I' and
		full_bkup_lsn = (case when @majorVersion < 8 then @last_lsn else @checkpoint_lsn end) and
		backup_finish_Date <= @in_time
		order by backup_finish_Date DESC
	END
END
ELSE IF(@in_restoreType = 3) --Transaction mark restore
BEGIN
	SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
	where
	sqlNameId in (select id from  @SQLNAMEIDTABLE) and
	instanceId = @in_instanceId and
	type = 'L' and
	backup_finish_Date >= @in_time
	order by backup_finish_Date ASC
END
SELECT @fullBackupFinishTime, @logOrDiffBackupFinishTime
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetPointInTimeForRestore')
	delete from GxQscripts where name = 'SqlGetPointInTimeForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForRestore')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForRestore'
GO

insert into GXDBVersions values(2, 'SqlGetPointInTimeForRestore',  '00010006029000010000', 'SqlGetPointInTimeForRestore', '00010006029000010000')
GO

