

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetPointInTimeForFFGRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetPointInTimeForFFGRestore.sp,v $ $Id: SqlGetPointInTimeForFFGRestore.sp,v 1.3.274.1 2018/03/27 08:46:48 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetPointInTimeForRestore_V1
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Kiran		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlGetPointInTimeForFFGRestore <<<'

IF EXISTS (select * from sysobjects where name='SqlGetPointInTimeForFFGRestore')
	drop procedure SqlGetPointInTimeForFFGRestore
IF EXISTS (select * from GxQscripts where name='SqlGetPointInTimeForFFGRestore')
	delete from GxQscripts where name = 'SqlGetPointInTimeForFFGRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForFFGRestore')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForFFGRestore'
GO
print '... Creating Procedure: SqlGetPointInTimeForFFGRestore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetPointInTimeForFFGRestore
  @in_databaseName NVARCHAR(256),
  @i_logicalFileName NVARCHAR(1024),
  @in_time INTEGER,
  @in_instanceId INTEGER,
  @in_restoreType INTEGER
AS
  DECLARE @o_fullBackupFinishTime INTEGER; 
  DECLARE @o_logOrDiffBackupFinishTime INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--DECLARE @sqlNameId INTEGER
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
DECLARE @SqlLogicalFilestoRestore Table
(
	id INT
);
DECLARE @fullBackupFinishTime INTEGER
DECLARE @logOrDiffBackupFinishTime INTEGER
DECLARE @majorVersion INTEGER
DECLARE @first_lsn VARCHAR(1024)
DECLARE @last_lsn VARCHAR(1024)
DECLARE @checkpoint_lsn VARCHAR(1024)
DECLARE @fullBackup_lsn VARCHAR(1024)
SET @fullBackupFinishTime = 0
SET @logOrDiffBackupFinishTime = 0
insert into @SQLNAMEIDTABLE select id from sqlNames where sqlid in (select id from sqlNames2 where name = @in_databaseName  and type = 1) and type = 1
insert into @SqlLogicalFilestoRestore SELECT  id from sqlNames where id in (select id from sqlNames2 where name = @i_logicalFileName and type = 4) and type = 4
SELECT TOP 1 @first_lsn = first_lsn, @last_lsn = last_lsn,
			@checkpoint_lsn = checkpoint_lsn, @fullBackup_lsn = full_bkup_lsn,
			@fullBackupFinishTime = backup_finish_Date, @majorVersion = majorVersion
from sqlDbBackupInfo
where
sqlNameId in (select id from @SQLNAMEIDTABLE) and
instanceId = @in_instanceId and
type in ( 'D', 'F', 'P') and
backup_finish_Date <= @in_time
AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = sqlDbBackupInfo.id
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
				)
order by backup_finish_Date desc
IF(@in_restoreType = 1) --Point-in-time restore
BEGIN
	SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
	where
	sqlNameId in (select id from  @SQLNAMEIDTABLE) and
	instanceId = @in_instanceId and
	type = 'L' and
	backup_finish_Date >= @in_time
	order by backup_finish_Date ASC
	IF(@logOrDiffBackupFinishTime = 0)
	BEGIN
		SELECT TOP 1 @logOrDiffBackupFinishTime = backup_finish_Date from sqldbbackupInfo
		where
		sqlNameId in (select id from @SQLNAMEIDTABLE) and
		instanceId = @in_instanceId and
		type in ('L')  and
		backup_finish_Date < @in_time
		order by backup_finish_Date DESC
	END
END
SELECT @fullBackupFinishTime, @logOrDiffBackupFinishTime
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetPointInTimeForFFGRestore')
	delete from GxQscripts where name = 'SqlGetPointInTimeForFFGRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetPointInTimeForFFGRestore')
	delete from GXDBVersions where aliasname = 'SqlGetPointInTimeForFFGRestore'
GO

insert into GXDBVersions values(2, 'SqlGetPointInTimeForFFGRestore',  '00010003027400010000', 'SqlGetPointInTimeForFFGRestore', '00010003027400010000')
GO

