

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLogMarksForDbRestore_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetLogMarksForDbRestore_V1.sp,v $ $Id: SqlGetLogMarksForDbRestore_V1.sp,v 1.7.204.3 2019/03/20 01:17:20 shussain Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetLogMarksForDbRestore_V1
--  |
--  | Description:
--  |
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Kiran & Anup		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetLogMarksForDbRestore_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLogMarksForDbRestore_V1 <<<'
	drop procedure SqlGetLogMarksForDbRestore_V1
END
IF EXISTS (select * from GxQscripts where name='SqlGetLogMarksForDbRestore_V1')
	delete from GxQscripts where name = 'SqlGetLogMarksForDbRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLogMarksForDbRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetLogMarksForDbRestore_V1'
GO
print '... Creating Procedure: SqlGetLogMarksForDbRestore_V1'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetLogMarksForDbRestore_V1
  @i_instanceId INTEGER,
  @i_databaseName NVARCHAR(1024),
  @i_beforeBrowseTime INTEGER,
  @i_afterBrowseTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_includeAgedData integer
AS
  DECLARE @o_markName NVARCHAR(1024)
  DECLARE @o_markTime INTEGER
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
IF object_id('tempdb.dbo.#SqlGetLogMarksForDbRestore_dbbackupList') is not null DROP TABLE #SqlGetLogMarksForDbRestore_dbbackupList
create TABLE #SqlGetLogMarksForDbRestore_dbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
IF object_id('tempdb.dbo.#SqlGetLogMarksForDbRestore_copydbbackupList') is not null DROP TABLE #SqlGetLogMarksForDbRestore_copydbbackupList
create TABLE #SqlGetLogMarksForDbRestore_copydbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
DECLARE @appIdTable TABLE
(
	appId INT
)
IF object_id('tempdb.dbo.#SqlGetLogMarksForDbRestore_archFileIdTable') is not null DROP TABLE #SqlGetLogMarksForDbRestore_archFileIdTable
create TABLE #SqlGetLogMarksForDbRestore_archFileIdTable
(
	archFileId INT,
	commCellId INT
)
IF object_id('tempdb.dbo.#SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable') is not null DROP TABLE #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable
create TABLE #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable
(
	sqlDbBackupFileId INT
)
create index sqldbid_idx on #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable (sqlDbBackupFileId)
DECLARE @lastBackupType CHAR
DECLARE @lastBackupTime INTEGER
DECLARE @lastbkpsetId INTEGER
DECLARE @majorVersion INTEGER
DECLARE @lastBackupfirstLsn NUMERIC(25, 0)
DECLARE @lastBackuplastLsn NUMERIC(25, 0)
DECLARE @lastBackupcheckpointLsn NUMERIC(25, 0)
DECLARE @lastBackupfullbackupLsn NUMERIC(25, 0)
DECLARE @fullBackupType char
insert into @SQLNAMEIDTABLE select id from sqlNames where sqlid in (select id from sqlNames2 where name = @i_databaseName  and type = 1) and type = 1
INSERT	INTO @appIdTable
	SELECT	DISTINCT appId  FROM	sqlDbBackupInfo SDB
	WHERE	instanceId = @i_instanceId  AND backup_finish_Date <= @i_beforeBrowseTime
		AND sqlNameId in (select id from @SQLNAMEIDTABLE)
	UNION
	SELECT	DISTINCT appId FROM	sqlDbBackupInfo SDB
		WHERE	instanceId = @i_instanceId AND SDB.type = 'L' AND SDB.begins_log_chain = 'Y'
			AND @i_beforeBrowseTime > SDB.backup_start_Date AND @i_beforeBrowseTime <= SDB.backup_finish_Date
			AND sqlNameId in (select id from @SQLNAMEIDTABLE)
IF @i_copyPrecedence = 0
	INSERT	INTO #SqlGetLogMarksForDbRestore_archFileIdTable
	SELECT	a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_beforeBrowseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND b.archCopyId = c.id
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
ELSE
	INSERT	INTO #SqlGetLogMarksForDbRestore_archFileIdTable
	SELECT	DISTINCT a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_beforeBrowseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
		AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
INSERT	INTO #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable
	SELECT	DISTINCT sqlDbBackupFileId
	FROM	sqlArchiveInfo a, #SqlGetLogMarksForDbRestore_archFileIdTable b
	WHERE	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
insert into #SqlGetLogMarksForDbRestore_dbbackupList
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
		from sqldbbackupinfo SDBI, #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable SLM
		where SDBI.id = SLM.sqlDbBackupFileId and
			SDBI.sqlNameId in (select id from @SQLNAMEIDTABLE) and
			SDBI.instanceId = @i_instanceId and
			SDBI.type not in ('F', 'G', 'P', 'Q') and
			SDBI.majorVersion > 7 and
			not exists (select * from sqlfilebackupinfo SFBI where
							SFBI.sqlDbBackupInfoId = SDBI.id and SFBI.type = 100 ) and
			SDBI.backup_finish_date <= @i_beforeBrowseTime
	UNION
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
		from sqldbbackupinfo SDBI, #SqlGetLogMarksForDbRestore_sqlDbBackupFileIdTable SLM
		where SDBI.id = SLM.sqlDbBackupFileId and
			SDBI.sqlNameId in (select id from @SQLNAMEIDTABLE) and
			SDBI.instanceId = @i_instanceId and
			SDBI.type not in ('F', 'G', 'P', 'Q') and
			SDBI.majorVersion > 7 and
			not exists (select * from sqlfilebackupinfo SFBI where
							SFBI.sqlDbBackupInfoId = SDBI.id and SFBI.type = 100 ) and
			SDBI.type = 'L' AND SDBI.begins_log_chain = 'Y'
							AND @i_beforeBrowseTime > SDBI.backup_start_Date AND @i_beforeBrowseTime <= SDBI.backup_finish_Date
	ORDER BY SDBI.id DESC
SELECT TOP 1 @majorVersion = majorVersion, @lastBackupType = backupType,
		@lastbkpsetId = backupsetId, @lastBackupTime = backupFinishTime,
		@lastBackupfirstLsn = firstLsn,  @lastBackuplastLsn = lastLsn,
		@lastBackupcheckpointLsn = checkpointLsn, @lastBackupfullbackupLsn = fullbackupLsn
FROM #SqlGetLogMarksForDbRestore_dbbackupList ORDER BY backupFinishTime DESC
DECLARE @fullBackupSetId  INTEGER
DECLARE @fullbackupFinishTime INTEGER
DECLARE @firstLsn NUMERIC(25, 0)
DECLARE @lastLsn NUMERIC(25, 0)
DECLARE @checkpointLsn NUMERIC(25, 0)
DECLARE @fullbkpLsn NUMERIC(25, 0)
DECLARE @version INTEGER
set @fullBackupSetId = 0
set @fullbackupFinishTime = 0
IF(@i_afterBrowseTime = 0)
BEGIN
	IF(@lastBackupType = 'D')
	BEGIN
		set @fullBackupSetId = @lastbkpsetId
		set @fullbackupFinishTime = @lastBackupTime
		set @firstLsn = @lastBackupfirstLsn
		set @lastLsn = @lastBackuplastLsn
		set @checkpointLsn = @lastBackupcheckpointLsn
		set @fullbkpLsn = @lastBackupfullbackupLsn
		set @fullBackupType = @lastBackupType
	END
	ELSE
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @fullbackupFinishTime = backupFinishTime,
				   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
				   @fullBackupType = backupType
		from #SqlGetLogMarksForDbRestore_dbbackupList
		where
		checkpointLsn = @lastBackupfullbackupLsn and backupType = 'D'
	END
END
IF(@fullBackupSetId = 0)
BEGIN
	select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
		   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
		   @fullBackupType = backupType
	from #SqlGetLogMarksForDbRestore_dbbackupList
	where
	backupType = 'D'
	order by backupFinishTime desc
END
IF(@fullBackupSetId = 0 and @majorVersion > 8)
BEGIN
	select TOP 1 @fullBackupSetId = DBL.backupsetId, @lastLsn = DBL.lastLsn, @fullbackupFinishTime = DBL.backupFinishTime,
		   @firstLsn = DBL.firstLsn, @lastLsn = DBL.lastLsn, @checkpointLsn = DBL.checkpointLsn, @fullbkpLsn = DBL.fullbackupLsn,
		   @fullBackupType = DBL.backupType
	from #SqlGetLogMarksForDbRestore_dbbackupList DBL
	where
	DBL.backupType = 'P'
	order by backupFinishTime desc
END
SET @i_afterBrowseTime = @fullbackupFinishTime
IF(@i_afterBrowseTime <> 0 AND @i_beforeBrowseTime <> 0)
BEGIN
	select name, markTime
	from sqlLogMarks
	where
	dbName = @i_databaseName and
	instanceId = @i_instanceId and
	markTime >= @i_afterBrowseTime and
	markTime <= @i_beforeBrowseTime
END
ELSE IF(@i_afterBrowseTime <> 0)
BEGIN
	select name, markTime
	from sqlLogMarks
	where
	dbName = @i_databaseName and
	instanceId = @i_instanceId and
	markTime >= @i_afterBrowseTime
END
ELSE IF(@i_beforeBrowseTime <> 0)
BEGIN
	select name, markTime
	from sqlLogMarks
	where
	dbName = @i_databaseName and
	instanceId = @i_instanceId and
	markTime <= @i_beforeBrowseTime
END
ELSE
BEGIN
	select name, markTime
	from sqlLogMarks
	where
	dbName = @i_databaseName and
	instanceId = @i_instanceId
END
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetLogMarksForDbRestore_V1')
	delete from GxQscripts where name = 'SqlGetLogMarksForDbRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLogMarksForDbRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetLogMarksForDbRestore_V1'
GO

insert into GXDBVersions values(2, 'SqlGetLogMarksForDbRestore_V1',  '00010007020400030000', 'SqlGetLogMarksForDbRestore_V1', '00010007020400030000')
GO

