

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLogBackupCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetLogBackupCount.sp,v $ $Id: SqlGetLogBackupCount.sp,v 1.11.200.1.68.1 2021/05/04 02:33:05 ankumar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetLogBackupCount
--  |
--  | Description:
--  |
--  |   Return the number of consecutive log backup after the last full backup
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SqlGetLogBackupCount')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLogBackupCount <<<'
	drop procedure SqlGetLogBackupCount
END
IF EXISTS (select * from GxQscripts where name='SqlGetLogBackupCount')
	delete from GxQscripts where name = 'SqlGetLogBackupCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLogBackupCount')
	delete from GXDBVersions where aliasname = 'SqlGetLogBackupCount'
GO
print '... Creating Procedure: SqlGetLogBackupCount'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SqlGetLogBackupCount
  @i_instanceId INTEGER,
  @i_databaseName NVARCHAR(1024)
AS
  DECLARE @o_logBackupCount INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @max_checkpoint_lsn NUMERIC(25, 0) = 0
DECLARE @max_backup_finish_date INTEGER = 0
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
insert into @SQLNAMEIDTABLE select  id from sqlNames where sqlid in (select id from sqlNames2 where name = @i_databaseName and type = 1) and type = 1
--
-- to convert the sqlnameidstring which is in '1,2' form to integer form i,e (1,2)
--
-- Get the checkpoint_lsn of the last full backup
--
SELECT TOP 1 @max_checkpoint_lsn = CONVERT(NUMERIC(25, 0), first_lsn), @max_backup_finish_date = backup_finish_Date
FROM sqlDbBackupInfo, @SQLNAMEIDTABLE idTable
WHERE instanceId = @i_instanceId
AND sqlNameId = idTable.ID
AND type = 'D'
ORDER BY backup_finish_Date DESC
--
-- Get the number of log backups after the last full backup
--
SELECT COUNT(SDBI.id) AS LogCount
FROM sqlDbBackupInfo SDBI, @SQLNAMEIDTABLE idTable
WHERE SDBI.instanceId = @i_instanceId
AND SDBI.sqlNameId = idTable.ID
AND SDBI.type = 'L'
AND CONVERT(NUMERIC(25, 0), SDBI.last_lsn) > @max_checkpoint_lsn
AND SDBI.backup_finish_date >= @max_backup_finish_date
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetLogBackupCount')
	delete from GxQscripts where name = 'SqlGetLogBackupCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLogBackupCount')
	delete from GXDBVersions where aliasname = 'SqlGetLogBackupCount'
GO

insert into GXDBVersions values(2, 'SqlGetLogBackupCount',  'v1.11.200.1.68.1', 'SqlGetLogBackupCount', 'v1.11.200.1.68.1')
GO

