

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLastLsnForLatestBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: SqlGetLastLsnForLatestBackup
--  |
--  | Description:
--  |  Get last_lsn corresponding to the Latest Backup that was performed in Commvault for given database
--  |
--  | -- Existing Stored Procedure SqlGetDbBackupSetInfo.sp uses backup_finish_date and backup_set_id to identify the Last Backup that was performed in Commvault for given database
--  | -- However, backup_finish_time and backup_set_id don't appear to be reliable to make this decision as shown in following situations
--  | ---- TR 180906-14 showed us that in case of overlapping Full+Log or Diff+Log Backups, backup finishing last could end up with a smaller backup set id
--  | ---- TR 181030-174 and 181105-291 showed us that in case of Daylight Saving Time Change Situations, backup finishing during that time change window ends up with lower timestamp than previous backup
--  | -- To resolve this, we need to use sqldbbackupinfo.last_lsn to identify the last Backup that was performed in Commvault for given database
--  | -- last_lsn should really be the source of truth regarding which backup is latest regardless of backup_finish_time and backup_set_id values
--  |
--  | -- sqldbbackupinfo.last_lsn is of type string and not numeric and so we have to use numeric sorting [order by CAST(last_lsn as numeric(25,0)) DESC] instead of string sorting [order by last_lsn DESC]
--  | -- to make sure we always get the highest value available for last_lsn in CS DB
--  | -- e.g. Consider two rows in sqldbbackupinfo with values for last_lsn as '99' and '100'. String sorting will give us incorrect value '99' as the highest value available for last_lsn instead of '100'
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetLastLsnForLatestBackup')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLastLsnForLatestBackup <<<'
	drop procedure SqlGetLastLsnForLatestBackup
END
IF EXISTS (select * from GxQscripts where name='SqlGetLastLsnForLatestBackup')
	delete from GxQscripts where name = 'SqlGetLastLsnForLatestBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastLsnForLatestBackup')
	delete from GXDBVersions where aliasname = 'SqlGetLastLsnForLatestBackup'
GO
print '... Creating Procedure: SqlGetLastLsnForLatestBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlGetLastLsnForLatestBackup
  @xmlInput XML
AS
-- This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @dbName		NVARCHAR(1024)
DECLARE @instanceId INTEGER
DECLARE @xmlOutput	XML
-- Extract Parameters from XML Input
SET @dbName	= ISNULL((SELECT  ref.value('@dbName', 'nvarchar(1024)') FROM @xmlInput.nodes('SQLiDA_SqlGetLastLsnForLatestBackupReq') R ( ref )),N'')
SET @dbName = (select dbo.DecodeInvalidXMLChar(@dbName) )
SET @instanceId	= ISNULL((SELECT  ref.value('@instanceId', 'int') FROM @xmlInput.nodes('SQLiDA_SqlGetLastLsnForLatestBackupReq') R ( ref )), 0)
-- Backup finish time is UTC timestamp. To get latest last LSN, ordering should be based on backup finish time which resolves DST and parallel backups.
-- In case of in-place restore, DB GUID does not get changed and it fails the logic of fetching the last LSN.
-- As backup finish time is used for ordering now, it resolves the issues with DB GUID as well.
SET @xmlOutput = (SELECT ( SELECT TOP 1 last_lsn FROM sqldbbackupinfo SDB WITH (NOLOCK)
						   JOIN sqlNames2 SN2 WITH (NOLOCK) ON SN2.name = @dbName AND SN2.type = 1 AND SDB.instanceId=@instanceId
						   JOIN sqlNames SN WITH (NOLOCK) ON SN.sqlId = SN2.id AND SN.type = 1 AND SDB.sqlNameId = SN.id
						   ORDER BY backup_finish_Date DESC, CAST(last_lsn as numeric(25,0)) DESC)
				  AS '@last_lsn'
				  FOR XML PATH('SQLiDA_SqlGetLastLsnForLatestBackupResp'))
SELECT @xmlOutput
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetLastLsnForLatestBackup')
	delete from GxQscripts where name = 'SqlGetLastLsnForLatestBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastLsnForLatestBackup')
	delete from GXDBVersions where aliasname = 'SqlGetLastLsnForLatestBackup'
GO

insert into GXDBVersions values(2, 'SqlGetLastLsnForLatestBackup',  '00000000000000000000', 'SqlGetLastLsnForLatestBackup', '00000000000000000000')
GO

