

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLastFullDbBackupSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetLastFullDbBackupSetInfo.sp,v $ $Id: SqlGetLastFullDbBackupSetInfo.sp,v 1.1.8.4 2020/02/26 22:15:22 ankumar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetLastFullDbBackupSetInfo
--  |
--  | Description:
--  |  Get info in SqlDbBackupSetInfo table
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        wliao				Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetLastFullDbBackupSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLastFullDbBackupSetInfo <<<'
	drop procedure SqlGetLastFullDbBackupSetInfo
END
IF EXISTS (select * from GxQscripts where name='SqlGetLastFullDbBackupSetInfo')
	delete from GxQscripts where name = 'SqlGetLastFullDbBackupSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastFullDbBackupSetInfo')
	delete from GXDBVersions where aliasname = 'SqlGetLastFullDbBackupSetInfo'
GO
print '... Creating Procedure: SqlGetLastFullDbBackupSetInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetLastFullDbBackupSetInfo
  @i_sqlNameId INTEGER,
  @i_instanceId INTEGER,
  @i_is_copy INTEGER
AS
  DECLARE @o_backup_set_id INTEGER; 
  DECLARE @o_backupmethod INTEGER;
  DECLARE @o_backup_finish_Date INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- i_is_copy param will be used to get FULL backup information by either paying attention to
-- is_copy field or not.
-- For differential backup, we want to find FULL with is_copy flag as false to get ACTUAL FULL info
-- whereas, for log backup, we dont want to check is_copy flag to get ACTUAL or COPY ONLY FULL who ever is latest.
IF @i_is_copy = 0
BEGIN
	SELECT TOP 1 backup_set_id, backupmethod, backup_finish_Date
	FROM dbo.sqldbbackupinfo WITH (NOLOCK)
	WHERE sqlNameId = @i_sqlNameId AND instanceId = @i_instanceId AND type = 'D' AND is_copy = 0
	order by backup_finish_Date DESC
END
ELSE
BEGIN
	SELECT TOP 1 backup_set_id, backupmethod, backup_finish_Date
	FROM dbo.sqldbbackupinfo WITH (NOLOCK)
	WHERE sqlNameId = @i_sqlNameId AND instanceId = @i_instanceId AND type = 'D' order by backup_finish_Date DESC
END
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetLastFullDbBackupSetInfo')
	delete from GxQscripts where name = 'SqlGetLastFullDbBackupSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastFullDbBackupSetInfo')
	delete from GXDBVersions where aliasname = 'SqlGetLastFullDbBackupSetInfo'
GO

insert into GXDBVersions values(2, 'SqlGetLastFullDbBackupSetInfo',  '00010001000800040000', 'SqlGetLastFullDbBackupSetInfo', '00010001000800040000')
GO

