

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLastDatabaseBackupDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault  Systems, Inc.
--        The copyright notice above does not evidence any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SqlGetLastDatabaseBackupDetails')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLastDatabaseBackupDetails <<<'
	drop procedure SqlGetLastDatabaseBackupDetails
END
IF EXISTS (select * from GxQscripts where name='SqlGetLastDatabaseBackupDetails')
	delete from GxQscripts where name = 'SqlGetLastDatabaseBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastDatabaseBackupDetails')
	delete from GXDBVersions where aliasname = 'SqlGetLastDatabaseBackupDetails'
GO
print '... Creating Procedure: SqlGetLastDatabaseBackupDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SqlGetLastDatabaseBackupDetails
  @inXML XML OUTPUT
AS
  DECLARE @outXML XML
/*
	SqlGetLastDatabaseBackupDetails SP is created to get
		1. Latest backup details for each database.
		2. Latest FULL backup details for each database.
		3. Any hole details - will be ignored in case of error.
		4. If PIT restore for the database or System DB restore done for instance.
	It will be called from the CPP layer, hence the output XML will be returned by OUTPUT param.
*/
-- Pre-requisites.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @instanceId		INT = 0
DECLARE @i_is_copy		INT = 0
SET @instanceId = ISNULL((Select Tbl.Col.value('@instanceId', 'int') From @inXML.nodes('SQLiDA_GetSqlDatabaseDetailReq') Tbl(Col)), 0)
SET @i_is_copy = ISNULL((Select Tbl.Col.value('@copyOnlyFull', 'int') From @inXML.nodes('SQLiDA_GetSqlDatabaseDetailReq') Tbl(Col)), 0)
IF OBJECT_ID('tempdb..#DatabaseDetails') IS NOT NULL DROP TABLE #DatabaseDetails
CREATE TABLE #DatabaseDetails(instanceId INT, dbName NVARCHAR(256), dbId INT, backup_set_id INT,
		bkpType CHAR, database_creation_date INT, backup_finish_Date INT, full_backup_set_id INT,
		full_backup_method INT, full_start_date INT, full_finish_date INT, log_count INT, full_check_point_lsn NUMERIC(32,0),
		holeXML XML, isPITorTMRestoreDone INT, isSystemDbRestoreDone INT,
	PRIMARY KEY(instanceId, dbName, dbId))
INSERT INTO #DatabaseDetails(instanceId, dbName, dbId)
	SELECT	@instanceId, ISNULL(Tbl.Col.value('@val', 'nvarchar(256)'), ''), SN.id
	FROM @inXML.nodes('/SQLiDA_GetSqlDatabaseDetailReq/databases') as Tbl(Col)
		JOIN sqlNames2 SN2
			ON SN2.name = ISNULL(Tbl.Col.value('@val', 'nvarchar(256)'), '')
				AND SN2.type = 1 -- DATABASE_NAME
		JOIN sqlNames SN
			ON SN.sqlId = SN2.id
				AND SN.type = 1 -- DATABASE_NAME
-- Update database backup details.
UPDATE DDL SET
	DDL.backup_set_id = TR.backup_set_id,
	DDL.bkpType = TR.type,
	DDL.database_creation_date = TR.database_creation_date,
	DDL.backup_finish_Date = TR.backup_finish_Date
FROM #DatabaseDetails DDL
	-- Get top 1 row for each database id and instance id.
	JOIN (SELECT TOP 1 WITH TIES
				SD.instanceId,
				SD.sqlNameId,
				SD.backup_set_id,
				SD.type,
				SD.database_creation_date,
				SD.backup_finish_Date
			FROM dbo.sqldbbackupinfo SD WITH (NOLOCK)
				JOIN #DatabaseDetails DD
					ON SD.sqlNameId = DD.dbId
						AND SD.instanceId = DD.instanceId
			ORDER BY ROW_NUMBER()
				OVER (PARTITION BY SD.sqlNameId ORDER BY SD.backup_finish_Date DESC)) TR
	ON DDL.instanceId = TR.instanceId
		AND DDL.dbId = TR.sqlNameId
IF @i_is_copy = 0
BEGIN
    UPDATE DDL SET
		DDL.full_backup_set_id = TR.backup_set_id,
		DDL.full_backup_method = TR.backupmethod,
		DDL.full_start_date = TR.backup_start_Date,
		DDL.full_finish_date = TR.backup_finish_Date,
		DDL.full_check_point_lsn = TR.checkpoint_lsn
	FROM #DatabaseDetails DDL
		-- Get top 1 row for each database id and instance id.
		JOIN (SELECT TOP 1 WITH TIES
				SD.instanceId,
				SD.sqlNameId,
				SD.backup_set_id,
				SD.backup_start_Date,
				SD.backup_finish_Date,
				SD.backupmethod,
				SD.checkpoint_lsn,
				SD.first_lsn,
				SD.last_lsn
			FROM dbo.sqldbbackupinfo SD WITH (NOLOCK)
				JOIN #DatabaseDetails DD
					ON SD.sqlNameId = DD.dbId
						AND SD.instanceId = DD.instanceId
			WHERE SD.is_copy = 0 AND SD.type = 'D'
			ORDER BY ROW_NUMBER()
				OVER (PARTITION BY SD.sqlNameId ORDER BY SD.backup_finish_Date DESC)) TR
		ON DDL.instanceId = TR.instanceId
			AND DDL.dbId = TR.sqlNameId
END
ELSE
BEGIN
	UPDATE DDL SET
		DDL.full_backup_set_id = TR.backup_set_id,
		DDL.full_backup_method = TR.backupmethod,
		DDL.full_start_date = TR.backup_start_Date,
		DDL.full_finish_date = TR.backup_finish_Date,
		DDL.full_check_point_lsn = TR.checkpoint_lsn
	FROM #DatabaseDetails DDL
		-- Get top 1 row for each database id and instance id.
		JOIN (SELECT TOP 1 WITH TIES
				SD.instanceId,
				SD.sqlNameId,
				SD.backup_set_id,
				SD.backup_start_Date,
				SD.backup_finish_Date,
				SD.backupmethod,
				SD.checkpoint_lsn,
				SD.first_lsn,
				SD.last_lsn
			FROM dbo.sqldbbackupinfo SD WITH (NOLOCK)
				JOIN #DatabaseDetails DD
					ON SD.sqlNameId = DD.dbId
						AND SD.instanceId = DD.instanceId
			WHERE SD.type = 'D'
			ORDER BY ROW_NUMBER()
				OVER (PARTITION BY SD.sqlNameId ORDER BY SD.backup_finish_Date DESC)) TR
		ON DDL.instanceId = TR.instanceId
			AND DDL.dbId = TR.sqlNameId
END
UPDATE DDL SET
	DDL.log_count = TR.LogCount
FROM #DatabaseDetails DDL
	-- Get count of log backups.
	JOIN (SELECT SD.instanceId,
				SD.sqlNameId,
				COUNT(SD.id) AS LogCount
			FROM sqlDbBackupInfo SD
				JOIN #DatabaseDetails DD
					ON SD.instanceId = DD.instanceId
						AND SD.sqlNameId = DD.dbId
						AND SD.type = 'L'
			WHERE CONVERT(NUMERIC(25, 0), SD.last_lsn) > DD.full_check_point_lsn
				AND SD.backup_finish_date >= DD.full_finish_date
			GROUP BY SD.instanceId, SD.sqlNameId) TR
	ON DDL.instanceId = TR.instanceId
		AND DDL.dbId = TR.sqlNameId
-- Table created to avoid the output from exec call.
IF OBJECT_ID('tempdb..#ot_SqlGetBackupChainHoles') IS NOT NULL DROP TABLE #ot_SqlGetBackupChainHoles
CREATE TABLE #ot_SqlGetBackupChainHoles (outXML XML)
IF OBJECT_ID('tempdb..#ot_SqlFindRestoreJobs') IS NOT NULL DROP TABLE #ot_SqlFindRestoreJobs
CREATE TABLE #ot_SqlFindRestoreJobs (rstJobCount INT)
DECLARE @DbID INT = 0
DECLARE @DBName NVARCHAR(1024) = N''
DECLARE @latest_end_date INT
DECLARE @row_count INT = 0
DECLARE @ioXmlHoleDatabase XML = N''
DECLARE @RC INT = 0
DECLARE GetEachDatabase CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
	SELECT DD.dbId, DD.dbName, DD.backup_finish_Date FROM #DatabaseDetails DD
OPEN GetEachDatabase
FETCH FROM GetEachDatabase INTO @DbID, @DBName, @latest_end_date
WHILE @@FETCH_STATUS = 0
BEGIN
	IF EXISTS(SELECT 1 FROM #ot_SqlGetBackupChainHoles)
		TRUNCATE TABLE #ot_SqlGetBackupChainHoles
	SET @ioXmlHoleDatabase = ISNULL((SELECT @DBName AS '@database',
										(SELECT @instanceId AS '@instanceId'
											FOR XML PATH('entity'), TYPE)
										FOR XML PATH('SQLiDA_SqlGetBackupChainHoleReq')), N'<SQLiDA_SqlGetBackupChainHoleReq />')
	EXEC SqlGetBackupChainHoles @ioXmlHoleDatabase
	SELECT TOP 1 @ioXmlHoleDatabase = outXML FROM #ot_SqlGetBackupChainHoles
	-- Ignore the error XML that stays inline with the existing CPP code.
	UPDATE DDL SET DDL.holeXML = @ioXmlHoleDatabase
		FROM #DatabaseDetails DDL
			WHERE DDL.dbId = @DbID
	IF EXISTS(SELECT 1 FROM #ot_SqlFindRestoreJobs)
		TRUNCATE TABLE #ot_SqlFindRestoreJobs
	-- PIT database restore happened for this database
	EXEC SqlFindRestoreJobs @instanceId, @latest_end_date, @DBName
	SELECT @row_count = rstJobCount FROM #ot_SqlFindRestoreJobs
	UPDATE DDL SET DDL.isPITorTMRestoreDone = CASE WHEN @row_count = 0 THEN 0 ELSE 1 END
		FROM #DatabaseDetails DDL
			WHERE DDL.dbId = @DbID
	-- System database restore happened.
	IF EXISTS(SELECT 1 FROM #ot_SqlFindRestoreJobs)
		TRUNCATE TABLE #ot_SqlFindRestoreJobs
	EXEC SqlFindRestoreJobs @instanceId, @latest_end_date, N''
	SELECT @row_count = rstJobCount FROM #ot_SqlFindRestoreJobs
	UPDATE DDL SET DDL.isSystemDbRestoreDone = CASE WHEN @row_count = 0 THEN 0 ELSE 1 END
		FROM #DatabaseDetails DDL
			WHERE DDL.dbId = @DbID
	FETCH FROM GetEachDatabase INTO @DbID, @DBName, @latest_end_date
END
CLOSE GetEachDatabase
DEALLOCATE GetEachDatabase
SET @outXML = ISNULL((SELECT DDL.dbName AS '@databaseName',
							DDL.backup_set_id AS '@backup_set_id',
							DDL.bkpType AS '@backupType',
							DDL.database_creation_date AS '@databaseCreationTime',
							DDL.backup_finish_Date AS '@lastDatabaseBackupTime',
							DDL.full_backup_set_id AS '@lastFullBackupsetId',
							DDL.full_backup_method AS '@backupmethod',
							DDL.full_finish_date AS '@lastFullBackupTime',
							DDL.log_count AS '@logBackupCount',
							DDL.isPITorTMRestoreDone AS '@isPITorTMRestoreDone',
							DDL.isSystemDbRestoreDone AS '@isSystemDbRestoreDone',
							0 AS '@isRestoreBeforeUpgrade',
							ISNULL((SELECT DDL.holeXML.value('(/SQLiDA_SqlGetBackupChainHoleResp/SqlBackupHole/@holeStartLSN)[1]', 'nvarchar(1024)')), N'') AS '@holeStartLSN',
							ISNULL((SELECT DDL.holeXML.value('(/SQLiDA_SqlGetBackupChainHoleResp/SqlBackupHole/@holeEndLSN)[1]', 'nvarchar(1024)')), N'') AS '@holeEndLSN',
							ISNULL((SELECT DDL.holeXML.value('(/SQLiDA_SqlGetBackupChainHoleResp/SqlBackupHole/@holeStartLSNTime)[1]', 'INT')), 0) AS '@holeStartLSNTime',
							ISNULL((SELECT DDL.holeXML.value('(/SQLiDA_SqlGetBackupChainHoleResp/SqlBackupHole/@holeEndLSNTime)[1]', 'INT')), 0) AS '@holeEndLSNTime'
					FROM #DatabaseDetails DDL
						FOR XML PATH('databaseList'),
						ROOT('SQLiDA_GetSqlDatabaseDetailResp')),
					N'<SQLiDA_GetSqlDatabaseDetailResp />')
SELECT @outXML

IF EXISTS (select * from GxQscripts where name = 'SqlGetLastDatabaseBackupDetails')
	delete from GxQscripts where name = 'SqlGetLastDatabaseBackupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastDatabaseBackupDetails')
	delete from GXDBVersions where aliasname = 'SqlGetLastDatabaseBackupDetails'
GO

insert into GXDBVersions values(2, 'SqlGetLastDatabaseBackupDetails',  '00000000000000000000', 'SqlGetLastDatabaseBackupDetails', '00000000000000000000')
GO

