

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetLastCheckpointLsn.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetLastCheckpointLsn.sp,v $ $Id: SqlGetLastCheckpointLsn.sp,v 1.1.4.4 2020/02/26 22:15:16 ankumar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetLastCheckpointLsn
--  |
--  | Description:
--  |   This sp checks LOG backups full_bkup_lsn exists as the checkpoint_lsn
--  |   of a FULL backup in sqlDbBackupInfo table. If not, return the last
--  |   FULL backups checkpoint_lsn.
--  |
--  | Return:
--  |   0 - if checkpoint_lsn is found
--  |   checkpoint_lsn of last FULL - otherwise
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        wliao    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetLastCheckpointLsn')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetLastCheckpointLsn <<<'
	drop procedure SqlGetLastCheckpointLsn
END
IF EXISTS (select * from GxQscripts where name='SqlGetLastCheckpointLsn')
	delete from GxQscripts where name = 'SqlGetLastCheckpointLsn'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastCheckpointLsn')
	delete from GXDBVersions where aliasname = 'SqlGetLastCheckpointLsn'
GO
print '... Creating Procedure: SqlGetLastCheckpointLsn'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlGetLastCheckpointLsn
  @xmlInput XML
AS
  DECLARE @xmlOutput XML
DECLARE @database_name	VARCHAR(1024)
DECLARE @instance_id	INT
DECLARE @full_bkup_lsn	VARCHAR(32)
SET @database_name = @xmlInput.value('(/SQLiDA_SqlGetLastCheckpointLsnReq/@dbName)[1]', 'VARCHAR(1024)')
SET @database_name = ( select dbo.DecodeInvalidXMLChar(@database_name) )
SET @instance_id = @xmlInput.value('(/SQLiDA_SqlGetLastCheckpointLsnReq/@instanceId)[1]', 'INT')
SET @full_bkup_lsn = @xmlInput.value('(/SQLiDA_SqlGetLastCheckpointLsnReq/@full_bkup_lsn)[1]', 'VARCHAR(32)')
SET @full_bkup_lsn = ( select dbo.DecodeInvalidXMLChar(@full_bkup_lsn) )
-- Compute the dbId one time so that it doesn't have to be recomputed.
DECLARE @sqlNameId INT
SELECT @sqlNameId = ID
FROM sqlNames
WHERE sqlid in (SELECT TOP 1 id FROM sqlNames2 WHERE name = @database_name AND type = 1)
BEGIN
	-- In order to support
	-- 1. COPY ONLY FULL backup as regular FULL
	-- 2. FULL backup from outside
	-- We need to do following:
	-- 1. First get latest FULL backup.
	-- 2. If full backup lsn of log matches with latest FULL then return 0.
	-- 3. If full backup lsn of log does not match then we need to checkpoint lsn of latest full.
	DECLARE @latestFullCPLsn VARCHAR(32) = '0'
	SELECT TOP 1 @latestFullCPLsn = checkpoint_lsn
	FROM sqlDbBackupInfo WITH (NOLOCK)
	WHERE TYPE = 'D' AND instanceid = @instance_id AND sqlNameId = @sqlNameId ORDER BY backup_finish_Date DESC
	SET @xmlOutput = (SELECT @latestFullCPLsn AS '@checkpoint_lsn'
	FOR XML PATH('SQLiDA_SqlGetLastCheckpointLsnRsp'))
END
SELECT @xmlOutput
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetLastCheckpointLsn')
	delete from GxQscripts where name = 'SqlGetLastCheckpointLsn'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetLastCheckpointLsn')
	delete from GXDBVersions where aliasname = 'SqlGetLastCheckpointLsn'
GO

insert into GXDBVersions values(2, 'SqlGetLastCheckpointLsn',  '00010001000400040000', 'SqlGetLastCheckpointLsn', '00010001000400040000')
GO

