

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetFFGBackups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetFFGBackups.sp,v $ $Id: SqlGetFFGBackups.sp,v 1.6.204.1 2018/03/27 08:54:07 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetFFGBackups
--  |
--  | Description:
--  |
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlGetFFGBackups <<<'

IF EXISTS (select * from sysobjects where name='SqlGetFFGBackups')
	drop procedure SqlGetFFGBackups
IF EXISTS (select * from GxQscripts where name='SqlGetFFGBackups')
	delete from GxQscripts where name = 'SqlGetFFGBackups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetFFGBackups')
	delete from GXDBVersions where aliasname = 'SqlGetFFGBackups'
GO
print '... Creating Procedure: SqlGetFFGBackups'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetFFGBackups
  @i_instanceId INTEGER,
  @i_databaseName VARCHAR(1024),
  @i_browseTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_includeAgedData integer
AS
  DECLARE @o_fileGroup VARCHAR(1024);
  DECLARE @o_physicalFileName VARCHAR(1024);
  DECLARE @o_logicalFileName VARCHAR(1024);
  DECLARE @o_pageSize INTEGER
  DECLARE @o_fileNumber INTEGER
--DECLARE @in_sqlNameId INTEGER
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
IF object_id('tempdb.dbo.#sqlgetFFGBackups_dbbackupList') is not null DROP TABLE #sqlgetFFGBackups_dbbackupList
create TABLE #sqlgetFFGBackups_dbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
IF object_id('tempdb.dbo.#sqlgetFFGBackups_copydbbackupList') is not null DROP TABLE #sqlgetFFGBackups_copydbbackupList
create TABLE #sqlgetFFGBackups_copydbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
DECLARE @appIdTable TABLE
(
	appId INT
)
IF object_id('tempdb.dbo.#sqlgetFFGBackups_archFileIdTable') is not null DROP TABLE #sqlgetFFGBackups_archFileIdTable
create TABLE #sqlgetFFGBackups_archFileIdTable
(
	archFileId INT,
	commCellId INT
)
IF object_id('tempdb.dbo.#sqlgetFFGBackups_sqlDbBackupFileIdTable') is not null DROP TABLE #sqlgetFFGBackups_sqlDbBackupFileIdTable
create TABLE #sqlgetFFGBackups_sqlDbBackupFileIdTable
(
	sqlDbBackupFileId INT
)
DECLARE @BackupInfoIdTable table
(
	id INT,
	backupFinishTime INTEGER
)
DECLARE @lastBackupType CHAR
DECLARE @lastBackupTime INTEGER
DECLARE @lastbkpsetId INTEGER
DECLARE @majorVersion INTEGER
DECLARE @lastBackupfirstLsn NUMERIC(25, 0)
DECLARE @lastBackuplastLsn NUMERIC(25, 0)
DECLARE @lastBackupcheckpointLsn NUMERIC(25, 0)
DECLARE @lastBackupfullbackupLsn NUMERIC(25, 0)
DECLARE @fullBackupType char
insert into @SQLNAMEIDTABLE SELECT   id from sqlNames where id in (select id from sqlNames where  name = @i_databaseName and type = 1) and type = 1
INSERT	INTO @appIdTable
SELECT	DISTINCT appId
FROM	sqlDbBackupInfo
WHERE	instanceId = @i_instanceId
	AND backup_finish_Date <= @i_browseTime
	AND sqlNameId in (select id from  @SQLNAMEIDTABLE)
IF @i_copyPrecedence = 0
	INSERT	INTO #sqlgetFFGBackups_archFileIdTable
	SELECT	a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND b.archCopyId = c.id
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
ELSE
	INSERT	INTO #sqlgetFFGBackups_archFileIdTable
	SELECT	DISTINCT a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
		AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
INSERT	INTO #sqlgetFFGBackups_sqlDbBackupFileIdTable
	SELECT	DISTINCT sqlDbBackupFileId
	FROM	sqlArchiveInfo a, #sqlgetFFGBackups_archFileIdTable b
	WHERE	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
insert into #sqlgetFFGBackups_dbbackupList
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
	from sqldbbackupinfo SDBI
	where
	SDBI.id in (select sqlDbBackupFileId from #sqlgetFFGBackups_sqlDbBackupFileIdTable) and
	SDBI.sqlNameId in (select id from @SQLNAMEIDTABLE) and
	SDBI.instanceId = @i_instanceId and
	SDBI.majorVersion > 7 and
	not exists (
					select * from sqlfilebackupinfo SFBI
					where
					SFBI.sqlDbBackupInfoId = SDBI.id
					and SFBI.type = 100
				) and
	SDBI.backup_finish_date <= @i_browseTime
	order by id DESC
select top 1 @majorVersion = majorVersion, @lastBackupType = backupType,
		@lastbkpsetId = backupsetId, @lastBackupTime = backupFinishTime,
		@lastBackupfirstLsn = firstLsn,  @lastBackuplastLsn = lastLsn,
		@lastBackupcheckpointLsn = checkpointLsn, @lastBackupfullbackupLsn = fullbackupLsn
from #sqlgetFFGBackups_dbbackupList
BEGIN
	DECLARE @fullBackupSetId  INTEGER
	DECLARE @fullbackupFinishTime INTEGER
	DECLARE @firstLsn NUMERIC(25, 0)
	DECLARE @lastLsn NUMERIC(25, 0)
	DECLARE @checkpointLsn NUMERIC(25, 0)
	DECLARE @fullbkpLsn NUMERIC(25, 0)
	DECLARE @version INTEGER
	set @fullBackupSetId = 0
	IF(@lastBackupType = 'D')
	BEGIN
		set @fullBackupSetId = @lastbkpsetId
		set @fullbackupFinishTime = @lastBackupTime
		set @firstLsn = @lastBackupfirstLsn
		set @lastLsn = @lastBackuplastLsn
		set @checkpointLsn = @lastBackupcheckpointLsn
		set @fullbkpLsn = @lastBackupfullbackupLsn
		set @fullBackupType = @lastBackupType
	END
	ELSE
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @fullbackupFinishTime = backupFinishTime,
				   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
				   @fullBackupType = backupType
		from #sqlgetFFGBackups_dbbackupList
		where
		checkpointLsn = @lastBackupfullbackupLsn and backupType = 'D'
	END
	IF(@fullBackupSetId = 0)
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
			   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
			   @fullBackupType = backupType
		from #sqlgetFFGBackups_dbbackupList
		where
		backupType = 'D'
		order by backupFinishTime desc
	END
	IF(@fullBackupSetId = 0 and @majorVersion > 8)
	BEGIN
		select TOP 1 @fullBackupSetId = DBL.backupsetId, @lastLsn = DBL.lastLsn, @fullbackupFinishTime = DBL.backupFinishTime,
			   @firstLsn = DBL.firstLsn, @lastLsn = DBL.lastLsn, @checkpointLsn = DBL.checkpointLsn, @fullbkpLsn = DBL.fullbackupLsn,
			   @fullBackupType = DBL.backupType
		from #sqlgetFFGBackups_dbbackupList DBL
		where
		DBL.backupType = 'P'
		order by backupFinishTime desc
	END
	IF(@fullBackupType = 'D')
	BEGIN
		INSERT INTO #sqlgetFFGBackups_copydbbackupList
			select * from #sqlgetFFGBackups_dbbackupList
			where backupsetId = @fullBackupSetId
		INSERT INTO #sqlgetFFGBackups_copydbbackupList
			SELECT * FROM #sqlgetFFGBackups_dbbackupList DBL
			where
			DBL.fullbackupLsn = @checkpointLsn
			order by DBL.backupFinishTime ASC
		INSERT INTO #sqlgetFFGBackups_copydbbackupList
			SELECT * FROM #sqlgetFFGBackups_dbbackupList DBL
			WHERE
			DBL.backupType in ('F', 'G', 'L')
			and DBL.backupFinishTime >=  @fullbackupFinishTime
			order by DBL.backupFinishTime ASC
	END
	ELSE
	BEGIN
		INSERT INTO #sqlgetFFGBackups_copydbbackupList
			SELECT * FROM #sqlgetFFGBackups_dbbackupList DBL
			WHERE
			DBL.backupType in ('F', 'G', 'Q', 'P')
			order by DBL.backupFinishTime ASC
	END
END
select FG.name, PHYFILE.name, LOGICALFILE.name, SFBI.pageSize, SFBI.number
from
(select * from sqlnames where type = 2 and name not in ('NULL', 'DatabaseLogs')) as FG,
(select * from sqlnames where type = 3) as PHYFILE,
(select * from sqlnames where type = 4) as LOGICALFILE,
sqlfilebackupinfo SFBI, #sqlgetFFGBackups_copydbbackupList CDBL
where
CDBL.backupsetId = SFBI.sqldbbackupinfoId and
SFBI.sqlNameFgId = FG.id and
SFBI.sqlNamePhyId = PHYFILE.id and
SFBI.sqlNameLogId = LOGICALFILE.id
order by FG.name
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetFFGBackups')
	delete from GxQscripts where name = 'SqlGetFFGBackups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetFFGBackups')
	delete from GXDBVersions where aliasname = 'SqlGetFFGBackups'
GO

insert into GXDBVersions values(2, 'SqlGetFFGBackups',  '00010006020400010000', 'SqlGetFFGBackups', '00010006020400010000')
GO

