

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetDbChain_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetDbChain_V1.sp,v $ $Id: SqlGetDbChain_V1.sp,v 1.1.6.20 2020/06/11 20:07:31 vkhule Exp $";
-- 	+-----------------------------------------------------------------------+
--	| Stored Procedure: SqlGetDbChain_V1
--	|
--	| Description:
--	|	This SP is similar to sqlgetdbchain cursor. In addition to
--	|	functionality of the cursor it take care of calculating chain by
--	|	making sure that the log following full/diff are aptly chained.
--  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetDbChain_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetDbChain_V1 <<<'
	drop procedure SqlGetDbChain_V1
END
IF EXISTS (select * from GxQscripts where name='SqlGetDbChain_V1')
	delete from GxQscripts where name = 'SqlGetDbChain_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDbChain_V1')
	delete from GXDBVersions where aliasname = 'SqlGetDbChain_V1'
GO
print '... Creating Procedure: SqlGetDbChain_V1'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlGetDbChain_V1
  @i_instanceId INTEGER,
  @i_databaseName NVARCHAR(1024),
  @i_restoreType INTEGER,
  @i_browseTime INTEGER,
  @i_requestTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_logShippingOnly INTEGER,
  @i_includeAgedData INTEGER,
  @i_DelayFactorInMins INTEGER
AS
  DECLARE @o_backupsetId INTEGER
  DECLARE @o_backupType CHAR
  DECLARE @o_backupFinishTime INTEGER
  DECLARE @o_majorVersion INTEGER
  DECLARE @o_firstLsn VARCHAR(256)
  DECLARE @o_lastLsn VARCHAR(256)
  DECLARE @o_checkpointLsn VARCHAR(256)
  DECLARE @o_fullbackupLsn VARCHAR(256)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_dataType INTEGER = 1
DECLARE @hotServerRestoreTime INTEGER = 0
DECLARE @fullBackupCheckPointLsn NUMERIC(25, 0) = 0
DECLARE @SQLNAMEIDTABLE TABLE ( ID INT );
IF object_id('tempdb.dbo.#dbbackupList') is not null DROP TABLE #dbbackupList
CREATE TABLE #dbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0),
	begins_log_chain CHAR,
	isCopy INTEGER
)
CREATE NONCLUSTERED INDEX IX_temp_table_dbbackupList ON #dbbackupList (backupFinishTime, backupType)
IF object_id('tempdb.dbo.#copydbbackupList') is not null DROP TABLE #copydbbackupList
CREATE TABLE #copydbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0),
	begins_log_chain CHAR,
	isCopy INTEGER
)
IF object_id('tempdb.dbo.#appIdTable') is not null DROP TABLE #appIdTable
CREATE TABLE #appIdTable ( appId INT NOT NULL PRIMARY KEY )
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
CREATE TABLE #archFileIdTable
(
	archFileId INT,
	commCellId INT,
	jobId INT
)
CREATE CLUSTERED INDEX IX_temp_table_archFileIdTable ON #archFileIdTable(archFileId, commCellId, jobId)
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
CREATE TABLE #sqlDbBackupFileIdTable( sqlDbBackupFileId INT NOT NULL PRIMARY KEY )
INSERT INTO @SQLNAMEIDTABLE
SELECT  SN.id
FROM sqlNames SN
JOIN sqlNames2 SN2 ON SN2.name = @i_databaseName AND SN2.type = 1 AND SN.sqlId = SN2.id AND SN.type = 1
-- Adjust browse time for hotserver restore
if(@i_restoreType = 4)
BEGIN
	SET @hotServerRestoreTime = @i_browseTime
	SELECT @i_browseTime = dbo.GetUnixTime(GETUTCDATE())
	-- Adjust @i_browseTime based on delay factor
	SET @i_browseTime = @i_browseTime - (@i_DelayFactorInMins * 60)
END
-- Prepare subclients table that falls in the given time range.
INSERT	INTO #appIdTable
	SELECT	DISTINCT appId  FROM	sqlDbBackupInfo SDBI
		JOIN @SQLNAMEIDTABLE SNT ON SDBI.sqlNameId = SNT.id
	WHERE	instanceId = @i_instanceId  AND backup_finish_Date <= @i_browseTime
		AND ( SDBI.type not in ('F', 'G'))
	UNION
	SELECT	DISTINCT appId  FROM sqlDbBackupInfo SDBI
		JOIN @SQLNAMEIDTABLE SNT ON SDBI.sqlNameId = SNT.id
	WHERE instanceId = @i_instanceId AND SDBI.type = 'L'
		AND SDBI.begins_log_chain IS NOT NULL AND
		SDBI.begins_log_chain = 'Y' AND
		@i_browseTime > SDBI.backup_start_Date
		AND @i_browseTime <= SDBI.backup_finish_Date
-- Create JobIdTable to consider only completed jobs
IF object_id('tempdb.dbo.#JobIdTable') is not null DROP TABLE #JobIdTable
CREATE TABLE #JobIdTable
(
	jobId INT,
	commCellId INT,
	archCopyId INT,
	fileType INT
	PRIMARY KEY (jobId, commCellId, archCopyId, fileType)
)
-- Fetch archive files that falls in the given time range considering completed jobs
IF @i_copyPrecedence = 0
BEGIN
	IF @i_includeAgedData  = 0
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A
	  WHERE JDS.appId = A.appId
	  AND	 JDS.status = 100
	  AND	 JDS.disabled & 256 = 0
	  AND	 JDS.dataType IN (1, 4)
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
		AND AFC.flags & 256 = 0
	END
	ELSE
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A
	  WHERE JDS.appId = A.appId
	  AND	 JDS.status = 100
	  AND	 JDS.dataType IN (1, 4)
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
	END
END
ELSE
BEGIN
	IF @i_includeAgedData  = 0
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A, archGroupCopy AGC WITH (NOLOCK)
	  WHERE JDS.appId = A.appId
	  AND JDS.status = 100
	  AND JDS.disabled & 256 = 0
	  AND JDS.dataType IN (1, 4)
	  AND JDS.archGrpCopyId = AGC.id
	  AND (AGC.copy = @i_copyPrecedence OR (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))))
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
		AND AFC.flags & 256 = 0
	END
	ELSE
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A, archGroupCopy AGC WITH (NOLOCK)
	  WHERE JDS.appId = A.appId
	  AND JDS.status = 100
	  AND JDS.dataType IN (1, 4)
	  AND JDS.archGrpCopyId = AGC.id
	  AND (AGC.copy = @i_copyPrecedence OR (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))))
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
	END
END
-- Drop table #JobIdTable since it is no longer required.
IF object_id('tempdb.dbo.#JobIdTable') IS NOT NULL DROP TABLE #JobIdTable
update #archFileIdTable
set #archFileIdTable.commCellId = JMPreparedJob.commCellId, #archFileIdTable.jobId = JMPreparedJob.jobId, #archFileIdTable.archFileId = archFile.id
from JMPreparedJob, archFile
Where
JMPreparedJob.preparedJobId = #archFileIdTable.jobId and
JMPreparedJob.preparedJobCCId = #archFileIdTable.commCellId AND
archFile.jobId = JMPreparedJob.jobId and
archFile.commCellId = JMPreparedJob.commCellId
INSERT	INTO #sqlDbBackupFileIdTable
	SELECT	DISTINCT sqlDbBackupFileId  FROM	sqlArchiveInfo a JOIN #archFileIdTable b
		ON	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
INSERT	INTO #sqlDbBackupFileIdTable
	SELECT	dbinfo.ID FROM sqldbbackupinfo dbinfo JOIN #archFileIdTable afid ON  dbinfo.jobId = afid.jobId AND dbinfo.backupMethod = 2 GROUP BY dbinfo.ID
	EXCEPT
	SELECT SD.sqlDbBackupFileId FROM #sqlDbBackupFileIdTable SD GROUP BY SD.sqlDbBackupFileId
INSERT INTO #dbbackupList
	SELECT SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn,
		SDBI.checkpoint_lsn, SDBI.full_bkup_lsn, SDBI.begins_log_chain, SDBI.is_copy
		FROM sqldbbackupinfo SDBI
		JOIN #sqlDbBackupFileIdTable SD ON SDBI.id = SD.sqlDbBackupFileId
		JOIN @SQLNAMEIDTABLE SN ON SN.id = SDBI.sqlNameId
		WHERE SDBI.instanceId = @i_instanceId AND SDBI.backup_finish_date <= @i_browseTime
	UNION
	SELECT SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn,
		SDBI.checkpoint_lsn, SDBI.full_bkup_lsn, SDBI.begins_log_chain, SDBI.is_copy
		FROM sqldbbackupinfo SDBI
		JOIN #sqlDbBackupFileIdTable SD ON SDBI.id = SD.sqlDbBackupFileId
		JOIN @SQLNAMEIDTABLE SN ON SN.id = SDBI.sqlNameId
		WHERE SDBI.instanceId = @i_instanceId AND SDBI.type = 'L' AND SDBI.begins_log_chain IS NOT NULL AND SDBI.begins_log_chain = 'Y' AND @i_browseTime > SDBI.backup_start_Date
			AND @i_browseTime <= SDBI.backup_finish_Date
	ORDER BY backup_finish_date DESC
-- For PIT Restore, get rid of any Full Backups with backup finish time greater than the Request Time
-- This will ensure that correct cycle is returned for PIT restore and restore then goes through without any issues
--   Without these changes, PIT Restore to 8 PM for following situation fails because cycle F2->L3 is returned by the SP.
--     @i_requestTime = 8 PM, @i_browseTime = 08:07:42 PM and values in the brackets below are Finish Time for corresponding backups
--     F1 (07:34:11 PM) -> L1 (07:35:14 PM) -> L2 (07:56:42 PM) -> F2 (08:01:09 PM) -> L3 (08:07:42 PM)
--   With these changes, PIT Restore to 8 PM succeeds because cycle F1->L1->L2->L3 is returned by the SP.
IF(@i_restoreType = 1)
BEGIN
	DELETE FROM #dbbackupList WHERE backupType = 'D' AND backupFinishTime > @i_requestTime
END
DECLARE @lastBackupType CHAR = ''
DECLARE @lastBackupTime INTEGER = 0
DECLARE @lastbkpsetId INTEGER = 0
select top 1 @lastBackupType = backupType, @lastbkpsetId = backupsetId, @lastBackupTime = backupFinishTime
from #dbbackupList
order by backupFinishTime DESC
IF(@i_logShippingOnly = 1 and @hotServerRestoreTime > 0)
BEGIN
	INSERT INTO #copydbbackupList
		select * from #dbbackupList
		where backupFinishTime > @hotServerRestoreTime and
		backupType = 'L'
END
ELSE
BEGIN
	IF(@lastBackupType = 'D')
	BEGIN
		--return only this entry
		insert into #copydbbackupList
			select * from #dbbackupList where backupsetId = @lastbkpsetId
		IF(@hotServerRestoreTime >= @lastBackupTime)
		BEGIN
			--There is no need to restore the whole last full cycle
			delete #copydbbackupList where backupFinishTime <= @hotServerRestoreTime
		END
	END
	ELSE
	BEGIN
		--Chaining logic Based on the sqlversion
		DECLARE @fullBackupSetId  INTEGER = 0
		DECLARE @fullbackupFinishTime INTEGER = 0
		DECLARE @firstLsn NUMERIC(25, 0) = 0
		DECLARE @lastLsn NUMERIC(25, 0) = 0
		DECLARE @checkpointLsn NUMERIC(25, 0) = 0
		DECLARE @fullbkpLsn NUMERIC(25, 0) = 0
		DECLARE @fullBkpType CHAR = 'D'
		DECLARE @IsFullBkpCopyOnly INTEGER = 0
		DECLARE @version INTEGER = 0
		select top 1 @lastLsn = lastLsn, @fullbkpLsn = fullbackupLsn, @version = majorVersion
		from #dbbackupList
		order by backupFinishTime DESC
		--Check if there is a full backup which chains to this.
		if(@version = 7)
		BEGIN
			select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
					@firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
					@IsFullBkpCopyOnly = isCopy
			from #dbbackupList
			where (lastLsn = @fullbkpLsn and backupType = 'D')
			order by backupFinishTime DESC
		END
		ELSE if(@version = 8)
		BEGIN
			--SQL 2000 chaining logic
			select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
					@firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
					@IsFullBkpCopyOnly = isCopy
			from #dbbackupList
			where (checkpointLsn = @fullbkpLsn and backupType = 'D')
			order by backupFinishTime DESC
		END
		ELSE if(@version > 8)
		BEGIN
			---SQL 2005 chaining logic
			select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
					@firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
					@IsFullBkpCopyOnly = isCopy
			from #dbbackupList
			where ((checkpointLsn = @fullbkpLsn and backupType = 'D'))
			order by backupFinishTime DESC
			IF(@fullBackupSetId = 0)
			BEGIN
				select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
					@firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
					@fullBkpType = backupType
				from #dbbackupList
				where
				backupType = 'P'
				order by backupFinishTime DESC
			END
		END
		IF(@fullBackupSetId = 0)
		BEGIN
			--Full Backup is done outside galaxy. Check if this log backup is linked to previous log.
			--Get Latest Galaxy Full
			select top 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
					@firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn,
					@fullBkpType = backupType, @IsFullBkpCopyOnly = isCopy
			from #dbbackupList
			where (backupType = 'D' or backupType = 'P')
			order by backupFinishTime DESC
		END
		BEGIN
			if(@version = 7)
			BEGIN
				set @checkpointLsn = @lastlsn
			END
			set @fullBackupCheckPointLsn = @checkpointLsn
			if(@version <= 8)
			BEGIN
				insert into #copydbbackupList
					select * from #dbbackupList
					where backupFinishTime > @fullbackupFinishTime and
					backupType not in ('F', 'D', 'G') and
					(backupType in ('L')) or (backupType in ('I') and fullbackupLsn = @checkpointLsn)
			END
			ELSE
			BEGIN
				if(@fullBkpType = 'D')
				BEGIN
					-- If I/P/Q is in between the latest job (L/D) and oldest job (FC/F)
					-- then, we need to bring chain with actual full.
					-- So we need to do 2 things here, first check if FULL obtained above is copy only.
					-- If its is copy only, then check if there is I/P/Q in the picture.
					IF @IsFullBkpCopyOnly = 0
					BEGIN
						insert into #copydbbackupList
							select *
							from #dbbackupList
							where backupFinishTime > @fullbackupFinishTime and
								(backupType in ('L')) or (backupType in ( 'P', 'I', 'Q' ) and fullbackupLsn = @checkpointLsn)
					END
					ELSE
					BEGIN
						-- So the FULL obtained above is copy only, so lets check if I/P/Q is in the chain to
						-- be used for restore.
						DECLARE @latestIPQFullBkpLsn NUMERIC(25, 0) = 0
						SELECT TOP 1 @latestIPQFullBkpLsn = fullbackuplsn
						FROM #dbbackupList
						WHERE backupFinishTime > @fullbackupFinishTime AND backupType IN ('I', 'P', 'Q')
						ORDER BY backupFinishTime DESC
						IF @latestIPQFullBkpLsn = 0
						BEGIN
							-- There is no I/P/Q in the chain hence we can use copy only FULL backup to calculate the chain for restore
							-- by picking only required logs.
							insert into #copydbbackupList
								select *
								from #dbbackupList
								where backupFinishTime > @fullbackupFinishTime and
									backupType = 'L'
						END
						ELSE
						BEGIN
							-- There is/are I/P/Q in the chain hence lets get corresponding FULL.
							-- Using different variable to find corresponding FULL. In case we dont get corresponding FULL then we can use the FULL
							-- backup information obtained already.
							DECLARE @fullBackupSetIdIPQ INTEGER = 0
							DECLARE @fullbackupFinishTimeIPQ INTEGER = 0
							DECLARE @checkpointLsnIPQ NUMERIC(25, 0) = 0
							SELECT TOP 1 @fullBackupSetIdIPQ = backupsetId, @fullbackupFinishTimeIPQ = backupFinishTime, @checkpointLsnIPQ = checkpointLsn
							FROM #dbbackupList
							WHERE checkpointLsn = @latestIPQFullBkpLsn and backupType = 'D'
							ORDER BY backupFinishTime DESC
							-- IF we do not get actual FULL, we cannot use I/P/Q for restore, hence we will use COPY ONLY FULL and logs for restore.
							IF @fullBackupSetIdIPQ = 0
							BEGIN
								insert into #copydbbackupList
									select *
									from #dbbackupList
									where backupFinishTime > @fullbackupFinishTime and
										backupType = 'L'
							END
							ELSE
							BEGIN
								-- Now get the backups using actual FULL
								SET @fullBackupSetId = @fullBackupSetIdIPQ
								INSERT INTO #copydbbackupList
									SELECT *
									FROM #dbbackupList
									WHERE backupFinishTime > @fullbackupFinishTimeIPQ and
										(backupType in ('L')) or (backupType in ( 'P', 'I', 'Q' ) and fullbackupLsn = @checkpointLsnIPQ)
							END
						END
					END
				END
				ELSE
				BEGIN
					insert into #copydbbackupList
						select * from #dbbackupList
						where backupFinishTime > @fullbackupFinishTime and
						backupType not in ('F', 'D', 'G') and
						backupType in ('L', 'I', 'Q')
				END
			END
			insert into #copydbbackupList
				select * from #dbbackupList
				where backupsetId = @fullBackupSetId
			DECLARE @latestDiffBackupId INTEGER = 0
			DECLARE @latestDiffBackupTime INTEGER = 0
			DECLARE @latestPartialFullBackupTime INTEGER = 0
			DECLARE @latestPartialFullBackupId INTEGER = 0
			DECLARE @latestPartialDiffBackupId INTEGER = 0
			DECLARE @latestPartialDiffBackupTime INTEGER = 0
			select top 1 @latestDiffBackupId = backupsetId,  @latestDiffBackupTime = backupFinishTime
			from #copydbbackupList
			where backupType = 'I'
			ORDER BY backupFinishTime DESC
			select top 1 @latestPartialFullBackupId = backupsetId,  @latestPartialFullBackupTime = backupFinishTime
			from #copydbbackupList
			where backupType = 'P'
			ORDER BY backupFinishTime DESC
			select top 1 @latestPartialDiffBackupId = backupsetId,  @latestPartialDiffBackupTime = backupFinishTime
			from #copydbbackupList
			where backupType = 'Q'
			ORDER BY backupFinishTime DESC
			if(@i_restoreType = 1 and @i_requestTime < @latestDiffBackupTime)
			BEGIN
				--POINT-IN-TIME RESTORE
				delete #copydbbackupList
				where
				backupFinishTime > @i_requestTime and
				backupType IN ('I', 'P', 'Q')
				set @latestDiffBackupId = 0
				set @latestDiffBackupTime = 0
				set @latestPartialFullBackupTime = 0
				set @latestPartialFullBackupId = 0
				set @latestPartialDiffBackupId = 0
				set @latestPartialDiffBackupTime = 0
				-- Updating last latest DIFF backup time and backup set ID
				-- In case of PIT, if latest DIFF is past PIT time, it will be deleted by above statement.
				-- To calculate Chain with next latest DIFF, we need to update those varaibles with latest time and ID.
				select top 1 @latestDiffBackupId = backupsetId,  @latestDiffBackupTime = backupFinishTime
					from #copydbbackupList
						where backupType = 'I'
							ORDER BY backupFinishTime DESC
				select top 1 @latestPartialFullBackupId = backupsetId,  @latestPartialFullBackupTime = backupFinishTime
					from #copydbbackupList
						where backupType = 'P'
							ORDER BY backupFinishTime DESC
				select top 1 @latestPartialDiffBackupId = backupsetId,  @latestPartialDiffBackupTime = backupFinishTime
					from #copydbbackupList
						where backupType = 'Q'
							ORDER BY backupFinishTime DESC
			END
			-- Below code should be executed no matter what.
			-- It will create correct database chain where Logs between DIFF and FULL are not included in chain.
			BEGIN
				if(@latestDiffBackupId <> 0)
				BEGIN
					delete #copydbbackupList
					where backupFinishTime < @latestDiffBackupTime AND
					backupType IN ('I', 'L', 'P') AND
					backupsetId <> @fullBackupSetId
				END
				if(@latestPartialFullBackupId <> 0)
				BEGIN
					delete #copydbbackupList
					where backupFinishTime < @latestPartialFullBackupTime AND
					backupType IN ('P', 'Q') AND
					backupsetId <> @fullBackupSetId
				END
				if(@latestPartialDiffBackupId <> 0)
				BEGIN
					delete #copydbbackupList
					where backupFinishTime < @latestPartialDiffBackupTime AND
					backupType in ('Q', 'L')
				END
			END
			IF(@hotServerRestoreTime >= @fullbackupFinishTime)
			BEGIN
				--There is no need to restore the whole last full cycle
				delete #copydbbackupList where backupFinishTime <= @hotServerRestoreTime
			END
		END
	END
END
DECLARE @logBackupsetId TABLE
(
	logBackupsetId INTEGER
)
DECLARE @logChain_FirstLsn NUMERIC(25, 0)
DECLARE @logChain_LastLsn NUMERIC(25, 0)
DECLARE @logChain_fullBackupLsn NUMERIC(25, 0)
DECLARE @logChain_backupsetId INTEGER
DECLARE @logChain_version INTEGER
SET @logChain_backupsetId = 0
DECLARE @prev_logChain_FirstLsn NUMERIC(25, 0)
DECLARE @prev_logChain_LastLsn NUMERIC(25, 0)
DECLARE @prev_logChain_backupsetId INTEGER
SET @prev_logChain_backupsetId = 0
DECLARE LogChainCheck CURSOR FOR
SELECT backupsetId, firstLsn, lastLsn, fullbackupLsn, majorVersion FROM #copydbbackupList WHERE backupType = 'L' order by backupsetId ASC
OPEN LogChainCheck
FETCH NEXT FROM LogChainCheck INTO @logChain_backupsetId, @firstLsn, @lastLsn, @logChain_fullBackupLsn, @logChain_version
WHILE (@@FETCH_STATUS = 0)
BEGIN
IF(@prev_logChain_backupsetId = 0)
BEGIN
	set @prev_logChain_FirstLsn = @firstLsn
	set @prev_logChain_LastLsn = @lastLsn
	set @prev_logChain_backupsetId = @logChain_backupsetId
END
ELSE
BEGIN
	if(@logChain_fullBackupLsn <> @fullBackupCheckPointLsn)
	BEGIN
		DECLARE @isFullExists INTEGER
		DECLARE @doNotCheckForLogChain INTEGER
		set @isFullExists = 0
		IF(@logChain_version = 7)
		BEGIN
			IF exists (select * from sqldbbackupinfo where last_lsn = @logChain_fullBackupLsn and type = 'D')
				set @isFullExists = 1
		END
		ELSE IF(@logChain_version >= 8)
		BEGIN
			IF exists (select * from sqldbbackupinfo where checkpoint_lsn = @logChain_fullBackupLsn and type = 'D')
				set @isFullExists = 1
		END
		IF(@logChain_version > 8 and @isFullExists = 0)
		BEGIN
			IF exists (select * from #copydbbackupList where backupType IN ('P', 'Q'))
				set @doNotCheckForLogChain = 1
		END
		DECLARE @IsAddedToDeleteSet INTEGER
		SET @IsAddedToDeleteSet = 0
		if(@isFullExists = 1 OR @prev_logChain_LastLsn != @firstLsn)
		BEGIN
			-- Here we could be because either full backup exists or prev log last lsn != current log first lsn.
			-- In case prev log last lsn = current log first lsn, we should consider this current log
			IF ( (@prev_logChain_LastLsn <> @firstLsn) AND (@prev_logChain_FirstLsn <> @firstLsn) )
			BEGIN
				insert INTO @logBackupsetId values (@logChain_backupsetId)
				SET @IsAddedToDeleteSet = 1
			END
		END
		IF @IsAddedToDeleteSet = 0
		BEGIN
			set @prev_logChain_FirstLsn = @firstLsn
			set @prev_logChain_LastLsn = @lastLsn
			set @prev_logChain_backupsetId = @logChain_backupsetId
		END
	END
	ELSE
	BEGIN
		set @prev_logChain_FirstLsn = @firstLsn
		set @prev_logChain_LastLsn = @lastLsn
		set @prev_logChain_backupsetId = @logChain_backupsetId
	END
END
FETCH NEXT FROM LogChainCheck INTO @logChain_backupsetId, @firstLsn, @lastLsn, @logChain_fullBackupLsn, @logChain_version
End
CLOSE LogChainCheck
DEALLOCATE LogChainCheck
DELETE FROM #copydbbackupList WHERE backupsetId IN (SELECT logBackupsetId FROM @logBackupsetId)
-- Get expanded list of backups in this module.
IF OBJECT_ID('tempdb..#GetLogChainExpanded') IS NOT NULL DROP TABLE #GetLogChainExpanded
CREATE TABLE #GetLogChainExpanded(rn INT IDENTITY PRIMARY KEY, sqlInfoID INT, aFilId INT, first_lsn numeric(25,0), last_lsn numeric(25, 0), ckpt_lsn numeric(25, 0), backup_finish_time int)
CREATE INDEX IDX_GET_CHAIN_LSN ON #GetLogChainExpanded (rn, sqlInfoID, last_lsn, ckpt_lsn, backup_finish_time)
-- Get compressed xml entries.
IF OBJECT_ID('tempdb..#compressedEntries') IS NOT NULL DROP TABLE #compressedEntries
CREATE TABLE #compressedEntries(sqlInfoID INT, afileId INT, xmlOffsets XML)
INSERT INTO #compressedEntries
	SELECT SA.sqlDbBackupFileId, SA.aFileId, CAST(SA.DbFile AS XML)
		FROM #copydbbackupList CP JOIN sqlArchiveInfo SA ON SA.sqlDbBackupFileId = CP.backupsetId AND
		CP.begins_log_chain IS NOT NULL AND CP.begins_log_chain = 'Y'
-- Query takes more time if entries are high. Need to to verify the performance.
INSERT INTO #GetLogChainExpanded
	select SA.sqlInfoID, M.C.value('@id', 'INT') AFile, NULL, CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) LastLSN,
		CAST(M.C.value('@ckpt_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0))  CKPT_LSN, M.C.value('@backupTime', 'INT') bkp_fin_time
	from #compressedEntries AS SA OUTER APPLY SA.xmlOffsets.nodes('/App_SqlAfile/offset') AS M(C)
		ORDER BY CAST(M.C.value('@last_lsn', 'NVARCHAR(48)') AS NUMERIC(25,0)) DESC
-- Self join to populate the first LSN.
UPDATE GC SET GC.first_lsn = PREV.last_lsn
	FROM #GetLogChainExpanded GC
		LEFT JOIN #GetLogChainExpanded PREV ON GC.rn = PREV.rn - 1
-- Prepare the final list of backups with right LSN.
IF object_id('tempdb.dbo.#finalBackupList') is not null DROP TABLE #finalBackupList
CREATE TABLE #finalBackupList(backupsetId INTEGER, backupType  CHAR, backupFinishTime INTEGER, majorVersion INTEGER,
	firstLsn NUMERIC(25, 0), lastLsn NUMERIC(25, 0), checkpointLsn NUMERIC(25, 0), fullbackupLsn NUMERIC(25, 0))
INSERT INTO #finalBackupList
	SELECT CP.backupsetId, CP.backupType, CP.backupFinishTime, Cp.majorVersion, CP.firstLsn, CP.lastLsn,
		CP.checkpointLsn, CP.fullbackupLsn FROM #copydbbackupList CP
		WHERE CP.begins_log_chain IS NULL OR CP.begins_log_chain <> 'Y'
-- Now get expanded list.
INSERT INTO #finalBackupList
	SELECT	CP.backupsetId, CP.backupType, GC.backup_finish_time, Cp.majorVersion,
		CASE WHEN GC.first_lsn IS NULL THEN CP.firstLsn ELSE GC.first_lsn END, CASE WHEN GC.last_lsn IS NULL THEN CP.lastLsn ELSE GC.last_lsn END,
		GC.ckpt_lsn, CP.fullbackupLsn
		FROM #copydbbackupList CP
		JOIN #GetLogChainExpanded GC ON CP.backupsetId = GC.sqlInfoID AND CP.begins_log_chain IS NOT NULL AND CP.begins_log_chain = 'Y'
		WHERE GC.backup_finish_time <= @i_browseTime
-- Due to log compression, we can have logs which are not required for restore in the final list.
-- These logs will have last lsn less than the full/diff.
-- We need to remove them if we find FULL/DIFF in the list.
DECLARE @fullDiffLastLsnInFinalList NUMERIC(25,0) = 0
SELECT @fullDiffLastLsnInFinalList = MAX(lastLsn)
FROM #finalBackupList
WHERE backupType in ('D', 'I')
IF @fullDiffLastLsnInFinalList <> 0
BEGIN
	DELETE FROM #finalBackupList WHERE lastLsn < @fullDiffLastLsnInFinalList and backupType = 'L'
END
select * from #finalBackupList order by backupType desc, lastLsn desc
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetDbChain_V1')
	delete from GxQscripts where name = 'SqlGetDbChain_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDbChain_V1')
	delete from GXDBVersions where aliasname = 'SqlGetDbChain_V1'
GO

insert into GXDBVersions values(2, 'SqlGetDbChain_V1',  '00010001000600200000', 'SqlGetDbChain_V1', '00010001000600200000')
GO

