

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetDbBackupSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetDbBackupSetInfo.sp,v $ $Id: SqlGetDbBackupSetInfo.sp,v 1.1.8.3 2018/03/27 08:55:32 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetDbBackupSetInfo
--  |
--  | Description:
--  |  Get info in SqlDbBackupSetInfo table
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        wliao				Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlGetDbBackupSetInfo <<<'

IF EXISTS (select * from sysobjects where name='SqlGetDbBackupSetInfo')
	drop procedure SqlGetDbBackupSetInfo
IF EXISTS (select * from GxQscripts where name='SqlGetDbBackupSetInfo')
	delete from GxQscripts where name = 'SqlGetDbBackupSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDbBackupSetInfo')
	delete from GXDBVersions where aliasname = 'SqlGetDbBackupSetInfo'
GO
print '... Creating Procedure: SqlGetDbBackupSetInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetDbBackupSetInfo
  @i_sqlNameId INTEGER,
  @i_instanceId INTEGER,
  @i_subclientId INTEGER
AS
  DECLARE @o_backup_set_id INTEGER; 
  DECLARE @o_type VARCHAR(1);
  DECLARE @o_database_creation_date INTEGER;
  DECLARE @o_backup_finish_Date INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @sqlNameId INTEGER
DECLARE @instanceId INTEGER
DECLARE @subclientId INTEGER
SET @sqlNameId = @i_sqlNameId
SET @instanceId = @i_instanceId
SET @subclientId = @i_subclientId
-- TL backup started before Full snap and finished exactly at the same second.
-- In msdb, we see FULL and then log, but in sqldbbackupinfo table,
-- we first see log and then FULL. As a result, if we just order by finish date,
-- we get Full backup set id which is lower than log and when we cross check with
-- msdb, we get backups done after the full backup set id causing the job to convert.
-- To resolve this, we need to order by backup_set_id desc as well.
--!!Potential cause of MR89663
IF(@subclientId = 0)
BEGIN
SELECT TOP 1 backup_set_id, type, database_creation_date, backup_finish_Date FROM dbo.sqldbbackupinfo WITH (NOLOCK) WHERE sqlNameId = @sqlNameId AND instanceId = @instanceId order by backup_finish_Date DESC, backup_set_id DESC
END
ELSE
BEGIN
SELECT TOP 1 backup_set_id, type, database_creation_date, backup_finish_Date FROM dbo.sqldbbackupinfo WITH (NOLOCK) WHERE sqlNameId = @sqlNameId AND instanceId = @instanceId AND appId = @subclientId order by backup_finish_Date DESC, backup_set_id DESC
END
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetDbBackupSetInfo')
	delete from GxQscripts where name = 'SqlGetDbBackupSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDbBackupSetInfo')
	delete from GXDBVersions where aliasname = 'SqlGetDbBackupSetInfo'
GO

insert into GXDBVersions values(2, 'SqlGetDbBackupSetInfo',  '00010001000800030000', 'SqlGetDbBackupSetInfo', '00010001000800030000')
GO

