

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetDatabasesDevices.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| Stored Procedure: SqlGetDatabasesDevices
--	|
--	| Description:
--	|	This stored procedure will return latest backup information including
--	|	backup method for FULL. The id corresponding to latest backup will
--	|	then be used in another curosr to fetch file/filegroup information.
--  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetDatabasesDevices')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetDatabasesDevices <<<'
	drop procedure SqlGetDatabasesDevices
END
IF EXISTS (select * from GxQscripts where name='SqlGetDatabasesDevices')
	delete from GxQscripts where name = 'SqlGetDatabasesDevices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDatabasesDevices')
	delete from GXDBVersions where aliasname = 'SqlGetDatabasesDevices'
GO
print '... Creating Procedure: SqlGetDatabasesDevices'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlGetDatabasesDevices
  @ioXmlInput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT OFF
-- Input Arguments
DECLARE @i_unixTime				INT = ISNULL((SELECT @ioXmlInput.value('(/SQLiDA_GetSQLDatabasesDevicesReq/@unixTime)[1]','INT')), 0)
DECLARE @i_serverId				INT = ISNULL((SELECT @ioXmlInput.value('(/SQLiDA_GetSQLDatabasesDevicesReq/@serverId)[1]','INT')), 0)
DECLARE @i_copyPrecedence 		INT = ISNULL((SELECT @ioXmlInput.value('(/SQLiDA_GetSQLDatabasesDevicesReq/@copyPrecedence)[1]','INT')), 0)
DECLARE @i_includeAgedData		INT = ISNULL((SELECT @ioXmlInput.value('(/SQLiDA_GetSQLDatabasesDevicesReq/@includeAgedData)[1]','INT')), 0)
DECLARE @i_excludeBeforeTime	INT = ISNULL((SELECT @ioXmlInput.value('(/SQLiDA_GetSQLDatabasesDevicesReq/@excludeBeforeTime)[1]','INT')), 0)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Create temp table with the given list of databases
IF OBJECT_ID('tempdb.dbo.#SqlDatabasesTbl') IS NOT NULL DROP TABLE #SqlDatabasesTbl
CREATE TABLE #SqlDatabasesTbl ( name nvarchar (2048) )
INSERT INTO #SqlDatabasesTbl
SELECT Tbl.Col.value('@name', 'NVARCHAR(2048)')
FROM @ioXmlInput.nodes('/SQLiDA_GetSQLDatabasesDevicesReq/sqlDbs/dbs') Tbl(Col)
-- Populate #sqlNameIdTbl with sqlNameId of given dbs.
IF OBJECT_ID('tempdb.dbo.#SqlNameIdTbl') IS NOT NULL DROP TABLE #SqlNameIdTbl
CREATE TABLE #sqlNameIdTbl ( sqlNameId INT NOT NULL PRIMARY KEY, name nvarchar(2048))
INSERT INTO #sqlNameIdTbl (sqlNameId, name)
	SELECT DISTINCT sn.id, SN2.name
	FROM sqlNames SN
	JOIN sqlNames2 SN2 ON SN.sqlid = SN2.id
	JOIN #SqlDatabasesTbl SDT ON SN2.name = SDT.name
	WHERE SN.type = 1 AND SN2.type = 1
-- Fetch subclients containing backups for given dbs.
IF object_id('tempdb.dbo.#appIdTable') is not null DROP TABLE #appIdTable
CREATE TABLE #appIdTable ( appId INT NOT NULL PRIMARY KEY )
INSERT  INTO #appIdTable
SELECT  DISTINCT SDBI.appId
FROM    sqlDbBackupInfo SDBI
JOIN	#sqlNameIdTbl SNT ON SDBI.sqlNameId = SNT.SqlNameId
WHERE   instanceId = @i_serverId
    AND backup_finish_Date <= @i_unixTime
    AND backup_finish_Date >= @i_excludeBeforeTime
-- Fetch archive file information for above subclients.
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
CREATE TABLE #archFileIdTable
(
	archFileId INT,
	commCellId INT,
	jobId INT
)
CREATE CLUSTERED INDEX IX_temp_table_archFileIdTable ON #archFileIdTable(archFileId, commCellId, jobId)
-- Create JobIdTable to consider only completed jobs
IF object_id('tempdb.dbo.#JobIdTable') is not null DROP TABLE #JobIdTable
CREATE TABLE #JobIdTable
(
	jobId INT,
	commCellId INT,
	archCopyId INT,
	fileType INT
	PRIMARY KEY (jobId, commCellId, archCopyId, fileType)
)
-- Fetch archive files that falls in the given time range considering completed jobs
IF @i_copyPrecedence = 0
BEGIN
	IF @i_includeAgedData  = 0
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A
	  WHERE JDS.appId = A.appId
	  AND	 JDS.status = 100
	  AND	 JDS.disabled & 256 = 0
	  AND	 JDS.dataType IN (1, 4)
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
		AND AFC.flags & 256 = 0
	END
	ELSE
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A
	  WHERE JDS.appId = A.appId
	  AND	 JDS.status = 100
	  AND	 JDS.dataType IN (1, 4)
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
	END
END
ELSE
BEGIN
	IF @i_includeAgedData  = 0
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A, archGroupCopy AGC WITH (NOLOCK)
	  WHERE JDS.appId = A.appId
	  AND JDS.status = 100
	  AND JDS.disabled & 256 = 0
	  AND JDS.dataType IN (1, 4)
	  AND JDS.archGrpCopyId = AGC.id
	  AND (AGC.copy = @i_copyPrecedence OR (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))))
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
		AND AFC.flags & 256 = 0
	END
	ELSE
	BEGIN
		INSERT INTO #JobIdTable
    SELECT jobId, commcellId, archGrpCopyId, dataType
	  FROM JMJobDataStats JDS WITH (NOLOCK), #appIdTable A, archGroupCopy AGC WITH (NOLOCK)
	  WHERE JDS.appId = A.appId
	  AND JDS.status = 100
	  AND JDS.dataType IN (1, 4)
	  AND JDS.archGrpCopyId = AGC.id
	  AND (AGC.copy = @i_copyPrecedence OR (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK))))
	  INSERT INTO #archFileIdTable
		select DISTINCT AF.id, AF.commCellId, AF.jobId
		from archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK),  #JobIdTable J
		WHERE AF.jobId = J.jobId
		AND AF.commcellId = J.commcellId
		AND	AF.fileType = J.fileType
		AND	AF.isValid = 1
		AND	AF.id = AFC.archFileId
		AND AF.commCellId = AFC.commCellId
		AND	AFC.archCopyId = J.archCopyId
		AND	AFC.isValid > 0
	END
END
-- Drop table #JobIdTable since it is no longer required.
IF object_id('tempdb.dbo.#JobIdTable') IS NOT NULL DROP TABLE #JobIdTable
update #archFileIdTable
	set #archFileIdTable.commCellId = JMPreparedJob.commCellId, #archFileIdTable.jobId = JMPreparedJob.jobId, #archFileIdTable.archFileId = archFile.id
from JMPreparedJob, archFile
WHERE JMPreparedJob.preparedJobId = #archFileIdTable.jobId and
	JMPreparedJob.preparedJobCCId = #archFileIdTable.commCellId AND
	archFile.jobId = JMPreparedJob.jobId and
	archFile.commCellId = JMPreparedJob.commCellId
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
	CREATE TABLE #sqlDbBackupFileIdTable (sqlDbBackupFileId INT, commCellId INT, PRIMARY KEY (commCellId, sqlDbBackupFileId))
INSERT  INTO #sqlDbBackupFileIdTable
	SELECT  DISTINCT sqlDbBackupFileId, b.commCellId
	FROM    sqlArchiveInfo a, #archFileIdTable b
	WHERE   a.aFileId = b.archFileId AND a.commCellId = b.commCellId
INSERT  INTO #sqlDbBackupFileIdTable
	SELECT  DISTINCT dbinfo.ID, afid.commCellId
	FROM sqldbbackupinfo dbinfo, #archFileIdTable afid
	WHERE
	dbinfo.jobId = afid.jobId and
	dbinfo.id not in (select sqlDbBackupFileId from #sqlDbBackupFileIdTable) and
	dbinfo.backupMethod = 2
IF object_id('tempdb.dbo.#finalDatabaseList') is not null DROP TABLE #finalDatabaseList
	CREATE TABLE #finalDatabaseList (databaseName nvarchar(1024), databaseId int, version nvarchar(256),
			sqlNameId int, backup_finish_date int, jobId int, lastBkpSet int, mjrVersion int,
			lastLsn NUMERIC(25, 0), fullBkpLsn NUMERIC(25, 0), bkpType char, minorVersion int, buildVersion int, commCellId int)
-- Get last backup details
;WITH last_bkp_details (backup_finish_time, sqlnameId, BkpSetId, commCellId, row_num) AS
	(SELECT b.backup_finish_date, b.sqlNameId, b.id, a.commCellId, ROW_NUMBER() OVER (PARTITION BY  b.sqlNameId ORDER BY backup_finish_date DESC)
		from #sqlDbBackupFileIdTable a
		JOIN sqlDbBackupInfo b ON b.id = a.sqlDbBackupFileId)
	INSERT INTO #finalDatabaseList
		select sntbl.name, sdbi.dbId, concat(sdbi.majorVersion, '.', sdbi.minorVersion, '.', sdbi.buildVersion) as version,
			sdbi.sqlNameId, lbd.backup_finish_time, sdbi.jobId, sdbi.id as bkpSetId,
			sdbi.majorVersion, sdbi.last_lsn, sdbi.full_bkup_lsn, sdbi.type, sdbi.minorVersion, sdbi.buildVersion, lbd.commCellId
		FROM last_bkp_details lbd
		JOIN sqlDbBackupInfo sdbi ON lbd.sqlNameId = sdbi.sqlNameId AND sdbi.instanceId = @i_ServerId AND lbd.BkpSetId = sdbi.id
		JOIN #sqlNameIdTbl sntbl on lbd.sqlNameId = sntbl.sqlNameId
		WHERE lbd.row_num = 1
-- Lets get the FULL backup details now.
IF OBJECT_ID('tempdb.dbo.#fullBackupInfo') is not null DROP TABLE #fullBackupInfo
	CREATE TABLE #fullBackupInfo (sqlNameId int, fullBkpSet int, backup_finish_date int, jobId int, backupmethod int, appId int, cloneable int)
;WITH SqlFullBkp (SqlNameId, fullBkpSet, BkpFinTime, AppId, BkpMethod, jobId, rn)  AS
	(select s.sqlNameId, s.id, s.backup_finish_Date, s.appId, s.backupmethod, s.jobId,
		ROW_NUMBER() OVER (PARTITION BY  s.sqlNameId ORDER BY s.backup_finish_date DESC) rn
		FROM  sqlDbBackupInfo s
		JOIN #finalDatabaseList f ON s.sqlNameId = f.sqlNameId AND s.instanceId = @i_ServerId AND s.backup_finish_Date <= @i_unixTime
		WHERE (f.bkpType = 'D' AND f.lastBkpSet = s.id ) OR
			(f.mjrVersion = 7 and s.last_lsn = f.lastLsn and s.type = 'D') OR
			(f.mjrVersion >= 8 AND s.checkpoint_lsn = f.fullBkpLsn and s.type IN ('D', 'P')) OR
			(s.type IN ('D', 'P')))
	INSERT INTO #fullBackupInfo
		SELECT SqlNameId, fullBkpSet, BkpFinTime, jobId, BkpMethod, AppId, 0
		from SqlFullBkp WHERE rn = 1
SET @ioXmlInput = ISNULL((SELECT (SELECT fdl. databaseName AS '@dbName', fdl.lastBkpSet AS '@sqlBackupSetId', 'D' AS '@bkpType',
									fdl.backup_finish_date AS '@time', fbi.backupmethod AS '@backupmethod'
									FROM #finalDatabaseList fdl
									JOIN #fullBackupInfo fbi ON fdl.sqlNameId = fbi.sqlNameId FOR XML PATH('listSQLBackupSetItem'), type)
									FOR XML PATH(''), root('SQLiDA_GetSQLDatabasesDevicesRsp')), N'<SQLiDA_GetSQLDatabasesDevicesRsp />')
SELECT @ioXmlInput
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetDatabasesDevices')
	delete from GxQscripts where name = 'SqlGetDatabasesDevices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetDatabasesDevices')
	delete from GXDBVersions where aliasname = 'SqlGetDatabasesDevices'
GO

insert into GXDBVersions values(2, 'SqlGetDatabasesDevices',  '00000000000000000000', 'SqlGetDatabasesDevices', '00000000000000000000')
GO

