

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetBackupChainHoles.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault  Systems, Inc.
--        The copyright notice above does not evidence any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SqlGetBackupChainHoles')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetBackupChainHoles <<<'
	drop procedure SqlGetBackupChainHoles
END
IF EXISTS (select * from GxQscripts where name='SqlGetBackupChainHoles')
	delete from GxQscripts where name = 'SqlGetBackupChainHoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetBackupChainHoles')
	delete from GXDBVersions where aliasname = 'SqlGetBackupChainHoles'
GO
print '... Creating Procedure: SqlGetBackupChainHoles'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SqlGetBackupChainHoles
  @ioXml XML
AS
  DECLARE @outXML XML
/*
	SqlGetBackupChainHoles SP was introduced to find if any holes created in the SQL backup chain and make decision to run FULL backups.
	This will take the XML input containing instance ID and database name.
	When SP finds any hole in the chain, it will be returned to the caller.
	To get the output from this SP inside another SP, we can use the well-known table created prior to its caller.
		IF OBJECT_ID('tempdb..#ot_SqlGetBackupChainHoles') IS NOT NULL DROP TABLE #ot_SqlGetBackupChainHoles
		CREATE TABLE #ot_SqlGetBackupChainHoles (outXML XML)
	We have removed the OUTPUT parameter as it is no longer called from C++ layer.
	Caller SP will get the response from known table.
	Upon error, we return error code XML and will be ignored at the caller site.
*/
-- Pre-requisites.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
BEGIN TRY
	-- Inputs.
	DECLARE @instanceId INTEGER = ISNULL((SELECT @ioXml.value('(/SQLiDA_SqlGetBackupChainHoleReq/entity/@instanceId)[1]','INT')), 0)
	DECLARE @SqlDatabaseName NVARCHAR(1024) = ISNULL((SELECT @ioXml.value('(/SQLiDA_SqlGetBackupChainHoleReq/@database)[1]','NVARCHAR(1024)')), N'')
	-- Validate the inputs
	IF @instanceId = 0 OR @SqlDatabaseName IS NULL OR @SqlDatabaseName = N'' OR LEN(@SqlDatabaseName) = 0
	BEGIN
		SET @errorCode = 100
		SET @ioXml = ISNULL((SELECT 100 AS '@errorCode', 'Invalid parameters. Please check the input xml.' AS '@errorMessage'
			FOR XML PATH('SQLiDA_GenericResp'), TYPE), '<SQLiDA_GenericResp />')
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb..#tChainPenUltimate') IS NOT NULL DROP TABLE #tChainPenUltimate
		CREATE TABLE #tChainUltimate (rn INT IDENTITY(1,1) PRIMARY KEY, backupId INT, firstLSN NUMERIC(32,0), lastLSN NUMERIC(32,0), type CHAR, backup_start_time INT, backup_finish_time INT)
		CREATE INDEX IDX_Chain_LSN_time ON #tChainUltimate (backupId, backup_finish_time, lastLSN)
		DECLARE @SQLNamesTable TABLE(ID INT)
		INSERT INTO @SQLNamesTable
			SELECT  SN.id
			FROM sqlNames SN
				JOIN sqlNames2 SN2
					ON SN2.name = @SqlDatabaseName
						AND SN2.type = 1
						AND SN.sqlId = SN2.id
						AND SN.type = 1
		-- Get ultimate or latest FULL details
		DECLARE @UltiFullLastLSN NUMERIC(32,0) = 0
		DECLARE @UltiFullFirstLSN NUMERIC(32,0) = 0
		DECLARE @UltiFullStartTime INT = 0
		DECLARE @UltiFullEndTime INT = 0
		SELECT TOP 1 @UltiFullFirstLSN = SD.first_lsn,
			@UltiFullLastLSN = SD.last_lsn,
			@UltiFullStartTime = SD.backup_start_Date,
			@UltiFullEndTime = SD.backup_finish_Date
		FROM sqlDbBackupInfo SD
			JOIN @SQLNamesTable SN
				ON SD.instanceId = @instanceId
					AND SN.id = SD.sqlNameId
		WHERE SD.type = 'D'
		ORDER BY SD.backup_finish_Date DESC
		INSERT INTO #tChainUltimate
			-- Gets the first LOG chained to the found FULL.
			SELECT SD.id,
					SD.first_lsn,
					SD.last_lsn,
					SD.type,
					SD.backup_start_Date,
					SD.backup_finish_Date
				FROM sqlDbBackupInfo SD
					JOIN @SQLNamesTable SN
						ON SD.instanceId = @instanceId
							AND SN.id = SD.sqlNameId
				WHERE SD.type = 'L'
					AND SD.first_lsn < @UltiFullLastLSN
					AND SD.last_lsn >= @UltiFullLastLSN
					AND SD.backup_finish_Date >= @UltiFullEndTime
			UNION
			-- Get the log backups after the found full.
			SELECT SD.id,
					SD.first_lsn,
					SD.last_lsn,
					SD.type,
					SD.backup_start_Date,
					SD.backup_finish_Date
				FROM sqlDbBackupInfo SD
					JOIN @SQLNamesTable SN
						ON SD.instanceId = @instanceId
							AND SN.id = SD.sqlNameId
				WHERE SD.type = 'L'
					AND SD.last_lsn > @UltiFullLastLSN
					AND SD.backup_finish_Date > @UltiFullEndTime
		-- Find all the holes
		IF OBJECT_ID('tempdb..#tDetectedHoles') IS NOT NULL DROP TABLE #tDetectedHoles
		CREATE TABLE #tDetectedHoles (HoleId INT IDENTITY(1,1) PRIMARY KEY, startHoleBkpId INT, startHoleLastLSN NUMERIC(32,0), startHoleTime INT, endHoleBkpId INT, endHoleLastLSN NUMERIC(32,0), endHoleTime INT)
		INSERT INTO #tDetectedHoles
			SELECT ISNULL(rt.backupId, 0),
				rt.lastLSN,
				rt.backup_finish_time,
				ISNULL(lt.backupId, 0),
				lt.lastLSN,
				lt.backup_finish_time
			FROM #tChainUltimate lt
				JOIN #tChainUltimate rt
					ON rt.rn = lt.rn-1
			WHERE lt.lastLSN IS NOT NULL
				AND rt.firstLSN IS NOT NULL
				AND rt.lastLSN <> lt.firstLSN
		SET @ioXml = ISNULL((SELECT
						(SELECT TH.HoleId       AS '@holeId',
							TH.endHoleLastLSN   AS '@holeEndLSN',
							TH.endHoleTime      AS '@holeEndLSNTime',
							TH.startHoleLastLSN AS '@holeStartLSN',
							TH.startHoleTime    AS '@holeStartLSNTime'
						FROM #tDetectedHoles TH
						WHERE TH.HoleId = 1
						FOR XML PATH('SqlBackupHole'), TYPE)
					FOR XML PATH(''), ROOT('SQLiDA_SqlGetBackupChainHoleResp')), N'<SQLiDA_SqlGetBackupChainHoleResp />')
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @ioXml = ISNULL((SELECT @errorCode AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
			FOR XML PATH('SQLiDA_GenericResp'), TYPE), '<SQLiDA_GenericResp />')
END   CATCH
IF OBJECT_ID('tempdb..#ot_SqlGetBackupChainHoles') IS NOT NULL
	INSERT INTO #ot_SqlGetBackupChainHoles VALUES(@ioXml)
ELSE IF OBJECT_ID('tempdb..#ot_SqlGetBackupChainHoles') IS NULL
	SELECT @ioXml AS outXML

IF EXISTS (select * from GxQscripts where name = 'SqlGetBackupChainHoles')
	delete from GxQscripts where name = 'SqlGetBackupChainHoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetBackupChainHoles')
	delete from GXDBVersions where aliasname = 'SqlGetBackupChainHoles'
GO

insert into GXDBVersions values(2, 'SqlGetBackupChainHoles',  '00000000000000000000', 'SqlGetBackupChainHoles', '00000000000000000000')
GO

