

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetAFilesForFFGRestore_V1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetAFilesForFFGRestore_V1.sp,v $ $Id: SqlGetAFilesForFFGRestore_V1.sp,v 1.8.204.4 2020/09/08 15:57:05 shussain Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetAFilesForFFGRestore_V1
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Kiran & Anup		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SqlGetAFilesForFFGRestore_V1')
BEGIN
	print '>>> Drop Stored Procedure: SqlGetAFilesForFFGRestore_V1 <<<'
	drop procedure SqlGetAFilesForFFGRestore_V1
END
IF EXISTS (select * from GxQscripts where name='SqlGetAFilesForFFGRestore_V1')
	delete from GxQscripts where name = 'SqlGetAFilesForFFGRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetAFilesForFFGRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetAFilesForFFGRestore_V1'
GO
print '... Creating Procedure: SqlGetAFilesForFFGRestore_V1'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetAFilesForFFGRestore_V1
  @i_instanceId INTEGER,
  @i_databaseName NVARCHAR(1024),
  @i_restoreType INTEGER,
  @i_browseTime INTEGER,
  @i_requestTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_includeAgedData integer,
  @i_logicalFileName NVARCHAR(1024)
AS
  DECLARE @o_backupsetId INTEGER;
DECLARE @backupRowCount INTEGER
DECLARE @i_dataType INTEGER
SET @i_dataType = 1
--DECLARE @in_sqlNameId INTEGER
DECLARE @SQLNAMEIDTABLE TABLE
(
	ID INT
);
DECLARE @SQLLOGICALNAMEIDTABLE TABLE
(
	ID INT
);
IF object_id('tempdb.dbo.#dbbackupList') is not null DROP TABLE #dbbackupList
create TABLE #dbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
IF object_id('tempdb.dbo.#copydbbackupList') is not null DROP TABLE #copydbbackupList
create TABLE #copydbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
DECLARE @appIdTable TABLE
(
	appId INT
)
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
create TABLE #archFileIdTable
(
	archFileId INT,
	commCellId INT,
	jobId INT
)
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
create TABLE #sqlDbBackupFileIdTable
(
	sqlDbBackupFileId INT
)
DECLARE @BackupInfoIdTable table
(
	id INT,
	backupFinishTime INTEGER
)
DECLARE @i_sqlLogNameId INTEGER
DECLARE @lastBackupType CHAR
DECLARE @lastBackupTime INTEGER
DECLARE @lastbkpsetId INTEGER
DECLARE @majorVersion INTEGER
DECLARE @lastBackupfirstLsn NUMERIC(25, 0)
DECLARE @lastBackuplastLsn NUMERIC(25, 0)
DECLARE @lastBackupcheckpointLsn NUMERIC(25, 0)
DECLARE @lastBackupfullbackupLsn NUMERIC(25, 0)
insert into @SQLNAMEIDTABLE select SN.id from sqlNames SN JOIN sqlNames2 SN2 ON SN2.name = @i_databaseName AND SN2.type = 1 AND SN.sqlId = SN2.id AND SN.type = 1
insert into @SQLLOGICALNAMEIDTABLE select SN.id from sqlNames SN JOIN sqlNames2 SN2 ON SN2.name = @i_logicalFileName AND SN2.type = 4 AND SN.sqlId = SN2.id AND SN.type = 4
INSERT	INTO @appIdTable
	SELECT	DISTINCT appId
		FROM	sqlDbBackupInfo SDB
		WHERE	instanceId = @i_instanceId AND backup_finish_Date <= @i_browseTime
			AND sqlNameId in (select id from  @SQLNAMEIDTABLE)
	UNION
	SELECT	DISTINCT appId
		FROM	sqlDbBackupInfo SDB
		WHERE	instanceId = @i_instanceId AND SDB.type = 'L' AND SDB.begins_log_chain = 'Y'
					AND @i_browseTime > SDB.backup_start_Date AND @i_browseTime <= SDB.backup_finish_Date
			AND sqlNameId in (select id from  @SQLNAMEIDTABLE)
IF @i_copyPrecedence = 0
	INSERT	INTO #archFileIdTable
	SELECT	a.id, a.commCellId, a.jobid
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND b.archCopyId = c.id
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
ELSE
	INSERT	INTO #archFileIdTable
	SELECT	DISTINCT a.id, a.commCellId, a.jobid
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
		AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
INSERT	INTO #sqlDbBackupFileIdTable
	SELECT	DISTINCT sqlDbBackupFileId
	FROM	sqlArchiveInfo a, #archFileIdTable b
	WHERE	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
insert into #dbbackupList
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
	from sqldbbackupinfo SDBI JOIN #sqlDbBackupFileIdTable SF ON SDBI.id = SF.sqlDbBackupFileId
	where  SDBI.sqlNameId in (select id from @SQLNAMEIDTABLE) and SDBI.instanceId = @i_instanceId and
	(SDBI.backup_finish_date <= @i_browseTime) and
	SDBI.majorVersion > 7 AND
	NOT EXISTS (SELECT * from sqlfilebackupinfo SFBI where
					SFBI.sqlDbBackupInfoId = SDBI.id and SFBI.type = 100 )
	UNION
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
		from sqldbbackupinfo SDBI JOIN #sqlDbBackupFileIdTable SF ON SDBI.id = SF.sqlDbBackupFileId
		where  SDBI.sqlNameId in (select id from @SQLNAMEIDTABLE) and SDBI.instanceId = @i_instanceId and
			SDBI.type = 'L' AND SDBI.begins_log_chain = 'Y' AND @i_browseTime > SDBI.backup_start_Date AND
			@i_browseTime <= SDBI.backup_finish_Date and SDBI.majorVersion > 7 AND
			NOT EXISTS (SELECT * from sqlfilebackupinfo SFBI where
						SFBI.sqlDbBackupInfoId = SDBI.id and SFBI.type = 100 )
	ORDER BY SDBI.backup_finish_date DESC
select top 1 @majorVersion = majorVersion, @lastBackupType = backupType,
		@lastbkpsetId = backupsetId, @lastBackupTime = backupFinishTime,
		@lastBackupfirstLsn = firstLsn,  @lastBackuplastLsn = lastLsn,
		@lastBackupcheckpointLsn = checkpointLsn, @lastBackupfullbackupLsn = fullbackupLsn
from #dbbackupList ORDER BY backupFinishTime DESC
-- Removing the check for LOG backup as it is not required.
-- SIMPLE recovery model databases cannot have LOG backup and for such databases, there is no support of FFG restore.
-- Considering the FFG restores for SIMPLE databases, following condition was removed.
IF(@majorVersion > 7)
BEGIN
	DECLARE @fullBackupSetId  INTEGER
	DECLARE @fullbackupFinishTime INTEGER
	DECLARE @firstLsn NUMERIC(25, 0)
	DECLARE @lastLsn NUMERIC(25, 0)
	DECLARE @checkpointLsn NUMERIC(25, 0)
	DECLARE @fullbkpLsn NUMERIC(25, 0)
	DECLARE @version INTEGER
	set @fullBackupSetId = 0
	select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
			   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn
	from #dbbackupList
	where
	checkpointLsn = @lastBackupfullbackupLsn and backupType = 'D'
	IF(@fullBackupSetId = 0)
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
			   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn
		from #dbbackupList
		where
		backupType = 'D'
		order by backupFinishTime desc
	END
	IF(@fullBackupSetId = 0 and @majorVersion > 8)
	BEGIN
		select TOP 1 @fullBackupSetId = DBL.backupsetId, @lastLsn = DBL.lastLsn, @fullbackupFinishTime = DBL.backupFinishTime,
			   @firstLsn = DBL.firstLsn, @lastLsn = DBL.lastLsn, @checkpointLsn = DBL.checkpointLsn, @fullbkpLsn = DBL.fullbackupLsn
		from #dbbackupList DBL
		where
		DBL.backupType = 'P'
		AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = DBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
				)
		order by backupFinishTime desc
	END
	IF(@fullBackupSetId = 0)
	BEGIN
		select TOP 1 @fullBackupSetId = DBL.backupsetId, @lastLsn = DBL.lastLsn, @fullbackupFinishTime = DBL.backupFinishTime,
		       @firstLsn = DBL.firstLsn, @lastLsn = DBL.lastLsn, @checkpointLsn = DBL.checkpointLsn, @fullbkpLsn = DBL.fullbackupLsn
		from #dbbackupList DBL
		where
		backupType = 'F'
		AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = DBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
				)
		order by backupFinishTime desc
	END
	BEGIN
		INSERT INTO #copydbbackupList
			SELECT * FROM #dbbackupList DBL
			WHERE
			DBL.backupFinishTime >=  @fullbackupFinishTime
			AND DBL.backupType in ('F', 'G', 'I', 'Q', 'P', 'D')
			AND exists (
							select * from sqlfilebackupinfo FBI
							where
							FBI.sqlDbBackupInfoId = DBL.backupSetId
							AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
						)
			order by backupFinishTime ASC
	END
	INSERT INTO #copydbbackupList
		SELECT * FROM #dbbackupList
		WHERE
		backupFinishTime >  @fullbackupFinishTime
		AND backupType = 'L'
		AND fullbackupLsn = @lastBackupfullbackupLsn
		order by backupFinishTime ASC
	DECLARE @latestDiffFinishTime INTEGER
	DECLARE @latestPartialFullFinishTime INTEGER
	DECLARE @latestPartialDiffFinishTime INTEGER
	DECLARE @latestFileFullBackupTime INTEGER
	DECLARE @latestFileDiffBackupTime INTEGER
	select @latestFileFullBackupTime = MAX(CBL.backupFinishTime)
	from #copydbbackupList CBL
	where CBL.backupType = 'F'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
			   )
	select @latestFileDiffBackupTime = MAX(CBL.backupFinishTime)
	from #copydbbackupList CBL
	where CBL.backupType = 'G'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
			   )
	select @latestDiffFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'I'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
			   )
	select @latestPartialFullFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'P'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
			   )
	select @latestPartialDiffFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'Q'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)
			   )
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestFileFullBackupTime
	and backupType in ('F', 'G', 'L', 'I', 'P', 'Q', 'D')
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestFileDiffBackupTime
	and backupType in ('G', 'I', 'Q', 'L')
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestDiffFinishTime
	and backupType in ('G', 'I', 'Q', 'L')
	and backupsetId <> @fullBackupSetId
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestPartialFullFinishTime
	and backupType in ('F', 'L', 'P', 'Q')
	and backupsetId <> @fullBackupSetId
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestPartialDiffFinishTime
	and backupType in ('G', 'I', 'L', 'Q')
	INSERT INTO @BackupInfoIdTable
		select distinct CBL.backupSetId, CBL.backupFinishTime
		from sqlfilebackupinfo FBI, #copydbbackupList CBL
		where CBL.backupSetId = FBI.sqlDbBackupInfoId
		AND ((FBI.sqlNameLogId in (select id from @SQLLOGICALNAMEIDTABLE)) or CBL.backupType = 'L')
		order by CBL.backupFinishTime ASC
END
select distinct BI.id
FROM @BackupInfoIdTable BI
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetAFilesForFFGRestore_V1')
	delete from GxQscripts where name = 'SqlGetAFilesForFFGRestore_V1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetAFilesForFFGRestore_V1')
	delete from GXDBVersions where aliasname = 'SqlGetAFilesForFFGRestore_V1'
GO

insert into GXDBVersions values(2, 'SqlGetAFilesForFFGRestore_V1',  '00010008020400040000', 'SqlGetAFilesForFFGRestore_V1', '00010008020400040000')
GO

