

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlGetAFilesForFFGRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlGetAFilesForFFGRestore.sp,v $ $Id: SqlGetAFilesForFFGRestore.sp,v 1.14.204.1 2018/03/27 08:57:37 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlGetAFilesForFFGRestore
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlGetAFilesForFFGRestore <<<'

IF EXISTS (select * from sysobjects where name='SqlGetAFilesForFFGRestore')
	drop procedure SqlGetAFilesForFFGRestore
IF EXISTS (select * from GxQscripts where name='SqlGetAFilesForFFGRestore')
	delete from GxQscripts where name = 'SqlGetAFilesForFFGRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetAFilesForFFGRestore')
	delete from GXDBVersions where aliasname = 'SqlGetAFilesForFFGRestore'
GO
print '... Creating Procedure: SqlGetAFilesForFFGRestore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlGetAFilesForFFGRestore
  @i_instanceId INTEGER,
  @i_databaseName VARCHAR(1024),
  @i_restoreType INTEGER,
  @i_browseTime INTEGER,
  @i_requestTime INTEGER,
  @i_copyPrecedence INTEGER,
  @i_includeAgedData integer,
  @i_logicalFileName VARCHAR(1024)
AS
  DECLARE @o_backupsetId INTEGER;
DECLARE @backupRowCount INTEGER
DECLARE @i_dataType INTEGER
SET @i_dataType = 1
--DECLARE @in_sqlNameId INTEGER
DECLARE @SqldatabaseNames Table
(
	id INT
);
DECLARE @SqlLogicalFilestoRestore Table
(
	id INT
);
IF object_id('tempdb.dbo.#dbbackupList') is not null DROP TABLE #dbbackupList
create TABLE #dbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
IF object_id('tempdb.dbo.#copydbbackupList') is not null DROP TABLE #copydbbackupList
create TABLE #copydbbackupList
(
	backupsetId INTEGER,
	backupType  CHAR,
	backupFinishTime INTEGER,
	majorVersion INTEGER,
	firstLsn NUMERIC(25, 0),
	lastLsn NUMERIC(25, 0),
	checkpointLsn NUMERIC(25, 0),
	fullbackupLsn NUMERIC(25, 0)
)
DECLARE @appIdTable TABLE
(
	appId INT
)
IF object_id('tempdb.dbo.#archFileIdTable') is not null DROP TABLE #archFileIdTable
create TABLE #archFileIdTable
(
	archFileId INT,
	commCellId INT
)
IF object_id('tempdb.dbo.#sqlDbBackupFileIdTable') is not null DROP TABLE #sqlDbBackupFileIdTable
create TABLE #sqlDbBackupFileIdTable
(
	sqlDbBackupFileId INT
)
DECLARE @BackupInfoIdTable table
(
	id INT,
	backupFinishTime INTEGER
)
DECLARE @i_sqlLogNameId INTEGER
DECLARE @lastBackupType CHAR
DECLARE @lastBackupTime INTEGER
DECLARE @lastbkpsetId INTEGER
DECLARE @majorVersion INTEGER
DECLARE @lastBackupfirstLsn NUMERIC(25, 0)
DECLARE @lastBackuplastLsn NUMERIC(25, 0)
DECLARE @lastBackupcheckpointLsn NUMERIC(25, 0)
DECLARE @lastBackupfullbackupLsn NUMERIC(25, 0)
insert into @SqldatabaseNames SELECT id from sqlNames where id in (select id from sqlNames where  name = @i_databaseName and type = 1) and type = 1
insert into @SqlLogicalFilestoRestore SELECT  id from sqlNames where id in (select id from sqlNames where  name = @i_logicalFileName and type = 4) and type = 4
INSERT	INTO @appIdTable
SELECT	DISTINCT appId
FROM	sqlDbBackupInfo
WHERE	instanceId = @i_instanceId
	AND backup_finish_Date <= @i_browseTime
	AND sqlNameId in (select id from @SqldatabaseNames)
IF @i_copyPrecedence = 0
	INSERT	INTO #archFileIdTable
	SELECT	a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND b.archCopyId = c.id
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
ELSE
	INSERT	INTO #archFileIdTable
	SELECT	DISTINCT a.id, a.commCellId
	FROM	archFile a, archFileCopy b, archGroupCopy c
	WHERE	a.appId IN (SELECT appId FROM @appIdTable)
		AND a.id = b.archFileId AND a.commCellId = b.commCellId
		AND b.archCopyId = c.id AND a.archGroupId = c.archGroupId
		AND a.fileType in (1, 4)
		AND a.cTime <= @i_browseTime
		AND b.isValid > 0 AND (@i_includeAgedData <> 0 OR (b.flags & 256) = 0)
		AND c.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
		AND (c.copy = @i_copyPrecedence OR @i_copyPrecedence = -1 AND c.id IN (SELECT defaultCopy FROM archGroup))
INSERT	INTO #sqlDbBackupFileIdTable
	SELECT	DISTINCT sqlDbBackupFileId
	FROM	sqlArchiveInfo a, #archFileIdTable b
	WHERE	a.aFileId = b.archFileId AND a.commCellId = b.commCellId
insert into #dbbackupList
	select SDBI.id, SDBI.type, SDBI.backup_finish_date, SDBI.majorVersion, SDBI.first_lsn, SDBI.last_lsn, SDBI.checkpoint_lsn, SDBI.full_bkup_lsn
	from sqldbbackupinfo SDBI
	where
	SDBI.id in (select sqlDbBackupFileId from #sqlDbBackupFileIdTable) and
	SDBI.sqlNameId in(select id from @SqldatabaseNames) and
	SDBI.instanceId = @i_instanceId and
	SDBI.backup_finish_date <= @i_browseTime and
	SDBI.majorVersion > 7 and
	not exists (
					select * from sqlfilebackupinfo SFBI
					where
					SFBI.sqlDbBackupInfoId = SDBI.id
					and SFBI.type = 100
				)
	order by SDBI.id DESC
select top 1 @majorVersion = majorVersion, @lastBackupType = backupType,
		@lastbkpsetId = backupsetId, @lastBackupTime = backupFinishTime,
		@lastBackupfirstLsn = firstLsn,  @lastBackuplastLsn = lastLsn,
		@lastBackupcheckpointLsn = checkpointLsn, @lastBackupfullbackupLsn = fullbackupLsn
from #dbbackupList
IF(@lastBackupType = 'L' and @majorVersion > 7)
BEGIN
	DECLARE @fullBackupSetId  INTEGER
	DECLARE @fullbackupFinishTime INTEGER
	DECLARE @firstLsn NUMERIC(25, 0)
	DECLARE @lastLsn NUMERIC(25, 0)
	DECLARE @checkpointLsn NUMERIC(25, 0)
	DECLARE @fullbkpLsn NUMERIC(25, 0)
	DECLARE @version INTEGER
	set @fullBackupSetId = 0
	select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
			   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn
	from #dbbackupList
	where
	checkpointLsn = @lastBackupfullbackupLsn and backupType = 'D'
	IF(@fullBackupSetId = 0)
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
			   @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn
		from #dbbackupList
		where
		backupType = 'D'
		order by backupFinishTime desc
	END
	IF(@fullBackupSetId = 0 and @majorVersion > 8)
	BEGIN
		select TOP 1 @fullBackupSetId = DBL.backupsetId, @lastLsn = DBL.lastLsn, @fullbackupFinishTime = DBL.backupFinishTime,
			   @firstLsn = DBL.firstLsn, @lastLsn = DBL.lastLsn, @checkpointLsn = DBL.checkpointLsn, @fullbkpLsn = DBL.fullbackupLsn
		from #dbbackupList DBL
		where
		DBL.backupType = 'P'
		AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = DBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
				)
		order by backupFinishTime desc
	END
	IF(@fullBackupSetId = 0)
	BEGIN
		select TOP 1 @fullBackupSetId = backupsetId, @lastLsn = lastLsn, @fullbackupFinishTime = backupFinishTime,
		       @firstLsn = firstLsn, @lastLsn = lastLsn, @checkpointLsn = checkpointLsn, @fullbkpLsn = fullbackupLsn
		from #dbbackupList
		where
		backupType = 'F'
	END
	BEGIN
		INSERT INTO #copydbbackupList
			SELECT * FROM #dbbackupList DBL
			WHERE
			DBL.backupFinishTime >=  @fullbackupFinishTime
			AND DBL.backupType in ('F', 'G', 'I', 'Q', 'P', 'D')
			AND exists (
							select * from sqlfilebackupinfo FBI
							where
							FBI.sqlDbBackupInfoId = DBL.backupSetId
							AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
						)
			order by backupFinishTime ASC
	END
	INSERT INTO #copydbbackupList
		SELECT * FROM #dbbackupList
		WHERE
		backupFinishTime >  @fullbackupFinishTime
		AND backupType = 'L'
		AND fullbackupLsn = @lastBackupfullbackupLsn
		order by backupFinishTime ASC
	DECLARE @latestDiffFinishTime INTEGER
	DECLARE @latestPartialFullFinishTime INTEGER
	DECLARE @latestPartialDiffFinishTime INTEGER
	DECLARE @latestFileFullBackupTime INTEGER
	DECLARE @latestFileDiffBackupTime INTEGER
	select @latestFileFullBackupTime = MAX(CBL.backupFinishTime)
	from #copydbbackupList CBL
	where CBL.backupType = 'F'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
			   )
	select @latestFileDiffBackupTime = MAX(CBL.backupFinishTime)
	from #copydbbackupList CBL
	where CBL.backupType = 'G'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
			   )
	select @latestDiffFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'I'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
			   )
	select @latestPartialFullFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'P'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
			   )
	select @latestPartialDiffFinishTime = MAX(backupFinishTime)
	from #copydbbackupList CBL
	where
	CBL.backupType = 'Q'
	AND exists (
					select * from sqlfilebackupinfo FBI
					where
					FBI.sqlDbBackupInfoId = CBL.backupSetId
					AND FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)
			   )
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestFileFullBackupTime
	and backupType in ('F', 'G', 'L', 'I', 'P', 'Q', 'D')
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestFileDiffBackupTime
	and backupType in ('G', 'L', 'I', 'P', 'Q', 'D')
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestDiffFinishTime
	and backupType in ('L', 'I', 'P', 'Q')
	and backupsetId <> @fullBackupSetId
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestPartialFullFinishTime
	and backupType in ('L', 'P', 'Q')
	and backupsetId <> @fullBackupSetId
	DELETE #copydbbackupList WHERE
	backupFinishTime < @latestPartialDiffFinishTime
	and backupType in ('L', 'Q')
	INSERT INTO @BackupInfoIdTable
		select distinct CBL.backupSetId, CBL.backupFinishTime
		from sqlfilebackupinfo FBI, #copydbbackupList CBL
		where CBL.backupSetId = FBI.sqlDbBackupInfoId
		AND ((FBI.sqlNameLogId in (select id from @SqlLogicalFilestoRestore)) or CBL.backupType = 'L')
		order by CBL.backupFinishTime ASC
END
select distinct BI.id
FROM @BackupInfoIdTable BI
GO

IF EXISTS (select * from GxQscripts where name = 'SqlGetAFilesForFFGRestore')
	delete from GxQscripts where name = 'SqlGetAFilesForFFGRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlGetAFilesForFFGRestore')
	delete from GXDBVersions where aliasname = 'SqlGetAFilesForFFGRestore'
GO

insert into GXDBVersions values(2, 'SqlGetAFilesForFFGRestore',  '00010014020400010000', 'SqlGetAFilesForFFGRestore', '00010014020400010000')
GO

