

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlFindRestoreJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| Stored Procedure: SqlFindRestoreJobs
--	|
--	| Description:
--	|	Find if PIT/TM/system database restore has happened on the given
--	|	sql server instance.
--  |
--	| One can create the well-known table '#ot_SqlFindRestoreJobs' to get any restore jobs done for given database or system database.
--	| To get the response from this SP, please create the below table and call the SP.
--	|	IF OBJECT_ID('tempdb..#ot_SqlFindRestoreJobs') IS NOT NULL DROP TABLE #ot_SqlFindRestoreJobs
--	|	CREATE TABLE #ot_SqlFindRestoreJobs (restoreJobCount INT)
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SqlFindRestoreJobs')
BEGIN
	print '>>> Drop Stored Procedure: SqlFindRestoreJobs <<<'
	drop procedure SqlFindRestoreJobs
END
IF EXISTS (select * from GxQscripts where name='SqlFindRestoreJobs')
	delete from GxQscripts where name = 'SqlFindRestoreJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlFindRestoreJobs')
	delete from GXDBVersions where aliasname = 'SqlFindRestoreJobs'
GO
print '... Creating Procedure: SqlFindRestoreJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SqlFindRestoreJobs
  @i_instanceId integer,
  @i_backupFinishTime integer,
  @i_databaseName NVARCHAR(256)
AS
  DECLARE @o_rowCount INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_rowCount = 0
-------------------------------------------------------------
-- We need to retrieve rows from JMJobOptions table with
-- the given instance id. If there have been restores then
-- we would get restore JobId and commcell id.
-------------------------------------------------------------
IF object_id('tempdb.dbo.#JMRestoreJobs') is not null DROP TABLE #JMRestoreJobs
CREATE TABLE #JMRestoreJobs (
	JMRstId  INTEGER IDENTITY(1,1) PRIMARY KEY,
	JobId INTEGER NOT NULL,
	CommcellId INTEGER NOT NULL)
CREATE NONCLUSTERED INDEX IDX_JMRestoreJobs_JobId_CommcellId ON #JMRestoreJobs(JobId, CommcellId)
INSERT INTO #JMRestoreJobs
	SELECT DISTINCT JMRJ.jobId,
		JMRJ.commCellId
	FROM JMRestoreStats JMRS
		INNER JOIN JMJobOptions JMRJ
			ON JMRS.jobId = JMRJ.jobId
				AND JMRS.commCellId = JMRJ.commCellId
	WHERE JMRS.commCellId = 2
		AND JMRS.status = 1
		AND JMRS.servStartTime > @i_backupFinishTime
		AND JMRS.appType = 81
		AND JMRJ.attributeName = 'SYB_DEST_INST_ID'
		AND JMRJ.attributeValue = @i_instanceId
-------------------------------------------------------------
-- We need to retrieve rows from JMJobOptions table to know
-- the databases that has been restored as part of the jobids
-- in #JMRestoreJobs. We are only interseted in either the db
-- passed or system dbs if none is passed.
-------------------------------------------------------------
IF object_id('tempdb.dbo.#JMSourcePaths') is not null DROP TABLE #JMSourcePaths
CREATE TABLE #JMSourcePaths (JMRstId INT NOT NULL,
	DB NVARCHAR(256) NOT NULL,
	PRIMARY KEY(JMRstId, DB))
IF LEN(@i_databaseName) = 0
BEGIN
	INSERT INTO #JMSourcePaths
		SELECT JMRJ.JMRstId,
			JMSP.attributeValue
		FROM #JMRestoreJobs JMRJ
			JOIN JMJobOptions JMSP
				ON JMSP.jobId = JMRJ.JobId
					AND JMSP.commCellId = JMRJ.CommcellId
		WHERE JMSP.attributeName = 'Source Path'
			AND JMSP.attributeValue IN ('master', 'model', 'msdb')
END
ELSE
BEGIN
	INSERT INTO #JMSourcePaths
		SELECT JMRJ.JMRstId,
			JMSP.attributeValue
		FROM #JMRestoreJobs JMRJ
			JOIN JMJobOptions JMSP
				ON JMSP.jobId = JMRJ.JobId
					AND JMSP.commCellId = JMRJ.CommcellId
		WHERE JMSP.attributeName = 'Source Path'
			AND JMSP.attributeValue = @i_databaseName
END
-------------------------------------------------------------
-- Now we need to retrieve the options with which the
-- database(s) was (were) restored.
-------------------------------------------------------------
IF object_id('tempdb.dbo.#JMRestoreOptions') IS NOT NULL DROP TABLE #JMRestoreOptions
CREATE TABLE #JMRestoreOptions(JMRstId INT NOT NULL,
	Options BIGINT NOT NULL,
	PRIMARY KEY (JMRstId, Options))
INSERT INTO #JMRestoreOptions
	SELECT DISTINCT JMRJ.JMRstId,
		JMRO.attributeValue
	FROM #JMSourcePaths JMSP
		JOIN #JMRestoreJobs JMRJ
			ON JMRJ.JMRstId = JMSP.JMRstId
		JOIN JMJobOptions JMRO
			ON JMRJ.jobId = JMRO.JobId
				AND JMRJ.commCellId = JMRO.CommcellId
	WHERE JMRO.attributeName = 'EV_RST_SQL_RESTORE_OPTIONS'
DECLARE @rcnt INT = 0
---------------------------------------------------------------
-- Lets consolidate the result and populate #JMJobInfo
-- We need those jobs only which are in-place restores.
-- In case of inplace restore, destination path is not present.
---------------------------------------------------------------
IF object_id('tempdb.dbo.#JMJobInfo') is not null DROP TABLE #JMJobInfo
CREATE TABLE #JMJobInfo (JobId INTEGER,
	CommcellId INTEGER,
	DatabaseName NVARCHAR(256),
	Options INTEGER)
INSERT INTO #JMJobInfo
	SELECT JMRJ.JobId, JMRJ.CommcellId, JMSP.DB, JMRO.Options
		FROM #JMRestoreJobs JMRJ
			JOIN #JMSourcePaths JMSP
				ON JMRJ.JMRstId = JMSP.JMRstId
			INNER JOIN #JMRestoreOptions JMRO
				ON JMSP.JMRstId = JMRO.JMRstId
			LEFT OUTER JOIN (
				  SELECT jobId, commcellId, attributeValue
					FROM JMJobOptions
					WHERE attributeName = 'Destination Path' ) AS JMDestPaths
			ON JMRJ.jobId = JMDestPaths.jobId
				AND JMRJ.commCellId = JMDestPaths.commcellId
		WHERE JMDestPaths.jobId IS NULL
-- Row count variable is introduced to avoid the table scan again.
SELECT @rcnt = @@ROWCOUNT
----------------------------------------------------------------------------------------------------
-- Lets return the rows considering options if database name is passed.
----------------------------------------------------------------------------------------------------
IF OBJECT_ID('tempdb..#ot_SqlFindRestoreJobs') IS NOT NULL
BEGIN
	IF(LEN(@i_databaseName) = 0)
	BEGIN
		INSERT INTO #ot_SqlFindRestoreJobs VALUES(@rcnt)
	END
	ELSE
	BEGIN
		INSERT INTO #ot_SqlFindRestoreJobs
		 SELECT COUNT(JobId)
			FROM #JMJobInfo
			WHERE (((Options & 8) <> 0) OR ((Options & 8192) <> 0) OR ((Options & 16384) <> 0))
	END
END
ELSE IF OBJECT_ID('tempdb..#ot_SqlFindRestoreJobs') IS NULL
BEGIN
	if(LEN(@i_databaseName) = 0)
	BEGIN
		SELECT @rcnt AS o_rowCount
	END
	ELSE
	BEGIN
		SELECT COUNT(JobId) AS o_rowCount
			FROM #JMJobInfo
			WHERE (((Options & 8) <> 0) OR ((Options & 8192) <> 0) OR ((Options & 16384) <> 0))
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SqlFindRestoreJobs')
	delete from GxQscripts where name = 'SqlFindRestoreJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlFindRestoreJobs')
	delete from GXDBVersions where aliasname = 'SqlFindRestoreJobs'
GO

insert into GXDBVersions values(2, 'SqlFindRestoreJobs',  '00000000000000000000', 'SqlFindRestoreJobs', '00000000000000000000')
GO

