

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SqlFindDependentJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SqlFindDependentJobs.sp,v $ $Id: SqlFindDependentJobs.sp,v 1.13.278.3 2018/03/27 09:03:37 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SqlFindDependentJobs
--  |
--  | Description:
--  |  Finds all the dependent jobs to be pruned
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlFindDependentJobs <<<'

IF EXISTS (select * from sysobjects where name='SqlFindDependentJobs')
	drop procedure SqlFindDependentJobs
IF EXISTS (select * from GxQscripts where name='SqlFindDependentJobs')
	delete from GxQscripts where name = 'SqlFindDependentJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlFindDependentJobs')
	delete from GXDBVersions where aliasname = 'SqlFindDependentJobs'
GO
print '... Creating Procedure: SqlFindDependentJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SqlFindDependentJobs
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @o_jobId INTEGER
  DECLARE @o_commCellId INTEGER
  DECLARE @o_appId INTEGER
  DECLARE @o_appTypeId INTEGER
  DECLARE @o_opType INTEGER
  DECLARE @o_backupLevel INTEGER
  DECLARE @o_attributes BIGINT
  DECLARE @o_startDate INTEGER
  DECLARE @o_endDate INTEGER
  DECLARE @o_sizeOfApp BIGINT
  DECLARE @o_sizeOnMedia BIGINT
  DECLARE @o_status INTEGER
  DECLARE @o_disabled INTEGER
  DECLARE @o_flags INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @backupType CHAR
DECLARE @backupFinishTime int
DECLARE @databaseCreationTime int
DECLARE @dbinfoId int
DECLARE @instanceId int
DECLARE @sqlNameId int
DECLARE @dbName VARCHAR(1024)
DECLARE @nextJobFinishTime int
DECLARE @archFileId int
DECLARE @sqlDbBackupInfoId int
DECLARE @rowCount int
DECLARE @majorVersion INTEGER
DECLARE @first_lsn VARCHAR(1024)
DECLARE @last_lsn VARCHAR(1024)
DECLARE @full_backup_lsn VARCHAR(1024)
DECLARE @check_point_lsn VARCHAR(1024)
IF object_id('tempdb.dbo.#returnTable') is not null DROP TABLE #returnTable
CREATE TABLE #returnTable
(
	sqlDbBackupFileId int,
	backupFinishTime int,
	backupType char
)
DECLARE GetSqlDbBackupInfoListForJob CURSOR FOR
	select distinct sqlDbBackupFileId
	from sqlArchiveInfo a, archFile b
	where a.commcellId = b.commCellId and a.aFileId = b.id and b.jobId = @i_jobId and b.commcellId = @i_commCellId
OPEN GetSqlDbBackupInfoListForJob
FETCH GetSqlDbBackupInfoListForJob INTO @sqlDbBackupInfoId
WHILE @@FETCH_STATUS = 0
BEGIN
	select @dbinfoId = id, @sqlNameId = sqlNameId, @instanceId = instanceId, @majorVersion = majorVersion,
	@backupType = type, @databaseCreationTime = database_creation_date,
	@backupFinishTime = backup_finish_date,
	@first_lsn = first_lsn, @last_lsn = last_lsn, @check_point_lsn = checkpoint_lsn,
	@full_backup_lsn = full_bkup_lsn
	from sqlDbBackupInfo where id = @sqlDbBackupInfoId
	IF(@backupType = 'I' or @backupType = 'L')
	BEGIN
		--CHECK IF THERE ARE DIFFERENTIAL BACKUP RAN FOR THIS JOB
		DECLARE @diffDbInfoId INT
		DECLARE @diffDbBackupFinishTime INT
		select @diffDbInfoId = id, @diffDbBackupFinishTime = backup_finish_date from sqldbbackupinfo
		where
		backup_finish_date > @backupFinishTime and
		(type = 'I' or type = 'D') and
		sqlNameId = @sqlNameId and
		instanceId = @instanceId AND
		full_bkup_lsn = @full_backup_lsn
		if(@@ROWCOUNT <> 0)
		BEGIN
			insert into #returnTable
				select id, backup_finish_date, type from sqlDbBackupinfo
				where
				backup_finish_date > @backupFinishTime and
				backup_finish_date < @diffDbBackupFinishTime and
				type not in ('I', 'D') and
				sqlNameId = @sqlNameId and
				instanceId = @instanceId AND
				full_bkup_lsn = @full_backup_lsn
				order by backup_finish_date DESC
		END
		ELSE
		BEGIN
			insert into #returnTable
				select id, backup_finish_date, type from sqlDbBackupinfo
				where
				backup_finish_date > @backupFinishTime and
				type not in ('I', 'D') and
				sqlNameId = @sqlNameId and
				instanceId = @instanceId AND
				full_bkup_lsn = @full_backup_lsn
				order by backup_finish_date DESC
		END
	END
	ELSE IF(@backupType = 'D')
	BEGIN
		--All the jobs till next Full can be pruned
		if(@majorVersion = 7)
		BEGIN
			set @check_point_lsn = @last_lsn
		END
		insert INTO #returnTable
			select id, backup_finish_date, type from sqlDbBackupinfo
			where
			backup_finish_date > @backupFinishTime and
			sqlNameId = @sqlNameId and
			instanceId = @instanceId and
			full_bkup_lsn = @check_point_lsn and
			type not in ('D')
			order by backup_finish_date DESC
	END
	FETCH GetSqlDbBackupInfoListForJob INTO @sqlDbBackupInfoId
END
CLOSE GetSqlDbBackupInfoListForJob
DEALLOCATE GetSqlDbBackupInfoListForJob
DECLARE	@tblJobs TABLE (
		jobId INT, commCellId INT, appId INT, appType INT, opType INT, backupLevel INT, attributes BIGINT,
		startDate INT, endDate INT, sizeOfApp BIGINT, sizeOnMedia BIGINT, status INT, disabled INT, flags INT)
DECLARE	@tblCopyCount TABLE (
		jobId INT, commCellId INT, dataType INT, copyCount INT)
INSERT	INTO @tblJobs
SELECT	DISTINCT J.jobId, J.commCellId, J.appId, J.appType, J.opType, J.bkpLevel, J.bkpAttributes,
		J.servStartDate, J.servEndDate, J.totalUncompBytes, 0, 0, 0, 0
FROM	JMBkpStats J, archFile as AF,
		(
			select a.aFileId, a.commCellId from sqlArchiveInfo a, #returnTable b
			where a.sqlDbBackupFileId = b.sqlDbBackupFileId
		) as SAF
WHERE	J.jobId = AF.jobId AND J.commCellId = AF.commCellId AND AF.id = SAF.aFileId and AF.commCellId = SAF.commCellId
UPDATE	@tblJobs
SET		status	= (case when (B.minStatus = 100 and B.maxStatus = 101) then 103 else B.maxStatus end),
		disabled= B.disabled, sizeOnMedia = B.sizeOnMedia
FROM	@tblJobs A,
		(SELECT	J.jobId, J.commCellId,
				MIN(J.status) AS minStatus, MAX(J.status) AS maxStatus, MAX(J.disabled) AS disabled, SUM(J.sizeOnMedia) AS sizeOnMedia
		FROM	@tblJobs T, JMJobDataStats J
		WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @i_copyId
AND (J.disabled & 256) = 0
		GROUP BY J.jobId, J.commCellId) B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
DELETE	@tblJobs
WHERE	status = 0
INSERT	INTO @tblCopyCount
SELECT	J.jobId, J.commCellId, J.dataType, COUNT(DISTINCT J.archGrpCopyId)
FROM	@tblJobs T, JMJobDataStats J
WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.status = 100 AND (J.disabled & 256) = 0
GROUP BY J.jobId, J.commCellId, J.dataType
UPDATE	@tblJobs
SET		flags = (flags | 1)
FROM	@tblJobs A, (SELECT jobId, commCellId, MIN(copyCount) AS copyCount FROM @tblCopyCount GROUP BY jobId, commCellId) B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.copyCount <= 1
SELECT	jobId, commCellId, appId, appType, opType, backupLevel, attributes, startDate, endDate,
		sizeOfApp, sizeOnMedia,	status, disabled, flags
FROM	@tblJobs
ORDER BY startDate ASC
GO

IF EXISTS (select * from GxQscripts where name = 'SqlFindDependentJobs')
	delete from GxQscripts where name = 'SqlFindDependentJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlFindDependentJobs')
	delete from GXDBVersions where aliasname = 'SqlFindDependentJobs'
GO

insert into GXDBVersions values(2, 'SqlFindDependentJobs',  '00010013027800030000', 'SqlFindDependentJobs', '00010013027800030000')
GO

