

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Sprov_GetSProvInfoForLunImport.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "Sprov_GetSProvInfoForLunImport"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Sprov_GetSProvInfoForLunImport <<<'

IF EXISTS (select * from sysobjects where name='Sprov_GetSProvInfoForLunImport')
	drop procedure Sprov_GetSProvInfoForLunImport
IF EXISTS (select * from GxQscripts where name='Sprov_GetSProvInfoForLunImport')
	delete from GxQscripts where name = 'Sprov_GetSProvInfoForLunImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sprov_GetSProvInfoForLunImport')
	delete from GXDBVersions where aliasname = 'Sprov_GetSProvInfoForLunImport'
GO
print '... Creating Procedure: Sprov_GetSProvInfoForLunImport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Sprov_GetSProvInfoForLunImport
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256),
  @o_outXML XML OUTPUT
AS
  DECLARE @o_outputXML XML
SET NOCOUNT ON
PRINT 'In Sprov_GetSProvInfoForLunImport'
DECLARE @tblLUNDetails TABLE (LUNId INT, UserId INT)
DECLARE @tblVolIds TABLE (VolumeId INT)
DECLARE @tblPoolIds TABLE (PoolId INT)
DECLARE @tblArrayNums TABLE (ArrayNum INT, PhyArrayNum INT, useTunneling INT, ClientId INT, vServerName NVARCHAR(1024))
DECLARE @tblVendorIdsLibraryNames TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @errorCode INT = 0
DECLARE @errorMsg VARCHAR(256) = ''
DECLARE @userId INT = 0
DECLARE @opType INT = 0
SET @userId = ISNULL((SELECT R.ref.value('@userId', 'INT')
                    FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref)), 0)
INSERT  INTO @tblLUNDetails (LunId, UserId)
SELECT  R.ref.value('@lunId', 'INT'),
        @userId
FROM    @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
INSERT  INTO @tblVolIds
SELECT DISTINCT ArrayVolumeId FROM SMLUN SMLN
INNER JOIN @tblLUNDetails tblLnDetails ON tblLnDetails.LUNId = SMLN.Id
INSERT  INTO @tblPoolIds
SELECT DISTINCT StoragePoolId FROM SMArrayVolume SMVol
INNER JOIN @tblVolIds tblVolIds ON tblVolIds.VolumeId = SMVol.Id
INSERT  INTO @tblArrayNums (ArrayNum)
SELECT DISTINCT SMArr.Id from SMArray SMArr
INNER JOIN SMStoragePool SPool ON SPool.ClientId = SMArr.ClientId
INNER JOIN SMArrayVolume SMArrVol ON SMArrVol.StoragePoolId = SPool.Id
INNER JOIN SMLUN SMLN ON SMLN.ArrayVolumeId = SMArrVol.Id
INNER JOIN @tblLUNDetails tblLnDetails ON tblLnDetails.LUNId = SMLN.Id
UPDATE  TMP
SET     TMP.ClientId = HOST.ClientId
        FROM @tblArrayNums TMP
            INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
            INNER JOIN SMControlHost HOST(NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
UPDATE  TMP
SET     TMP.useTunneling = CONF.ValueInt
        FROM @tblArrayNums TMP
            INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
            INNER JOIN SMControlHost HOST (NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
            INNER JOIN SMConfigs CONF (NOLOCK) ON CONF.ArrayId = HOST.ControlHostId AND CONF.AssocId = HOST.ControlHostId
            INNER JOIN SMMasterConfigs MC(NOLOCK) ON MC.Id = CONF.MasterConfigId
            AND MC.KeyName = 'SMCONFIG_NAME_USE_TUNNELING'
UPDATE  TMP
SET     TMP.PhyArrayNum = MAP.ArrayId
        FROM APP_VMToPMMap VMMAP (NOLOCK)
            INNER JOIN SMControlHost HOST(NOLOCK)
                ON VMMAP.PMClientId = HOST.ClientId
            INNER JOIN @tblArrayNums TMP ON VMMAP.VMClientId = TMP.ClientId AND TMP.useTunneling = 1
            INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
WHERE   TMP.useTunneling = 1
INSERT INTO @tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT DISTINCT Ven.Id, SMEngine.SnapEngineDLL
FROM SMSnapShotEngine SMEngine
INNER JOIN SMVendor Ven ON SMEngine.SnapVendorName = Ven.Name
INNER JOIN SMControlHost Host ON Ven.Name = Host.SnapVendorName
INNER JOIN SMArrayCtrlHostMap Map ON Map.ControlHostId = Host.ControlHostId
INNER JOIN @tblArrayNums T_ARR ON Map.ArrayId = T_ARR.ArrayNum
UPDATE  TMP
SET     TMP.vServerName = PROP.attrVal
        FROM @tblArrayNums TMP
            INNER JOIN APP_ClientProp PROP ON PROP.componentNameId = TMP.ClientId
                AND PROP.attrName = 'NAS vServer Name'
WHERE   TMP.useTunneling = 1
DECLARE @MAClientId INT = 0
;WITH cte AS
(SELECT CTRL.*,
        COUNT(TMP.ArrayNum) OVER (PARTITION BY CTRL.MMHostId) t1c
 FROM @tblArrayNums TMP
        INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
        INNER JOIN SMArrayController CTRL (NOLOCK) ON MAP.ControlHostId = CTRL.ArrayNum
        INNER JOIN MMHost HOST (NOLOCK) ON HOST.ClientId = CTRL.MMHostId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
        INNER JOIN APP_Client CLNT (NOLOCK) ON CLNT.Id = CTRL.MMHostId AND CLNT.releaseId = 16)
SELECT @MAClientId =  MIN(MMHostId) FROM cte WHERE t1c = (SELECT COUNT(DISTINCT arrayNum) FROM @tblArrayNums)
SET @o_outXML =
(SELECT
        (SELECT TOP 1
        CLNT.id AS 'client/@clientId',
        CLNT.net_hostname AS 'client/@clientName'
        FROM APP_Client CLNT (NOLOCK) WHERE Id = @MAClientId
        FOR XML PATH ('sprovParam'), TYPE),
        (SELECT
        EPNT.Id AS '@endPointId',
        EPNT.AddressType AS '@addressType',
        EPNT.Address AS '@address',
        EPNT.IsActive AS '@isActive'
        FROM SMEndPoint EPNT (NOLOCK)
            INNER JOIN (SELECT DISTINCT M.EndPointID FROM @tblLUNDetails T
                            INNER JOIN SProvMountLUN M ON M.LUNId = T.LUNId) TMP
                ON EPNT.Id = TMP.EndPointId
        FOR XML PATH ('endPointList'), TYPE),
        (SELECT
        VEN.Id AS '@vendorId',
        VEN.Name AS '@vendorName',
        VEN.Name AS '@familyName',
        VEN.ShowInGUI AS '@showInGUI',
        VEN.IsEnabled AS '@enabled',
        0 AS '@flags',
        0 AS '@status',
        0 AS '@errorCode',
        '' AS '@errorString',
	T_IDSLIBS.LibraryName AS '@libraryName',
            (SELECT
            ARR.Id AS '@arrayNum',
            T_ARR.PhyArrayNum AS '@phyArrayNum',
            T_ARR.useTunneling AS '@useTunneling',
            T_ARR.vServerName AS '@vServerName',
            ARR.ArrayName AS '@arrayName',
            HOST.SMHostName AS '@controlHost',
            HOST.SMHostUserName AS '@userName',
            HOST.SMHostPassword AS '@password',
            1 AS '@enabled',
            0 AS '@status',
            0 AS '@errorCode',
            '' AS '@errorString',
            HOST.ClientId AS 'client/@clientId',
                (SELECT
                S_POOL.Id AS '@storagePoolId',
                S_POOL.Name AS '@storagePoolName',
                SMArr.Id AS '@arrayNum',
                S_POOL.UsedSpaceMB AS '@usedSpace',
                S_POOL.TotalSpaceMB AS '@totalSpace',
                S_POOL.IsEnabled AS '@enabled',
                S_POOL.Flags AS '@flags',
                0 AS '@status',
                0 AS '@errorCode',
                '' AS '@errorString',
                    (SELECT
                    S_VOL.Id AS '@volumeId',
                    S_VOL.Name AS '@volumeName',
                    S_POOL.Id AS '@storagePoolId',
                    SMArr.Id AS '@arrayNum',
                    S_VOL.UsedSpaceMB * 1024 * 1024 AS '@usedSpace',
                    S_VOL.TotalSpaceMB * 1024 * 1024 AS '@totalSpace',
                    S_VOL.IsEnabled AS '@enabled',
                    S_VOL.Flags AS '@flags',
                    S_VOL.Path AS '@volumePath',
                    0 AS '@status',
                    0 AS '@errorCode',
                    '' AS '@errorString'
                    FROM SMArrayVolume S_VOL (NOLOCK)
                        INNER JOIN @tblVolIds T_VOL ON S_VOL.Id = T_VOL.VolumeId
						INNER JOIN SMArray SMArr ON SMArr.ClientId = S_VOL.ClientId
						AND S_POOL.Id = S_VOL.StoragePoolId
                    FOR XML PATH ('volumeList'), TYPE)
                FROM SMStoragePool S_POOL (NOLOCK)
                    INNER JOIN @tblPoolIds T_POOL ON T_POOL.PoolId = S_POOL.Id
					INNER JOIN SMArray SMArr ON SMArr.ClientId = S_POOL.ClientId
					aND SMArr.Id = T_ARR.ArrayNum
                FOR XML PATH('poolList'), TYPE)
            FROM  @tblArrayNums T_ARR
            INNER JOIN SMArray ARR (NOLOCK) ON (T_ARR.ArrayNum = ARR.Id OR T_ARR.PhyArrayNum = ARR.Id)
            INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK)
                ON MAP.ArrayId = ARR.Id
            INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
            FOR XML PATH ('arrayList'), TYPE )
        FROM SMVendor VEN (NOLOCK) INNER JOIN @tblVendorIdsLibraryNames T_IDSLIBS ON T_IDSLIBS.VendorId = VEN.Id
        FOR XML PATH ('arrayFamilyList'), TYPE),
        (SELECT
        SM_LUN.Id AS '@lunId',
        SM_LUN.Name AS '@lunName',
        SM_LUN.ArrayVolumeId AS '@volumeId',
        SM_VOL.StoragePoolId AS '@storagePoolId',
        SM_ARR.Id AS '@arrayNum',
        SM_LUN.UsedSpaceBytes AS '@usedSpace',
        SM_LUN.TotalSpaceBytes AS '@totalSpace',
        SM_LUN.IsEnabled AS '@enabled',
        SM_LUN.Flags AS '@flags',
        SM_LUN.Path AS '@lunPath',
		SM_LUN.ReserveFieldStr AS '@osTypeName',
        0 AS '@errorCode',
        '' AS '@errorString'
        FROM SMLUN SM_LUN
		INNER JOIN @tblLUNDetails TMP_LNTBL ON TMP_LNTBL.LUNId = SM_LUN.Id
        INNER JOIN SMArrayVolume SM_VOL ON SM_LUN.ArrayVolumeId = SM_VOL.Id
		INNER JOIN SMStoragePool SM_POOL ON SM_VOL.StoragePoolId = SM_POOL.Id
		INNER JOIN SMArray SM_ARR ON SM_ARR.ClientId = SM_POOL.ClientId
		--LEFT OUTER JOIN SProvLUN SP_LUN ON SP_LUN.LUNId = SM_LUN.Id
		--WHERE SP_LUN.LUNId IS NULL
        FOR XML PATH ('lunList'), TYPE)
FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
RETURN
ERR_EXIT:
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
RETURN

IF EXISTS (select * from GxQscripts where name = 'Sprov_GetSProvInfoForLunImport')
	delete from GxQscripts where name = 'Sprov_GetSProvInfoForLunImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sprov_GetSProvInfoForLunImport')
	delete from GXDBVersions where aliasname = 'Sprov_GetSProvInfoForLunImport'
GO

insert into GXDBVersions values(2, 'Sprov_GetSProvInfoForLunImport',  '00000000000000000000', 'Sprov_GetSProvInfoForLunImport', '00000000000000000000')
GO

