

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Sprov_GetSProvInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Sprov_GetSProvInfo.sp,v $ $Id: Sprov_GetSProvInfo.sp,v 1.3.12.4 2018/03/20 00:16:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "Sprov_GetSProvInfo"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Sprov_GetSProvInfo <<<'

IF EXISTS (select * from sysobjects where name='Sprov_GetSProvInfo')
	drop procedure Sprov_GetSProvInfo
IF EXISTS (select * from GxQscripts where name='Sprov_GetSProvInfo')
	delete from GxQscripts where name = 'Sprov_GetSProvInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sprov_GetSProvInfo')
	delete from GXDBVersions where aliasname = 'Sprov_GetSProvInfo'
GO
print '... Creating Procedure: Sprov_GetSProvInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Sprov_GetSProvInfo
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
DECLARE @tblLUNDetails TABLE (LUNId INT, UserId INT)
DECLARE @tblMountLUNDetails TABLE (MountLUNId INT, UserId INT)
DECLARE @tblVolIds TABLE (VolumeId INT, TotalLUNsUnderVolume INT, TotalLUNsSelectedForSProvOperation INT, DeleteVolume INT)
DECLARE @tblPoolIds TABLE (PoolId INT)
DECLARE @tblArrayNums TABLE (ArrayNum INT, PhyArrayNum INT, useTunneling INT, ClientId INT, vServerName NVARCHAR(1024))
DECLARE @tblVendorIdsLibraryNames TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @errorCode INT = 0
DECLARE @errorMsg VARCHAR(256) = ''
DECLARE @userId			INT = 0
DECLARE @opType			INT = 0
SET @userId = ISNULL((SELECT R.ref.value('@userId', 'INT')
					FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref)), 0)
SET @opType = ISNULL((SELECT R.ref.value('@operation', 'INT')
					FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
IF @opType = 7
BEGIN
	PRINT 'Calling Sprov_GetSProvInfoForLunImport'
	EXEC Commserv.dbo.Sprov_GetSProvInfoForLunImport @xmlText, 1, '', @o_outXML OUTPUT
	SELECT @o_outXML
	RETURN
END
INSERT	INTO @tblLUNDetails (LunId, UserId)
SELECT	R.ref.value('@lunId', 'INT'),
		@userId
FROM	@xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
--select * from @tblLUNDetails
INSERT	INTO @tblMountLUNDetails (MountLUNId, UserId)
SELECT	R.ref.value('@mountLunId', 'INT'),
		@userId
FROM	@xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList/mountList') R(ref)
--select * from @tblMountLUNDetails
INSERT	INTO @tblVolIds
SELECT	DISTINCT VolumeId, 0, 0, 0
FROM	@tblLUNDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
IF @opType = 2
BEGIN
	--Get the total number of LUNs under each of these volumes
	UPDATE @tblVolIds SET TotalLUNsUnderVolume = (SELECT COUNT(LUN.LUNId) FROM SProvLUN LUN WHERE LUN.VolumeId = [@tblVolIds].VolumeId)
	--Get the total number of LUNs selected under each of these volumes
	UPDATE @tblVolIds SET TotalLUNsSelectedForSProvOperation = (SELECT COUNT(LUN.LUNId) FROM SProvLUN LUN (NOLOCK) INNER JOIN @tblLUNDetails T_LUN
																ON T_LUN.LUNId = LUN.LUNId WHERE LUN.VolumeId = [@tblVolIds].VolumeId)
	--Determine if this volume needs to be deleted
	UPDATE @tblVolIds SET DeleteVolume = (CASE
											   WHEN (TotalLUNsUnderVolume - TotalLUNsSelectedForSProvOperation) > 0
											   THEN 0
											   ELSE 1
										  END )
	--Now that you know whether the volume should be deleted or not, get the right flag and update the same in the DeleteVolume field
UPDATE @tblVolIds SET DeleteVolume = (CASE WHEN SP_VOL.Flags = 8 THEN 32 ELSE 16 END)
	FROM SProvArrayVolume SP_VOL INNER JOIN @tblVolIds T_VOL ON T_VOL.VolumeId = SP_VOL.VolumeId
	WHERE T_VOL.DeleteVolume = 1
	--Now for Volumes that don't need deletion reset the Delete Volume field
	UPDATE @tblVolIds SET DeleteVolume = SP_VOL.Flags
	FROM SProvArrayVolume SP_VOL INNER JOIN @tblVolIds T_VOL ON T_VOL.VolumeId = SP_VOL.VolumeId
	WHERE T_VOL.DeleteVolume = 0
END
INSERT	INTO @tblPoolIds
SELECT	DISTINCT StoragePoolId
FROM	@tblLUNDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
INSERT	INTO @tblArrayNums (ArrayNum)
SELECT	DISTINCT ArrayNum
FROM	@tblLUNDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
UPDATE	TMP
SET		TMP.ClientId = HOST.ClientId
		FROM @tblArrayNums TMP
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
			INNER JOIN SMControlHost HOST(NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
UPDATE	TMP
SET		TMP.useTunneling = CONF.ValueInt
		FROM @tblArrayNums TMP
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
			INNER JOIN SMControlHost HOST (NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
			INNER JOIN SMConfigs CONF (NOLOCK) ON CONF.ArrayId = HOST.ControlHostId AND CONF.AssocId = HOST.ControlHostId
			INNER JOIN SMMasterConfigs MC(NOLOCK) ON MC.Id = CONF.MasterConfigId
			AND MC.KeyName = 'SMCONFIG_NAME_USE_TUNNELING'
UPDATE	TMP
SET		TMP.PhyArrayNum = MAP.ArrayId
		FROM APP_VMToPMMap VMMAP (NOLOCK)
			INNER JOIN SMControlHost HOST(NOLOCK)
				ON VMMAP.PMClientId = HOST.ClientId
			INNER JOIN @tblArrayNums TMP ON VMMAP.VMClientId = TMP.ClientId AND TMP.useTunneling = 1
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
WHERE	TMP.useTunneling = 1
INSERT INTO @tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT DISTINCT Ven.Id, SMEngine.SnapEngineDLL
FROM SMSnapShotEngine SMEngine
INNER JOIN SMVendor Ven ON SMEngine.SnapVendorName = Ven.Name
INNER JOIN SMControlHost Host ON Ven.Name = Host.SnapVendorName
INNER JOIN SMArrayCtrlHostMap Map ON Map.ControlHostId = Host.ControlHostId
INNER JOIN @tblArrayNums T_ARR ON Map.ArrayId = T_ARR.ArrayNum
UPDATE	TMP
SET		TMP.vServerName = PROP.attrVal
		FROM @tblArrayNums TMP
			INNER JOIN APP_ClientProp PROP ON PROP.componentNameId = TMP.ClientId
				AND PROP.attrName = 'NAS vServer Name'
WHERE	TMP.useTunneling = 1
--select * from @tblArrayNums
DECLARE @MAClientId INT = 0
;with cte as
(SELECT CTRL.*,
        COUNT(TMP.ArrayNum) OVER (PARTITION BY CTRL.MMHostId) t1c
 FROM @tblArrayNums TMP
		INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
		INNER JOIN SMArrayController CTRL (NOLOCK) ON MAP.ControlHostId = CTRL.ArrayNum
		INNER JOIN MMHost HOST (NOLOCK) ON HOST.ClientId = CTRL.MMHostId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
		INNER JOIN APP_Client CLNT (NOLOCK) ON CLNT.Id = CTRL.MMHostId AND CLNT.releaseId = 16)
SELECT @MAClientId =  MIN(MMHostId) FROM cte WHERE t1c = (SELECT COUNT(DISTINCT arrayNum) FROM @tblArrayNums)
SET @o_outXML =
(SELECT
		(SELECT TOP 1
		CLNT.id AS 'client/@clientId',
		CLNT.net_hostname AS 'client/@clientName'
		FROM APP_Client CLNT (NOLOCK) WHERE Id = @MAClientId
		FOR XML PATH ('sprovParam'), TYPE),
		(SELECT
		EPNT.Id AS '@endPointId',
		EPNT.AddressType AS '@addressType',
		EPNT.Address AS '@address',
		EPNT.IsActive AS '@isActive'
		FROM SMEndPoint EPNT (NOLOCK)
			INNER JOIN (SELECT DISTINCT M.EndPointID FROM @tblLUNDetails T
							INNER JOIN SProvMountLUN M ON M.LUNId = T.LUNId) TMP
				ON EPNT.Id = TMP.EndPointId
		FOR XML PATH ('endPointList'), TYPE),
		(SELECT
		VEN.Id AS '@vendorId',
		VEN.Name AS '@vendorName',
		VEN.Name AS '@familyName',
		VEN.ShowInGUI AS '@showInGUI',
		VEN.IsEnabled AS '@enabled',
		0 AS '@flags',
		0 AS '@status',
		0 AS '@errorCode',
		'' AS '@errorString',
		T_IDSLIBS.LibraryName AS '@libraryName',
			(SELECT
			ARR.Id AS '@arrayNum',
			T_ARR.PhyArrayNum AS '@phyArrayNum',
			T_ARR.useTunneling AS '@useTunneling',
			T_ARR.vServerName AS '@vServerName',
			ARR.ArrayName AS '@arrayName',
			HOST.SMHostName AS '@controlHost',
			HOST.SMHostUserName AS '@userName',
			HOST.SMHostPassword AS '@password',
			1 AS '@enabled',
			0 AS '@status',
			0 AS '@errorCode',
			'' AS '@errorString',
			HOST.ClientId AS 'client/@clientId',
				(SELECT
				S_POOL.StoragePoolId AS '@storagePoolId',
				POOL.Name AS '@storagePoolName',
				S_POOL.ArrayNum AS '@arrayNum',
				POOL.UsedSpaceMB AS '@usedSpace',
				POOL.TotalSpaceMB AS '@totalSpace',
				S_POOL.Enabled AS '@enabled',
				S_POOL.Flags AS '@flags',
				0 AS '@status',
				0 AS '@errorCode',
				'' AS '@errorString',
					(SELECT
					S_VOL.VolumeId AS '@volumeId',
					VOL.Name AS '@volumeName',
					S_POOL.StoragePoolId AS '@storagePoolId',
					S_VOL.ArrayNum AS '@arrayNum',
					VOL.UsedSpaceMB * 1024 * 1024 AS '@usedSpace',
					VOL.TotalSpaceMB * 1024 * 1024 AS '@totalSpace',
					S_VOL.Enabled AS '@enabled',
(CASE WHEN @opType = 2 THEN T_VOL.DeleteVolume ELSE S_VOL.Flags END) AS '@flags',
					VOL.Path AS '@volumePath',
					0 AS '@status',
					0 AS '@errorCode',
					'' AS '@errorString'
					FROM SProvArrayVolume S_VOL (NOLOCK)
						INNER JOIN @tblVolIds T_VOL ON S_VOL.VolumeId = T_VOL.VolumeId
						INNER JOIN SMArrayVolume VOL (NOLOCK) ON S_VOL.VolumeId = VOL.Id
						AND S_VOL.ArrayNum = ARR.Id
					FOR XML PATH ('volumeList'), TYPE)
				FROM SProvStoragePool S_POOL (NOLOCK)
					INNER JOIN @tblPoolIds T_POOL ON T_POOL.PoolId = S_POOL.StoragePoolId
					INNER JOIN SMStoragePool POOL (NOLOCK) ON S_POOL.StoragePoolId = POOL.Id
						AND S_POOL.ArrayNum = ARR.Id
				FOR XML PATH('poolList'), TYPE)
			FROM  @tblArrayNums T_ARR --, @tblPoolIds T_POOL, @tblVolIds T_VOL
			INNER JOIN SMArray ARR (NOLOCK) ON (T_ARR.ArrayNum = ARR.Id OR T_ARR.PhyArrayNum = ARR.Id)
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK)
				ON MAP.ArrayId = ARR.Id
				--AND ARR.Id = P_LUN.ArrayNum
				--	AND ARR.Id IN (@arrayNum, @phyArrayNum)
			INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
			FOR XML PATH ('arrayList'), TYPE )
		FROM SMVendor VEN (NOLOCK) INNER JOIN @tblVendorIdsLibraryNames T_IDSLIBS ON T_IDSLIBS.VendorId = VEN.Id
		FOR XML PATH ('arrayFamilyList'), TYPE),
		(SELECT
		P_LUN.LUNId AS '@lunId',
		LUN.Name AS '@lunName',
		P_LUN.VolumeId AS '@volumeId',
		P_LUN.StoragePoolId AS '@storagePoolId',
		P_LUN.ArrayNum AS '@arrayNum',
		LUN.UsedSpaceBytes AS '@usedSpace',
		LUN.TotalSpaceBytes AS '@totalSpace',
		P_LUN.Criteria AS '@criteria',
		--@criteria AS '@criteria',
		P_LUN.ExpirationDate AS '@expirationDate',
		P_LUN.Enabled AS '@enabled',
		P_LUN.Flags AS '@flags',
		P_LUN.OSType AS '@osTypeId',
		--SIM.Name AS '@osTypeName',
		P_LUN.Status AS '@status',
		P_LUN.Description AS '@description',
		LUN.Path AS '@lunPath',
		0 AS '@errorCode',
		'' AS '@errorString',
		P_LUN.userId AS 'user/@userId',
			(SELECT
			M_LUN.MountLunId AS '@mountLunId',
			M_LUN.LunId AS '@lunId',
			M_LUN.ProtocolId AS '@protocolId',
			M_LUN.EndPointId AS '@endPointId',
			CLNT.simOperatingSystemId AS '@mountHostOSTypeId',
			SIM.Name AS '@mountHostOSType',
			M_LUN.UserId AS 'user/@userId',
			M_LUN.MountHostId AS 'mountHost/@clientId',
			CLNT.net_hostname AS 'mountHost/@clientName'
			FROM SProvMountLUN M_LUN (NOLOCK) INNER JOIN APP_CLIENT CLNT (NOLOCK) ON CLNT.id = M_LUN.MountHostId
			INNER JOIN simOperatingSystem SIM (NOLOCK) ON CLNT.simOperatingSystemId = SIM.id
			WHERE M_LUN.LUNId = TMP.LUNId
			AND M_LUN.MountLunId IN (SELECT MountLunId FROM @tblMountLUNDetails)
			FOR XML PATH('mountList'), TYPE)
		FROM @tblLUNDetails TMP
			INNER JOIN SProvLUN P_LUN (NOLOCK) ON TMP.LUNId = P_LUN.LUNId
			INNER JOIN SMLUN LUN (NOLOCK) ON P_LUN.LUNId = LUN.Id
			--INNER JOIN simOperatingSystem SIM (NOLOCK) ON P_LUN.OSType = SIM.id
		FOR XML PATH ('lunList'), TYPE)
FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
ERR_EXIT:
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'Sprov_GetSProvInfo')
	delete from GxQscripts where name = 'Sprov_GetSProvInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sprov_GetSProvInfo')
	delete from GXDBVersions where aliasname = 'Sprov_GetSProvInfo'
GO

insert into GXDBVersions values(2, 'Sprov_GetSProvInfo',  '00010003001200040000', 'Sprov_GetSProvInfo', '00010003001200040000')
GO

