

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SpContentDBSkipBackupList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SpContentDBSkipBackupList <<<'

IF EXISTS (select * from sysobjects where name='SpContentDBSkipBackupList')
	drop procedure SpContentDBSkipBackupList
IF EXISTS (select * from GxQscripts where name='SpContentDBSkipBackupList')
	delete from GxQscripts where name = 'SpContentDBSkipBackupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SpContentDBSkipBackupList')
	delete from GXDBVersions where aliasname = 'SpContentDBSkipBackupList'
GO
print '... Creating Procedure: SpContentDBSkipBackupList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SpContentDBSkipBackupList
  @clientId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @twoDayOldTime INT = dbo.GetUnixTime(DATEADD(hour,-48,GETUTCDATE()) )
SELECT	A.componentNameId --componentNameId as applicationId
  FROM	APP_SubClientProp A
  JOIN	APP_application B
    ON 	A.componentNameId = B.id
  JOIN	App_client C
    ON	C.id = B.clientId
  JOIN JMBkpStats J
	ON J.appId=B.id
 WHERE	J.servEndDate > @twoDayOldTime AND
		A.attrname = N'SharePoint SQL Client Id' AND
		A.attrval = CAST(@clientId AS NVARCHAR(10)) AND A.modified = 0 AND
		A.cs_attrName = CHECKSUM(N'SharePoint SQL Client Id') AND
(C.status & 0x00004) <> 0x00004 AND
(C.status & 0x00002) <> 0x00002  AND
(B.subclientStatus & 0x00004) <> 0x00004 AND
(B.subclientStatus & 0x00002) <> 0x00002
GO

IF EXISTS (select * from GxQscripts where name = 'SpContentDBSkipBackupList')
	delete from GxQscripts where name = 'SpContentDBSkipBackupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SpContentDBSkipBackupList')
	delete from GXDBVersions where aliasname = 'SpContentDBSkipBackupList'
GO

insert into GXDBVersions values(2, 'SpContentDBSkipBackupList',  '00000000000000000000', 'SpContentDBSkipBackupList', '00000000000000000000')
GO

