

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SoftwareStoreItem.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SoftwareStoreItem <<<'

IF EXISTS (select * from sysobjects where name='SoftwareStoreItem')
	drop procedure SoftwareStoreItem
IF EXISTS (select * from GxQscripts where name='SoftwareStoreItem')
	delete from GxQscripts where name = 'SoftwareStoreItem'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SoftwareStoreItem')
	delete from GXDBVersions where aliasname = 'SoftwareStoreItem'
GO
print '... Creating Procedure: SoftwareStoreItem'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SoftwareStoreItem
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#StoreItems') is not null DROP TABLE #StoreItems
CREATE TABLE #StoreItems(GUID NVARCHAR(256), Type NVARCHAR(200), Revision NVARCHAR(256), packageId INT, platformId INT, whatsnew NVARCHAR(MAX), certified int,
 packagename nvarchar(510), pushtostoreclients int, minServicePack INT, minRelId INT, maxServicePack INT, maxRelId INT)
 IF object_id('tempdb.dbo.#Package') IS NOT NULL DROP TABLE #Package
 CREATE TABLE #Package ( reportguid NVARCHAR(256), packageid INT, packagename NVARCHAR(MAX), platformid INT , reportrevision NVARCHAR(256), whatsnew NVARCHAR(MAX), certified INT, pushtostoreclients INT,
 minServicePack INT, minRelId INT, maxServicePack INT, maxRelId INT, categoryId INT)
INSERT INTO #Package
SELECT ISNULL(c.value('@guid', 'nvarchar(256)'), '') AS reportguid,
	   p.PackageId,
	   p.PackageName,
	   PP.PlatformId,
	   ISNULL(c.value('@revision', 'nvarchar(256)'), '') AS reportrevision,
	   ISNULL(c.value('@whatsnew', 'nvarchar(max)'), '') AS whatsnew,
	   ISNULL(c.value('@certified', 'int'), 1) AS certified,
	   ISNULL(c.value('@pushToStoreClients', 'int'), 0) AS pushtostoreclients,
	   ISNULL(c.value('minCommCellVersion[1]/@servicePack', 'int'), 0) AS minServicePack,
	   ISNULL(c.value('minCommCellVersion[1]/@releaseID', 'int'), 0) AS minRelId,
	   ISNULL(c.value('maxCommCellVersion[1]/@servicePack', 'int'), 0) AS maxServicePack,
	   ISNULL(c.value('maxCommCellVersion[1]/@releaseID', 'int'), 0) AS maxRelId,
	   p.CategoryId
FROM DCPackage P
INNER JOIN DCPackagePlatform PP
ON PP.PackageId = P.PackageId AND PP.Attribute & 4 = 0
INNER JOIN DCEntityProperty EP
ON PackageStatus =0
AND ((EP.EntityId = P.CategoryId
AND EP.EntityType =0) OR (EP.EntityId = P.SubCategoryId
AND EP.EntityType =1))
AND EP.PropertyName ='IsInstallable'
and PropertyValue ='true'
cross apply P.PackageXML.nodes('/extraPropContainer/customScriptDescription') C(c)
INSERT INTO #StoreItems
SELECT
	csInfo.n.value('@id','nvarchar(256)'), '', '', 0, 0, '', 1, '', 0, 0, 0, 0, 0
FROM @request.nodes('/WebReport_StoreItemReq/items') AS csInfo(n)
DELETE S
FROM #StoreItems S
LEFT JOIN #Package P
ON S.GUID = P.reportguid
WHERE P.reportguid is NULL
INSERT INTO #StoreItems
SELECT
	reportguid, '', '', 0, 0, '', 1, '', 0, 0, 0, 0, 0
FROM ( SELECT reportguid from #Package where pushtostoreclients =1 and certified=1) p
LEFT JOIN #StoreItems s
on p.reportguid = s.GUID
WHERE s.guid is null
IF object_id('tempdb.dbo.#LatestSP') is not null DROP TABLE #LatestSP
CREATE TABLE #LatestSP( reportGuid NVARCHAR(256) , minSP INT,minRelId INT)
INSERT INTO #LatestSP (reportGuid,minRelId)
select reportGuid,max(minRelId)  from #Package Group by reportguid
update #LatestSP
set minSP = t.sp
from (select reportGuid,minRelId,max(minServicePack) as 'sp' from #Package  group by reportGuid,minRelId) t
where t.minRelId = #LatestSP.minRelId and #LatestSP.reportGuid=  t.reportGuid
UPDATE S
SET Revision = P.reportrevision,
	packageId = P.packageId,
	platformId = P.platformId,
	Type = ISNULL(case when dcp.PropertyValue='report' then 'Custom Reports'
	                   when dcp.PropertyValue='workflow' then 'Workflows'
					   when dcp.PropertyValue='customRule' then 'Custom Rules'
					   when dcp.PropertyValue='tool' then 'Quick Access Tools'
					   else dcp.PropertyValue
					   end ,''),
	whatsnew = P.whatsnew,
	packagename = p.packagename,
	certified = p.certified,
	pushtostoreclients = p.pushtostoreclients,
	minServicePack = p.minServicePack,
	minRelId = p.minRelId,
	maxServicePack = p.maxServicePack,
	maxRelId = p.maxRelId
FROM #StoreItems S
INNER JOIN #Package P
       ON S.GUID = P.reportguid
          INNER JOIN #LatestSP SP
          ON P.reportguid = SP.reportGuid AND P.minServicePack = SP.minSP AND SP.minRelId = P.minRelId
LEFT JOIN DCEntityProperty dcp
on dcp.entityid = P.categoryid
and dcp.propertyName = 'InternalName'
SET @response = (SELECT (SELECT GUID AS '@id',
								Type AS '@type',
								Revision AS '@revision',
								packageId AS '@packageId',
								platformId AS '@platformId',
								whatsNew AS '@whatsNew',
								packagename as '@name',
								certified as '@certified',
								pushtostoreclients as '@pushToStoreClients',
								(SELECT minServicePack AS '@servicePack', minRelId AS '@releaseID' FOR XML PATH('minCommCellVersion'), TYPE),
								(SELECT maxServicePack AS '@servicePack', maxRelId AS '@releaseID' FOR XML PATH('maxCommCellVersion'), TYPE)
						FROM #StoreItems
						FOR XML PATH('items'), Type) FOR XML PATH('WebReport_StoreItemResp'), TYPE)
IF object_id('tempdb.dbo.#StoreItems') is not null DROP TABLE #StoreItems
SELECT @response AS 'response'
DROP TABLE #LatestSP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SoftwareStoreItem')
	delete from GxQscripts where name = 'SoftwareStoreItem'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SoftwareStoreItem')
	delete from GXDBVersions where aliasname = 'SoftwareStoreItem'
GO

insert into GXDBVersions values(2, 'SoftwareStoreItem',  '00010001000200110000', 'SoftwareStoreItem', '00010001000200110000')
GO

