

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SoftwareStoreAutoUpdateHandler.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SoftwareStoreAutoUpdateHandler <<<'

IF EXISTS (select * from sysobjects where name='SoftwareStoreAutoUpdateHandler')
	drop procedure SoftwareStoreAutoUpdateHandler
IF EXISTS (select * from GxQscripts where name='SoftwareStoreAutoUpdateHandler')
	delete from GxQscripts where name = 'SoftwareStoreAutoUpdateHandler'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SoftwareStoreAutoUpdateHandler')
	delete from GXDBVersions where aliasname = 'SoftwareStoreAutoUpdateHandler'
GO
print '... Creating Procedure: SoftwareStoreAutoUpdateHandler'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SoftwareStoreAutoUpdateHandler
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @storeconfig XML
DECLARE @opType INT = -1
DECLARE @AUPreference INT
DECLARE @AUUserId INT
DECLARE @AUUserConfig NVARCHAR(MAX)
DECLARE @ClientSettings NVARCHAR(MAX)
DECLARE @curTime INT = dbo.GetUnixTime(GetUTCDate())
SELECT
	@opType = ISNULL(csInfo.n.value('@opType','INT'), -1)
FROM @request.nodes('/WebReport_StoreAutoUpdateReq') AS csInfo(n)
IF (@opType = 0) --StoreOpType.GET
BEGIN
	SELECT @storeconfig =
		(SELECT
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateDisabled' AND modified = 0) AS '@isCheckAndUpdateDisabled',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateUserId' AND modified = 0) AS '@AUUserId',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdatePreference' AND modified = 0) AS '@AUPreference',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateUserConfig' AND modified = 0) AS '@AUUserConfig',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateLastUpdateTime' AND modified = 0) AS '@LastAUTime' ,
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateStatus' AND modified = 0) AS '@LastAUStatus',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateMessage' AND modified = 0) AS '@LastAUMessage',
			(SELECT value FROM GXGlobalParam WHERE name = 'SWStoreClientSettings' AND modified = 0) AS '@settingsJson'
		FOR XML PATH('detail'))
END
ELSE IF (@opType = 1) --StoreOpType.MODIFY
BEGIN
	SELECT
		@AUPreference = csInfo.n.value('@AUPreference','INT'),
		@AUUserId = csInfo.n.value('@AUUserId','INT'),
		@AUUserConfig = csInfo.n.value('@AUUserConfig','NVARCHAR(MAX)'),
		@ClientSettings = csInfo.n.value('@settingsJson','NVARCHAR(MAX)')
	FROM @request.nodes('/WebReport_StoreAutoUpdateReq/detail') AS csInfo(n)
	IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdatePreference' AND modified = 0)
		UPDATE GXGlobalParam SET value = CAST(@AUPreference AS NVARCHAR(10)) WHERE name = 'SWStoreAutoUpdatePreference' AND modified = 0
	ELSE
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES('SWStoreAutoUpdatePreference', CAST(@AUPreference AS NVARCHAR(10)), @curTime, 0)
	IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateUserId' AND modified = 0)
		UPDATE GXGlobalParam SET value = CAST(@AUUserId AS NVARCHAR(10)) WHERE name = 'SWStoreAutoUpdateUserId' AND modified = 0
	ELSE
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES('SWStoreAutoUpdateUserId', CAST(@AUUserId AS NVARCHAR(10)), @curTime, 0)
	IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'SWStoreAutoUpdateUserConfig' AND modified = 0)
		UPDATE GXGlobalParam SET value = @AUUserConfig WHERE name = 'SWStoreAutoUpdateUserConfig' AND modified = 0
	ELSE
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES('SWStoreAutoUpdateUserConfig', @AUUserConfig, @curTime, 0)
    IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'SWStoreClientSettings' AND modified = 0)
		UPDATE GXGlobalParam SET value = @ClientSettings WHERE name = 'SWStoreClientSettings' AND modified = 0
	ELSE
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES('SWStoreClientSettings', @ClientSettings, @curTime, 0)
	SELECT @storeconfig = (SELECT 0 AS '@errorCode', 'Success' AS '@errorMessage' FOR XML PATH('msg'))
END
ELSE --Invalid Request
BEGIN
	SELECT @storeconfig = (SELECT 1 AS '@errorCode', 'Invalid Input' AS '@errorMessage' FOR XML PATH('msg'))
END
SET @response =(SELECT @storeconfig FOR XML PATH( 'WebReport_StoreAutoUpdateResp')  )
SELECT @response AS 'response'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SoftwareStoreAutoUpdateHandler')
	delete from GxQscripts where name = 'SoftwareStoreAutoUpdateHandler'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SoftwareStoreAutoUpdateHandler')
	delete from GXDBVersions where aliasname = 'SoftwareStoreAutoUpdateHandler'
GO

insert into GXDBVersions values(2, 'SoftwareStoreAutoUpdateHandler',  '00010001000200050000', 'SoftwareStoreAutoUpdateHandler', '00010001000200050000')
GO

