

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SimSetClientProp.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SimSetClientProp <<<'

IF EXISTS (select * from sysobjects where name='SimSetClientProp')
	drop procedure SimSetClientProp
IF EXISTS (select * from GxQscripts where name='SimSetClientProp')
	delete from GxQscripts where name = 'SimSetClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimSetClientProp')
	delete from GXDBVersions where aliasname = 'SimSetClientProp'
GO
print '... Creating Procedure: SimSetClientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SimSetClientProp
-- INPUT TYPE: 0x1 - update client description; 0x2 - update [Indexing datasource id]
  @i_type bigint,
  @i_clientID integer = 0,
  @i_idxDSId integer = 0,
  @i_subclientID integer = 0,
  @i_clientDescription nvarchar(max)
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr varchar(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
SET @o_errorCode = 0
IF (@i_type & 1) > 0
	UPDATE APP_CLient SET clientDescription = @i_clientDescription WHERE id = @i_clientID
IF (@i_type & 2) > 0
BEGIN
	IF EXISTS (select 1 from APP_CLientProp WHERE componentNameID = @i_clientID and attrName = 'Indexing datasource id' and modified = 0)
		UPDATE APP_CLientProp SET attrVal = CAST(@i_idxDSId AS VARCHAR(32)) WHERE componentNameID = @i_clientID and attrName = 'Indexing datasource id' and modified = 0
	ELSE
		INSERT INTO APP_CLientProp
		SELECT @i_clientID, 'Indexing datasource id', 7, CAST(@i_idxDSId AS VARCHAR(32)), dbo.getUNIXTime(GetUTCDate()), 0, 0
END
IF (@i_type & 4) > 0
BEGIN
	IF NOT EXISTS (select id from APP_Application where id = @i_subclientID)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorStr = 'Invalid subclient ID'
	END
	ELSE IF EXISTS (select 1 from APP_subclientProp WHERE componentNameID = @i_subclientID and attrName = 'Indexing datasource id' and modified = 0)
		UPDATE APP_subclientProp SET attrVal = CAST(@i_idxDSId AS VARCHAR(32)) WHERE componentNameID = @i_subclientID and attrName = 'Indexing datasource id' and modified = 0
	ELSE
	BEGIN
		INSERT INTO APP_subclientProp
		SELECT @i_subclientID, 'Indexing datasource id', 1, CAST(@i_idxDSId AS VARCHAR(32)), dbo.getUNIXTime(GetUTCDate()), 0, 0
		END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER();
	SET @o_errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_errorCode, @o_errorStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SimSetClientProp')
	delete from GxQscripts where name = 'SimSetClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimSetClientProp')
	delete from GXDBVersions where aliasname = 'SimSetClientProp'
GO

insert into GXDBVersions values(2, 'SimSetClientProp',  '00000000000000000000', 'SimSetClientProp', '00000000000000000000')
GO

